/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.conversions;

import io.specmatic.conversions.StringConstraintsKt;
import io.swagger.v3.oas.models.media.StringSchema;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lio/specmatic/conversions/StringConstraints;", "", "schema", "Lio/swagger/v3/oas/models/media/StringSchema;", "patternName", "", "breadCrumb", "(Lio/swagger/v3/oas/models/media/StringSchema;Ljava/lang/String;Ljava/lang/String;)V", "downsampledMax", "", "getDownsampledMax", "()Z", "downsampledMin", "getDownsampledMin", "resolvedBreadCrumb", "resolvedMaxLength", "", "getResolvedMaxLength", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "resolvedMinLength", "getResolvedMinLength", "specmatic-core"})
public final class StringConstraints {
    @NotNull
    private final String resolvedBreadCrumb;
    @Nullable
    private final Integer resolvedMaxLength;
    private final boolean downsampledMax;
    @Nullable
    private final Integer resolvedMinLength;
    private final boolean downsampledMin;

    public StringConstraints(@NotNull StringSchema schema, @NotNull String patternName, @NotNull String breadCrumb) {
        Pair<Integer, Boolean> pair;
        Intrinsics.checkNotNullParameter(schema, "schema");
        Intrinsics.checkNotNullParameter(patternName, "patternName");
        Intrinsics.checkNotNullParameter(breadCrumb, "breadCrumb");
        this.resolvedBreadCrumb = !StringsKt.isBlank(patternName) ? "schema " + patternName : breadCrumb;
        Pair<Integer, Boolean> it = pair = StringConstraintsKt.rightSizedLength(schema.getMaxLength(), "maxLength", this.resolvedBreadCrumb);
        boolean bl = false;
        this.resolvedMaxLength = it.getFirst();
        this.downsampledMax = it.getSecond();
        it = pair = StringConstraintsKt.rightSizedLength(schema.getMinLength(), "minLength", this.resolvedBreadCrumb);
        boolean bl2 = false;
        this.resolvedMinLength = it.getFirst();
        this.downsampledMin = it.getSecond();
    }

    @Nullable
    public final Integer getResolvedMaxLength() {
        return this.resolvedMaxLength;
    }

    public final boolean getDownsampledMax() {
        return this.downsampledMax;
    }

    @Nullable
    public final Integer getResolvedMinLength() {
        return this.resolvedMinLength;
    }

    public final boolean getDownsampledMin() {
        return this.downsampledMin;
    }
}

