/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.conversions;

import io.specmatic.core.log.LoggingKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a5\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"REASONABLE_STRING_LENGTH", "", "rightSizedLength", "Lkotlin/Pair;", "", "length", "paramName", "", "breadCrumb", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Lkotlin/Pair;", "specmatic-core"})
public final class StringConstraintsKt {
    private static final int REASONABLE_STRING_LENGTH = 0x400000;

    @NotNull
    public static final Pair<Integer, Boolean> rightSizedLength(@Nullable Integer length, @NotNull String paramName, @NotNull String breadCrumb) {
        Pair<Integer, Boolean> pair;
        Intrinsics.checkNotNullParameter(paramName, "paramName");
        Intrinsics.checkNotNullParameter(breadCrumb, "breadCrumb");
        Integer n = length;
        if (n == null) {
            return TuplesKt.to(null, false);
        }
        n.intValue();
        if (length > 0x400000) {
            String warningMessage = "WARNING: The " + paramName + " of " + length + " for " + breadCrumb + " is very large. We will use a more reasonable " + paramName + " of 4MB. Boundary testing will not be done for this parameter, and string lengths generated for test or stub will not exceed 4MB in length. Please review the " + paramName + " of " + length + " on this field.";
            LoggingKt.getLogger().log(warningMessage);
            pair = TuplesKt.to(0x400000, true);
        } else {
            pair = TuplesKt.to(length, false);
        }
        return pair;
    }
}

