/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import io.specmatic.core.Dictionary;
import io.specmatic.core.Resolver;
import io.specmatic.core.URLPathSegmentPattern;
import io.specmatic.core.log.LogStrategy;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.DeferredPatternKt;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.pattern.HasException;
import io.specmatic.core.pattern.MemberList;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.QueryParameterScalarPattern;
import io.specmatic.core.pattern.ReturnFailure;
import io.specmatic.core.pattern.ReturnValue;
import io.specmatic.core.pattern.ScalarType;
import io.specmatic.core.pattern.SequenceType;
import io.specmatic.core.utilities.Utilities;
import io.specmatic.core.utilities.YAMLSerialisationKt;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.Value;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\b\u0018\u0000 52\u00020\u0001:\u00015B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J7\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0002\u001a\u0002H\u000b2\u001a\u0010\f\u001a\u0016\u0012\u0004\u0012\u0002H\u000b\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\u000e0\rH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J5\u0010\u0015\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003JL\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0016\b\u0002\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\rH\u0002J\u001e\u0010 \u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010!\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ9\u0010\"\u001a\u00020\u0000\"\f\b\u0000\u0010\u000b*\u00020\u001a*\u00020#2\u0006\u0010\u0019\u001a\u0002H\u000b2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010'\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0004J0\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ,\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010.\u001a\u00020\u0013H\u0002J\t\u0010/\u001a\u00020\nH\u00d6\u0001J\u001a\u00100\u001a\u00020\u00002\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003J\b\u00101\u001a\u00020\u0000H\u0002J\t\u00102\u001a\u00020\u0004H\u00d6\u0001J\u0014\u00103\u001a\u00020\u0013*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\f\u00104\u001a\u00020\u0004*\u00020\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/specmatic/core/Dictionary;", "", "data", "", "", "Lio/specmatic/core/value/Value;", "focusedData", "(Ljava/util/Map;Ljava/util/Map;)V", "defaultData", "calculateDepth", "", "T", "getChildren", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)I", "component1", "component2", "containsKey", "", "key", "copy", "equals", "other", "focusInto", "pattern", "Lio/specmatic/core/pattern/Pattern;", "resolver", "Lio/specmatic/core/Resolver;", "storeToUse", "onValue", "Lio/specmatic/core/value/JSONObjectValue;", "focusIntoProperty", "focusIntoSchema", "focusIntoSequence", "Lio/specmatic/core/pattern/SequenceType;", "childPattern", "(Lio/specmatic/core/pattern/Pattern;Lio/specmatic/core/pattern/Pattern;Ljava/lang/String;Lio/specmatic/core/Resolver;)Lio/specmatic/core/Dictionary;", "getDefaultValueFor", "getRawValue", "getReturnValueFor", "Lio/specmatic/core/pattern/ReturnValue;", "lookup", "value", "getValueFor", "getValueToMatch", "overrideNestedCheck", "hashCode", "plus", "resetFocus", "toString", "isScalar", "tailEndKey", "Companion", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nDictionary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dictionary.kt\nio/specmatic/core/Dictionary\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n478#2,7:158\n1#3:165\n*S KotlinDebug\n*F\n+ 1 Dictionary.kt\nio/specmatic/core/Dictionary\n*L\n14#1:158,7\n*E\n"})
public final class Dictionary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Value> data;
    @NotNull
    private final Map<String, Value> focusedData;
    @NotNull
    private final Map<String, Value> defaultData;

    /*
     * WARNING - void declaration
     */
    public Dictionary(@NotNull Map<String, ? extends Value> data2, @NotNull Map<String, ? extends Value> focusedData) {
        void $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(focusedData, "focusedData");
        this.data = data2;
        this.focusedData = focusedData;
        Map<String, Value> map2 = this.data;
        Dictionary dictionary = this;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            Object p0 = entry$iv.getKey();
            boolean bl = false;
            if (!GrammarKt.isPatternToken(p0)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        dictionary.defaultData = result$iv;
    }

    public /* synthetic */ Dictionary(Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map3 = MapsKt.emptyMap();
        }
        this(map2, map3);
    }

    @NotNull
    public final Dictionary plus(@NotNull Map<String, ? extends Value> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Dictionary.copy$default(this, MapsKt.plus(this.data, other), null, 2, null);
    }

    public final boolean containsKey(@NotNull String key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        return this.data.containsKey(key2);
    }

    @NotNull
    public final Value getRawValue(@NotNull String key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        if (!this.data.containsKey(key2)) {
            throw new IllegalArgumentException("Dictionary does not contain key: " + key2);
        }
        return MapsKt.getValue(this.data, key2);
    }

    @NotNull
    public final Dictionary focusIntoSchema(@NotNull Pattern pattern2, @NotNull String key2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(pattern2, "pattern");
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return Dictionary.focusInto$default(this, pattern2, key2, resolver, this.data, null, 16, null);
    }

    @NotNull
    public final Dictionary focusIntoProperty(@NotNull Pattern pattern2, @NotNull String key2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(pattern2, "pattern");
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return Dictionary.focusInto$default(this, pattern2, key2, resolver, this.focusedData, null, 16, null);
    }

    @NotNull
    public final <T extends Pattern & SequenceType> Dictionary focusIntoSequence(@NotNull T pattern2, @NotNull Pattern childPattern, @NotNull String key2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(pattern2, "pattern");
        Intrinsics.checkNotNullParameter(childPattern, "childPattern");
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return this.focusInto(pattern2, key2, resolver, this.focusedData, (Function1<? super Value, JSONObjectValue>)new Function1<Value, JSONObjectValue>(this, childPattern, resolver, key2){
            final /* synthetic */ Dictionary this$0;
            final /* synthetic */ Pattern $childPattern;
            final /* synthetic */ Resolver $resolver;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$childPattern = $childPattern;
                this.$resolver = $resolver;
                this.$key = $key;
                super(1);
            }

            public final JSONObjectValue invoke(Value value2) {
                Intrinsics.checkNotNullParameter(value2, "value");
                Value valueToMatch = Dictionary.access$getValueToMatch(this.this$0, value2, this.$childPattern, this.$resolver, false);
                return valueToMatch instanceof JSONObjectValue ? (JSONObjectValue)valueToMatch : (valueToMatch != null ? new JSONObjectValue(MapsKt.mapOf(TuplesKt.to(this.$key, valueToMatch))) : (value2 instanceof JSONObjectValue ? (JSONObjectValue)value2 : null));
            }
        });
    }

    @Nullable
    public final Value getDefaultValueFor(@NotNull Pattern pattern2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(pattern2, "pattern");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Pattern resolved2 = DeferredPatternKt.resolvedHop(pattern2, resolver);
        String lookupKey = GrammarKt.withPatternDelimiters(resolved2.getTypeName());
        Value value2 = this.defaultData.get(lookupKey);
        if (value2 == null) {
            return null;
        }
        Value defaultValue = value2;
        ReturnValue<Value> returnValue2 = this.getReturnValueFor(lookupKey, defaultValue, resolved2, resolver);
        return returnValue2 != null ? (Value)returnValue2.withDefault(null, getDefaultValueFor.1.INSTANCE) : null;
    }

    @Nullable
    public final ReturnValue<Value> getValueFor(@NotNull String lookup2, @NotNull Pattern pattern2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(lookup2, "lookup");
        Intrinsics.checkNotNullParameter(pattern2, "pattern");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        String tailEndKey = this.tailEndKey(lookup2);
        Value value2 = this.focusedData.get(tailEndKey);
        if (value2 == null) {
            return null;
        }
        Value dictionaryValue = value2;
        return this.getReturnValueFor(lookup2, dictionaryValue, pattern2, resolver);
    }

    private final Dictionary focusInto(Pattern pattern2, String key2, Resolver resolver, Map<String, ? extends Value> storeToUse, Function1<? super Value, JSONObjectValue> onValue) {
        Value value2 = storeToUse.get(key2);
        if (value2 == null) {
            return this.resetFocus();
        }
        Value rawValue = value2;
        Value value3 = this.getValueToMatch(rawValue, pattern2, resolver, true);
        if (value3 == null) {
            return this.resetFocus();
        }
        Value valueToFocusInto = value3;
        Object object = onValue.invoke(valueToFocusInto);
        if (object == null || (object = ((JSONObjectValue)object).getJsonObject()) == null) {
            object = storeToUse;
        }
        Map<String, ? extends Value> dataToFocusInto = object;
        return Dictionary.copy$default(this, null, dataToFocusInto, 1, null);
    }

    static /* synthetic */ Dictionary focusInto$default(Dictionary dictionary, Pattern pattern2, String string, Resolver resolver, Map map2, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = focusInto.1.INSTANCE;
        }
        return dictionary.focusInto(pattern2, string, resolver, map2, function1);
    }

    private final ReturnValue<Value> getReturnValueFor(String lookup2, Value value2, Pattern pattern2, Resolver resolver) {
        Object object;
        Object $this$getReturnValueFor_u24lambda_u240;
        Value value3 = Dictionary.getValueToMatch$default(this, value2, pattern2, resolver, false, 8, null);
        if (value3 == null) {
            return null;
        }
        Value valueToMatch = value3;
        Object object2 = this;
        try {
            $this$getReturnValueFor_u24lambda_u240 = object2;
            boolean bl = false;
            ReturnValue<Value> result2 = pattern2.fillInTheBlanks(valueToMatch, Resolver.copy$default(resolver, null, false, null, null, null, null, false, null, null, null, null, null, null, null, null, false, null, null, null, 524223, null), true);
            if (result2 instanceof ReturnFailure && resolver.isNegative()) {
                return null;
            }
            $this$getReturnValueFor_u24lambda_u240 = Result.constructor-impl(result2.addDetails("Invalid Dictionary value at \"" + lookup2 + "\"", ""));
        }
        catch (Throwable bl) {
            $this$getReturnValueFor_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object2 = $this$getReturnValueFor_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable p0 = throwable;
            boolean bl = false;
            object = new HasException(p0, null, null, 6, null);
        }
        return (ReturnValue)object;
    }

    private final Value getValueToMatch(Value value2, Pattern pattern2, Resolver resolver, boolean overrideNestedCheck) {
        if (!(value2 instanceof JSONArrayValue)) {
            Value value3;
            Value it = value3 = value2;
            boolean bl = false;
            return this.isScalar(pattern2, resolver) || overrideNestedCheck ? value3 : null;
        }
        if (!(pattern2 instanceof SequenceType)) {
            return overrideNestedCheck ? value2 : (Value)CollectionsKt.randomOrNull((Collection)((JSONArrayValue)value2).getList(), Random.Default);
        }
        int patternDepth2 = this.calculateDepth(pattern2, (Function1)new Function1<Pattern, List<? extends Pattern>>(resolver){
            final /* synthetic */ Resolver $resolver;
            {
                this.$resolver = $resolver;
                super(1);
            }

            public final List<Pattern> invoke(Pattern it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Pattern pattern2 = DeferredPatternKt.resolvedHop(it, this.$resolver);
                Object object = pattern2 instanceof SequenceType ? (SequenceType)((Object)pattern2) : null;
                return object != null && (object = object.getMemberList()) != null ? ((MemberList)object).patternList() : null;
            }
        });
        int valueDepth2 = this.calculateDepth(value2, getValueToMatch.valueDepth.1.INSTANCE);
        return valueDepth2 > patternDepth2 ? (Value)CollectionsKt.randomOrNull((Collection)((JSONArrayValue)value2).getList(), Random.Default) : value2;
    }

    static /* synthetic */ Value getValueToMatch$default(Dictionary dictionary, Value value2, Pattern pattern2, Resolver resolver, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return dictionary.getValueToMatch(value2, pattern2, resolver, bl);
    }

    private final <T> int calculateDepth(T data2, Function1<? super T, ? extends List<? extends T>> getChildren) {
        int n;
        List<T> list = getChildren.invoke(data2);
        if (list == null) {
            return 0;
        }
        List<T> children2 = list;
        if (children2.isEmpty()) {
            n = 1;
        } else {
            Iterable iterable = children2;
            int n2 = 1;
            Iterator iterator2 = iterable.iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Object it = iterator2.next();
            boolean bl = false;
            int n3 = this.calculateDepth(it, getChildren);
            while (iterator2.hasNext()) {
                Object it2 = iterator2.next();
                $i$a$-maxOf-Dictionary$calculateDepth$1 = false;
                int n4 = this.calculateDepth(it2, getChildren);
                if (n3 >= n4) continue;
                n3 = n4;
            }
            int n5 = n3;
            n = n2 + n5;
        }
        return n;
    }

    private final String tailEndKey(String $this$tailEndKey) {
        return StringsKt.removeSuffix(StringsKt.substringAfterLast$default($this$tailEndKey, ".", null, 2, null), (CharSequence)"[*]");
    }

    private final boolean isScalar(Pattern $this$isScalar, Resolver resolver) {
        Pattern resolved2 = DeferredPatternKt.resolvedHop($this$isScalar, resolver);
        return resolved2 instanceof ScalarType || resolved2 instanceof URLPathSegmentPattern || resolved2 instanceof QueryParameterScalarPattern;
    }

    private final Dictionary resetFocus() {
        return Dictionary.copy$default(this, null, MapsKt.emptyMap(), 1, null);
    }

    private final Map<String, Value> component1() {
        return this.data;
    }

    private final Map<String, Value> component2() {
        return this.focusedData;
    }

    @NotNull
    public final Dictionary copy(@NotNull Map<String, ? extends Value> data2, @NotNull Map<String, ? extends Value> focusedData) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(focusedData, "focusedData");
        return new Dictionary(data2, focusedData);
    }

    public static /* synthetic */ Dictionary copy$default(Dictionary dictionary, Map map2, Map map3, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = dictionary.data;
        }
        if ((n & 2) != 0) {
            map3 = dictionary.focusedData;
        }
        return dictionary.copy(map2, map3);
    }

    @NotNull
    public String toString() {
        return "Dictionary(data=" + this.data + ", focusedData=" + this.focusedData + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.data).hashCode();
        result2 = result2 * 31 + ((Object)this.focusedData).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Dictionary)) {
            return false;
        }
        Dictionary dictionary = (Dictionary)other;
        if (!Intrinsics.areEqual(this.data, dictionary.data)) {
            return false;
        }
        return Intrinsics.areEqual(this.focusedData, dictionary.focusedData);
    }

    public static final /* synthetic */ Value access$getValueToMatch(Dictionary $this, Value value2, Pattern pattern2, Resolver resolver, boolean overrideNestedCheck) {
        return $this.getValueToMatch(value2, pattern2, resolver, overrideNestedCheck);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0005\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lio/specmatic/core/Dictionary$Companion;", "", "()V", "empty", "Lio/specmatic/core/Dictionary;", "from", "file", "Ljava/io/File;", "data", "", "", "Lio/specmatic/core/value/Value;", "fromYaml", "content", "specmatic-core"})
    @SourceDebugExtension(value={"SMAP\nDictionary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dictionary.kt\nio/specmatic/core/Dictionary$Companion\n+ 2 Grammar.kt\nio/specmatic/core/pattern/GrammarKt\n*L\n1#1,157:1\n385#2,3:158\n*S KotlinDebug\n*F\n+ 1 Dictionary.kt\nio/specmatic/core/Dictionary$Companion\n*L\n125#1:158,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Dictionary from(@NotNull File file2) {
            Object $this$from_u24lambda_u240;
            Intrinsics.checkNotNullParameter(file2, "file");
            if (!file2.exists()) {
                String string = file2.getPath();
                String string2 = "Expected dictionary file at " + file2.getPath() + ", but it does not exist";
                Intrinsics.checkNotNull(string);
                throw new ContractException(string2, string, null, null, false, 28, null);
            }
            if (!file2.isFile()) {
                String string = file2.getPath();
                String string3 = "Expected dictionary file at " + file2.getPath() + " to be a file";
                Intrinsics.checkNotNull(string);
                throw new ContractException(string3, string, null, null, false, 28, null);
            }
            Object object = this;
            try {
                $this$from_u24lambda_u240 = object;
                boolean bl = false;
                LoggingKt.getLogger().log("Using dictionary file " + file2.getPath());
                File file$iv = file2;
                boolean $i$f$readValueAs = false;
                Value parsedValue$iv = GrammarKt.readValue(file$iv);
                if (!(parsedValue$iv instanceof JSONObjectValue)) {
                    throw new ClassCastException("Expected " + Reflection.getOrCreateKotlinClass(JSONObjectValue.class).getSimpleName() + " but got " + Reflection.getOrCreateKotlinClass(parsedValue$iv.getClass()).getSimpleName());
                }
                Map<String, Value> dictionaryContent = ((JSONObjectValue)parsedValue$iv).getJsonObject();
                $this$from_u24lambda_u240 = Result.constructor-impl(((Companion)$this$from_u24lambda_u240).from(dictionaryContent));
            }
            catch (Throwable bl) {
                $this$from_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object = $this$from_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Throwable e2 = throwable;
                boolean bl = false;
                LogStrategy.debug$default(LoggingKt.getLogger(), e2, null, 2, null);
                String string = file2.getPath();
                String string4 = "Could not parse dictionary file " + file2.getPath() + ", it must be a valid JSON/YAML object:\n" + Utilities.exceptionCauseMessage(e2);
                Intrinsics.checkNotNull(string);
                throw new ContractException(string4, string, null, null, false, 28, null);
            }
            return (Dictionary)object;
        }

        @NotNull
        public final Dictionary fromYaml(@NotNull String content2) {
            Object $this$fromYaml_u24lambda_u242;
            Intrinsics.checkNotNullParameter(content2, "content");
            Object object = this;
            try {
                $this$fromYaml_u24lambda_u242 = object;
                boolean bl = false;
                Value value2 = YAMLSerialisationKt.yamlStringToValue(content2);
                if (!(value2 instanceof JSONObjectValue)) {
                    throw new ContractException("Expected dictionary file to be a YAML object", null, null, null, false, 30, null);
                }
                $this$fromYaml_u24lambda_u242 = Result.constructor-impl(((Companion)$this$fromYaml_u24lambda_u242).from(((JSONObjectValue)value2).getJsonObject()));
            }
            catch (Throwable bl) {
                $this$fromYaml_u24lambda_u242 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object = $this$fromYaml_u24lambda_u242;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Throwable e2 = throwable;
                boolean bl = false;
                String string = Utilities.exceptionCauseMessage(e2);
                throw new ContractException(string, "Error while parsing YAML dictionary content", null, null, false, 28, null);
            }
            return (Dictionary)object;
        }

        @NotNull
        public final Dictionary from(@NotNull Map<String, ? extends Value> data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            return new Dictionary(data2, null, 2, null);
        }

        @NotNull
        public final Dictionary empty() {
            return new Dictionary(MapsKt.emptyMap(), null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

