/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.request.forms.FormBuilder;
import io.ktor.client.request.forms.FormDataContent;
import io.ktor.client.request.forms.FormDslKt;
import io.ktor.client.request.forms.MultiPartFormDataContent;
import io.ktor.http.CodecsKt;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.ParametersKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.TextContent;
import io.ktor.util.reflect.TypeInfoJvmKt;
import io.specmatic.core.HttpHeadersPattern;
import io.specmatic.core.HttpHeadersPatternKt;
import io.specmatic.core.HttpPathPattern;
import io.specmatic.core.HttpPathPatternKt;
import io.specmatic.core.HttpQueryParamPattern;
import io.specmatic.core.HttpRequest;
import io.specmatic.core.HttpRequestKt;
import io.specmatic.core.HttpRequestMetadata;
import io.specmatic.core.HttpRequestPattern;
import io.specmatic.core.MultiPartContent;
import io.specmatic.core.MultiPartContentValue;
import io.specmatic.core.MultiPartFileValue;
import io.specmatic.core.MultiPartFormDataPattern;
import io.specmatic.core.MultiPartFormDataValue;
import io.specmatic.core.NoBodyValue;
import io.specmatic.core.QueryParameters;
import io.specmatic.core.Resolver;
import io.specmatic.core.URLParts;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.ExactValuePattern;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.QueryParameterArrayPattern;
import io.specmatic.core.pattern.QueryParameterScalarPattern;
import io.specmatic.core.pattern.StringPattern;
import io.specmatic.core.utilities.URIUtils;
import io.specmatic.core.value.EmptyStringKt;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import io.specmatic.core.value.XMLNode;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0086\b\u0018\u00002\u00020\u0001:\u0006\u0083\u0001\u0084\u0001\u0085\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u008f\u0001\b\u0016\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014Bw\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0017J\u0016\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003J\u0016\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003J\r\u00107\u001a\u00020 H\u0000\u00a2\u0006\u0002\b8J\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>J\u000b\u0010?\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\t\u0010B\u001a\u00020\u000bH\u00c6\u0003J\t\u0010C\u001a\u00020\u0016H\u00c6\u0003J\u0015\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\u000f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J\t\u0010F\u001a\u00020\u0013H\u00c6\u0003J$\u0010G\u001a\u00020\u00032\b\u0010H\u001a\u0004\u0018\u00010\u00032\b\u0010I\u001a\u0004\u0018\u00010\u00032\u0006\u0010J\u001a\u00020\u0003H\u0002J{\u0010K\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\u0013\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\r\u0010O\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u0010PJ\u0010\u0010Q\u001a\u0004\u0018\u00010\u00032\u0006\u0010R\u001a\u00020\u0003J\u0010\u0010S\u001a\u00020\u00032\b\u0010T\u001a\u0004\u0018\u00010\u0003J\u000e\u0010U\u001a\u00020M2\u0006\u00102\u001a\u00020\u0003J\u000e\u0010V\u001a\u00020M2\u0006\u00102\u001a\u00020\u0003J\t\u0010W\u001a\u00020 H\u00d6\u0001J\r\u0010X\u001a\u00020 H\u0000\u00a2\u0006\u0002\bYJ\u0010\u0010Z\u001a\u00020M2\u0006\u0010[\u001a\u00020\u0003H\u0002J\u0010\u0010\\\u001a\u00020M2\u0006\u0010[\u001a\u00020\u0003H\u0002J\u0006\u0010]\u001a\u00020MJ\u0006\u0010^\u001a\u00020\u0000J(\u0010_\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020`0\t2\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u0002J\u001c\u0010b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020`0\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\r\u0010c\u001a\u00020 H\u0000\u00a2\u0006\u0002\bdJ\r\u0010e\u001a\u00020 H\u0000\u00a2\u0006\u0002\bfJ\u0006\u0010g\u001a\u00020\u0003J\u000e\u0010g\u001a\u00020\u00032\u0006\u0010h\u001a\u00020iJ\u0006\u0010j\u001a\u00020\u0003J\u001a\u0010k\u001a\u00020\u00002\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tJ\u0006\u0010m\u001a\u00020nJ\u0010\u0010o\u001a\u00020\u00032\b\b\u0002\u0010p\u001a\u00020\u0003J\u0006\u0010q\u001a\u00020rJ\t\u0010s\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010t\u001a\u00020\u00002\u0006\u0010u\u001a\u00020\u0003J\u000e\u0010v\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010v\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0003J\u0016\u0010w\u001a\u00020\u00002\u0006\u0010R\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003J\u000e\u0010x\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0003J\u000e\u0010y\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010z\u001a\u00020\u00002\u0006\u0010R\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003J\u001a\u0010{\u001a\u00020\u00002\u0012\u0010|\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tJ\u000e\u0010}\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0005J\u001a\u0010~\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00032\b\u0010\u007f\u001a\u0004\u0018\u00010\u0003H\u0002J\u000f\u0010\u0080\u0001\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0003J3\u0010\u0081\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\b\u0010=\u001a\u0004\u0018\u00010>H\u0002J\u0007\u0010\u0082\u0001\u001a\u00020\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010\u001f\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001eR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001cR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001cR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001b\u0010.\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010$\u001a\u0004\b/\u0010\"\u00a8\u0006\u0086\u0001"}, d2={"Lio/specmatic/core/HttpRequest;", "", "method", "", "uri", "Ljava/net/URI;", "(Ljava/lang/String;Ljava/net/URI;)V", "path", "headers", "", "body", "Lio/specmatic/core/value/Value;", "queryParametersMap", "formFields", "multiPartFormData", "", "Lio/specmatic/core/MultiPartFormDataValue;", "marker", "metadata", "Lio/specmatic/core/HttpRequestMetadata;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lio/specmatic/core/value/Value;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;Ljava/lang/String;Lio/specmatic/core/HttpRequestMetadata;)V", "queryParams", "Lio/specmatic/core/QueryParameters;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lio/specmatic/core/value/Value;Lio/specmatic/core/QueryParameters;Ljava/util/Map;Ljava/util/List;Lio/specmatic/core/HttpRequestMetadata;)V", "getBody", "()Lio/specmatic/core/value/Value;", "bodyString", "getBodyString", "()Ljava/lang/String;", "getFormFields", "()Ljava/util/Map;", "generality", "", "getGenerality", "()I", "generality$delegate", "Lkotlin/Lazy;", "getHeaders", "getMetadata", "()Lio/specmatic/core/HttpRequestMetadata;", "getMethod", "getMultiPartFormData", "()Ljava/util/List;", "getPath", "getQueryParams", "()Lio/specmatic/core/QueryParameters;", "specificity", "getSpecificity", "specificity$delegate", "addHeaderIfMissing", "name", "value", "addSecurityHeader", "headerName", "headerValue", "bodySpecificity", "bodySpecificity$specmatic_core", "buildKTORRequest", "", "httpRequestBuilder", "Lio/ktor/client/request/HttpRequestBuilder;", "url", "Ljava/net/URL;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "concatNonNulls", "first", "second", "separator", "copy", "equals", "", "other", "expectedResponseCode", "()Ljava/lang/Integer;", "getHeader", "key", "getURL", "baseURL", "hasHeader", "hasQueryParam", "hashCode", "headerSpecificity", "headerSpecificity$specmatic_core", "isIPAddress", "host", "isNotIPAddress", "isRequestExpectingAcceptedResponse", "loadFileContentIntoParts", "mapToPattern", "Lio/specmatic/core/pattern/Pattern;", "map", "mapToQueryParameterPattern", "pathSpecificity", "pathSpecificity$specmatic_core", "queryParamsSpecificity", "queryParamsSpecificity$specmatic_core", "requestNotRecognized", "requestNotRecognizedMessages", "Lio/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "requestNotRecognizedInStrictMode", "setHeaders", "addedHeaders", "toJSON", "Lio/specmatic/core/value/JSONObjectValue;", "toLogString", "prefix", "toPattern", "Lio/specmatic/core/HttpRequestPattern;", "toString", "trimBaseUrlPath", "baseUrlPath", "updateBody", "updateHeader", "updateMethod", "updatePath", "updateQueryParam", "updateQueryParams", "otherQueryParams", "updateWith", "updateWithPathAndQuery", "query", "withHost", "withoutDuplicateHostHeader", "withoutTransportHeaders", "LenientRequestNotRecognizedMessages", "RequestNotRecognizedMessages", "StrictRequestNotRecognizedMessages", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nHttpRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequest.kt\nio/specmatic/core/HttpRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 RequestBody.kt\nio/ktor/client/request/RequestBodyKt\n+ 8 TypeInfoJvm.kt\nio/ktor/util/reflect/TypeInfoJvmKt\n*L\n1#1,725:1\n1549#2:726\n1620#2,3:727\n819#2:730\n847#2,2:731\n1238#2,4:736\n1549#2:740\n1620#2,3:741\n1549#2:752\n1620#2,3:753\n1238#2,4:758\n1477#2:762\n1502#2,3:763\n1505#2,3:773\n1238#2,2:778\n1549#2:780\n1620#2,3:781\n1241#2:784\n766#2:793\n857#2,2:794\n1855#2,2:796\n1238#2,4:800\n1549#2:823\n1620#2,3:824\n1549#2:827\n1620#2,3:828\n1747#2,3:838\n1774#2,4:848\n1774#2,4:852\n1774#2,4:856\n1#3:733\n453#4:734\n403#4:735\n453#4:756\n403#4:757\n372#4,7:766\n453#4:776\n403#4:777\n453#4:798\n403#4:799\n478#4,7:831\n526#4:841\n511#4,6:842\n125#5:744\n152#5,3:745\n125#5:748\n152#5,3:749\n125#5:785\n152#5,3:786\n125#5:789\n152#5,3:790\n37#6,2:804\n16#7,4:806\n21#7,10:813\n17#8,3:810\n*S KotlinDebug\n*F\n+ 1 HttpRequest.kt\nio/specmatic/core/HttpRequest\n*L\n137#1:726\n137#1:727,3\n142#1:730\n142#1:731,2\n156#1:736,4\n159#1:740\n159#1:741,3\n203#1:752\n203#1:753,3\n208#1:758,4\n217#1:762\n217#1:763,3\n217#1:773,3\n218#1:778,2\n219#1:780\n219#1:781,3\n218#1:784\n243#1:793\n243#1:794,2\n244#1:796,2\n257#1:800,4\n300#1:823\n300#1:824,3\n309#1:827\n309#1:828,3\n412#1:838,3\n440#1:848,4\n442#1:852,4\n445#1:856,4\n156#1:734\n156#1:735\n208#1:756\n208#1:757\n217#1:766,7\n218#1:776\n218#1:777\n257#1:798\n257#1:799\n394#1:831,7\n416#1:841\n416#1:842,6\n178#1:744\n178#1:745,3\n180#1:748\n180#1:749,3\n226#1:785\n226#1:786,3\n242#1:789\n242#1:790,3\n258#1:804,2\n254#1:806,4\n254#1:813,10\n254#1:810,3\n*E\n"})
public final class HttpRequest {
    @Nullable
    private final String method;
    @Nullable
    private final String path;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final Value body;
    @NotNull
    private final QueryParameters queryParams;
    @NotNull
    private final Map<String, String> formFields;
    @NotNull
    private final List<MultiPartFormDataValue> multiPartFormData;
    @NotNull
    private final HttpRequestMetadata metadata;
    @NotNull
    private final Lazy generality$delegate;
    @NotNull
    private final Lazy specificity$delegate;

    public HttpRequest(@Nullable String method2, @Nullable String path2, @NotNull Map<String, String> headers2, @NotNull Value body2, @NotNull QueryParameters queryParams2, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData, @NotNull HttpRequestMetadata metadata) {
        Intrinsics.checkNotNullParameter(headers2, "headers");
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(queryParams2, "queryParams");
        Intrinsics.checkNotNullParameter(formFields, "formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, "multiPartFormData");
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        this.method = method2;
        this.path = path2;
        this.headers = headers2;
        this.body = body2;
        this.queryParams = queryParams2;
        this.formFields = formFields;
        this.multiPartFormData = multiPartFormData;
        this.metadata = metadata;
        this.generality$delegate = LazyKt.lazy((Function0)new Function0<Integer>(this){
            final /* synthetic */ HttpRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Integer invoke() {
                int n;
                int n2;
                int n3;
                String[] stringArray;
                Object object = this.this$0.getPath();
                if (object != null && (object = StringsKt.split$default((CharSequence)object, stringArray = new String[]{"/"}, false, 0, 6, null)) != null) {
                    Iterable $this$count$iv = (Iterable)object;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n3 = 0;
                    } else {
                        int count$iv = 0;
                        for (T element$iv : $this$count$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            if (!new StringValue(it).isPatternToken() || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n3 = count$iv;
                    }
                } else {
                    n3 = 0;
                }
                int pathScore = n3;
                Iterable iterable = this.this$0.getHeaders().values();
                int n4 = 0;
                for (T t2 : iterable) {
                    void it;
                    String count$iv = (String)t2;
                    n2 = n4;
                    boolean bl = false;
                    n = GrammarKt.isPatternToken(it) ? 1 : 0;
                    n4 = n2 + n;
                }
                int headerScore = n4;
                Iterable iterable2 = this.this$0.getQueryParams().getParamPairs();
                int n5 = 0;
                for (T t3 : iterable2) {
                    void it;
                    Pair bl = (Pair)t3;
                    n2 = n5;
                    boolean bl2 = false;
                    n = GrammarKt.isPatternToken(it.getSecond()) ? 1 : 0;
                    n5 = n2 + n;
                }
                int queryScore = n5;
                int bodyScore = this.this$0.getBody().generality();
                return pathScore + headerScore + queryScore + bodyScore;
            }
        });
        this.specificity$delegate = LazyKt.lazy((Function0)new Function0<Integer>(this){
            final /* synthetic */ HttpRequest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Integer invoke() {
                return this.this$0.pathSpecificity$specmatic_core() + this.this$0.headerSpecificity$specmatic_core() + this.this$0.queryParamsSpecificity$specmatic_core() + this.this$0.bodySpecificity$specmatic_core();
            }
        });
    }

    public /* synthetic */ HttpRequest(String string, String string2, Map map2, Value value2, QueryParameters queryParameters2, Map map3, List list, HttpRequestMetadata httpRequestMetadata, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            value2 = EmptyStringKt.getEmptyString();
        }
        if ((n & 0x10) != 0) {
            queryParameters2 = new QueryParameters(null, 1, null);
        }
        if ((n & 0x20) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            httpRequestMetadata = new HttpRequestMetadata(null, 1, null);
        }
        this(string, string2, map2, value2, queryParameters2, map3, list, httpRequestMetadata);
    }

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Value getBody() {
        return this.body;
    }

    @NotNull
    public final QueryParameters getQueryParams() {
        return this.queryParams;
    }

    @NotNull
    public final Map<String, String> getFormFields() {
        return this.formFields;
    }

    @NotNull
    public final List<MultiPartFormDataValue> getMultiPartFormData() {
        return this.multiPartFormData;
    }

    @NotNull
    public final HttpRequestMetadata getMetadata() {
        return this.metadata;
    }

    public HttpRequest(@NotNull String method2, @NotNull URI uri2) {
        Intrinsics.checkNotNullParameter(method2, "method");
        Intrinsics.checkNotNullParameter(uri2, "uri");
        this(method2, uri2.getPath(), null, null, HttpRequestKt.urlToQueryParams(uri2), null, null, null, null, 492, null);
    }

    public HttpRequest(@Nullable String method2, @Nullable String path2, @NotNull Map<String, String> headers2, @NotNull Value body2, @NotNull Map<String, String> queryParametersMap, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData, @NotNull String marker, @NotNull HttpRequestMetadata metadata) {
        Intrinsics.checkNotNullParameter(headers2, "headers");
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(queryParametersMap, "queryParametersMap");
        Intrinsics.checkNotNullParameter(formFields, "formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, "multiPartFormData");
        Intrinsics.checkNotNullParameter(marker, "marker");
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        this(method2, path2, headers2, body2, new QueryParameters(queryParametersMap), formFields, multiPartFormData, metadata);
    }

    public /* synthetic */ HttpRequest(String string, String string2, Map map2, Value value2, Map map3, Map map4, List list, String string3, HttpRequestMetadata httpRequestMetadata, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            value2 = EmptyStringKt.getEmptyString();
        }
        if ((n & 0x10) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            map4 = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            string3 = "Dummy";
        }
        if ((n & 0x100) != 0) {
            httpRequestMetadata = new HttpRequestMetadata(null, 1, null);
        }
        this(string, string2, map2, value2, map3, map4, list, string3, httpRequestMetadata);
    }

    @NotNull
    public final HttpRequest trimBaseUrlPath(@NotNull String baseUrlPath) {
        Intrinsics.checkNotNullParameter(baseUrlPath, "baseUrlPath");
        String string = this.path;
        String string2 = string != null ? StringsKt.replaceFirst$default(string, baseUrlPath, "", false, 4, null) : null;
        if (string2 == null) {
            string2 = "";
        }
        return HttpRequest.copy$default(this, null, string2, null, null, null, null, null, null, 253, null);
    }

    @NotNull
    public final HttpRequest addHeaderIfMissing(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        if (this.headers.containsKey(name)) {
            return this;
        }
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, TuplesKt.to(name, value2)), null, null, null, null, null, 251, null);
    }

    public final boolean isRequestExpectingAcceptedResponse() {
        return Intrinsics.areEqual(this.headers.get("Specmatic-Response-Code"), String.valueOf(HttpStatusCode.Companion.getAccepted().getValue()));
    }

    @NotNull
    public final HttpRequest updateQueryParams(@NotNull Map<String, String> otherQueryParams) {
        Intrinsics.checkNotNullParameter(otherQueryParams, "otherQueryParams");
        return HttpRequest.copy$default(this, null, null, null, null, this.queryParams.plus(otherQueryParams), null, null, null, 239, null);
    }

    @NotNull
    public final HttpRequest withHost(@NotNull String host2) {
        Intrinsics.checkNotNullParameter(host2, "host");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, TuplesKt.to("Host", host2)), null, null, null, null, null, 251, null);
    }

    @NotNull
    public final HttpRequest updatePath(@NotNull String path2) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter(path2, "path");
        try {
            URI urlParam = new URI(CodecsKt.decodeURLPart$default(path2, 0, 0, null, 7, null));
            httpRequest = this.updateWith(urlParam);
        }
        catch (URISyntaxException e2) {
            String[] stringArray = new String[]{"?"};
            List pieces = StringsKt.split$default((CharSequence)path2, stringArray, false, 2, 2, null);
            httpRequest = this.updateWithPathAndQuery((String)pieces.get(0), (String)CollectionsKt.getOrNull(pieces, 1));
        }
        catch (UnsupportedEncodingException e3) {
            String[] stringArray = new String[]{"?"};
            List pieces = StringsKt.split$default((CharSequence)path2, stringArray, false, 2, 2, null);
            httpRequest = this.updateWithPathAndQuery((String)pieces.get(0), (String)CollectionsKt.getOrNull(pieces, 1));
        }
        return httpRequest;
    }

    @NotNull
    public final HttpRequest updateQueryParam(@NotNull String key2, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        return HttpRequest.copy$default(this, null, null, null, null, this.queryParams.plus(TuplesKt.to(key2, value2)), null, null, null, 239, null);
    }

    @NotNull
    public final HttpRequest updateBody(@NotNull Value body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        return HttpRequest.copy$default(this, null, null, null, body2, null, null, null, null, 247, null);
    }

    @NotNull
    public final HttpRequest updateBody(@Nullable String body2) {
        return HttpRequest.copy$default(this, null, null, null, GrammarKt.parsedValue(body2), null, null, null, null, 247, null);
    }

    @NotNull
    public final HttpRequest updateWith(@NotNull URI url2) {
        Intrinsics.checkNotNullParameter(url2, "url");
        String string = url2.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        return this.updateWithPathAndQuery(string, url2.getQuery());
    }

    private final HttpRequest updateWithPathAndQuery(String path2, String query2) {
        Map<String, String> queryParams2 = URIUtils.INSTANCE.parseQuery(query2);
        return HttpRequest.copy$default(this, null, path2, null, null, new QueryParameters(queryParams2), null, null, null, 237, null);
    }

    @NotNull
    public final HttpRequest updateMethod(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return HttpRequest.copy$default(this, string, null, null, null, null, null, null, null, 254, null);
    }

    @NotNull
    public final HttpRequest updateHeader(@NotNull String key2, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, TuplesKt.to(key2, value2)), null, null, null, null, null, 251, null);
    }

    @NotNull
    public final String getBodyString() {
        return this.body.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getURL(@Nullable String baseURL) {
        void $this$mapTo$iv$iv;
        String string = baseURL;
        String cleanBase = string != null ? StringsKt.removeSuffix(string, (CharSequence)"/") : null;
        String string2 = this.path;
        String cleanPath = string2 != null ? StringsKt.removePrefix(string2, (CharSequence)"/") : null;
        String fullUrl = new URLParts(this.concatNonNulls(cleanBase, cleanPath, "/")).withEncodedPathSegments();
        Iterable $this$map$iv = this.queryParams.getParamPairs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BasicNameValuePair((String)it.getFirst(), (String)it.getSecond()));
        }
        String queryPart = URLEncodedUtils.format((List)destination$iv$iv, Charsets.UTF_8);
        return this.concatNonNulls(fullUrl, queryPart, "?");
    }

    /*
     * WARNING - void declaration
     */
    private final String concatNonNulls(String first2, String second2, String separator) {
        void $this$filterNotTo$iv$iv;
        String[] stringArray = new String[]{first2, second2};
        Iterable $this$filterNot$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            if (charSequence == null || StringsKt.isBlank(charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, separator, null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObjectValue toJSON() {
        Unit unit;
        StringValue stringValue;
        Map requestMap;
        Map map2 = requestMap = (Map)new LinkedHashMap();
        String string = "path";
        String string2 = this.path;
        if (string2 != null && (string2 = CodecsKt.encodeURLPath(string2)) != null) {
            String it = string2;
            boolean bl = false;
            stringValue = new StringValue(it);
        } else {
            stringValue = new StringValue("/");
        }
        Value value2 = stringValue;
        map2.put(string, value2);
        String string3 = this.method;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            requestMap.put("method", new StringValue(it));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ContractException("Can't serialise the request without a method.", null, null, null, false, 30, null);
        }
        HttpRequestKt.access$setIfNotEmpty(requestMap, "query", this.queryParams.asJsonMap());
        HttpRequestKt.access$setIfNotEmpty(requestMap, "headers", this.headers);
        if (!this.formFields.isEmpty()) {
            void $this$mapValuesTo$iv$iv;
            map2 = requestMap;
            string = "form-fields";
            Object $this$mapValues$iv = this.formFields;
            boolean $i$f$mapValues = false;
            Map<String, String> bl = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl3 = false;
                StringValue stringValue2 = new StringValue((String)it.getValue());
                map4.put(k2, stringValue2);
            }
            Map map5 = destination$iv$iv;
            $this$mapValues$iv = new JSONObjectValue(map5);
            map2.put(string, $this$mapValues$iv);
        } else if (!((Collection)this.multiPartFormData).isEmpty()) {
            void $this$mapTo$iv$iv;
            map2 = requestMap;
            string = "multipart-formdata";
            Iterable $this$map$iv = this.multiPartFormData;
            boolean $i$f$map = false;
            Iterable $this$mapValuesTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toJSONObject());
            }
            List list = (List)destination$iv$iv;
            value2 = new JSONArrayValue(list);
            map2.put(string, value2);
        } else {
            requestMap.put("body", this.body);
        }
        return new JSONObjectValue(requestMap);
    }

    @NotNull
    public final HttpRequest setHeaders(@NotNull Map<String, String> addedHeaders) {
        Intrinsics.checkNotNullParameter(addedHeaders, "addedHeaders");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, addedHeaders), null, null, null, null, null, 251, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toLogString(@NotNull String prefix2) {
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv;
        String string;
        String methodString;
        Intrinsics.checkNotNullParameter(prefix2, "prefix");
        String string2 = this.method;
        if (string2 == null) {
            string2 = methodString = "NO_METHOD";
        }
        if ((string = this.path) == null) {
            string = "NO_PATH";
        }
        String pathString = string;
        String it = CollectionsKt.joinToString$default(this.queryParams.getParamPairs(), "&", null, null, 0, null, toLogString.queryParamString.1.INSTANCE, 30, null);
        boolean bl = false;
        Object queryParamString2 = ((CharSequence)it).length() > 0 ? "?" + it : it;
        String urlString = pathString + (String)queryParamString2;
        String firstLine = methodString + " " + urlString;
        Map<String, String> $this$map$iv = this.headers;
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it2.getKey() + ": " + it2.getValue());
        }
        String headerString2 = CollectionsKt.joinToString$default((List)destination$iv$iv, "\n", null, null, 0, null, null, 62, null);
        if (!this.formFields.isEmpty()) {
            void $this$mapTo$iv$iv2;
            Map<String, String> $this$map$iv2 = this.formFields;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator3 = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                void it3;
                Map.Entry item$iv$iv;
                Map.Entry bl2 = item$iv$iv = iterator3.next();
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it3.getKey() + "=" + it3.getValue());
            }
            object = CollectionsKt.joinToString$default((List)destination$iv$iv2, "&", null, null, 0, null, null, 62, null);
        } else {
            object = !((Collection)this.multiPartFormData).isEmpty() ? CollectionsKt.joinToString$default(this.multiPartFormData, "\n", null, null, 0, null, toLogString.bodyString.2.INSTANCE, 30, null) : this.body.toString();
        }
        String[] it4 = object;
        boolean bl4 = false;
        String bodyString2 = HttpRequestKt.formatJson((String)it4);
        it4 = new String[]{firstLine, headerString2};
        String firstPart = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default(CollectionsKt.listOf(it4), "\n", null, null, 0, null, null, 62, null))).toString();
        String[] stringArray = new String[]{firstPart, "", bodyString2};
        String requestString = CollectionsKt.joinToString$default(CollectionsKt.listOf(stringArray), "\n", null, null, 0, null, null, 62, null);
        return HttpRequestKt.startLinesWith(requestString, prefix2);
    }

    public static /* synthetic */ String toLogString$default(HttpRequest httpRequest, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return httpRequest.toLogString(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequestPattern toPattern() {
        Collection<MultiPartFormDataPattern> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = this.path;
        if (string == null) {
            string = "/";
        }
        String pathForPattern = string;
        Iterable iterable = this.multiPartFormData;
        Map<String, Pattern> map2 = this.mapToPattern(this.formFields);
        Pattern pattern2 = this.body.exactMatchElseType();
        String string2 = this.method;
        HttpQueryParamPattern httpQueryParamPattern = new HttpQueryParamPattern(this.mapToQueryParameterPattern(this.queryParams), null, 2, null);
        HttpPathPattern httpPathPattern = new HttpPathPattern(HttpPathPatternKt.pathToPattern(pathForPattern), pathForPattern, null, 4, null);
        HttpHeadersPattern httpHeadersPattern = new HttpHeadersPattern(this.mapToPattern(this.headers), null, null, 6, null);
        boolean $i$f$map = false;
        void var4_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.inferType());
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 128;
        List list = null;
        Collection<MultiPartFormDataPattern> collection2 = collection;
        Map<String, Pattern> map3 = map2;
        Pattern pattern3 = pattern2;
        String string3 = string2;
        HttpQueryParamPattern httpQueryParamPattern2 = httpQueryParamPattern;
        HttpPathPattern httpPathPattern2 = httpPathPattern;
        HttpHeadersPattern httpHeadersPattern2 = httpHeadersPattern;
        return new HttpRequestPattern(httpHeadersPattern2, httpPathPattern2, httpQueryParamPattern2, string3, pattern3, map3, (List)collection2, list, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Pattern> mapToPattern(Map<String, String> map2) {
        void $this$mapValuesTo$iv$iv;
        Map<String, String> $this$mapValues$iv = map2;
        boolean $i$f$mapValues = false;
        Map<String, String> map3 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            Map map5 = map4;
            boolean bl2 = false;
            String value2 = (String)entry2.getValue();
            Pattern pattern2 = GrammarKt.isPatternToken(value2) ? GrammarKt.parsedPattern$default(value2, null, null, 6, null) : (Pattern)new ExactValuePattern(new StringValue(value2), null, false, 6, null);
            map5.put(k2, pattern2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Pattern> mapToQueryParameterPattern(QueryParameters queryParams2) {
        void $this$mapTo$iv$iv;
        Map queryParamGroups;
        Object object;
        Map $this$mapValuesTo$iv$iv;
        Map $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = queryParams2.getParamPairs();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Object t2 = iterator2.next();
            Pair it = (Pair)t2;
            boolean bl = false;
            key$iv$iv = (String)it.getFirst();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(t2);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean bl = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv2;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            List keyValuePairs = (List)entry.getValue();
            Iterable $this$map$iv = keyValuePairs;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                String value2 = (String)pair.component2();
                collection.add(GrammarKt.isPatternToken(value2) ? GrammarKt.parsedPattern$default(value2, null, null, 6, null) : (Pattern)new ExactValuePattern(new StringValue(value2), null, false, 6, null));
            }
            List list = (List)destination$iv$iv2;
            object.put(k2, list);
        }
        Map $this$map$iv = queryParamGroups = destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapValuesTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            Map.Entry entry2 = entry;
            object = destination$iv$iv;
            boolean bl3 = false;
            String parameterKey = (String)entry2.getKey();
            List parameterPatterns = (List)entry2.getValue();
            object.add(parameterPatterns.size() > 1 ? TuplesKt.to(parameterKey, new QueryParameterArrayPattern(parameterPatterns, parameterKey)) : TuplesKt.to(parameterKey, new QueryParameterScalarPattern((Pattern)CollectionsKt.single(parameterPatterns))));
        }
        return MapsKt.toMap((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void buildKTORRequest(@NotNull HttpRequestBuilder httpRequestBuilder, @Nullable URL url2) {
        HttpRequestBuilder $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Triple it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(httpRequestBuilder, "httpRequestBuilder");
        String string = this.method;
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type kotlin.String");
        httpRequestBuilder.setMethod(HttpMethod.Companion.parse(string));
        List<String> listOfExcludedHeaders = HttpRequestKt.listOfExcludedHeaders();
        Map<String, String> map2 = this.withoutDuplicateHostHeader(this.headers, url2);
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            object = destination$iv$iv;
            boolean bl = false;
            String string2 = ((Object)StringsKt.trim((CharSequence)((String)it.getKey()))).toString();
            String string3 = ((Object)StringsKt.trim((CharSequence)((String)it.getKey()))).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            object.add(new Triple<String, String, String>(string2, string3, ((Object)StringsKt.trim((CharSequence)((String)it.getValue()))).toString()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv = iterator2.next();
            it = (Triple)((Object)element$iv$iv);
            boolean bl = false;
            String loweredKey = (String)it.component2();
            if (!(!listOfExcludedHeaders.contains(loweredKey))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object element$iv = $this$filterTo$iv$iv.next();
            Triple $i$f$filterTo2 = (Triple)element$iv;
            boolean bl = false;
            String key2 = (String)$i$f$filterTo2.component1();
            String value2 = (String)$i$f$filterTo2.component3();
            UtilsKt.header(httpRequestBuilder, key2, value2);
        }
        URLBuilder it2 = httpRequestBuilder.getUrl();
        boolean bl = false;
        if (it2.getPort() == 0 || it2.getPort() == it2.getProtocol().getDefaultPort()) {
            UtilsKt.header(httpRequestBuilder, "Host", URLBuilderKt.getAuthority(it2));
        }
        if (!(this.body instanceof NoBodyValue)) {
            void body$iv;
            OutgoingContent outgoingContent;
            Object parameters2;
            $this$forEach$iv = httpRequestBuilder;
            if (!this.formFields.isEmpty()) {
                void $this$mapValuesTo$iv$iv;
                Pair[] $this$mapValues$iv = this.formFields;
                boolean $i$f$mapValues = false;
                Pair[] $i$f$filterTo2 = $this$mapValues$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it3;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv2;
                    boolean bl2 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k2 = it$iv$iv.getKey();
                    object = map3;
                    boolean bl3 = false;
                    List list = CollectionsKt.listOf(it3.getValue());
                    object.put(k2, list);
                }
                parameters2 = MapsKt.toList(destination$iv$iv2);
                Collection $this$toTypedArray$iv = (Collection)parameters2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$mapValues$iv = thisCollection$iv.toArray(new Pair[0]);
                outgoingContent = new FormDataContent(ParametersKt.parametersOf(Arrays.copyOf($this$mapValues$iv, $this$mapValues$iv.length)));
            } else if (!((Collection)this.multiPartFormData).isEmpty()) {
                outgoingContent = new MultiPartFormDataContent(FormDslKt.formData((Function1<? super FormBuilder, Unit>)new Function1<FormBuilder, Unit>(this){
                    final /* synthetic */ HttpRequest this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(FormBuilder $this$formData) {
                        Intrinsics.checkNotNullParameter($this$formData, "$this$formData");
                        Iterable $this$forEach$iv = this.this$0.getMultiPartFormData();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            MultiPartFormDataValue value2 = (MultiPartFormDataValue)element$iv;
                            boolean bl = false;
                            value2.addTo($this$formData);
                        }
                    }
                }), null, null, 6, null);
            } else {
                TextContent textContent;
                if (this.headers.containsKey("Content-Type")) {
                    String string4 = this.getBodyString();
                    String string5 = this.headers.get("Content-Type");
                    Intrinsics.checkNotNull(string5, "null cannot be cast to non-null type kotlin.String");
                    textContent = new TextContent(string4, ContentType.Companion.parse(string5), null, 4, null);
                } else {
                    textContent = new TextContent(this.getBodyString(), ContentType.Companion.parse(this.body.getHttpContentType()), null, 4, null);
                }
                outgoingContent = textContent;
            }
            parameters2 = outgoingContent;
            boolean $i$f$setBody = false;
            void var7_11 = body$iv;
            if (var7_11 instanceof OutgoingContent) {
                $this$setBody$iv.setBody(body$iv);
                $this$setBody$iv.setBodyType(null);
            } else {
                $this$setBody$iv.setBody(body$iv);
                boolean $i$f$typeInfo = false;
                KType kType$iv$iv = Reflection.typeOf(OutgoingContent.class);
                Type reifiedType$iv$iv = TypesJVMKt.getJavaType(kType$iv$iv);
                $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl(reifiedType$iv$iv, Reflection.getOrCreateKotlinClass(OutgoingContent.class), kType$iv$iv));
            }
        }
    }

    private final Map<String, String> withoutDuplicateHostHeader(Map<String, String> headers2, URL url2) {
        if (url2 == null) {
            return headers2;
        }
        String string = url2.getHost();
        Intrinsics.checkNotNullExpressionValue(string, "getHost(...)");
        if (this.isNotIPAddress(string)) {
            return MapsKt.minus(headers2, "Host");
        }
        return headers2;
    }

    private final boolean isNotIPAddress(String host2) {
        return !this.isIPAddress(host2) && !Intrinsics.areEqual(host2, "localhost");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIPAddress(String host2) {
        boolean bl;
        try {
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{"."};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)host2, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(Integer.parseInt((String)it));
            }
            bl = !((Collection)((List)destination$iv$iv)).isEmpty();
        }
        catch (Throwable e2) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequest loadFileContentIntoParts() {
        void $this$mapTo$iv$iv;
        List<MultiPartFormDataValue> parts = this.multiPartFormData;
        Iterable $this$map$iv = parts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MultiPartFormDataValue multiPartFormDataValue;
            void part2;
            MultiPartFormDataValue multiPartFormDataValue2 = (MultiPartFormDataValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_11 = part2;
            if (var12_11 instanceof MultiPartContentValue) {
                multiPartFormDataValue = part2;
            } else if (var12_11 instanceof MultiPartFileValue) {
                File partFile = new File(StringsKt.removePrefix(((MultiPartFileValue)part2).getFilename(), (CharSequence)"@"));
                MultiPartContent binaryContent = partFile.exists() ? new MultiPartContent(partFile) : new MultiPartContent(new StringPattern(null, null, null, null, null, false, false, 127, null).generate(new Resolver()).toStringLiteral());
                multiPartFormDataValue = MultiPartFileValue.copy$default((MultiPartFileValue)part2, null, null, null, null, binaryContent, null, 47, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(multiPartFormDataValue);
        }
        List newMultiPartFormData = (List)destination$iv$iv;
        return HttpRequest.copy$default(this, null, null, null, null, null, null, newMultiPartFormData, null, 191, null);
    }

    @NotNull
    public final String requestNotRecognized(@NotNull RequestNotRecognizedMessages requestNotRecognizedMessages) {
        Intrinsics.checkNotNullParameter(requestNotRecognizedMessages, "requestNotRecognizedMessages");
        String soapActionHeader = "SOAPAction";
        String string = this.method;
        Intrinsics.checkNotNull(string);
        String method2 = string;
        String string2 = this.path;
        if (string2 == null) {
            string2 = "/";
        }
        String path2 = string2;
        return this.headers.containsKey(soapActionHeader) ? requestNotRecognizedMessages.soap(MapsKt.getValue(this.headers, soapActionHeader), path2) : (this.body instanceof XMLNode ? requestNotRecognizedMessages.xmlOverHttp(method2, path2) : requestNotRecognizedMessages.restful(method2, path2));
    }

    @NotNull
    public final String requestNotRecognized() {
        return this.requestNotRecognized(new LenientRequestNotRecognizedMessages());
    }

    @NotNull
    public final String requestNotRecognizedInStrictMode() {
        return this.requestNotRecognized(new StrictRequestNotRecognizedMessages());
    }

    @NotNull
    public final HttpRequest withoutTransportHeaders() {
        return HttpRequest.copy$default(this, null, null, HttpHeadersPatternKt.withoutTransportHeaders(this.headers), null, null, null, null, null, 251, null);
    }

    @NotNull
    public final HttpRequest addSecurityHeader(@NotNull String headerName, @NotNull String headerValue) {
        Intrinsics.checkNotNullParameter(headerName, "headerName");
        Intrinsics.checkNotNullParameter(headerValue, "headerValue");
        HttpRequestMetadata updatedMetadata = this.metadata.copy(SetsKt.plus(this.metadata.getSecurityHeaderNames(), headerName));
        Map<String, String> $this$filterKeys$iv = this.headers;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
            String key2 = entry$iv.getKey();
            boolean bl = false;
            boolean bl2 = !StringsKt.equals(key2, headerName, true);
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map<String, String> updatedHeaders = MapsKt.plus((Map)result$iv, TuplesKt.to(headerName, headerValue));
        return HttpRequest.copy$default(this, null, null, updatedHeaders, null, null, null, null, updatedMetadata, 123, null);
    }

    @Nullable
    public final Integer expectedResponseCode() {
        String string = this.headers.get("Specmatic-Response-Code");
        return string != null ? StringsKt.toIntOrNull(string) : null;
    }

    public final boolean hasHeader(@NotNull String name) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$any$iv = this.headers.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals(it, name, true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getHeader(@NotNull String key2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(key2, "key");
        Map<String, String> $this$filter$iv = this.headers;
        boolean $i$f$filter = false;
        Map<String, String> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!StringsKt.equals((String)it.getKey(), key2, true)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return (String)CollectionsKt.firstOrNull(destination$iv$iv.values());
    }

    public final boolean hasQueryParam(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.queryParams.containsKey(name);
    }

    public final int getGenerality() {
        Lazy lazy = this.generality$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getSpecificity() {
        Lazy lazy = this.specificity$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int bodySpecificity$specmatic_core() {
        return this.body.specificity();
    }

    /*
     * WARNING - void declaration
     */
    public final int queryParamsSpecificity$specmatic_core() {
        int n;
        Iterable $this$count$iv = this.queryParams.getParamPairs();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!(!GrammarKt.isPatternToken(it.getSecond())) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int headerSpecificity$specmatic_core() {
        int n;
        Iterable $this$count$iv = this.headers.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(!GrammarKt.isPatternToken(it)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final int pathSpecificity$specmatic_core() {
        int n;
        String[] stringArray;
        List list;
        String string;
        String string2 = string = Intrinsics.areEqual(this.path, "/") ? "" : this.path;
        if (string != null && (list = StringsKt.split$default((CharSequence)string, stringArray = new String[]{"/"}, false, 0, 6, null)) != null) {
            Iterable $this$count$iv = list;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!(!new StringValue(it).isPatternToken()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        } else {
            n = 0;
        }
        return n;
    }

    @Nullable
    public final String component1() {
        return this.method;
    }

    @Nullable
    public final String component2() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> component3() {
        return this.headers;
    }

    @NotNull
    public final Value component4() {
        return this.body;
    }

    @NotNull
    public final QueryParameters component5() {
        return this.queryParams;
    }

    @NotNull
    public final Map<String, String> component6() {
        return this.formFields;
    }

    @NotNull
    public final List<MultiPartFormDataValue> component7() {
        return this.multiPartFormData;
    }

    @NotNull
    public final HttpRequestMetadata component8() {
        return this.metadata;
    }

    @NotNull
    public final HttpRequest copy(@Nullable String method2, @Nullable String path2, @NotNull Map<String, String> headers2, @NotNull Value body2, @NotNull QueryParameters queryParams2, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData, @NotNull HttpRequestMetadata metadata) {
        Intrinsics.checkNotNullParameter(headers2, "headers");
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(queryParams2, "queryParams");
        Intrinsics.checkNotNullParameter(formFields, "formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, "multiPartFormData");
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        return new HttpRequest(method2, path2, headers2, body2, queryParams2, formFields, multiPartFormData, metadata);
    }

    public static /* synthetic */ HttpRequest copy$default(HttpRequest httpRequest, String string, String string2, Map map2, Value value2, QueryParameters queryParameters2, Map map3, List list, HttpRequestMetadata httpRequestMetadata, int n, Object object) {
        if ((n & 1) != 0) {
            string = httpRequest.method;
        }
        if ((n & 2) != 0) {
            string2 = httpRequest.path;
        }
        if ((n & 4) != 0) {
            map2 = httpRequest.headers;
        }
        if ((n & 8) != 0) {
            value2 = httpRequest.body;
        }
        if ((n & 0x10) != 0) {
            queryParameters2 = httpRequest.queryParams;
        }
        if ((n & 0x20) != 0) {
            map3 = httpRequest.formFields;
        }
        if ((n & 0x40) != 0) {
            list = httpRequest.multiPartFormData;
        }
        if ((n & 0x80) != 0) {
            httpRequestMetadata = httpRequest.metadata;
        }
        return httpRequest.copy(string, string2, map2, value2, queryParameters2, map3, list, httpRequestMetadata);
    }

    @NotNull
    public String toString() {
        return "HttpRequest(method=" + this.method + ", path=" + this.path + ", headers=" + this.headers + ", body=" + this.body + ", queryParams=" + this.queryParams + ", formFields=" + this.formFields + ", multiPartFormData=" + this.multiPartFormData + ", metadata=" + this.metadata + ")";
    }

    public int hashCode() {
        int result2 = this.method == null ? 0 : this.method.hashCode();
        result2 = result2 * 31 + (this.path == null ? 0 : this.path.hashCode());
        result2 = result2 * 31 + ((Object)this.headers).hashCode();
        result2 = result2 * 31 + this.body.hashCode();
        result2 = result2 * 31 + this.queryParams.hashCode();
        result2 = result2 * 31 + ((Object)this.formFields).hashCode();
        result2 = result2 * 31 + ((Object)this.multiPartFormData).hashCode();
        result2 = result2 * 31 + this.metadata.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpRequest)) {
            return false;
        }
        HttpRequest httpRequest = (HttpRequest)other;
        if (!Intrinsics.areEqual(this.method, httpRequest.method)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.path, httpRequest.path)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, httpRequest.headers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.body, httpRequest.body)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.queryParams, httpRequest.queryParams)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.formFields, httpRequest.formFields)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.multiPartFormData, httpRequest.multiPartFormData)) {
            return false;
        }
        return Intrinsics.areEqual(this.metadata, httpRequest.metadata);
    }

    public HttpRequest() {
        this(null, null, null, null, null, null, null, null, 255, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lio/specmatic/core/HttpRequest$LenientRequestNotRecognizedMessages;", "Lio/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "()V", "restful", "", "method", "path", "soap", "soapActionHeaderValue", "xmlOverHttp", "specmatic-core"})
    public static final class LenientRequestNotRecognizedMessages
    implements RequestNotRecognizedMessages {
        @Override
        @NotNull
        public String soap(@NotNull String soapActionHeaderValue, @NotNull String path2) {
            Intrinsics.checkNotNullParameter(soapActionHeaderValue, "soapActionHeaderValue");
            Intrinsics.checkNotNullParameter(path2, "path");
            return "No matching SOAP stub or contract found for SOAPAction " + soapActionHeaderValue + " and path " + path2;
        }

        @Override
        @NotNull
        public String xmlOverHttp(@NotNull String method2, @NotNull String path2) {
            Intrinsics.checkNotNullParameter(method2, "method");
            Intrinsics.checkNotNullParameter(path2, "path");
            return "No matching XML-REST stub or contract found for method " + method2 + " and path " + path2;
        }

        @Override
        @NotNull
        public String restful(@NotNull String method2, @NotNull String path2) {
            Intrinsics.checkNotNullParameter(method2, "method");
            Intrinsics.checkNotNullParameter(path2, "path");
            return "No matching REST stub or contract found for method " + method2 + " and path " + path2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lio/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "", "restful", "", "method", "path", "soap", "soapActionHeaderValue", "xmlOverHttp", "specmatic-core"})
    public static interface RequestNotRecognizedMessages {
        @NotNull
        public String soap(@NotNull String var1, @NotNull String var2);

        @NotNull
        public String xmlOverHttp(@NotNull String var1, @NotNull String var2);

        @NotNull
        public String restful(@NotNull String var1, @NotNull String var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lio/specmatic/core/HttpRequest$StrictRequestNotRecognizedMessages;", "Lio/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "()V", "restful", "", "method", "path", "soap", "soapActionHeaderValue", "xmlOverHttp", "specmatic-core"})
    public static final class StrictRequestNotRecognizedMessages
    implements RequestNotRecognizedMessages {
        @Override
        @NotNull
        public String soap(@NotNull String soapActionHeaderValue, @NotNull String path2) {
            Intrinsics.checkNotNullParameter(soapActionHeaderValue, "soapActionHeaderValue");
            Intrinsics.checkNotNullParameter(path2, "path");
            return "No matching SOAP stub (strict mode) found for SOAPAction " + soapActionHeaderValue + " and path " + path2;
        }

        @Override
        @NotNull
        public String xmlOverHttp(@NotNull String method2, @NotNull String path2) {
            Intrinsics.checkNotNullParameter(method2, "method");
            Intrinsics.checkNotNullParameter(path2, "path");
            return "No matching XML-REST stub (strict mode) found for method " + method2 + " and path " + path2;
        }

        @Override
        @NotNull
        public String restful(@NotNull String method2, @NotNull String path2) {
            Intrinsics.checkNotNullParameter(method2, "method");
            Intrinsics.checkNotNullParameter(path2, "path");
            return "No matching REST stub (strict mode) found for method " + method2 + " and path " + path2;
        }
    }
}

