/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.specmatic.core.AttributeSelectionPattern;
import io.specmatic.core.AttributeSelectionPatternDetails;
import io.specmatic.core.Auth;
import io.specmatic.core.Environment;
import io.specmatic.core.Pipeline;
import io.specmatic.core.PipelineProvider;
import io.specmatic.core.ReportConfiguration;
import io.specmatic.core.ReportConfigurationDetails;
import io.specmatic.core.RepositoryInfo;
import io.specmatic.core.ResiliencyTestSuite;
import io.specmatic.core.ResiliencyTestsConfig;
import io.specmatic.core.SecurityConfiguration;
import io.specmatic.core.SecuritySchemeConfiguration;
import io.specmatic.core.Source;
import io.specmatic.core.SourceProvider;
import io.specmatic.core.StubConfiguration;
import io.specmatic.core.TestConfiguration;
import io.specmatic.core.VirtualServiceConfiguration;
import io.specmatic.core.WorkflowConfiguration;
import io.specmatic.core.WorkflowDetails;
import io.specmatic.core.azure.AzureAPI;
import io.specmatic.core.config.SpecmaticConfigVersion;
import io.specmatic.core.config.Switch;
import io.specmatic.core.config.v3.SpecExecutionConfig;
import io.specmatic.core.git.SystemGit;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.utilities.ContractSource;
import io.specmatic.core.utilities.ContractSourceEntry;
import io.specmatic.core.utilities.Flags;
import io.specmatic.core.utilities.GitMonoRepo;
import io.specmatic.core.utilities.GitRepo;
import io.specmatic.core.utilities.LocalFileSystemSource;
import io.specmatic.core.utilities.WebSource;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.Value;
import io.specmatic.stub.HttpStubKt;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u0090\u00012\u00020\u0001:\u0002\u0090\u0001B\u008d\u0002\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010 \u001a\u00020!\u0012\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001e\u0012\u0014\b\u0002\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n\u0012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%\u00a2\u0006\u0002\u0010&J\b\u0010(\u001a\u00020\u000bH\u0007J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\t\u0010*\u001a\u00020\u0017H\u00c2\u0003J\t\u0010+\u001a\u00020\u0019H\u00c2\u0003J\u0011\u0010,\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0003H\u00c2\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u001cH\u00c2\u0003J\u0010\u0010.\u001a\u0004\u0018\u00010\u001eH\u00c2\u0003\u00a2\u0006\u0002\u0010/J\u000b\u00100\u001a\u0004\u0018\u00010\u000bH\u00c2\u0003J\t\u00101\u001a\u00020!H\u00c2\u0003J\u0010\u00102\u001a\u0004\u0018\u00010\u001eH\u00c2\u0003\u00a2\u0006\u0002\u0010/J\u0015\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u00c2\u0003J\u000b\u00104\u001a\u0004\u0018\u00010%H\u00c2\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\bH\u00c2\u0003J\u0017\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nH\u00c2\u0003J\u0015\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u00c2\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u000fH\u00c2\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\u0011H\u00c2\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u0013H\u00c2\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u0015H\u00c2\u0003J\u0096\u0002\u0010=\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00032\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0014\b\u0002\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u00c6\u0001\u00a2\u0006\u0002\u0010>J\u0010\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u001eH\u0007J\u0010\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020%H\u0007J\u0006\u0010C\u001a\u00020\u0000J\u0013\u0010D\u001a\u00020\u001e2\b\u0010E\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\n\u0010F\u001a\u0004\u0018\u00010\u000bH\u0007J\b\u0010G\u001a\u00020\u001eH\u0007J\b\u0010H\u001a\u00020IH\u0007J\n\u0010J\u001a\u0004\u0018\u00010\u0006H\u0007J\n\u0010K\u001a\u0004\u0018\u00010\u000bH\u0007J\n\u0010L\u001a\u0004\u0018\u00010\u000bH\u0007J\u0014\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007J\u001c\u0010N\u001a\u0004\u0018\u00010\u000b2\b\u0010O\u001a\u0004\u0018\u00010\u000b2\u0006\u0010P\u001a\u00020\u001eH\u0002J\u000e\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u000bJ\u000e\u0010T\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003H\u0007J\u0014\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\n\u0010V\u001a\u0004\u0018\u00010WH\u0007J\b\u0010X\u001a\u00020\u001eH\u0007J\u0012\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020\u000bH\u0007J\u000f\u0010\\\u001a\u0004\u0018\u00010]H\u0007\u00a2\u0006\u0002\u0010^J\n\u0010_\u001a\u0004\u0018\u00010\u000bH\u0007J\n\u0010`\u001a\u0004\u0018\u00010\u000bH\u0007J\n\u0010a\u001a\u0004\u0018\u00010bH\u0007J\n\u0010c\u001a\u0004\u0018\u00010dH\u0007J\n\u0010e\u001a\u0004\u0018\u00010\u000bH\u0007J\n\u0010f\u001a\u0004\u0018\u00010\u000bH\u0007J\b\u0010g\u001a\u00020hH\u0007J\u000f\u0010i\u001a\u0004\u0018\u00010jH\u0007\u00a2\u0006\u0002\u0010kJ\n\u0010l\u001a\u0004\u0018\u00010\u000bH\u0007J\b\u0010m\u001a\u00020\u001eH\u0007J\b\u0010n\u001a\u00020\u001eH\u0007J\b\u0010o\u001a\u00020jH\u0007J\u000f\u0010p\u001a\u0004\u0018\u00010jH\u0007\u00a2\u0006\u0002\u0010kJ\u0006\u0010q\u001a\u00020%J\u000e\u0010r\u001a\b\u0012\u0004\u0012\u00020\u000b0sH\u0007J\n\u0010t\u001a\u0004\u0018\u00010uH\u0007J\t\u0010v\u001a\u00020]H\u00d6\u0001J\b\u0010w\u001a\u00020\u001eH\u0007J\b\u0010x\u001a\u00020\u001eH\u0007J\b\u0010y\u001a\u00020\u001eH\u0007J\b\u0010z\u001a\u00020\u001eH\u0007J\u0018\u0010{\u001a\b\u0012\u0004\u0012\u00020|0\u00032\b\b\u0002\u0010P\u001a\u00020\u001eH\u0007J\u000f\u0010}\u001a\u00020~2\u0007\u0010\u007f\u001a\u00030\u0080\u0001J\u0016\u0010\u0081\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u000b\u0012\u0005\u0012\u00030\u0082\u00010\nH\u0007J\u001b\u0010\u0083\u0001\u001a\u00020\u000b2\u0007\u0010\u0084\u0001\u001a\u00020\u000b2\u0007\u0010\u0085\u0001\u001a\u00020\u000bH\u0007J\u0018\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\u0007\u0010\u0085\u0001\u001a\u00020\u000bH\u0007J\u001b\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\n\b\u0002\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0007J%\u0010\u008a\u0001\u001a\u0015\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u008b\u00010\u00032\u0007\u0010\u0085\u0001\u001a\u00020\u000bH\u0007J\n\u0010\u008c\u0001\u001a\u00020\u000bH\u00d6\u0001J\u0010\u0010\u008d\u0001\u001a\u00020\u00002\u0007\u0010\u008e\u0001\u001a\u00020dJ\u0017\u0010\u008f\u0001\u001a\u00020\u000b*\u00020\u000b2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0003R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0091\u0001"}, d2={"Lio/specmatic/core/SpecmaticConfig;", "", "sources", "", "Lio/specmatic/core/Source;", "auth", "Lio/specmatic/core/Auth;", "pipeline", "Lio/specmatic/core/Pipeline;", "environments", "", "", "Lio/specmatic/core/Environment;", "hooks", "repository", "Lio/specmatic/core/RepositoryInfo;", "report", "Lio/specmatic/core/ReportConfigurationDetails;", "security", "Lio/specmatic/core/SecurityConfiguration;", "test", "Lio/specmatic/core/TestConfiguration;", "stub", "Lio/specmatic/core/StubConfiguration;", "virtualService", "Lio/specmatic/core/VirtualServiceConfiguration;", "examples", "workflow", "Lio/specmatic/core/WorkflowConfiguration;", "ignoreInlineExamples", "", "additionalExampleParamsFilePath", "attributeSelectionPattern", "Lio/specmatic/core/AttributeSelectionPattern;", "allPatternsMandatory", "defaultPatternValues", "version", "Lio/specmatic/core/config/SpecmaticConfigVersion;", "(Ljava/util/List;Lio/specmatic/core/Auth;Lio/specmatic/core/Pipeline;Ljava/util/Map;Ljava/util/Map;Lio/specmatic/core/RepositoryInfo;Lio/specmatic/core/ReportConfigurationDetails;Lio/specmatic/core/SecurityConfiguration;Lio/specmatic/core/TestConfiguration;Lio/specmatic/core/StubConfiguration;Lio/specmatic/core/VirtualServiceConfiguration;Ljava/util/List;Lio/specmatic/core/WorkflowConfiguration;Ljava/lang/Boolean;Ljava/lang/String;Lio/specmatic/core/AttributeSelectionPattern;Ljava/lang/Boolean;Ljava/util/Map;Lio/specmatic/core/config/SpecmaticConfigVersion;)V", "Ljava/lang/Boolean;", "attributeSelectionQueryParamKey", "component1", "component10", "component11", "component12", "component13", "component14", "()Ljava/lang/Boolean;", "component15", "component16", "component17", "component18", "component19", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/util/List;Lio/specmatic/core/Auth;Lio/specmatic/core/Pipeline;Ljava/util/Map;Ljava/util/Map;Lio/specmatic/core/RepositoryInfo;Lio/specmatic/core/ReportConfigurationDetails;Lio/specmatic/core/SecurityConfiguration;Lio/specmatic/core/TestConfiguration;Lio/specmatic/core/StubConfiguration;Lio/specmatic/core/VirtualServiceConfiguration;Ljava/util/List;Lio/specmatic/core/WorkflowConfiguration;Ljava/lang/Boolean;Ljava/lang/String;Lio/specmatic/core/AttributeSelectionPattern;Ljava/lang/Boolean;Ljava/util/Map;Lio/specmatic/core/config/SpecmaticConfigVersion;)Lio/specmatic/core/SpecmaticConfig;", "copyResiliencyTestsConfig", "onlyPositive", "dropExcludedEndpointsAfterVersion1", "latestVersion", "enableResiliencyTests", "equals", "other", "getAdditionalExampleParamsFilePath", "getAllPatternsMandatory", "getAttributeSelectionPattern", "Lio/specmatic/core/AttributeSelectionPatternDetails;", "getAuth", "getAuthBearerEnvironmentVariable", "getAuthBearerFile", "getDefaultPatternValues", "getEffectiveBranchForSource", "configuredBranch", "useCurrentBranchForCentralRepo", "getEnvironment", "Lio/specmatic/core/value/JSONObjectValue;", "envName", "getExamples", "getHooks", "getHotReload", "Lio/specmatic/core/config/Switch;", "getIgnoreInlineExamples", "getOpenAPISecurityConfigurationScheme", "Lio/specmatic/core/SecuritySchemeConfiguration;", "scheme", "getPipelineDefinitionId", "", "()Ljava/lang/Integer;", "getPipelineOrganization", "getPipelineProject", "getPipelineProvider", "Lio/specmatic/core/PipelineProvider;", "getReport", "Lio/specmatic/core/ReportConfiguration;", "getRepositoryCollectionName", "getRepositoryProvider", "getResiliencyTestsEnabled", "Lio/specmatic/core/ResiliencyTestSuite;", "getStubDelayInMilliseconds", "", "()Ljava/lang/Long;", "getStubDictionary", "getStubGenerative", "getStubIncludeMandatoryAndRequestedKeysInResponse", "getStubStartTimeoutInMilliseconds", "getTestTimeoutInMilliseconds", "getVersion", "getVirtualServiceNonPatchableKeys", "", "getWorkflowDetails", "Lio/specmatic/core/WorkflowDetails;", "hashCode", "isExtensibleSchemaEnabled", "isOnlyPositiveTestingEnabled", "isResiliencyTestingEnabled", "isResponseValueValidationEnabled", "loadSources", "Lio/specmatic/core/utilities/ContractSource;", "logDependencyProjects", "", "azure", "Lio/specmatic/core/azure/AzureAPI;", "parsedDefaultPatternValues", "Lio/specmatic/core/value/Value;", "stubBaseUrlPathAssociatedTo", "url", "defaultBaseUrl", "stubBaseUrls", "stubContracts", "relativeTo", "Ljava/io/File;", "stubToBaseUrlList", "Lkotlin/Pair;", "toString", "updateReportConfiguration", "reportConfiguration", "canonicalPath", "Companion", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nSpecmaticConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecmaticConfig.kt\nio/specmatic/core/SpecmaticConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1164:1\n1360#2:1165\n1446#2,2:1166\n1549#2:1168\n1620#2,3:1169\n1448#2,3:1172\n1360#2:1175\n1446#2,2:1176\n1360#2:1178\n1446#2,2:1179\n1549#2:1181\n1620#2,3:1182\n1448#2,3:1185\n1448#2,3:1188\n1549#2:1191\n1620#2,3:1192\n288#2,2:1195\n1855#2:1197\n1855#2:1198\n1855#2,2:1199\n1856#2:1201\n1856#2:1202\n1549#2:1203\n1620#2,2:1204\n1549#2:1206\n1620#2,3:1207\n1549#2:1210\n1620#2,3:1211\n1622#2:1214\n1360#2:1216\n1446#2,2:1217\n1360#2:1219\n1446#2,5:1220\n1549#2:1225\n1620#2,3:1226\n1448#2,3:1229\n1#3:1215\n*S KotlinDebug\n*F\n+ 1 SpecmaticConfig.kt\nio/specmatic/core/SpecmaticConfig\n*L\n330#1:1165\n330#1:1166,2\n331#1:1168\n331#1:1169,3\n330#1:1172,3\n341#1:1175\n341#1:1176,2\n342#1:1178\n342#1:1179,2\n345#1:1181\n345#1:1182,3\n342#1:1185,3\n341#1:1188,3\n354#1:1191\n354#1:1192,3\n354#1:1195,2\n368#1:1197\n371#1:1198\n378#1:1199,2\n371#1:1201\n368#1:1202\n391#1:1203\n391#1:1204,2\n392#1:1206\n392#1:1207,3\n395#1:1210\n395#1:1211,3\n391#1:1214\n599#1:1216\n599#1:1217,2\n600#1:1219\n600#1:1220,5\n605#1:1225\n605#1:1226,3\n599#1:1229,3\n*E\n"})
public final class SpecmaticConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Source> sources;
    @Nullable
    private final Auth auth;
    @Nullable
    private final Pipeline pipeline;
    @Nullable
    private final Map<String, Environment> environments;
    @NotNull
    private final Map<String, String> hooks;
    @Nullable
    private final RepositoryInfo repository;
    @Nullable
    private final ReportConfigurationDetails report;
    @Nullable
    private final SecurityConfiguration security;
    @Nullable
    private final TestConfiguration test;
    @NotNull
    private final StubConfiguration stub;
    @NotNull
    private final VirtualServiceConfiguration virtualService;
    @Nullable
    private final List<String> examples;
    @Nullable
    private final WorkflowConfiguration workflow;
    @Nullable
    private final Boolean ignoreInlineExamples;
    @Nullable
    private final String additionalExampleParamsFilePath;
    @NotNull
    private final AttributeSelectionPattern attributeSelectionPattern;
    @Nullable
    private final Boolean allPatternsMandatory;
    @NotNull
    private final Map<String, Object> defaultPatternValues;
    @Nullable
    private final SpecmaticConfigVersion version;

    public SpecmaticConfig(@NotNull List<Source> sources, @Nullable Auth auth, @Nullable Pipeline pipeline, @Nullable Map<String, Environment> environments, @NotNull Map<String, String> hooks, @Nullable RepositoryInfo repository, @Nullable ReportConfigurationDetails report, @Nullable SecurityConfiguration security, @Nullable TestConfiguration test, @NotNull StubConfiguration stub, @NotNull VirtualServiceConfiguration virtualService, @Nullable List<String> examples, @Nullable WorkflowConfiguration workflow, @Nullable Boolean ignoreInlineExamples, @Nullable String additionalExampleParamsFilePath, @NotNull AttributeSelectionPattern attributeSelectionPattern, @Nullable Boolean allPatternsMandatory, @NotNull Map<String, ? extends Object> defaultPatternValues, @Nullable SpecmaticConfigVersion version2) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        Intrinsics.checkNotNullParameter(hooks, "hooks");
        Intrinsics.checkNotNullParameter(stub, "stub");
        Intrinsics.checkNotNullParameter(virtualService, "virtualService");
        Intrinsics.checkNotNullParameter(attributeSelectionPattern, "attributeSelectionPattern");
        Intrinsics.checkNotNullParameter(defaultPatternValues, "defaultPatternValues");
        this.sources = sources;
        this.auth = auth;
        this.pipeline = pipeline;
        this.environments = environments;
        this.hooks = hooks;
        this.repository = repository;
        this.report = report;
        this.security = security;
        this.test = test;
        this.stub = stub;
        this.virtualService = virtualService;
        this.examples = examples;
        this.workflow = workflow;
        this.ignoreInlineExamples = ignoreInlineExamples;
        this.additionalExampleParamsFilePath = additionalExampleParamsFilePath;
        this.attributeSelectionPattern = attributeSelectionPattern;
        this.allPatternsMandatory = allPatternsMandatory;
        this.defaultPatternValues = defaultPatternValues;
        this.version = version2;
    }

    public /* synthetic */ SpecmaticConfig(List list, Auth auth, Pipeline pipeline, Map map2, Map map3, RepositoryInfo repositoryInfo, ReportConfigurationDetails reportConfigurationDetails, SecurityConfiguration securityConfiguration, TestConfiguration testConfiguration, StubConfiguration stubConfiguration, VirtualServiceConfiguration virtualServiceConfiguration, List list2, WorkflowConfiguration workflowConfiguration, Boolean bl, String string, AttributeSelectionPattern attributeSelectionPattern, Boolean bl2, Map map4, SpecmaticConfigVersion specmaticConfigVersion, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            auth = null;
        }
        if ((n & 4) != 0) {
            pipeline = null;
        }
        if ((n & 8) != 0) {
            map2 = null;
        }
        if ((n & 0x10) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            repositoryInfo = null;
        }
        if ((n & 0x40) != 0) {
            reportConfigurationDetails = null;
        }
        if ((n & 0x80) != 0) {
            securityConfiguration = null;
        }
        if ((n & 0x100) != 0) {
            testConfiguration = new TestConfiguration(null, null, null, null, 15, null);
        }
        if ((n & 0x200) != 0) {
            stubConfiguration = new StubConfiguration(null, null, null, null, null, null, 63, null);
        }
        if ((n & 0x400) != 0) {
            virtualServiceConfiguration = new VirtualServiceConfiguration(null, 1, null);
        }
        if ((n & 0x800) != 0) {
            list2 = null;
        }
        if ((n & 0x1000) != 0) {
            workflowConfiguration = null;
        }
        if ((n & 0x2000) != 0) {
            bl = null;
        }
        if ((n & 0x4000) != 0) {
            string = null;
        }
        if ((n & 0x8000) != 0) {
            attributeSelectionPattern = new AttributeSelectionPattern(null, null, 3, null);
        }
        if ((n & 0x10000) != 0) {
            bl2 = null;
        }
        if ((n & 0x20000) != 0) {
            map4 = MapsKt.emptyMap();
        }
        if ((n & 0x40000) != 0) {
            specmaticConfigVersion = null;
        }
        this(list, auth, pipeline, map2, map3, repositoryInfo, reportConfigurationDetails, securityConfiguration, testConfiguration, stubConfiguration, virtualServiceConfiguration, list2, workflowConfiguration, bl, string, attributeSelectionPattern, bl2, map4, specmaticConfigVersion);
    }

    @JsonIgnore
    @Nullable
    public final Switch getHotReload() {
        return this.stub.getHotReload();
    }

    @JsonIgnore
    @NotNull
    public final SpecmaticConfig dropExcludedEndpointsAfterVersion1(@NotNull SpecmaticConfigVersion latestVersion) {
        Intrinsics.checkNotNullParameter((Object)latestVersion, "latestVersion");
        if (latestVersion == SpecmaticConfigVersion.VERSION_1) {
            return this;
        }
        LoggingKt.getLogger().log("\nWARNING: excludedEndpoints is not supported in Specmatic config v2. . Refer to https://specmatic.io/documentation/configuration.html#report-configuration to see how to exclude endpoints.\n");
        ReportConfigurationDetails reportConfigurationDetails = this.report;
        return SpecmaticConfig.copy$default(this, null, null, null, null, null, null, reportConfigurationDetails != null ? reportConfigurationDetails.clearPresenceOfExcludedEndpoints() : null, null, null, null, null, null, null, null, null, null, null, null, null, 524223, null);
    }

    @JsonIgnore
    @Nullable
    public final ReportConfiguration getReport() {
        return this.report;
    }

    @JsonIgnore
    @Nullable
    public final WorkflowDetails getWorkflowDetails() {
        return this.workflow;
    }

    @JsonIgnore
    @NotNull
    public final AttributeSelectionPatternDetails getAttributeSelectionPattern() {
        return this.attributeSelectionPattern;
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final List<String> stubBaseUrls(@NotNull String defaultBaseUrl) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(defaultBaseUrl, "defaultBaseUrl");
        Iterable $this$flatMap$iv = this.sources;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Source source2 = (Source)element$iv$iv;
            boolean bl = false;
            List<SpecExecutionConfig> list = source2.getStub();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable2 = list;
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void consumes2;
                SpecExecutionConfig specExecutionConfig = (SpecExecutionConfig)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                void var21_21 = consumes2;
                if (var21_21 instanceof SpecExecutionConfig.StringValue) {
                    string = defaultBaseUrl;
                } else if (var21_21 instanceof SpecExecutionConfig.ObjectValue) {
                    string = ((SpecExecutionConfig.ObjectValue)consumes2).toBaseUrl(defaultBaseUrl);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(string);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.distinct((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final List<Pair<String, String>> stubToBaseUrlList(@NotNull String defaultBaseUrl) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(defaultBaseUrl, "defaultBaseUrl");
        Iterable $this$flatMap$iv = this.sources;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            Source source2 = (Source)element$iv$iv;
            boolean bl = false;
            List<SpecExecutionConfig> list = source2.getStub();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable2 = list;
            boolean $i$f$flatMap2 = false;
            void var13_13 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                List list2;
                SpecExecutionConfig consumes2 = (SpecExecutionConfig)element$iv$iv2;
                boolean bl2 = false;
                SpecExecutionConfig specExecutionConfig = consumes2;
                if (specExecutionConfig instanceof SpecExecutionConfig.StringValue) {
                    list2 = CollectionsKt.listOf(TuplesKt.to(((SpecExecutionConfig.StringValue)consumes2).getValue(), defaultBaseUrl));
                } else if (specExecutionConfig instanceof SpecExecutionConfig.ObjectValue) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = ((SpecExecutionConfig.ObjectValue)consumes2).getSpecs();
                    boolean $i$f$map = false;
                    Iterable iterable3 = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl3 = false;
                        collection.add(TuplesKt.to(it, ((SpecExecutionConfig.ObjectValue)consumes2).toBaseUrl(defaultBaseUrl)));
                    }
                    list2 = (List)destination$iv$iv3;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final String stubBaseUrlPathAssociatedTo(@NotNull String url2, @NotNull String defaultBaseUrl) {
        Object v0;
        block3: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(url2, "url");
            Intrinsics.checkNotNullParameter(defaultBaseUrl, "defaultBaseUrl");
            URI parsedUrl = new URI(url2);
            Iterable $this$map$iv = this.stubBaseUrls(defaultBaseUrl);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new URI((String)p0));
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                URI stubBaseUrl = (URI)element$iv;
                boolean bl = false;
                if (!HttpStubKt.isSameBaseIgnoringHost(parsedUrl, stubBaseUrl)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        URI uRI = v0;
        String string = uRI != null ? uRI.getPath() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @JsonIgnore
    public final long getStubStartTimeoutInMilliseconds() {
        Long l = this.stub.getStartTimeoutInMilliseconds();
        return l != null ? l : 20000L;
    }

    public final void logDependencyProjects(@NotNull AzureAPI azure) {
        Intrinsics.checkNotNullParameter(azure, "azure");
        LoggingKt.getLogger().log("Dependency projects");
        LoggingKt.getLogger().log("-------------------");
        Iterable $this$forEach$iv = this.sources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Source source2 = (Source)element$iv;
            boolean bl = false;
            LoggingKt.getLogger().log("In central repo " + source2.getRepository());
            Iterable $this$forEach$iv2 = source2.specsUsedAsTest();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String relativeContractPath = (String)element$iv2;
                boolean bl2 = false;
                LoggingKt.getLogger().log("  Consumers of " + relativeContractPath);
                List<AzureAPI.ContractConsumerEntry> consumers = azure.referencesToContract(relativeContractPath);
                if (consumers.isEmpty()) {
                    LoggingKt.getLogger().log("    ** no consumers found **");
                } else {
                    Iterable $this$forEach$iv3 = consumers;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        AzureAPI.ContractConsumerEntry it = (AzureAPI.ContractConsumerEntry)element$iv3;
                        boolean bl3 = false;
                        LoggingKt.getLogger().log("  - " + it.getDescription());
                    }
                }
                LoggingKt.getLogger().newLine();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final List<ContractSource> loadSources(boolean useCurrentBranchForCentralRepo) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.sources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            Collection collection;
            void $this$mapTo$iv$iv3;
            void source2;
            Source source3 = (Source)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = Source.specToStubBaseUrlMap$default((Source)source2, null, 1, null).entrySet();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new ContractSourceEntry((String)it.getKey(), (String)it.getValue(), null, 4, null));
            }
            List stubPaths = (List)destination$iv$iv2;
            Map testBaseUrlMap = Source.specToTestBaseUrlMap$default((Source)source2, null, 1, null);
            Map<String, ResiliencyTestSuite> testGenerativeMap = source2.specToTestGenerativeMap();
            Iterable $this$map$iv3 = testBaseUrlMap.entrySet();
            boolean $i$f$map3 = false;
            Iterable iterable3 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv3;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                collection.add(new ContractSourceEntry((String)it.getKey(), (String)it.getValue(), testGenerativeMap.get(it.getKey())));
            }
            List testPaths = (List)destination$iv$iv3;
            String effectiveBranch = this.getEffectiveBranchForSource(source2.getBranch(), useCurrentBranchForCentralRepo);
            collection2.add(switch (WhenMappings.$EnumSwitchMapping$0[source2.getProvider().ordinal()]) {
                case 1 -> (ContractSource)((Object)(source2.getRepository() == null ? new GitMonoRepo(testPaths, stubPaths, source2.getProvider().toString()) : new GitRepo(source2.getRepository(), effectiveBranch, testPaths, stubPaths, source2.getProvider().toString(), useCurrentBranchForCentralRepo)));
                case 2 -> {
                    String v1 = source2.getDirectory();
                    if (v1 == null) {
                        v1 = ".";
                    }
                    yield new LocalFileSystemSource(v1, testPaths, stubPaths);
                }
                case 3 -> new WebSource(testPaths, stubPaths);
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List loadSources$default(SpecmaticConfig specmaticConfig, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return specmaticConfig.loadSources(bl);
    }

    private final String getEffectiveBranchForSource(String configuredBranch, boolean useCurrentBranchForCentralRepo) {
        String string;
        if (!useCurrentBranchForCentralRepo) {
            return configuredBranch;
        }
        try {
            SystemGit git = new SystemGit(null, null, null, 7, null);
            String currentBranch = git.getCurrentBranchForMatchBranch();
            LoggingKt.getLogger().debug("Current branch: " + currentBranch);
            LoggingKt.getLogger().log("Central repo branch: '" + currentBranch + "'");
            string = currentBranch;
        }
        catch (Throwable e2) {
            Object object;
            block7: {
                block6: {
                    object = configuredBranch;
                    if (object == null) break block6;
                    String it = object;
                    boolean bl = false;
                    String string2 = "configured branch: " + configuredBranch;
                    object = string2;
                    if (string2 != null) break block7;
                }
                object = "default";
            }
            String fallbackBranchToLog = object;
            LoggingKt.getLogger().log("Could not determine current branch for --match-branch flag: " + e2.getMessage());
            LoggingKt.getLogger().log("Falling back to " + fallbackBranchToLog);
            string = configuredBranch;
        }
        return string;
    }

    @JsonIgnore
    @NotNull
    public final String attributeSelectionQueryParamKey() {
        return this.attributeSelectionPattern.getQueryParamKey();
    }

    @JsonIgnore
    public final boolean isExtensibleSchemaEnabled() {
        Object object = this.test;
        return object != null && (object = ((TestConfiguration)object).getAllowExtensibleSchema()) != null ? (Boolean)object : Flags.Companion.getBooleanValue$default(Flags.Companion, "EXTENSIBLE_SCHEMA", false, 2, null);
    }

    @JsonIgnore
    public final boolean isResiliencyTestingEnabled() {
        return this.getResiliencyTestsEnabled() != ResiliencyTestSuite.none;
    }

    @JsonIgnore
    public final boolean isOnlyPositiveTestingEnabled() {
        return this.getResiliencyTestsEnabled() == ResiliencyTestSuite.positiveOnly;
    }

    @JsonIgnore
    public final boolean isResponseValueValidationEnabled() {
        Object object = this.test;
        return object != null && (object = ((TestConfiguration)object).getValidateResponseValues()) != null ? (Boolean)object : Flags.Companion.getBooleanValue$default(Flags.Companion, "VALIDATE_RESPONSE_VALUE", false, 2, null);
    }

    @JsonIgnore
    @NotNull
    public final Map<String, Value> parsedDefaultPatternValues() {
        String string = new ObjectMapper().writeValueAsString(this.defaultPatternValues);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        return GrammarKt.parsedJSONObject$default(string, null, 2, null).getJsonObject();
    }

    @JsonIgnore
    @NotNull
    public final ResiliencyTestSuite getResiliencyTestsEnabled() {
        ResiliencyTestSuite resiliencyTestSuite;
        Object object = this.test;
        if (object == null || (object = ((TestConfiguration)object).getResiliencyTests()) == null) {
            object = ResiliencyTestsConfig.Companion.fromSystemProperties();
        }
        if ((resiliencyTestSuite = ((ResiliencyTestsConfig)object).getEnable()) == null) {
            resiliencyTestSuite = ResiliencyTestSuite.none;
        }
        return resiliencyTestSuite;
    }

    @JsonIgnore
    @Nullable
    public final Long getTestTimeoutInMilliseconds() {
        Object object = this.test;
        if (object == null || (object = ((TestConfiguration)object).getTimeoutInMilliseconds()) == null) {
            object = Flags.Companion.getLongValue("SPECMATIC_TEST_TIMEOUT");
        }
        return object;
    }

    @JsonIgnore
    @NotNull
    public final SpecmaticConfig copyResiliencyTestsConfig(boolean onlyPositive) {
        TestConfiguration testConfiguration;
        TestConfiguration testConfiguration2 = this.test;
        if (testConfiguration2 != null) {
            ResiliencyTestsConfig resiliencyTestsConfig = this.test.getResiliencyTests();
            if (resiliencyTestsConfig == null) {
                resiliencyTestsConfig = ResiliencyTestsConfig.Companion.fromSystemProperties();
            }
            testConfiguration = TestConfiguration.copy$default(testConfiguration2, resiliencyTestsConfig.copy(onlyPositive ? ResiliencyTestSuite.positiveOnly : ResiliencyTestSuite.all), null, null, null, 14, null);
        } else {
            testConfiguration = null;
        }
        return SpecmaticConfig.copy$default(this, null, null, null, null, null, null, null, null, testConfiguration, null, null, null, null, null, null, null, null, null, null, 524031, null);
    }

    @JsonIgnore
    public final boolean getStubIncludeMandatoryAndRequestedKeysInResponse() {
        Boolean bl = this.stub.getIncludeMandatoryAndRequestedKeysInResponse();
        return bl != null ? bl : true;
    }

    @JsonIgnore
    public final boolean getStubGenerative() {
        Boolean bl = this.stub.getGenerative();
        return bl != null ? bl : false;
    }

    @JsonIgnore
    @Nullable
    public final Long getStubDelayInMilliseconds() {
        return this.stub.getDelayInMilliseconds();
    }

    @JsonIgnore
    @Nullable
    public final String getStubDictionary() {
        return this.stub.getDictionary();
    }

    @JsonIgnore
    public final boolean getIgnoreInlineExamples() {
        Boolean bl = this.ignoreInlineExamples;
        return bl != null ? bl : Flags.Companion.getBooleanValue$default(Flags.Companion, "IGNORE_INLINE_EXAMPLES", false, 2, null);
    }

    @JsonIgnore
    public final boolean getAllPatternsMandatory() {
        Boolean bl = this.allPatternsMandatory;
        return bl != null ? bl : Flags.Companion.getBooleanValue$default(Flags.Companion, "ALL_PATTERNS_MANDATORY", false, 2, null);
    }

    @JsonIgnore
    @Nullable
    public final String getAdditionalExampleParamsFilePath() {
        String string = this.additionalExampleParamsFilePath;
        if (string == null) {
            string = Flags.Companion.getStringValue("ADDITIONAL_EXAMPLE_PARAMS_FILE");
        }
        return string;
    }

    @JsonIgnore
    @NotNull
    public final Map<String, String> getHooks() {
        return this.hooks;
    }

    @JsonIgnore
    @NotNull
    public final Map<String, Object> getDefaultPatternValues() {
        return this.defaultPatternValues;
    }

    @NotNull
    public final SpecmaticConfigVersion getVersion() {
        SpecmaticConfigVersion specmaticConfigVersion = this.version;
        if (specmaticConfigVersion == null) {
            specmaticConfigVersion = SpecmaticConfigVersion.VERSION_1;
        }
        return specmaticConfigVersion;
    }

    @JsonIgnore
    @Nullable
    public final Auth getAuth() {
        return this.auth;
    }

    @JsonIgnore
    @Nullable
    public final String getAuthBearerFile() {
        Auth auth = this.auth;
        return auth != null ? auth.getBearerFile() : null;
    }

    @JsonIgnore
    @Nullable
    public final String getAuthBearerEnvironmentVariable() {
        Auth auth = this.auth;
        return auth != null ? auth.getBearerEnvironmentVariable() : null;
    }

    @JsonIgnore
    @NotNull
    public final List<String> getExamples() {
        List<String> list = this.examples;
        if (list == null) {
            List<String> list2;
            String string = Flags.Companion.getStringValue("EXAMPLE_DIRECTORIES");
            if (string != null) {
                String[] stringArray = new String[]{","};
                list2 = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    @JsonIgnore
    @Nullable
    public final String getRepositoryProvider() {
        RepositoryInfo repositoryInfo = this.repository;
        return repositoryInfo != null ? repositoryInfo.getProvider() : null;
    }

    @JsonIgnore
    @Nullable
    public final String getRepositoryCollectionName() {
        RepositoryInfo repositoryInfo = this.repository;
        return repositoryInfo != null ? repositoryInfo.getCollectionName() : null;
    }

    @JsonIgnore
    @Nullable
    public final PipelineProvider getPipelineProvider() {
        Pipeline pipeline = this.pipeline;
        return pipeline != null ? pipeline.getProvider() : null;
    }

    @JsonIgnore
    @Nullable
    public final Integer getPipelineDefinitionId() {
        Pipeline pipeline = this.pipeline;
        return pipeline != null ? Integer.valueOf(pipeline.getDefinitionId()) : null;
    }

    @JsonIgnore
    @Nullable
    public final String getPipelineOrganization() {
        Pipeline pipeline = this.pipeline;
        return pipeline != null ? pipeline.getOrganization() : null;
    }

    @JsonIgnore
    @Nullable
    public final String getPipelineProject() {
        Pipeline pipeline = this.pipeline;
        return pipeline != null ? pipeline.getProject() : null;
    }

    @JsonIgnore
    @Nullable
    public final SecuritySchemeConfiguration getOpenAPISecurityConfigurationScheme(@NotNull String scheme2) {
        Intrinsics.checkNotNullParameter(scheme2, "scheme");
        SecurityConfiguration securityConfiguration = this.security;
        return securityConfiguration != null ? securityConfiguration.getOpenAPISecurityScheme(scheme2) : null;
    }

    @JsonIgnore
    @NotNull
    public final Set<String> getVirtualServiceNonPatchableKeys() {
        return this.virtualService.getNonPatchableKeys();
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final List<String> stubContracts(@NotNull File relativeTo) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(relativeTo, "relativeTo");
        Iterable $this$flatMap$iv = this.sources;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            void $this$flatMapTo$iv$iv2;
            Iterable $this$flatMap$iv2;
            Source source2 = (Source)element$iv$iv;
            boolean bl = false;
            List<SpecExecutionConfig> list = source2.getStub();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable2 = list;
            boolean $i$f$flatMap2 = false;
            void var13_13 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                List<String> list2;
                SpecExecutionConfig stub = (SpecExecutionConfig)element$iv$iv2;
                boolean bl2 = false;
                SpecExecutionConfig specExecutionConfig = stub;
                if (specExecutionConfig instanceof SpecExecutionConfig.StringValue) {
                    list2 = CollectionsKt.listOf(((SpecExecutionConfig.StringValue)stub).getValue());
                } else if (specExecutionConfig instanceof SpecExecutionConfig.ObjectValue) {
                    list2 = ((SpecExecutionConfig.ObjectValue)stub).getSpecs();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                list$iv$iv = list2;
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            $this$flatMap$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void spec;
                list$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(source2.getProvider() == SourceProvider.web ? spec : this.canonicalPath((String)spec, relativeTo));
            }
            Iterable list$iv$iv2 = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv2);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List stubContracts$default(SpecmaticConfig specmaticConfig, File file2, int n, Object object) {
        if ((n & 1) != 0) {
            file2 = new File(".");
        }
        return specmaticConfig.stubContracts(file2);
    }

    @JsonIgnore
    private final String canonicalPath(String $this$canonicalPath, File relativeTo) {
        String string;
        File file2 = relativeTo.getParentFile();
        if ((file2 != null && (file2 = FilesKt.resolve(file2, $this$canonicalPath)) != null ? file2.getCanonicalPath() : (string = null)) == null) {
            String string2 = new File($this$canonicalPath).getCanonicalPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "getCanonicalPath(...)");
        }
        return string;
    }

    @NotNull
    public final SpecmaticConfig updateReportConfiguration(@NotNull ReportConfiguration reportConfiguration) {
        Intrinsics.checkNotNullParameter(reportConfiguration, "reportConfiguration");
        ReportConfigurationDetails reportConfigurationDetails = reportConfiguration instanceof ReportConfigurationDetails ? (ReportConfigurationDetails)reportConfiguration : null;
        if (reportConfigurationDetails == null) {
            return this;
        }
        ReportConfigurationDetails reportConfigurationDetails2 = reportConfigurationDetails;
        return SpecmaticConfig.copy$default(this, null, null, null, null, null, null, reportConfigurationDetails2, null, null, null, null, null, null, null, null, null, null, null, null, 524223, null);
    }

    @NotNull
    public final JSONObjectValue getEnvironment(@NotNull String envName) {
        Intrinsics.checkNotNullParameter(envName, "envName");
        Map<String, Environment> map2 = this.environments;
        if (map2 == null || (map2 = map2.get(envName)) == null) {
            return new JSONObjectValue(null, 1, null);
        }
        Map<String, Environment> envConfigFromFile = map2;
        try {
            String string = new ObjectMapper().writeValueAsString(envConfigFromFile);
            Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
            return GrammarKt.parsedJSONObject$default(string, null, 2, null);
        }
        catch (Throwable e2) {
            throw new ContractException("Error loading Specmatic configuration: " + e2.getMessage(), null, null, null, false, 30, null);
        }
    }

    @NotNull
    public final SpecmaticConfig enableResiliencyTests() {
        Object object;
        TestConfiguration testConfiguration = this.test;
        if (testConfiguration == null) {
            testConfiguration = new TestConfiguration(null, null, null, null, 15, null);
        }
        if ((object = this.test) == null || (object = ((TestConfiguration)object).getResiliencyTests()) == null) {
            object = new ResiliencyTestsConfig(null, 1, null);
        }
        return SpecmaticConfig.copy$default(this, null, null, null, null, null, null, null, null, TestConfiguration.copy$default(testConfiguration, ((ResiliencyTestsConfig)object).copy(ResiliencyTestSuite.all), null, null, null, 14, null), null, null, null, null, null, null, null, null, null, null, 524031, null);
    }

    private final List<Source> component1() {
        return this.sources;
    }

    private final Auth component2() {
        return this.auth;
    }

    private final Pipeline component3() {
        return this.pipeline;
    }

    private final Map<String, Environment> component4() {
        return this.environments;
    }

    private final Map<String, String> component5() {
        return this.hooks;
    }

    private final RepositoryInfo component6() {
        return this.repository;
    }

    private final ReportConfigurationDetails component7() {
        return this.report;
    }

    private final SecurityConfiguration component8() {
        return this.security;
    }

    private final TestConfiguration component9() {
        return this.test;
    }

    private final StubConfiguration component10() {
        return this.stub;
    }

    private final VirtualServiceConfiguration component11() {
        return this.virtualService;
    }

    private final List<String> component12() {
        return this.examples;
    }

    private final WorkflowConfiguration component13() {
        return this.workflow;
    }

    private final Boolean component14() {
        return this.ignoreInlineExamples;
    }

    private final String component15() {
        return this.additionalExampleParamsFilePath;
    }

    private final AttributeSelectionPattern component16() {
        return this.attributeSelectionPattern;
    }

    private final Boolean component17() {
        return this.allPatternsMandatory;
    }

    private final Map<String, Object> component18() {
        return this.defaultPatternValues;
    }

    private final SpecmaticConfigVersion component19() {
        return this.version;
    }

    @NotNull
    public final SpecmaticConfig copy(@NotNull List<Source> sources, @Nullable Auth auth, @Nullable Pipeline pipeline, @Nullable Map<String, Environment> environments, @NotNull Map<String, String> hooks, @Nullable RepositoryInfo repository, @Nullable ReportConfigurationDetails report, @Nullable SecurityConfiguration security, @Nullable TestConfiguration test, @NotNull StubConfiguration stub, @NotNull VirtualServiceConfiguration virtualService, @Nullable List<String> examples, @Nullable WorkflowConfiguration workflow, @Nullable Boolean ignoreInlineExamples, @Nullable String additionalExampleParamsFilePath, @NotNull AttributeSelectionPattern attributeSelectionPattern, @Nullable Boolean allPatternsMandatory, @NotNull Map<String, ? extends Object> defaultPatternValues, @Nullable SpecmaticConfigVersion version2) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        Intrinsics.checkNotNullParameter(hooks, "hooks");
        Intrinsics.checkNotNullParameter(stub, "stub");
        Intrinsics.checkNotNullParameter(virtualService, "virtualService");
        Intrinsics.checkNotNullParameter(attributeSelectionPattern, "attributeSelectionPattern");
        Intrinsics.checkNotNullParameter(defaultPatternValues, "defaultPatternValues");
        return new SpecmaticConfig(sources, auth, pipeline, environments, hooks, repository, report, security, test, stub, virtualService, examples, workflow, ignoreInlineExamples, additionalExampleParamsFilePath, attributeSelectionPattern, allPatternsMandatory, defaultPatternValues, version2);
    }

    public static /* synthetic */ SpecmaticConfig copy$default(SpecmaticConfig specmaticConfig, List list, Auth auth, Pipeline pipeline, Map map2, Map map3, RepositoryInfo repositoryInfo, ReportConfigurationDetails reportConfigurationDetails, SecurityConfiguration securityConfiguration, TestConfiguration testConfiguration, StubConfiguration stubConfiguration, VirtualServiceConfiguration virtualServiceConfiguration, List list2, WorkflowConfiguration workflowConfiguration, Boolean bl, String string, AttributeSelectionPattern attributeSelectionPattern, Boolean bl2, Map map4, SpecmaticConfigVersion specmaticConfigVersion, int n, Object object) {
        if ((n & 1) != 0) {
            list = specmaticConfig.sources;
        }
        if ((n & 2) != 0) {
            auth = specmaticConfig.auth;
        }
        if ((n & 4) != 0) {
            pipeline = specmaticConfig.pipeline;
        }
        if ((n & 8) != 0) {
            map2 = specmaticConfig.environments;
        }
        if ((n & 0x10) != 0) {
            map3 = specmaticConfig.hooks;
        }
        if ((n & 0x20) != 0) {
            repositoryInfo = specmaticConfig.repository;
        }
        if ((n & 0x40) != 0) {
            reportConfigurationDetails = specmaticConfig.report;
        }
        if ((n & 0x80) != 0) {
            securityConfiguration = specmaticConfig.security;
        }
        if ((n & 0x100) != 0) {
            testConfiguration = specmaticConfig.test;
        }
        if ((n & 0x200) != 0) {
            stubConfiguration = specmaticConfig.stub;
        }
        if ((n & 0x400) != 0) {
            virtualServiceConfiguration = specmaticConfig.virtualService;
        }
        if ((n & 0x800) != 0) {
            list2 = specmaticConfig.examples;
        }
        if ((n & 0x1000) != 0) {
            workflowConfiguration = specmaticConfig.workflow;
        }
        if ((n & 0x2000) != 0) {
            bl = specmaticConfig.ignoreInlineExamples;
        }
        if ((n & 0x4000) != 0) {
            string = specmaticConfig.additionalExampleParamsFilePath;
        }
        if ((n & 0x8000) != 0) {
            attributeSelectionPattern = specmaticConfig.attributeSelectionPattern;
        }
        if ((n & 0x10000) != 0) {
            bl2 = specmaticConfig.allPatternsMandatory;
        }
        if ((n & 0x20000) != 0) {
            map4 = specmaticConfig.defaultPatternValues;
        }
        if ((n & 0x40000) != 0) {
            specmaticConfigVersion = specmaticConfig.version;
        }
        return specmaticConfig.copy(list, auth, pipeline, map2, map3, repositoryInfo, reportConfigurationDetails, securityConfiguration, testConfiguration, stubConfiguration, virtualServiceConfiguration, list2, workflowConfiguration, bl, string, attributeSelectionPattern, bl2, map4, specmaticConfigVersion);
    }

    @NotNull
    public String toString() {
        return "SpecmaticConfig(sources=" + this.sources + ", auth=" + this.auth + ", pipeline=" + this.pipeline + ", environments=" + this.environments + ", hooks=" + this.hooks + ", repository=" + this.repository + ", report=" + this.report + ", security=" + this.security + ", test=" + this.test + ", stub=" + this.stub + ", virtualService=" + this.virtualService + ", examples=" + this.examples + ", workflow=" + this.workflow + ", ignoreInlineExamples=" + this.ignoreInlineExamples + ", additionalExampleParamsFilePath=" + this.additionalExampleParamsFilePath + ", attributeSelectionPattern=" + this.attributeSelectionPattern + ", allPatternsMandatory=" + this.allPatternsMandatory + ", defaultPatternValues=" + this.defaultPatternValues + ", version=" + this.version + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.sources).hashCode();
        result2 = result2 * 31 + (this.auth == null ? 0 : this.auth.hashCode());
        result2 = result2 * 31 + (this.pipeline == null ? 0 : this.pipeline.hashCode());
        result2 = result2 * 31 + (this.environments == null ? 0 : ((Object)this.environments).hashCode());
        result2 = result2 * 31 + ((Object)this.hooks).hashCode();
        result2 = result2 * 31 + (this.repository == null ? 0 : this.repository.hashCode());
        result2 = result2 * 31 + (this.report == null ? 0 : this.report.hashCode());
        result2 = result2 * 31 + (this.security == null ? 0 : this.security.hashCode());
        result2 = result2 * 31 + (this.test == null ? 0 : this.test.hashCode());
        result2 = result2 * 31 + this.stub.hashCode();
        result2 = result2 * 31 + this.virtualService.hashCode();
        result2 = result2 * 31 + (this.examples == null ? 0 : ((Object)this.examples).hashCode());
        result2 = result2 * 31 + (this.workflow == null ? 0 : this.workflow.hashCode());
        result2 = result2 * 31 + (this.ignoreInlineExamples == null ? 0 : ((Object)this.ignoreInlineExamples).hashCode());
        result2 = result2 * 31 + (this.additionalExampleParamsFilePath == null ? 0 : this.additionalExampleParamsFilePath.hashCode());
        result2 = result2 * 31 + this.attributeSelectionPattern.hashCode();
        result2 = result2 * 31 + (this.allPatternsMandatory == null ? 0 : ((Object)this.allPatternsMandatory).hashCode());
        result2 = result2 * 31 + ((Object)this.defaultPatternValues).hashCode();
        result2 = result2 * 31 + (this.version == null ? 0 : this.version.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpecmaticConfig)) {
            return false;
        }
        SpecmaticConfig specmaticConfig = (SpecmaticConfig)other;
        if (!Intrinsics.areEqual(this.sources, specmaticConfig.sources)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.auth, specmaticConfig.auth)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.pipeline, specmaticConfig.pipeline)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.environments, specmaticConfig.environments)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.hooks, specmaticConfig.hooks)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.repository, specmaticConfig.repository)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.report, specmaticConfig.report)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.security, specmaticConfig.security)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.test, specmaticConfig.test)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stub, specmaticConfig.stub)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.virtualService, specmaticConfig.virtualService)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.examples, specmaticConfig.examples)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.workflow, specmaticConfig.workflow)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ignoreInlineExamples, specmaticConfig.ignoreInlineExamples)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.additionalExampleParamsFilePath, specmaticConfig.additionalExampleParamsFilePath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.attributeSelectionPattern, specmaticConfig.attributeSelectionPattern)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.allPatternsMandatory, specmaticConfig.allPatternsMandatory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.defaultPatternValues, specmaticConfig.defaultPatternValues)) {
            return false;
        }
        return this.version == specmaticConfig.version;
    }

    public SpecmaticConfig() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 524287, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\""}, d2={"Lio/specmatic/core/SpecmaticConfig$Companion;", "", "()V", "getAllPatternsMandatory", "", "specmaticConfig", "Lio/specmatic/core/SpecmaticConfig;", "(Lio/specmatic/core/SpecmaticConfig;)Ljava/lang/Boolean;", "getAttributeSelectionPattern", "Lio/specmatic/core/AttributeSelectionPattern;", "getEnvironments", "", "", "Lio/specmatic/core/Environment;", "getIgnoreInlineExamples", "getPipeline", "Lio/specmatic/core/Pipeline;", "getReport", "Lio/specmatic/core/ReportConfigurationDetails;", "getRepository", "Lio/specmatic/core/RepositoryInfo;", "getSecurityConfiguration", "Lio/specmatic/core/SecurityConfiguration;", "getSources", "", "Lio/specmatic/core/Source;", "getStubConfiguration", "Lio/specmatic/core/StubConfiguration;", "getTestConfiguration", "Lio/specmatic/core/TestConfiguration;", "getVirtualServiceConfiguration", "Lio/specmatic/core/VirtualServiceConfiguration;", "getWorkflowConfiguration", "Lio/specmatic/core/WorkflowConfiguration;", "specmatic-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ReportConfigurationDetails getReport(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.report;
        }

        @JsonIgnore
        @NotNull
        public final List<Source> getSources(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.sources;
        }

        @JsonIgnore
        @Nullable
        public final RepositoryInfo getRepository(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.repository;
        }

        @JsonIgnore
        @Nullable
        public final Pipeline getPipeline(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.pipeline;
        }

        @JsonIgnore
        @Nullable
        public final SecurityConfiguration getSecurityConfiguration(@Nullable SpecmaticConfig specmaticConfig) {
            SpecmaticConfig specmaticConfig2 = specmaticConfig;
            return specmaticConfig2 != null ? specmaticConfig2.security : null;
        }

        @JsonIgnore
        @Nullable
        public final WorkflowConfiguration getWorkflowConfiguration(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.workflow;
        }

        @JsonIgnore
        @Nullable
        public final TestConfiguration getTestConfiguration(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.test;
        }

        @JsonIgnore
        @NotNull
        public final VirtualServiceConfiguration getVirtualServiceConfiguration(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.virtualService;
        }

        @JsonIgnore
        @Nullable
        public final Boolean getAllPatternsMandatory(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.allPatternsMandatory;
        }

        @JsonIgnore
        @Nullable
        public final Boolean getIgnoreInlineExamples(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.ignoreInlineExamples;
        }

        @JsonIgnore
        @NotNull
        public final AttributeSelectionPattern getAttributeSelectionPattern(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.attributeSelectionPattern;
        }

        @JsonIgnore
        @NotNull
        public final StubConfiguration getStubConfiguration(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.stub;
        }

        @Nullable
        public final Map<String, Environment> getEnvironments(@NotNull SpecmaticConfig specmaticConfig) {
            Intrinsics.checkNotNullParameter(specmaticConfig, "specmaticConfig");
            return specmaticConfig.environments;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceProvider.values().length];
            try {
                nArray[SourceProvider.git.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceProvider.filesystem.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceProvider.web.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

