/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.IgnoredPropertyException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.InvalidNullException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import io.specmatic.core.Configuration;
import io.specmatic.core.Feature;
import io.specmatic.core.FeatureKt;
import io.specmatic.core.SpecmaticConfig;
import io.specmatic.core.SpecmaticConfigKt;
import io.specmatic.core.config.VersionAwareConfigParserKt;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001fH\u0002\u001a\u000e\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001\u001a\u0012\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0001\u001a\u0012\u0010%\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010&\u001a\u0004\u0018\u00010#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010'\u001a\u00020\u00012\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002\u001a\n\u0010+\u001a\u00020,*\u00020\u0001\u001a\n\u0010-\u001a\u00020.*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"APPLICATION_NAME", "", "APPLICATION_NAME_LOWER_CASE", "CONFIG_EXTENSIONS", "", "getCONFIG_EXTENSIONS", "()Ljava/util/List;", "CONFIG_FILE_NAME_WITHOUT_EXT", "CONTRACT_EXTENSION", "CONTRACT_EXTENSIONS", "getCONTRACT_EXTENSIONS", "DATA_DIR_SUFFIX", "DEFAULT_TIMEOUT_IN_MILLISECONDS", "", "DEFAULT_WORKING_DIRECTORY", "EXAMPLES_DIR_SUFFIX", "JSON", "MISSING_CONFIG_FILE_MESSAGE", "OPENAPI_FILE_EXTENSIONS", "getOPENAPI_FILE_EXTENSIONS", "SPECMATIC_GITHUB_ISSUES", "SPECMATIC_STUB_DICTIONARY", "TEST_DIR_SUFFIX", "WSDL", "YAML", "YML", "excludedEndpointsWarning", "configErrorMessage", "e", "Lcom/fasterxml/jackson/databind/DatabindException;", "expectedType", "Lcom/fasterxml/jackson/databind/exc/MismatchedInputException;", "invalidContractExtensionMessage", "filename", "loadSpecmaticConfig", "Lio/specmatic/core/SpecmaticConfig;", "configFileName", "loadSpecmaticConfigOrDefault", "loadSpecmaticConfigOrNull", "readablePath", "path", "", "Lcom/fasterxml/jackson/databind/JsonMappingException$Reference;", "isContractFile", "", "loadContract", "Lio/specmatic/core/Feature;", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nSpecmaticConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecmaticConfig.kt\nio/specmatic/core/SpecmaticConfigKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,1164:1\n1#2:1165\n18#3:1166\n26#4:1167\n*S KotlinDebug\n*F\n+ 1 SpecmaticConfig.kt\nio/specmatic/core/SpecmaticConfigKt\n*L\n1150#1:1166\n1150#1:1167\n*E\n"})
public final class SpecmaticConfigKt {
    @NotNull
    private static final String excludedEndpointsWarning = "WARNING: excludedEndpoints is not supported in Specmatic config v2. . Refer to https://specmatic.io/documentation/configuration.html#report-configuration to see how to exclude endpoints.";
    @NotNull
    public static final String APPLICATION_NAME = "Specmatic";
    @NotNull
    public static final String APPLICATION_NAME_LOWER_CASE = "specmatic";
    @NotNull
    public static final String CONFIG_FILE_NAME_WITHOUT_EXT = "specmatic";
    public static final long DEFAULT_TIMEOUT_IN_MILLISECONDS = 6000L;
    @NotNull
    public static final String CONTRACT_EXTENSION = "spec";
    @NotNull
    public static final String YAML = "yaml";
    @NotNull
    public static final String WSDL = "wsdl";
    @NotNull
    public static final String YML = "yml";
    @NotNull
    public static final String JSON = "json";
    @NotNull
    private static final List<String> CONFIG_EXTENSIONS;
    @NotNull
    private static final List<String> OPENAPI_FILE_EXTENSIONS;
    @NotNull
    private static final List<String> CONTRACT_EXTENSIONS;
    @NotNull
    public static final String DATA_DIR_SUFFIX = "_data";
    @NotNull
    public static final String TEST_DIR_SUFFIX = "_tests";
    @NotNull
    public static final String EXAMPLES_DIR_SUFFIX = "_examples";
    @NotNull
    public static final String SPECMATIC_GITHUB_ISSUES = "https://github.com/specmatic/specmatic/issues";
    @NotNull
    public static final String DEFAULT_WORKING_DIRECTORY = ".specmatic";
    @NotNull
    public static final String SPECMATIC_STUB_DICTIONARY = "SPECMATIC_STUB_DICTIONARY";
    @NotNull
    public static final String MISSING_CONFIG_FILE_MESSAGE = "Config file does not exist. (Could not find file ./specmatic.json OR ./specmatic.yaml OR ./specmatic.yml)";

    @NotNull
    public static final List<String> getCONFIG_EXTENSIONS() {
        return CONFIG_EXTENSIONS;
    }

    @NotNull
    public static final List<String> getOPENAPI_FILE_EXTENSIONS() {
        return OPENAPI_FILE_EXTENSIONS;
    }

    @NotNull
    public static final List<String> getCONTRACT_EXTENSIONS() {
        return CONTRACT_EXTENSIONS;
    }

    @NotNull
    public static final String invalidContractExtensionMessage(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        return "The file " + filename + " does not seem like a contract file. Valid extensions for contract files are " + CollectionsKt.joinToString$default(CONTRACT_EXTENSIONS, ", ", null, null, 0, null, null, 62, null);
    }

    public static final boolean isContractFile(@NotNull String $this$isContractFile) {
        Intrinsics.checkNotNullParameter($this$isContractFile, "<this>");
        return CONTRACT_EXTENSIONS.contains(FilesKt.getExtension(new File($this$isContractFile)));
    }

    @NotNull
    public static final Feature loadContract(@NotNull String $this$loadContract) {
        Intrinsics.checkNotNullParameter($this$loadContract, "<this>");
        if (!SpecmaticConfigKt.isContractFile($this$loadContract)) {
            throw new ContractException(SpecmaticConfigKt.invalidContractExtensionMessage($this$loadContract), null, null, null, false, 30, null);
        }
        return FeatureKt.parseContractFileToFeature$default(new File($this$loadContract), null, null, null, null, null, null, null, null, false, 1022, null);
    }

    @NotNull
    public static final SpecmaticConfig loadSpecmaticConfigOrDefault(@Nullable String configFileName) {
        SpecmaticConfig specmaticConfig = SpecmaticConfigKt.loadSpecmaticConfigOrNull(configFileName);
        if (specmaticConfig == null) {
            specmaticConfig = new SpecmaticConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 524287, null);
        }
        return specmaticConfig;
    }

    public static /* synthetic */ SpecmaticConfig loadSpecmaticConfigOrDefault$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return SpecmaticConfigKt.loadSpecmaticConfigOrDefault(string);
    }

    @Nullable
    public static final SpecmaticConfig loadSpecmaticConfigOrNull(@Nullable String configFileName) {
        SpecmaticConfig specmaticConfig;
        if (configFileName == null) {
            specmaticConfig = new SpecmaticConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 524287, null);
        } else {
            SpecmaticConfig specmaticConfig2;
            try {
                specmaticConfig2 = SpecmaticConfigKt.loadSpecmaticConfig(configFileName);
            }
            catch (ContractException e2) {
                LoggingKt.getLogger().log(Utilities.exceptionCauseMessage(e2));
                specmaticConfig2 = null;
            }
            specmaticConfig = specmaticConfig2;
        }
        return specmaticConfig;
    }

    public static /* synthetic */ SpecmaticConfig loadSpecmaticConfigOrNull$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return SpecmaticConfigKt.loadSpecmaticConfigOrNull(string);
    }

    @NotNull
    public static final SpecmaticConfig loadSpecmaticConfig(@Nullable String configFileName) {
        File configFile;
        String string = configFileName;
        if (string == null) {
            string = Configuration.Companion.getConfigFilePath();
        }
        if (!(configFile = new File(string)).exists()) {
            throw new ContractException("Could not find the Specmatic configuration at path " + configFile.getCanonicalPath(), null, null, null, false, 30, null);
        }
        try {
            return VersionAwareConfigParserKt.toSpecmaticConfig(configFile);
        }
        catch (DatabindException e2) {
            throw new Exception(SpecmaticConfigKt.configErrorMessage(e2));
        }
        catch (Throwable e3) {
            throw new Exception("Error parsing config: " + e3.getMessage());
        }
    }

    public static /* synthetic */ SpecmaticConfig loadSpecmaticConfig$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return SpecmaticConfigKt.loadSpecmaticConfig(string);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String configErrorMessage(@NotNull DatabindException e) {
        Intrinsics.checkNotNullParameter(e, "e");
        v0 = e.getLocation();
        if ((v0 != null ? Integer.valueOf(v0.getLineNr()) : null) == null) ** GOTO lbl-1000
        v1 = e.getLocation();
        if ((v1 != null ? Integer.valueOf(v1.getColumnNr()) : null) != null) {
            v2 = " (line " + e.getLocation().getLineNr() + ", column " + e.getLocation().getColumnNr() + ")";
        } else lbl-1000:
        // 2 sources

        {
            v2 = "";
        }
        location = v2;
        errorPrefix = "Error parsing config" + location;
        var3_3 = e;
        if (var3_3 instanceof InvalidNullException) {
            path = ((InvalidNullException)e).getPath();
            Intrinsics.checkNotNull(path);
            fieldPath = SpecmaticConfigKt.readablePath(path);
            v3 = errorPrefix + ": " + fieldPath + " must not be null, but found null.";
        } else if (var3_3 instanceof InvalidFormatException) {
            path = ((InvalidFormatException)e).getPath();
            Intrinsics.checkNotNull(path);
            fieldPath = SpecmaticConfigKt.readablePath(path);
            v4 = ((InvalidFormatException)e).getValue();
            if (v4 != null) {
                it = v4;
                $i$a$-let-SpecmaticConfigKt$configErrorMessage$actualValueClause$1 = false;
                v5 = " (" + it + " is invalid)";
            } else {
                v5 = null;
            }
            actualValueClause = v5;
            v3 = errorPrefix + ": " + fieldPath + " accepts " + SpecmaticConfigKt.expectedType((MismatchedInputException)e) + actualValueClause;
        } else if (var3_3 instanceof IgnoredPropertyException) {
            path = ((IgnoredPropertyException)e).getPath();
            Intrinsics.checkNotNull(path);
            fieldPath = SpecmaticConfigKt.readablePath(path);
            v3 = errorPrefix + ": " + fieldPath + " is not a valid property in the configuration file.";
        } else if (var3_3 instanceof UnrecognizedPropertyException) {
            path = ((UnrecognizedPropertyException)e).getPath();
            Intrinsics.checkNotNull(path);
            fieldPath = SpecmaticConfigKt.readablePath(path);
            v6 = ((UnrecognizedPropertyException)e).getKnownPropertyIds();
            Intrinsics.checkNotNullExpressionValue(v6, "getKnownPropertyIds(...)");
            knownProperties = CollectionsKt.joinToString$default(v6, ", ", null, null, 0, null, null, 62, null);
            v3 = errorPrefix + ": " + fieldPath + " is not a valid property in the configuration file. Known properties are: " + knownProperties + ".";
        } else if (var3_3 instanceof MismatchedInputException) {
            path = ((MismatchedInputException)e).getPath();
            Intrinsics.checkNotNull(path);
            fieldPath = SpecmaticConfigKt.readablePath(path);
            v3 = errorPrefix + ": " + fieldPath + " accepts " + SpecmaticConfigKt.expectedType((MismatchedInputException)e);
        } else if (var3_3 instanceof JsonMappingException) {
            path = ((JsonMappingException)e).getPath();
            Intrinsics.checkNotNull(path);
            fieldPath = SpecmaticConfigKt.readablePath(path);
            v3 = errorPrefix + " at " + fieldPath + ": " + ((JsonMappingException)e).getOriginalMessage();
        } else {
            v3 = errorPrefix + ": " + e.getOriginalMessage();
        }
        return v3;
    }

    private static final String expectedType(MismatchedInputException e2) {
        Object object;
        Class<?> clazz = e2.getTargetType();
        if (clazz == null) {
            return "an object";
        }
        Class<?> targetType = clazz;
        if (targetType.isEnum()) {
            ?[] $this$orEmpty$iv = targetType.getEnumConstants();
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                boolean $i$f$emptyArray = false;
                objectArray = new Object[]{};
            }
            object = "one of the following: " + ArraysKt.joinToString$default(objectArray, (CharSequence)", ", null, null, 0, null, (Function1)expectedType.1.INSTANCE, 30, null);
        } else if (targetType.isPrimitive()) {
            String string = targetType.getSimpleName();
            if (string == null) {
                string = "";
            }
            String string2 = string.toLowerCase(Locale.ROOT);
            object = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        } else {
            Class[] classArray = new Class[]{Number.class, String.class, Boolean.class};
            if (CollectionsKt.contains((Iterable)CollectionsKt.listOf(classArray), targetType.getGenericSuperclass())) {
                String string = targetType.getSimpleName();
                if (string == null) {
                    string = "";
                }
                String string3 = string.toLowerCase(Locale.ROOT);
                object = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            } else {
                object = Intrinsics.areEqual(targetType.getSimpleName(), "ArrayList") ? "a list" : "an object";
            }
        }
        return object;
    }

    private static final String readablePath(List<JsonMappingException.Reference> path2) {
        return StringsKt.replace$default(CollectionsKt.joinToString$default(path2, ".", null, null, 0, null, readablePath.1.INSTANCE, 30, null), ".[", "[", false, 4, null);
    }

    static {
        String[] stringArray = new String[]{YAML, YML, JSON};
        CONFIG_EXTENSIONS = CollectionsKt.listOf(stringArray);
        stringArray = new String[]{YAML, YML, JSON};
        OPENAPI_FILE_EXTENSIONS = CollectionsKt.listOf(stringArray);
        stringArray = new String[]{CONTRACT_EXTENSION, WSDL};
        CONTRACT_EXTENSIONS = CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)OPENAPI_FILE_EXTENSIONS);
    }
}

