/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import io.specmatic.core.HttpPathPattern;
import io.specmatic.core.HttpRequest;
import io.specmatic.core.HttpResponse;
import io.specmatic.core.Result;
import io.specmatic.core.Scenario;
import io.specmatic.core.URLPathSegmentPattern;
import io.specmatic.core.WorkflowDetails;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.Value;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lio/specmatic/core/Workflow;", "", "workflow", "Lio/specmatic/core/WorkflowDetails;", "(Lio/specmatic/core/WorkflowDetails;)V", "id", "Lio/specmatic/core/value/Value;", "getId", "()Lio/specmatic/core/value/Value;", "setId", "(Lio/specmatic/core/value/Value;)V", "getWorkflow", "()Lio/specmatic/core/WorkflowDetails;", "extractDataFrom", "", "response", "Lio/specmatic/core/HttpResponse;", "originalScenario", "Lio/specmatic/core/Scenario;", "updateRequest", "Lio/specmatic/core/HttpRequest;", "request", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nWorkflow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Workflow.kt\nio/specmatic/core/Workflow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n350#2,7:92\n*S KotlinDebug\n*F\n+ 1 Workflow.kt\nio/specmatic/core/Workflow\n*L\n65#1:92,7\n*E\n"})
public final class Workflow {
    @NotNull
    private final WorkflowDetails workflow;
    @Nullable
    private Value id;

    public Workflow(@NotNull WorkflowDetails workflow) {
        Intrinsics.checkNotNullParameter(workflow, "workflow");
        this.workflow = workflow;
    }

    public /* synthetic */ Workflow(WorkflowDetails workflowDetails, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            workflowDetails = WorkflowDetails.Companion.getDefault();
        }
        this(workflowDetails);
    }

    @NotNull
    public final WorkflowDetails getWorkflow() {
        return this.workflow;
    }

    @Nullable
    public final Value getId() {
        return this.id;
    }

    public final void setId(@Nullable Value value2) {
        this.id = value2;
    }

    public final void extractDataFrom(@NotNull HttpResponse response2, @NotNull Scenario originalScenario) {
        Intrinsics.checkNotNullParameter(response2, "response");
        Intrinsics.checkNotNullParameter(originalScenario, "originalScenario");
        String string = this.workflow.getExtractForAPI(originalScenario.getDefaultAPIDescription());
        if (string == null) {
            return;
        }
        String extractLocation = string;
        String[] stringArray = new String[]{"."};
        List locationPath = StringsKt.split$default((CharSequence)extractLocation, stringArray, false, 0, 6, null);
        if (locationPath.isEmpty()) {
            return;
        }
        String area = (String)locationPath.get(0);
        List path2 = CollectionsKt.drop(locationPath, 1);
        String string2 = area.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        if (Intrinsics.areEqual(string2, "BODY")) {
            Value data2;
            Value responseBody2 = response2.getBody();
            if (path2.isEmpty()) {
                this.id = responseBody2;
            } else if (responseBody2 instanceof JSONObjectValue && (data2 = ((JSONObjectValue)responseBody2).findFirstChildByPath(CollectionsKt.joinToString$default(path2, ".", null, null, 0, null, null, 62, null))) != null) {
                this.id = data2;
            }
        } else {
            throw new ContractException("Cannot extract data from " + area + " yet", null, null, null, false, 30, null);
        }
    }

    @NotNull
    public final HttpRequest updateRequest(@NotNull HttpRequest request2, @NotNull Scenario originalScenario) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter(request2, "request");
        Intrinsics.checkNotNullParameter(originalScenario, "originalScenario");
        if (originalScenario.isNegative()) {
            return request2;
        }
        String string = this.workflow.getUseForAPI(originalScenario.getDefaultAPIDescription());
        if (string == null) {
            return request2;
        }
        String useLocation = string;
        String[] stringArray = new String[]{"."};
        List locationPath = StringsKt.split$default((CharSequence)useLocation, stringArray, false, 0, 6, null);
        if (locationPath.isEmpty()) {
            return request2;
        }
        String area = (String)locationPath.get(0);
        List path2 = CollectionsKt.drop(locationPath, 1);
        String string2 = area.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        if (Intrinsics.areEqual(string2, "PATH")) {
            int pathParamIndex;
            block15: {
                if (path2.isEmpty()) {
                    throw new ContractException("Cannot use id " + useLocation, null, null, null, false, 30, null);
                }
                if (path2.size() > 1) {
                    throw new ContractException("PATH.<name> must refer to the name of a path parameter", null, null, null, false, 30, null);
                }
                String pathParamName = (String)path2.get(0);
                Object object = originalScenario.getHttpRequestPattern().getHttpPathPattern();
                if (object != null && (object = ((HttpPathPattern)object).getPathSegmentPatterns()) != null) {
                    Object $this$indexOfFirst$iv = object;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object item$iv = iterator2.next();
                        URLPathSegmentPattern it = (URLPathSegmentPattern)item$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual(it.getKey(), pathParamName)) {
                            v3 = index$iv;
                            break block15;
                        }
                        ++index$iv;
                    }
                    v3 = -1;
                } else {
                    v3 = pathParamIndex = -1;
                }
            }
            if (pathParamIndex < 0) {
                httpRequest = request2;
            } else {
                Result result2;
                String string3 = request2.getPath();
                Intrinsics.checkNotNull(string3);
                String[] stringArray2 = new String[]{"/"};
                List updatedPath = CollectionsKt.toMutableList(StringsKt.split$default((CharSequence)string3, stringArray2, false, 0, 6, null));
                int indexToUpdate = Intrinsics.areEqual(CollectionsKt.getOrNull(updatedPath, 0), "") ? pathParamIndex + 1 : pathParamIndex;
                Value value2 = this.id;
                if (value2 != null) {
                    Value it = value2;
                    boolean bl = false;
                    updatedPath.set(indexToUpdate, it.toStringLiteral());
                }
                HttpPathPattern httpPathPattern = originalScenario.getHttpRequestPattern().getHttpPathPattern();
                Result result3 = result2 = httpPathPattern != null ? httpPathPattern.matches(CollectionsKt.joinToString$default(updatedPath, "/", null, null, 0, null, null, 62, null), originalScenario.getResolver()) : null;
                if (result3 != null) {
                    result3.throwOnFailure();
                }
                httpRequest = HttpRequest.copy$default(request2, null, CollectionsKt.joinToString$default(updatedPath, "/", null, null, 0, null, null, 62, null), null, null, null, null, null, null, 253, null);
            }
        } else {
            throw new ContractException("Cannot extract data from " + area + " yet", null, null, null, false, 30, null);
        }
        return httpRequest;
    }

    public Workflow() {
        this(null, 1, null);
    }
}

