/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.specmatic.core.SpecmaticConfig;
import io.specmatic.core.config.SpecmaticConfigVersion;
import io.specmatic.core.config.v1.SpecmaticConfigV1;
import io.specmatic.core.config.v2.SpecmaticConfigV2;
import io.specmatic.core.pattern.ContractException;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"SPECMATIC_CONFIG_VERSION", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getVersion", "Lio/specmatic/core/config/SpecmaticConfigVersion;", "toSpecmaticConfig", "Lio/specmatic/core/SpecmaticConfig;", "Ljava/io/File;", "specmatic-core"})
public final class VersionAwareConfigParserKt {
    @NotNull
    private static final String SPECMATIC_CONFIG_VERSION = "version";
    @NotNull
    private static final ObjectMapper objectMapper = ExtensionsKt.registerKotlinModule(new ObjectMapper(new YAMLFactory()));

    @NotNull
    public static final SpecmaticConfig toSpecmaticConfig(@NotNull File $this$toSpecmaticConfig) {
        Intrinsics.checkNotNullParameter($this$toSpecmaticConfig, "<this>");
        String configYaml = FilesKt.readText$default($this$toSpecmaticConfig, null, 1, null);
        SpecmaticConfigVersion specmaticConfigVersion = VersionAwareConfigParserKt.getVersion(configYaml);
        return switch (specmaticConfigVersion == null ? -1 : WhenMappings.$EnumSwitchMapping$0[specmaticConfigVersion.ordinal()]) {
            case 1 -> objectMapper.readValue(configYaml, SpecmaticConfigV1.class).transform();
            case 2 -> objectMapper.readValue(configYaml, SpecmaticConfigV2.class).transform();
            default -> throw new ContractException("Unsupported Specmatic config version", null, null, null, false, 30, null);
        };
    }

    @Nullable
    public static final SpecmaticConfigVersion getVersion(@NotNull String $this$getVersion) {
        Integer version2;
        Intrinsics.checkNotNullParameter($this$getVersion, "<this>");
        JsonNode jsonNode = objectMapper.readTree($this$getVersion).get(SPECMATIC_CONFIG_VERSION);
        Integer n = version2 = jsonNode != null ? Integer.valueOf(jsonNode.asInt()) : null;
        if (version2 == null || version2 == 0) {
            return SpecmaticConfigVersion.VERSION_1;
        }
        return SpecmaticConfigVersion.Companion.getByValue(version2);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpecmaticConfigVersion.values().length];
            try {
                nArray[SpecmaticConfigVersion.VERSION_1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpecmaticConfigVersion.VERSION_2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

