/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.config.v3;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.specmatic.core.ResiliencyTestSuite;
import io.specmatic.core.ResiliencyTestsConfig;
import io.specmatic.core.config.v3.SpecExecutionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/specmatic/core/config/v3/ConsumesDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "", "Lio/specmatic/core/config/v3/SpecExecutionConfig;", "consumes", "", "(Z)V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "getValidatedJsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "parseObjectValue", "Lio/specmatic/core/config/v3/SpecExecutionConfig$ObjectValue;", "parseResiliencyTestsIfApplicable", "Lio/specmatic/core/ResiliencyTestsConfig;", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nSpecExecutionConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecExecutionConfig.kt\nio/specmatic/core/config/v3/ConsumesDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1#2:149\n1549#3:150\n1620#3,3:151\n1549#3:154\n1620#3,3:155\n1747#3,3:158\n766#3:161\n857#3,2:162\n*S KotlinDebug\n*F\n+ 1 SpecExecutionConfig.kt\nio/specmatic/core/config/v3/ConsumesDeserializer\n*L\n61#1:150\n61#1:151,3\n72#1:154\n72#1:155,3\n109#1:158,3\n115#1:161\n115#1:162,2\n*E\n"})
public final class ConsumesDeserializer
extends JsonDeserializer<List<? extends SpecExecutionConfig>> {
    private final boolean consumes;

    public ConsumesDeserializer(boolean consumes2) {
        this.consumes = consumes2;
    }

    public /* synthetic */ ConsumesDeserializer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SpecExecutionConfig> deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(ctxt, "ctxt");
        Object t2 = p.getCodec().readTree(p);
        JsonNode p0 = (JsonNode)t2;
        boolean bl = false;
        JsonNode jsonNode = (JsonNode)(p0.isArray() ? t2 : null);
        if (jsonNode != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = jsonNode;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SpecExecutionConfig specExecutionConfig;
                void element;
                JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                if (element.isTextual()) {
                    String string = element.asText();
                    Intrinsics.checkNotNullExpressionValue(string, "asText(...)");
                    specExecutionConfig = new SpecExecutionConfig.StringValue(string);
                } else if (element.isObject()) {
                    Intrinsics.checkNotNull(element);
                    specExecutionConfig = this.parseObjectValue((JsonNode)element, p);
                } else {
                    throw new JsonMappingException(p, "Consumes entry must be string or object");
                }
                collection.add(specExecutionConfig);
            }
        } else {
            throw new JsonMappingException(p, "Consumes should be an array");
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final SpecExecutionConfig.ObjectValue parseObjectValue(JsonNode $this$parseObjectValue, JsonParser p) {
        SpecExecutionConfig.ObjectValue objectValue;
        void $this$mapTo$iv$iv;
        JsonNode validatedJsonNode = this.getValidatedJsonNode($this$parseObjectValue, p);
        JsonNode jsonNode = validatedJsonNode.get("specs");
        Intrinsics.checkNotNullExpressionValue(jsonNode, "get(...)");
        Iterable $this$map$iv = jsonNode;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.asText());
        }
        List specs = (List)destination$iv$iv;
        ResiliencyTestsConfig resiliencyTests = this.parseResiliencyTestsIfApplicable($this$parseObjectValue, p);
        if ($this$parseObjectValue.has("baseUrl")) {
            String string = $this$parseObjectValue.get("baseUrl").asText();
            Intrinsics.checkNotNullExpressionValue(string, "asText(...)");
            objectValue = new SpecExecutionConfig.ObjectValue.FullUrl(string, specs, resiliencyTests);
        } else {
            JsonNode jsonNode3 = $this$parseObjectValue.get("host");
            JsonNode jsonNode4 = $this$parseObjectValue.get("port");
            JsonNode jsonNode5 = $this$parseObjectValue.get("basePath");
            objectValue = new SpecExecutionConfig.ObjectValue.PartialUrl(jsonNode3 != null ? jsonNode3.asText() : null, jsonNode4 != null ? Integer.valueOf(jsonNode4.asInt()) : null, jsonNode5 != null ? jsonNode5.asText() : null, specs, resiliencyTests);
        }
        return objectValue;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonNode getValidatedJsonNode(JsonNode $this$getValidatedJsonNode, JsonParser p) {
        Iterable<JsonNode> it;
        boolean bl;
        block17: {
            Set<String> set2;
            Set<String> $this$getValidatedJsonNode_u24lambda_u242 = set2 = SetsKt.createSetBuilder();
            boolean bl2 = false;
            String[] stringArray = new String[]{"baseUrl", "host", "port", "basePath", "specs"};
            $this$getValidatedJsonNode_u24lambda_u242.addAll((Collection)CollectionsKt.listOf(stringArray));
            if (!this.consumes) {
                $this$getValidatedJsonNode_u24lambda_u242.add("resiliencyTests");
            }
            Set allowedFields = SetsKt.build(set2);
            Iterator<String> iterator2 = $this$getValidatedJsonNode.fieldNames();
            Intrinsics.checkNotNullExpressionValue(iterator2, "fieldNames(...)");
            Set<String> unknownFields2 = SequencesKt.toSet(SequencesKt.filterNot(SequencesKt.asSequence(iterator2), (Function1)new Function1<String, Boolean>(allowedFields){

                public final Boolean invoke(String p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((Set)this.receiver).contains(p0);
                }
            }));
            if (!((Collection)unknownFields2).isEmpty()) {
                throw new JsonMappingException(p, "Unknown fields: " + CollectionsKt.joinToString$default(unknownFields2, ", ", null, null, 0, null, null, 62, null) + "\nAllowed fields: " + CollectionsKt.joinToString$default(allowedFields, ", ", null, null, 0, null, null, 62, null));
            }
            if (!this.consumes && $this$getValidatedJsonNode.has("basePath")) {
                throw new JsonMappingException(p, "Field 'basePath' is not supported in provides");
            }
            JsonNode specsField = $this$getValidatedJsonNode.get("specs");
            if (specsField == null) {
                throw new JsonMappingException(p, "Missing required field 'specs'");
            }
            if (!specsField.isArray()) {
                throw new JsonMappingException(p, "'specs' must be an array");
            }
            if (specsField.isEmpty()) {
                throw new JsonMappingException(p, "'specs' array cannot be empty");
            }
            Iterable $this$any$iv = specsField;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (JsonNode)element$iv;
                    boolean bl3 = false;
                    if (!(!it.isTextual())) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new JsonMappingException(p, "'specs' must contain only strings");
        }
        boolean hasBaseUrl = $this$getValidatedJsonNode.has("baseUrl");
        if (this.consumes) {
            void $this$filterTo$iv$iv;
            String[] stringArray = new String[]{"host", "port", "basePath"};
            Iterable $this$filter$iv = CollectionsKt.listOf(stringArray);
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String p0 = (String)element$iv$iv;
                boolean bl4 = false;
                if (!$this$getValidatedJsonNode.has(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List partialFields = (List)destination$iv$iv;
            boolean hasPartialFields = !((Collection)partialFields).isEmpty();
            if (hasBaseUrl && hasPartialFields) {
                throw new JsonMappingException(p, "Cannot combine baseUrl with " + CollectionsKt.joinToString$default(partialFields, ", ", null, null, 0, null, null, 62, null));
            }
            if (!hasBaseUrl && !hasPartialFields) {
                throw new JsonMappingException(p, "Must provide baseUrl or one or combination of host, port, and basePath");
            }
        } else {
            boolean hasHostOrPort = $this$getValidatedJsonNode.has("host") || $this$getValidatedJsonNode.has("port");
            if (hasBaseUrl && hasHostOrPort) {
                throw new JsonMappingException(p, "Cannot combine baseUrl with host or port");
            }
            if (!hasBaseUrl && !hasHostOrPort) {
                throw new JsonMappingException(p, "Must provide baseUrl or one or combination of host and port");
            }
        }
        return $this$getValidatedJsonNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ResiliencyTestsConfig parseResiliencyTestsIfApplicable(JsonNode $this$parseResiliencyTestsIfApplicable, JsonParser p) {
        ResiliencyTestSuite resiliencyTestSuite;
        block12: {
            String value2;
            block11: {
                if (this.consumes) {
                    return null;
                }
                JsonNode jsonNode = $this$parseResiliencyTestsIfApplicable.get("resiliencyTests");
                if (jsonNode == null) {
                    return null;
                }
                JsonNode node = jsonNode;
                if (!node.isObject()) {
                    throw new JsonMappingException(p, "'resiliencyTests' must be an object with field 'enable'");
                }
                JsonNode jsonNode2 = node.get("enable");
                if (jsonNode2 == null) {
                    return new ResiliencyTestsConfig(null, 1, null);
                }
                JsonNode enableNode = jsonNode2;
                if (!enableNode.isTextual()) {
                    throw new JsonMappingException(p, "'resiliencyTests.enable' must be one of: positiveOnly, all, none");
                }
                value2 = enableNode.asText();
                if (value2 == null) throw new JsonMappingException(p, "Unknown value '" + value2 + "' for 'resiliencyTests.enable'. Allowed: positiveOnly, all, none");
                switch (value2.hashCode()) {
                    case 96673: {
                        if (value2.equals("all")) break;
                        throw new JsonMappingException(p, "Unknown value '" + value2 + "' for 'resiliencyTests.enable'. Allowed: positiveOnly, all, none");
                    }
                    case 3387192: {
                        if (!value2.equals("none")) {
                            throw new JsonMappingException(p, "Unknown value '" + value2 + "' for 'resiliencyTests.enable'. Allowed: positiveOnly, all, none");
                        }
                        break block11;
                    }
                    case 226003269: {
                        if (!value2.equals("positiveOnly")) throw new JsonMappingException(p, "Unknown value '" + value2 + "' for 'resiliencyTests.enable'. Allowed: positiveOnly, all, none");
                        resiliencyTestSuite = ResiliencyTestSuite.positiveOnly;
                        break block12;
                    }
                }
                resiliencyTestSuite = ResiliencyTestSuite.all;
                break block12;
            }
            resiliencyTestSuite = ResiliencyTestSuite.none;
            break block12;
            throw new JsonMappingException(p, "Unknown value '" + value2 + "' for 'resiliencyTests.enable'. Allowed: positiveOnly, all, none");
        }
        ResiliencyTestSuite enable = resiliencyTestSuite;
        return new ResiliencyTestsConfig(enable);
    }

    public ConsumesDeserializer() {
        this(false, 1, null);
    }
}

