/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.examples.module;

import io.specmatic.conversions.ExampleFromFile;
import io.specmatic.core.Feature;
import io.specmatic.core.FeatureKt;
import io.specmatic.core.Result;
import io.specmatic.core.Results;
import io.specmatic.core.examples.module.ExampleModule;
import io.specmatic.core.examples.module.ExampleValidationModule;
import io.specmatic.core.examples.module.ValidationResult;
import io.specmatic.core.examples.module.ValidationResults;
import io.specmatic.core.examples.server.InteractiveExamplesMismatchMessages;
import io.specmatic.core.examples.server.ScenarioFilter;
import io.specmatic.core.examples.server.SchemaExample;
import io.specmatic.core.lifecycle.ExamplesUsedFor;
import io.specmatic.core.lifecycle.LifecycleHooks;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.pattern.HasFailure;
import io.specmatic.core.value.NullValue;
import io.specmatic.mock.ScenarioStub;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\n\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\n\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00120\b2\b\b\u0002\u0010\u0017\u001a\u00020\u0018J@\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\b0\u001a2\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u001d"}, d2={"Lio/specmatic/core/examples/module/ExampleValidationModule;", "", "()V", "callLifecycleHook", "Lio/specmatic/core/Result;", "feature", "Lio/specmatic/core/Feature;", "examples", "", "Lio/specmatic/conversions/ExampleFromFile;", "validateExample", "example", "schemaExample", "Lio/specmatic/core/examples/server/SchemaExample;", "Lio/specmatic/core/Results;", "scenarioStub", "Lio/specmatic/mock/ScenarioStub;", "exampleFile", "Ljava/io/File;", "Lio/specmatic/core/examples/module/ValidationResult;", "contractFile", "validateExamples", "Lio/specmatic/core/examples/module/ValidationResults;", "scenarioFilter", "Lio/specmatic/core/examples/server/ScenarioFilter;", "validateInlineExamples", "", "", "validateSchemaExample", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nExampleValidationModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExampleValidationModule.kt\nio/specmatic/core/examples/module/ExampleValidationModule\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n453#2:112\n403#2:113\n1238#3,2:114\n1603#3,9:116\n1855#3:125\n1856#3:127\n1612#3:128\n1241#3:129\n1179#3,2:130\n1253#3,4:132\n1549#3:136\n1620#3,3:137\n1#4:126\n*S KotlinDebug\n*F\n+ 1 ExampleValidationModule.kt\nio/specmatic/core/examples/module/ExampleValidationModule\n*L\n24#1:112\n24#1:113\n24#1:114,2\n27#1:116,9\n27#1:125\n27#1:127\n27#1:128\n24#1:129\n45#1:130,2\n45#1:132,4\n105#1:136\n105#1:137,3\n27#1:126\n*E\n"})
public final class ExampleValidationModule {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Result> validateInlineExamples(@NotNull Feature feature, @NotNull Map<String, ? extends List<ScenarioStub>> examples, @NotNull ScenarioFilter scenarioFilter) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(feature, "feature");
        Intrinsics.checkNotNullParameter(examples, "examples");
        Intrinsics.checkNotNullParameter(scenarioFilter, "scenarioFilter");
        Feature updatedFeature = scenarioFilter.filter(feature);
        Map<String, ? extends List<ScenarioStub>> $this$mapValues$iv = examples;
        boolean $i$f$mapValues = false;
        Map<String, ? extends List<ScenarioStub>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String name = (String)entry2.getKey();
            List exampleList = (List)entry2.getValue();
            LoggingKt.getLogger().debug("Validating " + name);
            Iterable $this$mapNotNull$iv = exampleList;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Result it$iv$iv2;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
                boolean bl3 = false;
                ScenarioStub example = (ScenarioStub)element$iv$iv;
                boolean bl4 = false;
                Results results2 = this.validateExample(updatedFeature, example);
                if ((!results2.hasResults() ? null : results2.toResultIfAny()) == null) continue;
                it$iv$iv2 = it$iv$iv2;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            List it = (List)destination$iv$iv2;
            boolean bl6 = false;
            Result result2 = Result.Companion.fromResults(it);
            map4.put(k2, result2);
        }
        Map results3 = destination$iv$iv;
        return results3;
    }

    public static /* synthetic */ Map validateInlineExamples$default(ExampleValidationModule exampleValidationModule, Feature feature, Map map2, ScenarioFilter scenarioFilter, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            scenarioFilter = new ScenarioFilter(null, null, null, 7, null);
        }
        return exampleValidationModule.validateInlineExamples(feature, map2, scenarioFilter);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ValidationResults validateExamples(@NotNull Feature feature, @NotNull List<? extends File> examples, @NotNull ScenarioFilter scenarioFilter) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(feature, "feature");
        Intrinsics.checkNotNullParameter(examples, "examples");
        Intrinsics.checkNotNullParameter(scenarioFilter, "scenarioFilter");
        Feature updatedFeature = scenarioFilter.filter(feature);
        Iterable $this$associate$iv = examples;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            File exampleFile = (File)element$iv$iv;
            boolean bl = false;
            LoggingKt.getLogger().debug("Validating " + exampleFile.getName());
            Pair<String, Result> pair = TuplesKt.to(exampleFile.getCanonicalPath(), this.validateExample(updatedFeature, exampleFile));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Result result2 = this.callLifecycleHook(updatedFeature, new ExampleModule().getExamplesFromFiles(examples));
        Map map3 = destination$iv$iv;
        return new ValidationResults(map3, result2);
    }

    public static /* synthetic */ ValidationResults validateExamples$default(ExampleValidationModule exampleValidationModule, Feature feature, List list, ScenarioFilter scenarioFilter, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            scenarioFilter = new ScenarioFilter(null, null, null, 7, null);
        }
        return exampleValidationModule.validateExamples(feature, list, scenarioFilter);
    }

    @NotNull
    public final ValidationResult validateExample(@NotNull File contractFile, @NotNull File exampleFile) {
        Intrinsics.checkNotNullParameter(contractFile, "contractFile");
        Intrinsics.checkNotNullParameter(exampleFile, "exampleFile");
        Feature feature = FeatureKt.parseContractFileWithNoMissingConfigWarning(contractFile);
        return new ValidationResult(this.validateExample(feature, exampleFile), this.callLifecycleHook(feature, new ExampleModule().getExamplesFromFiles(CollectionsKt.listOf(exampleFile))));
    }

    @NotNull
    public final Results validateExample(@NotNull Feature feature, @NotNull ScenarioStub scenarioStub) {
        Intrinsics.checkNotNullParameter(feature, "feature");
        Intrinsics.checkNotNullParameter(scenarioStub, "scenarioStub");
        return feature.matchResultFlagBased(scenarioStub, InteractiveExamplesMismatchMessages.INSTANCE);
    }

    private final Result validateExample(Feature feature, ExampleFromFile example) {
        return feature.matchResultFlagBased(example.getRequest(), example.getResponse(), InteractiveExamplesMismatchMessages.INSTANCE, example.isPartial()).toResultIfAnyWithCauses();
    }

    private final Result validateExample(Feature feature, SchemaExample schemaExample) {
        if (schemaExample.getValue() instanceof NullValue) {
            return new Result.Success(null, null, 3, null);
        }
        return feature.matchResultSchemaFlagBased(schemaExample.getDiscriminatorBasedOn(), schemaExample.getSchemaBasedOn(), schemaExample.getValue(), InteractiveExamplesMismatchMessages.INSTANCE, schemaExample.getFile().getName());
    }

    @NotNull
    public final Result validateExample(@NotNull Feature feature, @NotNull File exampleFile) {
        Intrinsics.checkNotNullParameter(feature, "feature");
        Intrinsics.checkNotNullParameter(exampleFile, "exampleFile");
        return (Result)ExampleFromFile.Companion.fromFile(exampleFile).realise((Function2)new Function2<ExampleFromFile, String, Result>(this, feature){
            final /* synthetic */ ExampleValidationModule this$0;
            final /* synthetic */ Feature $feature;
            {
                this.this$0 = $receiver;
                this.$feature = $feature;
                super(2);
            }

            public final Result invoke(ExampleFromFile example, String string) {
                Intrinsics.checkNotNullParameter(example, "example");
                return ExampleValidationModule.access$validateExample(this.this$0, this.$feature, example);
            }
        }, (Function1)new Function1<HasFailure<ExampleFromFile>, Result>(this, feature, exampleFile){
            final /* synthetic */ ExampleValidationModule this$0;
            final /* synthetic */ Feature $feature;
            final /* synthetic */ File $exampleFile;
            {
                this.this$0 = $receiver;
                this.$feature = $feature;
                this.$exampleFile = $exampleFile;
                super(1);
            }

            public final Result invoke(HasFailure<ExampleFromFile> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.validateSchemaExample(this.$feature, this.$exampleFile);
            }
        }, validateExample.3.INSTANCE);
    }

    @NotNull
    public final Result validateSchemaExample(@NotNull Feature feature, @NotNull File exampleFile) {
        Intrinsics.checkNotNullParameter(feature, "feature");
        Intrinsics.checkNotNullParameter(exampleFile, "exampleFile");
        return (Result)SchemaExample.Companion.fromFile(exampleFile).realise((Function2)new Function2<SchemaExample, String, Result>(this, feature){
            final /* synthetic */ ExampleValidationModule this$0;
            final /* synthetic */ Feature $feature;
            {
                this.this$0 = $receiver;
                this.$feature = $feature;
                super(2);
            }

            public final Result invoke(SchemaExample example, String string) {
                Intrinsics.checkNotNullParameter(example, "example");
                return ExampleValidationModule.access$validateExample(this.this$0, this.$feature, example);
            }
        }, validateSchemaExample.2.INSTANCE, validateSchemaExample.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final Result callLifecycleHook(Feature feature, List<ExampleFromFile> examples) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = examples;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExampleFromFile exampleFromFile = (ExampleFromFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ScenarioStub(it.getRequest(), null, null, null, null, null, it.getFile().getPath(), null, 190, null));
        }
        List scenarioStubs = (List)destination$iv$iv;
        return LifecycleHooks.INSTANCE.getAfterLoadingStaticExamples().call(ExamplesUsedFor.Validation, CollectionsKt.listOf(new Pair<Feature, List>(feature, scenarioStubs)));
    }

    public static final /* synthetic */ Result access$validateExample(ExampleValidationModule $this, Feature feature, ExampleFromFile example) {
        return $this.validateExample(feature, example);
    }

    public static final /* synthetic */ Result access$validateExample(ExampleValidationModule $this, Feature feature, SchemaExample schemaExample) {
        return $this.validateExample(feature, schemaExample);
    }
}

