/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.filters;

import com.ezylang.evalex.Expression;
import com.ezylang.evalex.config.ExpressionConfiguration;
import io.specmatic.core.filters.ExpressionStandardizer;
import io.specmatic.core.filters.IncludesFunction;
import io.specmatic.core.filters.NumericComparisonOperatorFunction;
import io.specmatic.core.filters.Operator;
import io.specmatic.core.filters.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\r"}, d2={"Lio/specmatic/core/filters/ExpressionStandardizer;", "", "()V", "tokenize", "", "Lio/specmatic/core/filters/Token;", "expr", "", "tokenizeExpression", "expression", "tokensToString", "tokens", "Companion", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nExpressionStandardizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionStandardizer.kt\nio/specmatic/core/filters/ExpressionStandardizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class ExpressionStandardizer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String tokenizeExpression(@NotNull String expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        List<Token> tokens = this.tokenize(expression);
        return this.tokensToString(tokens);
    }

    private final List<Token> tokenize(String expr) {
        List tokens = new ArrayList();
        Ref.IntRef i2 = new Ref.IntRef();
        while (i2.element < expr.length()) {
            String value2;
            String key2;
            Operator operator;
            Object v0;
            block11: {
                int n;
                ExpressionStandardizer.tokenize$skipWhitespace(i2, expr);
                if (StringsKt.startsWith$default(expr, "&&", i2.element, false, 4, null)) {
                    tokens.add(Token.And.INSTANCE);
                    i2.element += 2;
                    continue;
                }
                if (StringsKt.startsWith$default(expr, "||", i2.element, false, 4, null)) {
                    tokens.add(Token.Or.INSTANCE);
                    i2.element += 2;
                    continue;
                }
                if (expr.charAt(i2.element) == '!') {
                    tokens.add(Token.Not.INSTANCE);
                    n = i2.element;
                    i2.element = n + 1;
                    continue;
                }
                if (expr.charAt(i2.element) == '(') {
                    tokens.add(Token.LParen.INSTANCE);
                    n = i2.element;
                    i2.element = n + 1;
                    continue;
                }
                if (expr.charAt(i2.element) == ')') {
                    tokens.add(Token.RParen.INSTANCE);
                    n = i2.element;
                    i2.element = n + 1;
                    continue;
                }
                int keyStart = i2.element;
                while (i2.element < expr.length() && (Character.isLetterOrDigit(expr.charAt(i2.element)) || expr.charAt(i2.element) == '_' || expr.charAt(i2.element) == '.' || expr.charAt(i2.element) == '-')) {
                    int n2 = i2.element;
                    i2.element = n2 + 1;
                }
                Intrinsics.checkNotNullExpressionValue(expr.substring(keyStart, i2.element), "substring(...)");
                ExpressionStandardizer.tokenize$skipWhitespace(i2, expr);
                Iterable iterable = Operator.Companion.getALL();
                for (Object t2 : iterable) {
                    Operator eachOperator = (Operator)t2;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default(expr, eachOperator.getSymbol(), i2.element, false, 4, null)) continue;
                    v0 = t2;
                    break block11;
                }
                v0 = null;
            }
            if ((Operator)v0 == null) {
                throw new IllegalArgumentException("Expected an operator for the given expression: " + expr + " at position " + i2.element);
            }
            i2.element += operator.getSymbol().length();
            ExpressionStandardizer.tokenize$skipWhitespace(i2, expr);
            if (expr.charAt(i2.element) != '\'') {
                throw new IllegalArgumentException("Expected quote for the given expression: " + expr + " at position " + i2.element);
            }
            int n = i2.element;
            int valueStart = i2.element = n + 1;
            while (i2.element < expr.length() && expr.charAt(i2.element) != '\'') {
                int n3 = i2.element;
                i2.element = n3 + 1;
            }
            Intrinsics.checkNotNullExpressionValue(expr.substring(valueStart, i2.element), "substring(...)");
            int n4 = i2.element;
            i2.element = n4 + 1;
            tokens.add(new Token.Operation(key2, operator, value2));
        }
        return tokens;
    }

    private final String tokensToString(List<? extends Token> tokens) {
        return CollectionsKt.joinToString$default(tokens, " ", null, null, 0, null, tokensToString.1.INSTANCE, 30, null);
    }

    private static final void tokenize$skipWhitespace(Ref.IntRef i2, String $expr) {
        while (i2.element < $expr.length() && CharsKt.isWhitespace($expr.charAt(i2.element))) {
            int n = i2.element;
            i2.element = n + 1;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/specmatic/core/filters/ExpressionStandardizer$Companion;", "", "()V", "expressionConfiguration", "Lcom/ezylang/evalex/config/ExpressionConfiguration;", "filterToEvalEx", "Lcom/ezylang/evalex/Expression;", "filterExpression", "", "specmatic-core"})
    @SourceDebugExtension(value={"SMAP\nExpressionStandardizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionStandardizer.kt\nio/specmatic/core/filters/ExpressionStandardizer$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,137:1\n125#2:138\n152#2,3:139\n37#3,2:142\n*S KotlinDebug\n*F\n+ 1 ExpressionStandardizer.kt\nio/specmatic/core/filters/ExpressionStandardizer$Companion\n*L\n132#1:138\n132#1:139,3\n132#1:142,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Expression filterToEvalEx(@NotNull String filterExpression) {
            Intrinsics.checkNotNullParameter(filterExpression, "filterExpression");
            if (StringsKt.isBlank(filterExpression)) {
                return new Expression("true", this.expressionConfiguration());
            }
            ExpressionStandardizer expressionStandardizer = new ExpressionStandardizer();
            String evalExExpression = expressionStandardizer.tokenizeExpression(filterExpression);
            return new Expression(evalExExpression, this.expressionConfiguration());
        }

        /*
         * WARNING - void declaration
         */
        private final ExpressionConfiguration expressionConfiguration() {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Map functions;
            Pair[] pairArray = new Pair[]{TuplesKt.to("eFunc", new NumericComparisonOperatorFunction()), TuplesKt.to("includes", new IncludesFunction())};
            Map map2 = functions = MapsKt.mapOf(pairArray);
            ExpressionConfiguration expressionConfiguration = ExpressionConfiguration.builder().binaryAllowed(true).singleQuoteStringLiteralsAllowed(true).build();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Map.entry(it.getKey(), it.getValue()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Map.Entry[] entryArray = thisCollection$iv.toArray(new Map.Entry[0]);
            ExpressionConfiguration configuration = expressionConfiguration.withAdditionalFunctions(Arrays.copyOf(entryArray, entryArray.length));
            return configuration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

