/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.filters;

import io.specmatic.conversions.OperationMetadata;
import io.specmatic.core.HttpPathPattern;
import io.specmatic.core.Scenario;
import io.specmatic.core.URLPathSegmentPattern;
import io.specmatic.core.filters.HTTPFilterKeysKt;
import io.specmatic.core.pattern.Examples;
import io.specmatic.core.pattern.Row;
import io.specmatic.mock.ScenarioStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0081\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H&J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u0006!"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys;", "", "key", "", "isPrefix", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "()Z", "getKey", "()Ljava/lang/String;", "includes", "scenario", "Lio/specmatic/core/Scenario;", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "PATH", "METHOD", "STATUS", "PARAMETERS_HEADER", "PARAMETERS_HEADER_WITH_SPECIFIC_VALUE", "PARAMETERS_QUERY", "PARAMETERS_QUERY_WITH_SPECIFIC_VALUE", "PARAMETERS_PATH", "PARAMETERS_PATH_WITH_SPECIFIC_VALUE", "REQUEST_BODY_CONTENT_TYPE", "RESPONSE_CONTENT_TYPE", "EXAMPLE_NAME", "TAGS", "SUMMARY", "OPERATION_ID", "DESCRIPTION", "Companion", "specmatic-core"})
public abstract class HTTPFilterKeys
extends Enum<HTTPFilterKeys> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String key;
    private final boolean isPrefix;
    public static final /* enum */ HTTPFilterKeys PATH;
    public static final /* enum */ HTTPFilterKeys METHOD;
    public static final /* enum */ HTTPFilterKeys STATUS;
    public static final /* enum */ HTTPFilterKeys PARAMETERS_HEADER;
    public static final /* enum */ HTTPFilterKeys PARAMETERS_HEADER_WITH_SPECIFIC_VALUE;
    public static final /* enum */ HTTPFilterKeys PARAMETERS_QUERY;
    public static final /* enum */ HTTPFilterKeys PARAMETERS_QUERY_WITH_SPECIFIC_VALUE;
    public static final /* enum */ HTTPFilterKeys PARAMETERS_PATH;
    public static final /* enum */ HTTPFilterKeys PARAMETERS_PATH_WITH_SPECIFIC_VALUE;
    public static final /* enum */ HTTPFilterKeys REQUEST_BODY_CONTENT_TYPE;
    public static final /* enum */ HTTPFilterKeys RESPONSE_CONTENT_TYPE;
    public static final /* enum */ HTTPFilterKeys EXAMPLE_NAME;
    public static final /* enum */ HTTPFilterKeys TAGS;
    public static final /* enum */ HTTPFilterKeys SUMMARY;
    public static final /* enum */ HTTPFilterKeys OPERATION_ID;
    public static final /* enum */ HTTPFilterKeys DESCRIPTION;
    private static final /* synthetic */ HTTPFilterKeys[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private HTTPFilterKeys(String key2, boolean isPrefix) {
        this.key = key2;
        this.isPrefix = isPrefix;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public final boolean isPrefix() {
        return this.isPrefix;
    }

    public abstract boolean includes(@NotNull Scenario var1, @NotNull String var2, @NotNull String var3);

    public abstract boolean includes(@NotNull ScenarioStub var1, @NotNull String var2, @NotNull String var3);

    public static HTTPFilterKeys[] values() {
        return (HTTPFilterKeys[])$VALUES.clone();
    }

    public static HTTPFilterKeys valueOf(String value2) {
        return Enum.valueOf(HTTPFilterKeys.class, value2);
    }

    @NotNull
    public static EnumEntries<HTTPFilterKeys> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ HTTPFilterKeys(String $enum$name, int $enum$ordinal, String key2, boolean isPrefix, DefaultConstructorMarker $constructor_marker) {
        this(key2, isPrefix);
    }

    static {
        PATH = new PATH("PATH", 0);
        METHOD = new METHOD("METHOD", 1);
        STATUS = new STATUS("STATUS", 2);
        PARAMETERS_HEADER = new PARAMETERS_HEADER("PARAMETERS_HEADER", 3);
        PARAMETERS_HEADER_WITH_SPECIFIC_VALUE = new PARAMETERS_HEADER_WITH_SPECIFIC_VALUE("PARAMETERS_HEADER_WITH_SPECIFIC_VALUE", 4);
        PARAMETERS_QUERY = new PARAMETERS_QUERY("PARAMETERS_QUERY", 5);
        PARAMETERS_QUERY_WITH_SPECIFIC_VALUE = new PARAMETERS_QUERY_WITH_SPECIFIC_VALUE("PARAMETERS_QUERY_WITH_SPECIFIC_VALUE", 6);
        PARAMETERS_PATH = new PARAMETERS_PATH("PARAMETERS_PATH", 7);
        PARAMETERS_PATH_WITH_SPECIFIC_VALUE = new PARAMETERS_PATH_WITH_SPECIFIC_VALUE("PARAMETERS_PATH_WITH_SPECIFIC_VALUE", 8);
        REQUEST_BODY_CONTENT_TYPE = new REQUEST_BODY_CONTENT_TYPE("REQUEST_BODY_CONTENT_TYPE", 9);
        RESPONSE_CONTENT_TYPE = new RESPONSE_CONTENT_TYPE("RESPONSE_CONTENT_TYPE", 10);
        EXAMPLE_NAME = new EXAMPLE_NAME("EXAMPLE_NAME", 11);
        TAGS = new TAGS("TAGS", 12);
        SUMMARY = new SUMMARY("SUMMARY", 13);
        OPERATION_ID = new OPERATION_ID("OPERATION_ID", 14);
        DESCRIPTION = new DESCRIPTION("DESCRIPTION", 15);
        $VALUES = hTTPFilterKeysArray = new HTTPFilterKeys[]{HTTPFilterKeys.PATH, HTTPFilterKeys.METHOD, HTTPFilterKeys.STATUS, HTTPFilterKeys.PARAMETERS_HEADER, HTTPFilterKeys.PARAMETERS_HEADER_WITH_SPECIFIC_VALUE, HTTPFilterKeys.PARAMETERS_QUERY, HTTPFilterKeys.PARAMETERS_QUERY_WITH_SPECIFIC_VALUE, HTTPFilterKeys.PARAMETERS_PATH, HTTPFilterKeys.PARAMETERS_PATH_WITH_SPECIFIC_VALUE, HTTPFilterKeys.REQUEST_BODY_CONTENT_TYPE, HTTPFilterKeys.RESPONSE_CONTENT_TYPE, HTTPFilterKeys.EXAMPLE_NAME, HTTPFilterKeys.TAGS, HTTPFilterKeys.SUMMARY, HTTPFilterKeys.OPERATION_ID, HTTPFilterKeys.DESCRIPTION};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$Companion;", "", "()V", "fromKey", "Lio/specmatic/core/filters/HTTPFilterKeys;", "key", "", "matchesPath", "", "scenarioValue", "value", "specmatic-core"})
    @SourceDebugExtension(value={"SMAP\nHTTPFilterKeys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n288#2,2:236\n288#2,2:239\n1#3:238\n*S KotlinDebug\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$Companion\n*L\n220#1:236,2\n221#1:239,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HTTPFilterKeys fromKey(@NotNull String key2) {
            Object v1;
            block5: {
                Object v0;
                HTTPFilterKeys it;
                boolean $i$f$firstOrNull;
                Iterable $this$firstOrNull$iv;
                block4: {
                    Intrinsics.checkNotNullParameter(key2, "key");
                    $this$firstOrNull$iv = HTTPFilterKeys.getEntries();
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (HTTPFilterKeys)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getKey(), key2)) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                HTTPFilterKeys hTTPFilterKeys = v0;
                if (hTTPFilterKeys != null) {
                    HTTPFilterKeys it2 = hTTPFilterKeys;
                    boolean bl = false;
                    return it2;
                }
                $this$firstOrNull$iv = HTTPFilterKeys.getEntries();
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (HTTPFilterKeys)((Object)element$iv);
                    boolean bl = false;
                    if (!(it.isPrefix() && StringsKt.startsWith$default(key2, it.getKey(), false, 2, null))) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            HTTPFilterKeys hTTPFilterKeys = v1;
            if (hTTPFilterKeys == null) {
                throw new IllegalArgumentException("Invalid filter key: " + key2);
            }
            return hTTPFilterKeys;
        }

        private final boolean matchesPath(String scenarioValue, String value2) {
            return StringsKt.contains$default((CharSequence)value2, "*", false, 2, null) && Pattern.compile(StringsKt.replace$default(value2, "*", ".*", false, 4, null)).matcher(scenarioValue).matches();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$DESCRIPTION;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class DESCRIPTION
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        DESCRIPTION() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            OperationMetadata operationMetadata = scenario.getOperationMetadata();
            return StringsKt.equals(operationMetadata != null ? operationMetadata.getDescription() : null, value2, true);
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$EXAMPLE_NAME;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    @SourceDebugExtension(value={"SMAP\nHTTPFilterKeys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$EXAMPLE_NAME\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1747#2,2:236\n1747#2,3:238\n1749#2:241\n*S KotlinDebug\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$EXAMPLE_NAME\n*L\n149#1:236,2\n150#1:238,3\n149#1:241\n*E\n"})
    static final class EXAMPLE_NAME
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        EXAMPLE_NAME() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter(scenario, "scenario");
                Intrinsics.checkNotNullParameter(key2, "key");
                Intrinsics.checkNotNullParameter(value2, "value");
                Iterable $this$any$iv = scenario.getExamples();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block6: {
                            Examples example = (Examples)element$iv;
                            boolean bl3 = false;
                            Iterable $this$any$iv2 = example.getRows();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    Row eachRow = (Row)element$iv2;
                                    boolean bl4 = false;
                                    if (!Intrinsics.areEqual(eachRow.getName(), value2)) continue;
                                    bl2 = true;
                                    break block6;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$METHOD;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class METHOD
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        METHOD() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            return StringsKt.equals(scenario.getMethod(), value2, true);
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            return StringsKt.equals(stub.getRequest().getMethod(), value2, true);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$OPERATION_ID;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class OPERATION_ID
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        OPERATION_ID() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            OperationMetadata operationMetadata = scenario.getOperationMetadata();
            return Intrinsics.areEqual(operationMetadata != null ? operationMetadata.getOperationId() : null, value2);
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_HEADER;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class PARAMETERS_HEADER
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        PARAMETERS_HEADER() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            return HTTPFilterKeysKt.caseInsensitiveContains((Iterable<String>)scenario.getHttpRequestPattern().getHeaderKeys(), value2);
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            return HTTPFilterKeysKt.caseInsensitiveContains((Iterable<String>)stub.getRequest().getHeaders().keySet(), value2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_HEADER_WITH_SPECIFIC_VALUE;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    @SourceDebugExtension(value={"SMAP\nHTTPFilterKeys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_HEADER_WITH_SPECIFIC_VALUE\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1747#2,2:236\n1747#2,3:238\n1749#2:241\n*S KotlinDebug\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_HEADER_WITH_SPECIFIC_VALUE\n*L\n45#1:236,2\n46#1:238,3\n45#1:241\n*E\n"})
    static final class PARAMETERS_HEADER_WITH_SPECIFIC_VALUE
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        PARAMETERS_HEADER_WITH_SPECIFIC_VALUE() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter(scenario, "scenario");
                Intrinsics.checkNotNullParameter(key2, "key");
                Intrinsics.checkNotNullParameter(value2, "value");
                String queryKey = StringsKt.substringBefore$default(StringsKt.substringAfter$default(key2, ((HTTPFilterKeys)this).getKey(), null, 2, null), "=", null, 2, null);
                String queryValue = StringsKt.substringAfter$default(value2, "=", null, 2, null);
                Iterable $this$any$iv = scenario.getExamples();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block6: {
                            Examples eachExample = (Examples)element$iv;
                            boolean bl3 = false;
                            Iterable $this$any$iv2 = eachExample.getRows();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    Row eachRow = (Row)element$iv2;
                                    boolean bl4 = false;
                                    if (!(eachRow.containsField(queryKey) && Intrinsics.areEqual(eachRow.getField(queryKey), queryValue))) continue;
                                    bl2 = true;
                                    break block6;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            String queryKey = StringsKt.substringBefore$default(StringsKt.substringAfter$default(key2, ((HTTPFilterKeys)this).getKey(), null, 2, null), "=", null, 2, null);
            String queryValue = StringsKt.substringAfter$default(value2, "=", null, 2, null);
            return Intrinsics.areEqual(stub.getRequest().getHeaders().get(queryKey), queryValue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_PATH;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    @SourceDebugExtension(value={"SMAP\nHTTPFilterKeys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_PATH\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1549#2:236\n1620#2,3:237\n*S KotlinDebug\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_PATH\n*L\n85#1:236\n85#1:237,3\n*E\n"})
    static final class PARAMETERS_PATH
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        PARAMETERS_PATH() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            Object object = scenario.getHttpRequestPattern().getHttpPathPattern();
            if (object != null && (object = ((HttpPathPattern)object).getPathSegmentPatterns()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    URLPathSegmentPattern uRLPathSegmentPattern = (URLPathSegmentPattern)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getKey());
                }
                bl = ((List)destination$iv$iv).contains(value2);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_PATH_WITH_SPECIFIC_VALUE;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    @SourceDebugExtension(value={"SMAP\nHTTPFilterKeys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_PATH_WITH_SPECIFIC_VALUE\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1747#2,2:236\n1747#2,3:238\n1749#2:241\n*S KotlinDebug\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_PATH_WITH_SPECIFIC_VALUE\n*L\n100#1:236,2\n101#1:238,3\n100#1:241\n*E\n"})
    static final class PARAMETERS_PATH_WITH_SPECIFIC_VALUE
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        PARAMETERS_PATH_WITH_SPECIFIC_VALUE() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter(scenario, "scenario");
                Intrinsics.checkNotNullParameter(key2, "key");
                Intrinsics.checkNotNullParameter(value2, "value");
                String pathKey = StringsKt.substringBefore$default(StringsKt.substringAfter$default(key2, ((HTTPFilterKeys)this).getKey(), null, 2, null), "=", null, 2, null);
                String pathValue = StringsKt.substringAfter$default(value2, "=", null, 2, null);
                Iterable $this$any$iv = scenario.getExamples();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block6: {
                            Examples eachExample = (Examples)element$iv;
                            boolean bl3 = false;
                            Iterable $this$any$iv2 = eachExample.getRows();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    Row eachRow = (Row)element$iv2;
                                    boolean bl4 = false;
                                    if (!(eachRow.containsField(pathKey) && Intrinsics.areEqual(eachRow.getField(pathKey), pathValue))) continue;
                                    bl2 = true;
                                    break block6;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_QUERY;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class PARAMETERS_QUERY
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        PARAMETERS_QUERY() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            return HTTPFilterKeysKt.caseSensitiveContains((Iterable<String>)scenario.getHttpRequestPattern().getQueryParamKeys(), value2);
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            return HTTPFilterKeysKt.caseSensitiveContains((Iterable<String>)stub.getRequest().getQueryParams().getKeys(), value2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_QUERY_WITH_SPECIFIC_VALUE;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    @SourceDebugExtension(value={"SMAP\nHTTPFilterKeys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_QUERY_WITH_SPECIFIC_VALUE\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1747#2,2:236\n1747#2,3:238\n1749#2:241\n1747#2,3:242\n*S KotlinDebug\n*F\n+ 1 HTTPFilterKeys.kt\nio/specmatic/core/filters/HTTPFilterKeys$PARAMETERS_QUERY_WITH_SPECIFIC_VALUE\n*L\n69#1:236,2\n70#1:238,3\n69#1:241\n78#1:242,3\n*E\n"})
    static final class PARAMETERS_QUERY_WITH_SPECIFIC_VALUE
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        PARAMETERS_QUERY_WITH_SPECIFIC_VALUE() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter(scenario, "scenario");
                Intrinsics.checkNotNullParameter(key2, "key");
                Intrinsics.checkNotNullParameter(value2, "value");
                String queryKey = StringsKt.substringBefore$default(StringsKt.substringAfter$default(key2, ((HTTPFilterKeys)this).getKey(), null, 2, null), "=", null, 2, null);
                String queryValue = StringsKt.substringAfter$default(value2, "=", null, 2, null);
                Iterable $this$any$iv = scenario.getExamples();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block6: {
                            Examples eachExample = (Examples)element$iv;
                            boolean bl3 = false;
                            Iterable $this$any$iv2 = eachExample.getRows();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    Row eachRow = (Row)element$iv2;
                                    boolean bl4 = false;
                                    if (!(eachRow.containsField(queryKey) && Intrinsics.areEqual(eachRow.getField(queryKey), queryValue))) continue;
                                    bl2 = true;
                                    break block6;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(stub, "stub");
                Intrinsics.checkNotNullParameter(key2, "key");
                Intrinsics.checkNotNullParameter(value2, "value");
                String queryKey = StringsKt.substringBefore$default(StringsKt.substringAfter$default(key2, ((HTTPFilterKeys)this).getKey(), null, 2, null), "=", null, 2, null);
                String queryValue = StringsKt.substringAfter$default(value2, "=", null, 2, null);
                Iterable $this$any$iv = stub.getRequest().getQueryParams().getParamPairs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual(it.getFirst(), queryKey) && Intrinsics.areEqual(it.getSecond(), queryValue))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$PATH;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class PATH
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        PATH() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            return Intrinsics.areEqual(value2, scenario.getRawPath()) || Companion.matchesPath(scenario.getRawPath(), value2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            if (Intrinsics.areEqual(value2, stub.getRequest().getPath())) return true;
            String string = stub.getRequest().getPath();
            if (string == null) {
                string = "";
            }
            if (!Companion.matchesPath(string, value2)) return false;
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$REQUEST_BODY_CONTENT_TYPE;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class REQUEST_BODY_CONTENT_TYPE
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        REQUEST_BODY_CONTENT_TYPE() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            try {
                bl = new MimeType(scenario.getHttpRequestPattern().getHeadersPattern().getContentType()).match(new MimeType(value2));
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            try {
                bl = new MimeType(stub.getRequest().getBody().getHttpContentType()).match(new MimeType(value2));
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$RESPONSE_CONTENT_TYPE;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class RESPONSE_CONTENT_TYPE
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        RESPONSE_CONTENT_TYPE() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            try {
                bl = new MimeType(scenario.getHttpResponsePattern().getHeadersPattern().getContentType()).match(new MimeType(value2));
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            try {
                bl = new MimeType(stub.getResponse().getBody().getHttpContentType()).match(new MimeType(value2));
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$STATUS;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class STATUS
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        STATUS() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            Integer n = StringsKt.toIntOrNull(value2);
            return n != null && scenario.getStatus() == n.intValue();
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            Integer n = StringsKt.toIntOrNull(value2);
            return n != null && stub.getResponse().getStatus() == n.intValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$SUMMARY;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class SUMMARY
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        SUMMARY() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            OperationMetadata operationMetadata = scenario.getOperationMetadata();
            return StringsKt.equals(operationMetadata != null ? operationMetadata.getSummary() : null, value2, true);
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lio/specmatic/core/filters/HTTPFilterKeys$TAGS;", "Lio/specmatic/core/filters/HTTPFilterKeys;", "includes", "", "scenario", "Lio/specmatic/core/Scenario;", "key", "", "value", "stub", "Lio/specmatic/mock/ScenarioStub;", "specmatic-core"})
    static final class TAGS
    extends HTTPFilterKeys {
        /*
         * WARNING - void declaration
         */
        TAGS() {
            void var1_1;
        }

        @Override
        public boolean includes(@NotNull Scenario scenario, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(scenario, "scenario");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            Object object = scenario.getOperationMetadata();
            return object != null && (object = ((OperationMetadata)object).getTags()) != null ? object.contains(value2) : false;
        }

        @Override
        public boolean includes(@NotNull ScenarioStub stub, @NotNull String key2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter(stub, "stub");
            Intrinsics.checkNotNullParameter(key2, "key");
            Intrinsics.checkNotNullParameter(value2, "value");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }
}

