/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.filters;

import io.specmatic.core.filters.Operator;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u0000 \r2\u00020\u0001:\u0007\r\u000e\u000f\u0010\u0011\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H&J\f\u0010\n\u001a\u00020\u000b*\u00020\u0003H\u0004J\f\u0010\f\u001a\u00020\u0003*\u00020\u0003H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lio/specmatic/core/filters/Operator;", "", "symbol", "", "(Ljava/lang/String;)V", "getSymbol", "()Ljava/lang/String;", "operate", "left", "right", "assertSingleValue", "", "splitToQuoteValues", "Companion", "EqualsOperator", "GreaterThanEqualsOperator", "GreaterThanOperator", "LessThanEqualsOperator", "LessThanOperator", "NotEqualsOperator", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nOperator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operator.kt\nio/specmatic/core/filters/Operator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1054#2:69\n*S KotlinDebug\n*F\n+ 1 Operator.kt\nio/specmatic/core/filters/Operator\n*L\n66#1:69\n*E\n"})
public abstract class Operator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String symbol;
    @NotNull
    private static final List<Operator> ALL;

    public Operator(@NotNull String symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        this.symbol = symbol;
    }

    @NotNull
    public final String getSymbol() {
        return this.symbol;
    }

    @NotNull
    public abstract String operate(@NotNull String var1, @NotNull String var2);

    protected final void assertSingleValue(@NotNull String $this$assertSingleValue) {
        Intrinsics.checkNotNullParameter($this$assertSingleValue, "<this>");
        if (StringsKt.contains$default((CharSequence)$this$assertSingleValue, ",", false, 2, null)) {
            throw new IllegalArgumentException("Operator '" + this.symbol + "' does not support multiple values. You specified '" + $this$assertSingleValue + "'");
        }
    }

    @NotNull
    protected final String splitToQuoteValues(@NotNull String $this$splitToQuoteValues) {
        Intrinsics.checkNotNullParameter($this$splitToQuoteValues, "<this>");
        char[] cArray = new char[]{','};
        return CollectionsKt.joinToString$default(StringsKt.split$default((CharSequence)$this$splitToQuoteValues, cArray, false, 0, 6, null), ", ", null, null, 0, null, splitToQuoteValues.1.INSTANCE, 30, null);
    }

    static {
        Operator[] operatorArray = new Operator[]{new NotEqualsOperator(), new GreaterThanEqualsOperator(), new LessThanEqualsOperator(), new EqualsOperator(), new GreaterThanOperator(), new LessThanOperator()};
        Iterable $this$sortedByDescending$iv = CollectionsKt.listOf(operatorArray);
        boolean $i$f$sortedByDescending = false;
        ALL = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                Operator it = (Operator)b2;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getSymbol().length());
                it = (Operator)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getSymbol().length());
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/specmatic/core/filters/Operator$Companion;", "", "()V", "ALL", "", "Lio/specmatic/core/filters/Operator;", "getALL", "()Ljava/util/List;", "specmatic-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Operator> getALL() {
            return ALL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lio/specmatic/core/filters/Operator$EqualsOperator;", "Lio/specmatic/core/filters/Operator;", "()V", "operate", "", "left", "right", "specmatic-core"})
    private static final class EqualsOperator
    extends Operator {
        public EqualsOperator() {
            super("=");
        }

        @Override
        @NotNull
        public String operate(@NotNull String left, @NotNull String right) {
            Intrinsics.checkNotNullParameter(left, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            String rightValues = this.splitToQuoteValues(right);
            return "includes('" + left + "', " + rightValues + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lio/specmatic/core/filters/Operator$GreaterThanEqualsOperator;", "Lio/specmatic/core/filters/Operator;", "()V", "operate", "", "left", "right", "specmatic-core"})
    private static final class GreaterThanEqualsOperator
    extends Operator {
        public GreaterThanEqualsOperator() {
            super(">=");
        }

        @Override
        @NotNull
        public String operate(@NotNull String left, @NotNull String right) {
            Intrinsics.checkNotNullParameter(left, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            this.assertSingleValue(right);
            return "eFunc('" + left + "', '" + this.getSymbol() + "', '" + right + "')";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lio/specmatic/core/filters/Operator$GreaterThanOperator;", "Lio/specmatic/core/filters/Operator;", "()V", "operate", "", "left", "right", "specmatic-core"})
    private static final class GreaterThanOperator
    extends Operator {
        public GreaterThanOperator() {
            super(">");
        }

        @Override
        @NotNull
        public String operate(@NotNull String left, @NotNull String right) {
            Intrinsics.checkNotNullParameter(left, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            this.assertSingleValue(right);
            return "eFunc('" + left + "', '" + this.getSymbol() + "', '" + right + "')";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lio/specmatic/core/filters/Operator$LessThanEqualsOperator;", "Lio/specmatic/core/filters/Operator;", "()V", "operate", "", "left", "right", "specmatic-core"})
    private static final class LessThanEqualsOperator
    extends Operator {
        public LessThanEqualsOperator() {
            super("<=");
        }

        @Override
        @NotNull
        public String operate(@NotNull String left, @NotNull String right) {
            Intrinsics.checkNotNullParameter(left, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            this.assertSingleValue(right);
            return "eFunc('" + left + "', '" + this.getSymbol() + "', '" + right + "')";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lio/specmatic/core/filters/Operator$LessThanOperator;", "Lio/specmatic/core/filters/Operator;", "()V", "operate", "", "left", "right", "specmatic-core"})
    private static final class LessThanOperator
    extends Operator {
        public LessThanOperator() {
            super("<");
        }

        @Override
        @NotNull
        public String operate(@NotNull String left, @NotNull String right) {
            Intrinsics.checkNotNullParameter(left, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            this.assertSingleValue(right);
            return "eFunc('" + left + "', '" + this.getSymbol() + "', '" + right + "')";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lio/specmatic/core/filters/Operator$NotEqualsOperator;", "Lio/specmatic/core/filters/Operator;", "()V", "operate", "", "left", "right", "specmatic-core"})
    private static final class NotEqualsOperator
    extends Operator {
        public NotEqualsOperator() {
            super("!=");
        }

        @Override
        @NotNull
        public String operate(@NotNull String left, @NotNull String right) {
            Intrinsics.checkNotNullParameter(left, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            String rightValues = this.splitToQuoteValues(right);
            return "!includes('" + left + "', " + rightValues + ")";
        }
    }
}

