/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.git;

import io.specmatic.core.Configuration;
import io.specmatic.core.azure.AuthCredentials;
import io.specmatic.core.azure.NoGitAuthCredentials;
import io.specmatic.core.git.GitCommand;
import io.specmatic.core.git.GitOperations;
import io.specmatic.core.git.NonZeroExitError;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.utilities.ExternalCommand;
import io.specmatic.core.utilities.Utilities;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0000H\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J!\u0010\u001b\u001a\u00020\u00032\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001d\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001b\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0002J+\u0010 \u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0002\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u00020\u00032\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001d\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0003H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010+\u001a\u00020\u0003J\b\u0010,\u001a\u00020\u0003H\u0016J\u0006\u0010-\u001a\u00020\u0003J\"\u0010.\u001a\u0004\u0018\u00010\u00162\u0006\u0010/\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0016J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u00100\u001a\u00020\u0003H\u0016J\b\u00102\u001a\u00020\u0003H\u0016J\u0010\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0016J\b\u00105\u001a\u000206H\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\b\u00108\u001a\u00020\u0003H\u0016J\u0010\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u0003H\u0016J\u0006\u0010;\u001a\u00020\u0000J\u0010\u0010<\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010=\u001a\u00020\u0000H\u0016J\b\u0010>\u001a\u00020\u0000H\u0016J\b\u0010?\u001a\u00020\u0000H\u0016J\u001c\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00030A2\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0010\u0010B\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010C\u001a\u00020\u0000H\u0016J\b\u0010D\u001a\u00020\u0000H\u0016J\b\u0010E\u001a\u000206H\u0016J\u0018\u0010F\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010G\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010H\u001a\u00020$H\u0016J\b\u0010I\u001a\u00020\u0000H\u0016J\b\u0010J\u001a\u00020\u0003H\u0016J\b\u0010K\u001a\u00020$H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006L"}, d2={"Lio/specmatic/core/git/SystemGit;", "Lio/specmatic/core/git/GitCommand;", "workingDirectory", "", "prefix", "authCredentials", "Lio/specmatic/core/azure/AuthCredentials;", "(Ljava/lang/String;Ljava/lang/String;Lio/specmatic/core/azure/AuthCredentials;)V", "getAuthCredentials", "()Lio/specmatic/core/azure/AuthCredentials;", "getWorkingDirectory", "()Ljava/lang/String;", "add", "relativePath", "checkIgnore", "path", "checkout", "branchName", "checkoutWithCreate", "clone", "gitRepositoryURI", "cloneDirectory", "Ljava/io/File;", "commit", "currentBranch", "currentRemoteBranch", "detachedHEAD", "execute", "command", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "executeCommandWithWorkingDirectory", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "executeWithAuth", "exists", "", "treeish", "fetch", "fileIsInGitDir", "newerContractPath", "getChangedFiles", "getChangesFromMainBranch", "mainBranch", "getCurrentBranch", "getCurrentBranchForMatchBranch", "getFileInBranch", "fileName", "baseBranch", "getFilesChangedInCurrentBranch", "getOriginDefaultBranchName", "getRemoteUrl", "name", "getStashListSize", "", "getUntrackedFiles", "gitRoot", "inGitRootOf", "contractPath", "init", "merge", "mergeAbort", "pull", "push", "relativeGitPath", "Lkotlin/Pair;", "remoteBranchExists", "resetHard", "resetMixed", "revisionsBehindCount", "shallowClone", "show", "stash", "stashPop", "statusPorcelain", "workingDirectoryIsGitRepo", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nSystemGit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemGit.kt\nio/specmatic/core/git/SystemGit\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n37#2,2:284\n37#2,2:286\n1#3:288\n1549#4:289\n1620#4,3:290\n766#4:293\n857#4,2:294\n1549#4:296\n1620#4,3:297\n1549#4:300\n1620#4,3:301\n1747#4,3:304\n1549#4:307\n1620#4,3:308\n819#4:311\n847#4,2:312\n766#4:314\n857#4,2:315\n1549#4:317\n1620#4,3:318\n*S KotlinDebug\n*F\n+ 1 SystemGit.kt\nio/specmatic/core/git/SystemGit\n*L\n23#1:284,2\n26#1:286,2\n102#1:289\n102#1:290,3\n104#1:293\n104#1:294,2\n104#1:296\n104#1:297,3\n149#1:300\n149#1:301,3\n206#1:304,3\n217#1:307\n217#1:308,3\n217#1:311\n217#1:312,2\n270#1:314\n270#1:315,2\n271#1:317\n271#1:318,3\n*E\n"})
public final class SystemGit
implements GitCommand {
    @NotNull
    private final String workingDirectory;
    @NotNull
    private final String prefix;
    @NotNull
    private final AuthCredentials authCredentials;

    public SystemGit(@NotNull String workingDirectory, @NotNull String prefix2, @NotNull AuthCredentials authCredentials) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(prefix2, "prefix");
        Intrinsics.checkNotNullParameter(authCredentials, "authCredentials");
        this.workingDirectory = workingDirectory;
        this.prefix = prefix2;
        this.authCredentials = authCredentials;
    }

    public /* synthetic */ SystemGit(String string, String string2, AuthCredentials authCredentials, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".";
        }
        if ((n & 2) != 0) {
            string2 = "- ";
        }
        if ((n & 4) != 0) {
            authCredentials = NoGitAuthCredentials.INSTANCE;
        }
        this(string, string2, authCredentials);
    }

    @Override
    @NotNull
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @NotNull
    public final AuthCredentials getAuthCredentials() {
        return this.authCredentials;
    }

    private final String executeWithAuth(String ... command2) {
        List<String> gitExecutable = CollectionsKt.listOf(Configuration.Companion.getGitCommand());
        List<String> auth = this.authCredentials.gitCommandAuthHeaders();
        return this.execute(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)gitExecutable, (Iterable)auth), (Iterable)ArraysKt.toList(command2)));
    }

    private final String execute(List<String> command2) {
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)command2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.executeCommandWithWorkingDirectory(this.prefix, this.getWorkingDirectory(), thisCollection$iv.toArray(new String[0]));
    }

    private final String execute(String ... command2) {
        Collection $this$toTypedArray$iv = ArraysKt.toList(command2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.executeCommandWithWorkingDirectory(this.prefix, this.getWorkingDirectory(), thisCollection$iv.toArray(new String[0]));
    }

    private final String executeCommandWithWorkingDirectory(String prefix2, String workingDirectory, String[] command2) {
        LoggingKt.getLogger().debug(prefix2 + "Executing: " + ArraysKt.joinToString$default(command2, (CharSequence)" ", null, null, 0, null, null, 62, null));
        return new ExternalCommand(command2, workingDirectory, MapsKt.mapOf(TuplesKt.to("GIT_SSL_NO_VERIFY", "true"))).executeAsSeparateProcess();
    }

    @NotNull
    public final SystemGit init() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "init"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit add() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "add", "."};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit add(@NotNull String relativePath) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "add", relativePath};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit commit() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "commit", "-m", "Updated contract"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit push() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "push"};
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit pull() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "pull"};
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit resetHard() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "reset", "--hard", "HEAD"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit resetMixed() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "reset", "--mixed", "HEAD"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit mergeAbort() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "merge", "--aborg"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit checkout(@NotNull String branchName) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter(branchName, "branchName");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "checkout", branchName};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit checkoutWithCreate(@NotNull String branchName) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter(branchName, "branchName");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "checkout", "-B", branchName};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit merge(@NotNull String branchName) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter(branchName, "branchName");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "merge", branchName};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit clone(@NotNull String gitRepositoryURI, @NotNull File cloneDirectory) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter(gitRepositoryURI, "gitRepositoryURI");
        Intrinsics.checkNotNullParameter(cloneDirectory, "cloneDirectory");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[3];
        stringArray[0] = "clone";
        Map<String, String> map2 = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map2, "getenv(...)");
        stringArray[1] = GitOperations.evaluateEnvVariablesInGitRepoURI(gitRepositoryURI, map2);
        Intrinsics.checkNotNullExpressionValue(cloneDirectory.getAbsolutePath(), "getAbsolutePath(...)");
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    public boolean exists(@NotNull String treeish, @NotNull String relativePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter(treeish, "treeish");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        try {
            this.show(treeish, relativePath);
            bl = true;
        }
        catch (NonZeroExitError e2) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean stash() {
        int stashListSizeBefore = this.getStashListSize();
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "stash", "push", "-m", "tmp"};
        this.execute(stringArray);
        return this.getStashListSize() > stashListSizeBefore;
    }

    @Override
    @NotNull
    public SystemGit stashPop() {
        SystemGit systemGit;
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "stash", "pop"};
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public String getCurrentBranch() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "git", "diff", "--name-only", "master"};
        return this.execute(stringArray);
    }

    @Override
    @NotNull
    public String statusPorcelain() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "status", "--porcelain"};
        return this.execute(stringArray);
    }

    @Override
    @NotNull
    public String fetch() {
        String[] stringArray = new String[]{"fetch"};
        return this.executeWithAuth(stringArray);
    }

    @Override
    public int revisionsBehindCount() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-list", "--count", "HEAD..@{u}"};
        return Integer.parseInt(((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString());
    }

    @Override
    @NotNull
    public String checkIgnore(@NotNull String path2) {
        Object object;
        Intrinsics.checkNotNullParameter(path2, "path");
        try {
            object = new String[]{Configuration.Companion.getGitCommand(), "check-ignore", path2};
            object = this.execute((String)object);
        }
        catch (NonZeroExitError nonZeroExitError) {
            object = "";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getFilesChangedInCurrentBranch(@NotNull String baseBranch) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(baseBranch, "baseBranch");
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "diff", baseBranch, "HEAD", "--name-status"};
        List<String> committedLocalChanges = StringsKt.lines(((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString());
        String[] stringArray2 = new String[]{Configuration.Companion.getGitCommand(), "diff", "HEAD", "--name-status"};
        List<String> uncommittedChanges = StringsKt.lines(((Object)StringsKt.trim((CharSequence)this.execute(stringArray2))).toString());
        Iterable $this$map$iv = CollectionsKt.plus((Collection)committedLocalChanges, (Iterable)uncommittedChanges);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray3 = new String[]{"\t"};
            collection.add((String)CollectionsKt.last(StringsKt.split$default((CharSequence)it, stringArray3, false, 0, 6, null)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Path path2 = Paths.get(this.getWorkingDirectory() + File.separator + it, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            collection.add(((Object)path2.toAbsolutePath()).toString());
        }
        return CollectionsKt.distinct((List)destination$iv$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public File getFileInBranch(@NotNull String fileName, @NotNull String currentBranch, @NotNull String baseBranch) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(currentBranch, "currentBranch");
        Intrinsics.checkNotNullParameter(baseBranch, "baseBranch");
        try {
            if (!Intrinsics.areEqual(baseBranch, currentBranch)) {
                this.checkout(baseBranch);
            }
            if (!new File(fileName).exists()) {
                File file2 = null;
                return file2;
            }
            File file3 = new File(fileName);
            return file3;
        }
        finally {
            this.checkout(currentBranch);
        }
    }

    @Override
    @NotNull
    public SystemGit shallowClone(@NotNull String gitRepositoryURI, @NotNull File cloneDirectory) {
        SystemGit systemGit;
        Intrinsics.checkNotNullParameter(gitRepositoryURI, "gitRepositoryURI");
        Intrinsics.checkNotNullParameter(cloneDirectory, "cloneDirectory");
        SystemGit it = systemGit = this;
        boolean bl = false;
        String[] stringArray = new String[5];
        stringArray[0] = "clone";
        stringArray[1] = "--depth";
        stringArray[2] = "1";
        stringArray[3] = gitRepositoryURI;
        Intrinsics.checkNotNullExpressionValue(cloneDirectory.getAbsolutePath(), "getAbsolutePath(...)");
        this.executeWithAuth(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public String gitRoot() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-parse", "--show-toplevel"};
        return ((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString();
    }

    @Override
    @NotNull
    public String show(@NotNull String treeish, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter(treeish, "treeish");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "show", treeish + ":" + relativePath};
        return this.execute(stringArray);
    }

    @Override
    public boolean workingDirectoryIsGitRepo() {
        boolean bl;
        try {
            String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-parse", "--is-inside-work-tree"};
            bl = Intrinsics.areEqual(((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString(), "true");
        }
        catch (Throwable e2) {
            boolean bl2;
            boolean it = bl2 = false;
            boolean bl3 = false;
            LoggingKt.getLogger().debug("This must not be a git dir, got error " + e2.getClass().getName() + ": " + Utilities.exceptionCauseMessage(e2));
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getChangedFiles() {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "status", "--porcelain=1"};
        String result2 = ((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString();
        if (((CharSequence)result2).length() == 0) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = StringsKt.lines(result2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{" "};
            collection.add((String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString(), stringArray2, false, 2, 2, null).get(1));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Pair<SystemGit, String> relativeGitPath(@NotNull String newerContractPath) {
        Intrinsics.checkNotNullParameter(newerContractPath, "newerContractPath");
        String string = new File(newerContractPath).getAbsoluteFile().getParent();
        Intrinsics.checkNotNullExpressionValue(string, "getParent(...)");
        File gitRoot = new File(new SystemGit(string, null, null, 6, null).gitRoot());
        String string2 = gitRoot.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string2, "getAbsolutePath(...)");
        SystemGit git = new SystemGit(string2, null, null, 6, null);
        File file2 = new File(newerContractPath).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue(file2, "getAbsoluteFile(...)");
        File file3 = gitRoot.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue(file3, "getAbsoluteFile(...)");
        String relativeContractPath = FilesKt.relativeTo(file2, file3).getPath();
        return new Pair<SystemGit, String>(git, relativeContractPath);
    }

    @Override
    public boolean fileIsInGitDir(@NotNull String newerContractPath) {
        Intrinsics.checkNotNullParameter(newerContractPath, "newerContractPath");
        String parentDir = new File(newerContractPath).getAbsoluteFile().getParentFile().getAbsolutePath();
        Intrinsics.checkNotNull(parentDir);
        return new SystemGit(parentDir, null, null, 6, null).workingDirectoryIsGitRepo();
    }

    @Override
    @NotNull
    public GitCommand inGitRootOf(@NotNull String contractPath) {
        Intrinsics.checkNotNullParameter(contractPath, "contractPath");
        String string = new File(contractPath).getParentFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        return new SystemGit(string, null, null, 6, null);
    }

    @NotNull
    public final List<String> getChangesFromMainBranch(@NotNull String mainBranch) {
        Intrinsics.checkNotNullParameter(mainBranch, "mainBranch");
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "diff", "--name-only", mainBranch};
        CharSequence charSequence = this.execute(stringArray);
        stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue(System.lineSeparator(), "lineSeparator(...)");
        return StringsKt.split$default(charSequence, stringArray, false, 0, 6, null);
    }

    @Override
    @NotNull
    public String getRemoteUrl(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "remote", "get-url", name};
        return this.execute(stringArray);
    }

    @Override
    @NotNull
    public String currentBranch() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-parse", "--abbrev-ref", "HEAD"};
        return ((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString();
    }

    @NotNull
    public final String getCurrentBranchForMatchBranch() {
        String githubHeadRef = System.getenv("GITHUB_HEAD_REF");
        CharSequence charSequence = githubHeadRef;
        if (!(charSequence == null || StringsKt.isBlank(charSequence))) {
            LoggingKt.getLogger().debug("Using GITHUB_HEAD_REF: " + githubHeadRef);
            Intrinsics.checkNotNull(githubHeadRef);
            return githubHeadRef;
        }
        String githubRefName = System.getenv("GITHUB_REF_NAME");
        CharSequence charSequence2 = githubRefName;
        if (!(charSequence2 == null || StringsKt.isBlank(charSequence2))) {
            LoggingKt.getLogger().debug("Using GITHUB_REF_NAME: " + githubRefName);
            Intrinsics.checkNotNull(githubRefName);
            return githubRefName;
        }
        return this.currentBranch();
    }

    @Override
    public boolean remoteBranchExists(@NotNull String branchName) {
        boolean bl;
        Intrinsics.checkNotNullParameter(branchName, "branchName");
        try {
            String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-parse", "--verify", "origin/" + branchName};
            this.execute(stringArray);
            bl = true;
        }
        catch (NonZeroExitError e2) {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public String currentRemoteBranch() {
        boolean hasUpstream;
        block4: {
            String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "status", "-b", "--porcelain=2"};
            String branchStatus = ((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString();
            Iterable $this$any$iv = StringsKt.lines(branchStatus);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default(it, "# branch.upstream", false, 2, null)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = hasUpstream = false;
            }
        }
        if (hasUpstream) {
            String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "rev-parse", "--abbrev-ref", "--symbolic-full-name", "@{u}"};
            return ((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString();
        }
        return this.currentBranch();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getOriginDefaultBranchName() {
        void $this$filterNotTo$iv$iv;
        String p0;
        Iterable $this$mapTo$iv$iv;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "symbolic-ref", "refs/remotes/origin/HEAD", "--short"};
        String defaultBranchRef = this.execute(stringArray);
        String[] stringArray2 = new String[]{"/"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)defaultBranchRef, stringArray2, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)p0)).toString());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            p0 = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)p0).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parts = (List)destination$iv$iv;
        if (parts.size() < 2) {
            throw new ContractException("Could not parse symbolic-ref value '" + defaultBranchRef + "'. Expected format: 'origin/branch'", null, null, null, false, 30, null);
        }
        return (String)parts.get(1);
    }

    private final int getStashListSize() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "stash", "list"};
        return StringsKt.lines(((Object)StringsKt.trim((CharSequence)this.execute(stringArray))).toString()).size();
    }

    @Override
    @NotNull
    public String detachedHEAD() {
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "show", "-s", "--pretty=%D", "HEAD"};
        String result2 = this.execute(stringArray);
        stringArray = new String[]{","};
        return ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)result2)).toString(), stringArray, false, 0, 6, null).get(1)))).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getUntrackedFiles() {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        String[] stringArray = new String[]{Configuration.Companion.getGitCommand(), "ls-files", "--others", "--exclude-standard"};
        String result2 = this.execute(stringArray);
        Iterable $this$filter$iv = StringsKt.lines(((Object)StringsKt.trim((CharSequence)result2)).toString());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path2 = Paths.get(this.getWorkingDirectory() + File.separator + it, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            collection.add(((Object)path2.toAbsolutePath()).toString());
        }
        return (List)destination$iv$iv;
    }

    public SystemGit() {
        this(null, null, null, 7, null);
    }
}

