/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.log;

import io.specmatic.core.log.CurrentDate;
import io.specmatic.core.log.LogFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lio/specmatic/core/log/LogDirectory;", "Lio/specmatic/core/log/LogFile;", "directory", "", "prefix", "suffix", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Ljava/io/File;", "name", "(Ljava/io/File;Ljava/lang/String;)V", "file", "getFile", "()Ljava/io/File;", "appendText", "", "text", "Companion", "specmatic-core"})
public final class LogDirectory
implements LogFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;

    public LogDirectory(@NotNull File directory, @NotNull String name) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(name, "name");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.file = FilesKt.resolve(directory, name);
        if (!this.file.exists()) {
            this.file.createNewFile();
            System.out.println((Object)("Logging to file " + this.file.getCanonicalFile()));
        }
    }

    public LogDirectory(@NotNull String directory, @NotNull String prefix2, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(prefix2, "prefix");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        this(new File(directory), LogDirectory.Companion.getLogFileName(prefix2, suffix));
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Override
    public void appendText(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        FilesKt.appendText$default(this.file, text, null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"Lio/specmatic/core/log/LogDirectory$Companion;", "", "()V", "getLogFileName", "", "prefix", "suffix", "specmatic-core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getLogFileName(String prefix2, String suffix) {
            String dateComponent = new CurrentDate(null, 1, null).toFileNameString();
            return prefix2 + "-" + dateComponent + suffix;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

