/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.log;

import io.specmatic.core.log.CompositePrinter;
import io.specmatic.core.log.LogMessage;
import io.specmatic.core.log.LogPrinter;
import io.specmatic.core.log.LogStrategy;
import io.specmatic.core.log.NewLineLogMessage;
import io.specmatic.core.log.NonVerboseExceptionLog;
import io.specmatic.core.log.ReadyMessage;
import io.specmatic.core.log.StringLog;
import io.specmatic.core.log.UsesBoundaryImpl;
import io.specmatic.core.log.UsesBoundaryWithHelpers;
import io.specmatic.core.log.UsesIndentationImpl;
import io.specmatic.core.log.UsesIndentationWithHelpers;
import io.specmatic.core.utilities.Utilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0016J\u001a\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u001a\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\u001a\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0016J\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010!\u001a\u00020\u0007H\u0096\u0001J*\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H#0'H\u0096\u0001\u00a2\u0006\u0002\u0010(R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/specmatic/core/log/NonVerbose;", "Lio/specmatic/core/log/LogStrategy;", "Lio/specmatic/core/log/UsesIndentationWithHelpers;", "Lio/specmatic/core/log/UsesBoundaryWithHelpers;", "printer", "Lio/specmatic/core/log/CompositePrinter;", "infoLoggingEnabled", "", "(Lio/specmatic/core/log/CompositePrinter;Z)V", "getInfoLoggingEnabled", "()Z", "setInfoLoggingEnabled", "(Z)V", "getPrinter", "()Lio/specmatic/core/log/CompositePrinter;", "readyMessage", "Lio/specmatic/core/log/ReadyMessage;", "boundary", "", "currentIndentation", "", "debug", "msg", "Lio/specmatic/core/log/LogMessage;", "e", "", "exceptionString", "keepReady", "log", "logError", "newLine", "ofTheException", "print", "removeBoundary", "withIndentation", "T", "count", "", "block", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "specmatic-core"})
public final class NonVerbose
implements LogStrategy,
UsesIndentationWithHelpers,
UsesBoundaryWithHelpers {
    @NotNull
    private final CompositePrinter printer;
    private boolean infoLoggingEnabled;
    private final /* synthetic */ UsesIndentationImpl $$delegate_0;
    private final /* synthetic */ UsesBoundaryImpl $$delegate_1;
    @NotNull
    private final ReadyMessage readyMessage;

    public NonVerbose(@NotNull CompositePrinter printer, boolean infoLoggingEnabled) {
        Intrinsics.checkNotNullParameter(printer, "printer");
        this.printer = printer;
        this.infoLoggingEnabled = infoLoggingEnabled;
        this.$$delegate_0 = new UsesIndentationImpl(0, 1, null);
        this.$$delegate_1 = new UsesBoundaryImpl();
        this.readyMessage = new ReadyMessage(null, 1, null);
    }

    public /* synthetic */ NonVerbose(CompositePrinter compositePrinter, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(compositePrinter, bl);
    }

    @Override
    @NotNull
    public CompositePrinter getPrinter() {
        return this.printer;
    }

    @Override
    public boolean getInfoLoggingEnabled() {
        return this.infoLoggingEnabled;
    }

    @Override
    public void setInfoLoggingEnabled(boolean bl) {
        this.infoLoggingEnabled = bl;
    }

    @Override
    @NotNull
    public String currentIndentation() {
        return this.$$delegate_0.currentIndentation();
    }

    @Override
    public <T> T withIndentation(int count2, @NotNull Function0<? extends T> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        return this.$$delegate_0.withIndentation(count2, block2);
    }

    @Override
    public void boundary() {
        this.$$delegate_1.boundary();
    }

    @Override
    public boolean removeBoundary() {
        return this.$$delegate_1.removeBoundary();
    }

    @Override
    public void keepReady(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.readyMessage.setMsg(msg);
    }

    public final void print(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        boolean hadBoundary = this.removeBoundary();
        if (hadBoundary) {
            LogPrinter.print$default(this.getPrinter(), NewLineLogMessage.INSTANCE, null, 2, null);
        }
        this.readyMessage.printLogString(this.getPrinter(), this.currentIndentation());
        this.getPrinter().print(msg, this.currentIndentation());
    }

    @Override
    @NotNull
    public String exceptionString(@NotNull Throwable e2, @Nullable String msg) {
        Intrinsics.checkNotNullParameter(e2, "e");
        return msg == null ? Utilities.exceptionCauseMessage(e2) : msg + ": " + Utilities.exceptionCauseMessage(e2);
    }

    @Override
    @NotNull
    public LogMessage ofTheException(@NotNull Throwable e2, @Nullable String msg) {
        Intrinsics.checkNotNullParameter(e2, "e");
        return new NonVerboseExceptionLog(e2, msg);
    }

    @Override
    public void log(@NotNull Throwable e2, @Nullable String msg) {
        Intrinsics.checkNotNullParameter(e2, "e");
        this.print(new NonVerboseExceptionLog(e2, msg));
    }

    @Override
    public void log(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.getInfoLoggingEnabled()) {
            this.log(new StringLog(msg));
        }
    }

    @Override
    public void log(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.getInfoLoggingEnabled()) {
            this.print(msg);
        }
    }

    @Override
    public void logError(@NotNull Throwable e2) {
        Intrinsics.checkNotNullParameter(e2, "e");
        this.log(e2, "ERROR");
    }

    @Override
    public void newLine() {
        this.print(NewLineLogMessage.INSTANCE);
    }

    @Override
    @NotNull
    public String debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        return msg;
    }

    @Override
    public void debug(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
    }

    @Override
    public void debug(@NotNull Throwable e2, @Nullable String msg) {
        Intrinsics.checkNotNullParameter(e2, "e");
    }
}

