/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.pattern;

import io.specmatic.core.MismatchMessages;
import io.specmatic.core.Resolver;
import io.specmatic.core.Result;
import io.specmatic.core.pattern.CsvPattern;
import io.specmatic.core.pattern.HasValue;
import io.specmatic.core.pattern.PairOfTypes;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.ReturnValue;
import io.specmatic.core.pattern.Row;
import io.specmatic.core.pattern.StringPattern;
import io.specmatic.core.pattern.config.NegativePatternConfiguration;
import io.specmatic.core.utilities.Utilities;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J2\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001e\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001a\u0010\u001c\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J,\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J$\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010(\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006)"}, d2={"Lio/specmatic/core/pattern/CsvPattern;", "Lio/specmatic/core/pattern/Pattern;", "pattern", "(Lio/specmatic/core/pattern/Pattern;)V", "getPattern", "()Lio/specmatic/core/pattern/Pattern;", "typeAlias", "", "getTypeAlias", "()Ljava/lang/String;", "typeName", "getTypeName", "encompasses", "Lio/specmatic/core/Result;", "otherPattern", "thisResolver", "Lio/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lio/specmatic/core/pattern/PairOfTypes;", "Lio/specmatic/core/pattern/TypeStack;", "generate", "Lio/specmatic/core/value/Value;", "resolver", "listOf", "valueList", "", "matches", "sampleData", "negativeBasedOn", "Lkotlin/sequences/Sequence;", "Lio/specmatic/core/pattern/ReturnValue;", "row", "Lio/specmatic/core/pattern/Row;", "config", "Lio/specmatic/core/pattern/config/NegativePatternConfiguration;", "newBasedOn", "parse", "value", "toString", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nCsvPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CsvPattern.kt\nio/specmatic/core/pattern/CsvPattern\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1559#2:76\n1590#2,4:77\n1549#2:81\n1620#2,3:82\n*S KotlinDebug\n*F\n+ 1 CsvPattern.kt\nio/specmatic/core/pattern/CsvPattern\n*L\n16#1:76\n16#1:77,4\n31#1:81\n31#1:82,3\n*E\n"})
public final class CsvPattern
implements Pattern {
    @NotNull
    private final Pattern pattern;

    public CsvPattern(@NotNull Pattern pattern2) {
        Intrinsics.checkNotNullParameter(pattern2, "pattern");
        this.pattern = pattern2;
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        if (!(sampleData instanceof StringValue)) {
            return MismatchMessages.valueMismatchFailure$default(resolver.getMismatchMessages(), "CSV string", sampleData, null, 4, null);
        }
        String[] stringArray = new String[]{","};
        Iterable $this$mapIndexed$iv = StringsKt.split$default((CharSequence)((StringValue)sampleData).getString(), stringArray, false, 0, 6, null);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Result result2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                void value2;
                this.getPattern().parse((String)value2, resolver);
                result2 = new Result.Success(null, null, 3, null);
            }
            catch (Throwable e2) {
                void index;
                result2 = new Result.Failure("Element " + (int)index + " did not match the type " + this.getPattern().getTypeName() + ". " + Utilities.exceptionCauseMessage(e2), null, null, null, null, 30, null);
            }
            collection.add(result2);
        }
        List results2 = (List)destination$iv$iv;
        return Result.Companion.fromResults(results2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        int max2 = RangesKt.random(new IntRange(2, 5), (Random)Random.Default);
        Iterable $this$map$iv = new IntRange(1, max2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Value)resolver.withCyclePrevention(this.getPattern(), (Function1)new Function1<Resolver, Value>((Object)this.getPattern()){

                public final Value invoke(Resolver p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((Pattern)this.receiver).generate(p0);
                }
            }));
        }
        String string = CollectionsKt.joinToString$default((List)destination$iv$iv, ",", null, null, 0, null, generate.2.INSTANCE, 30, null);
        return new StringValue(string);
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(row, "row");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        HasValue[] hasValueArray = new HasValue[]{new HasValue(this, null, 2, null)};
        return SequencesKt.sequenceOf(hasValueArray);
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver, @NotNull NegativePatternConfiguration config2) {
        Intrinsics.checkNotNullParameter(row, "row");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Intrinsics.checkNotNullParameter(config2, "config");
        return Pattern.negativeBasedOn$default(new StringPattern(null, null, null, null, null, false, false, 127, null), row, resolver, null, 4, null);
    }

    @Override
    @NotNull
    public Sequence<Pattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        CsvPattern[] csvPatternArray = new CsvPattern[]{this};
        return SequencesKt.sequenceOf(csvPatternArray);
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return new StringValue(value2);
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter(otherPattern, "otherPattern");
        Intrinsics.checkNotNullParameter(thisResolver, "thisResolver");
        Intrinsics.checkNotNullParameter(otherResolver, "otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, "typeStack");
        if (!(otherPattern instanceof CsvPattern)) {
            return new Result.Failure(thisResolver.getMismatchMessages().mismatchMessage(this.getTypeName(), otherPattern.getTypeName()), null, null, null, null, 30, null);
        }
        return this.getPattern().encompasses(((CsvPattern)otherPattern).getPattern(), thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, "valueList");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return new JSONArrayValue(valueList);
    }

    @NotNull
    public String toString() {
        return this.getTypeName();
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return null;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return "(csv/" + this.getPattern().getTypeName() + ")";
    }
}

