/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.pattern;

import io.specmatic.core.DefaultMismatchMessages;
import io.specmatic.core.MismatchMessages;
import io.specmatic.core.log.LogStrategy;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.pattern.AnyPattern;
import io.specmatic.core.pattern.AnyPatternKt;
import io.specmatic.core.pattern.AnyValuePattern;
import io.specmatic.core.pattern.AnythingPattern;
import io.specmatic.core.pattern.BooleanPattern;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.CsvPattern;
import io.specmatic.core.pattern.DatePattern;
import io.specmatic.core.pattern.DateTimePattern;
import io.specmatic.core.pattern.DeferredPattern;
import io.specmatic.core.pattern.DictionaryPattern;
import io.specmatic.core.pattern.EmailPattern;
import io.specmatic.core.pattern.EmptyStringPattern;
import io.specmatic.core.pattern.ExactValuePattern;
import io.specmatic.core.pattern.JSONArrayPattern;
import io.specmatic.core.pattern.JSONObjectPatternKt;
import io.specmatic.core.pattern.ListPattern;
import io.specmatic.core.pattern.LookupRowPattern;
import io.specmatic.core.pattern.NullPattern;
import io.specmatic.core.pattern.NullPatternKt;
import io.specmatic.core.pattern.NumberPattern;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.PatternInStringPattern;
import io.specmatic.core.pattern.RestPattern;
import io.specmatic.core.pattern.RestPatternKt;
import io.specmatic.core.pattern.StringPattern;
import io.specmatic.core.pattern.TimePattern;
import io.specmatic.core.pattern.URLPattern;
import io.specmatic.core.pattern.URLScheme;
import io.specmatic.core.pattern.UUIDPattern;
import io.specmatic.core.pattern.XMLPattern;
import io.specmatic.core.utilities.JSONSerialisationKt;
import io.specmatic.core.utilities.YAMLSerialisationKt;
import io.specmatic.core.value.BooleanValue;
import io.specmatic.core.value.EmptyStringKt;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.JSONComposite;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.NullValue;
import io.specmatic.core.value.NumberValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import io.specmatic.core.value.XMLNodeKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\u001a,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a&\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00052\u0006\u0010\u0015\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0014\u001a\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0001\u001a\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0010\u0010 \u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014\u001a\u0010\u0010!\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014\u001a\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0001\u001a\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010$2\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00012\b\b\u0002\u0010(\u001a\u00020)\u001a\u0018\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020\u00012\b\b\u0002\u0010(\u001a\u00020)\u001a\u0018\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020\u00012\b\b\u0002\u0010(\u001a\u00020)\u001a&\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u00012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u00101\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u00102\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u00103\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u00104\u001a\u00020\u0001H\u0002\u001a\u000e\u00105\u001a\u00020&2\u0006\u00106\u001a\u000207\u001a\"\u00108\u001a\u0002H9\"\n\b\u0000\u00109\u0018\u0001*\u00020&2\u0006\u00106\u001a\u000207H\u0086\b\u00a2\u0006\u0002\u0010:\u001a\u000e\u0010;\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\u0001\u001a\u0018\u0010=\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010>\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0000\u001a\u000e\u0010?\u001a\u00020\u00012\u0006\u0010@\u001a\u00020\u0001\u001a\u000e\u0010A\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0014\u001a\u000e\u0010B\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u000e\u0010C\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\" \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006D"}, d2={"DEFAULT_OPTIONAL_SUFFIX", "", "UTF_BYTE_ORDER_MARK", "XML_ATTR_OPTIONAL_SUFFIX", "builtInPatterns", "", "Lio/specmatic/core/pattern/Pattern;", "getBuiltInPatterns", "()Ljava/util/Map;", "breakIntoParts", "", "text", "delimiter", "count", "", "errorMessage", "Lkotlin/text/Regex;", "containsKey", "", "jsonObject", "", "key", "getBuiltInPattern", "patternString", "isBuiltInPattern", "pattern", "isDictionaryPattern", "isLookupRowPattern", "token", "isNumberPatternWithRestrictions", "patternValue", "isOptional", "isPatternToken", "isRepeatingPattern", "isStringPatternWithRestrictions", "parseLookupRowPattern", "Lkotlin/Pair;", "parsedJSON", "Lio/specmatic/core/value/Value;", "content", "mismatchMessages", "Lio/specmatic/core/MismatchMessages;", "parsedJSONArray", "Lio/specmatic/core/value/JSONArrayValue;", "parsedJSONObject", "Lio/specmatic/core/value/JSONObjectValue;", "parsedPattern", "rawContent", "typeAlias", "parsedScalarValue", "parsedValue", "processContent", "extension", "readValue", "file", "Ljava/io/File;", "readValueAs", "T", "(Ljava/io/File;)Lio/specmatic/core/value/Value;", "stringInErrorMessage", "value", "stringToPattern", "withOptionality", "withPatternDelimiters", "name", "withoutListToken", "withoutOptionality", "withoutPatternDelimiters", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nGrammar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Grammar.kt\nio/specmatic/core/pattern/GrammarKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n1747#2,3:407\n1747#2,3:410\n1549#2:413\n1620#2,3:414\n1179#2,2:417\n1253#2,4:419\n1179#2,2:423\n1253#2,4:425\n1549#2:429\n1620#2,3:430\n*S KotlinDebug\n*F\n+ 1 Grammar.kt\nio/specmatic/core/pattern/GrammarKt\n*L\n84#1:407,3\n89#1:410,3\n111#1:413\n111#1:414,3\n202#1:417,2\n202#1:419,4\n218#1:423,2\n218#1:425,4\n258#1:429\n258#1:430,3\n*E\n"})
public final class GrammarKt {
    @NotNull
    public static final String XML_ATTR_OPTIONAL_SUFFIX = ".opt";
    @NotNull
    public static final String DEFAULT_OPTIONAL_SUFFIX = "?";
    @NotNull
    public static final String UTF_BYTE_ORDER_MARK = "\ufeff";
    @NotNull
    private static final Map<String, Pattern> builtInPatterns;

    @NotNull
    public static final String withoutOptionality(@NotNull String key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        return StringsKt.endsWith$default(key2, DEFAULT_OPTIONAL_SUFFIX, false, 2, null) ? StringsKt.removeSuffix(key2, (CharSequence)DEFAULT_OPTIONAL_SUFFIX) : (StringsKt.endsWith$default(key2, XML_ATTR_OPTIONAL_SUFFIX, false, 2, null) ? StringsKt.removeSuffix(key2, (CharSequence)XML_ATTR_OPTIONAL_SUFFIX) : key2);
    }

    @NotNull
    public static final String withOptionality(@NotNull String key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        return StringsKt.endsWith$default(key2, DEFAULT_OPTIONAL_SUFFIX, false, 2, null) ? key2 : key2 + DEFAULT_OPTIONAL_SUFFIX;
    }

    public static final boolean isOptional(@NotNull String key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        return StringsKt.endsWith$default(key2, DEFAULT_OPTIONAL_SUFFIX, false, 2, null) || StringsKt.endsWith$default(key2, XML_ATTR_OPTIONAL_SUFFIX, false, 2, null);
    }

    public static final boolean containsKey(@NotNull Map<String, ? extends Object> jsonObject, @NotNull String key2) {
        Intrinsics.checkNotNullParameter(jsonObject, "jsonObject");
        Intrinsics.checkNotNullParameter(key2, "key");
        return GrammarKt.isOptional(key2) ? jsonObject.containsKey(GrammarKt.withoutOptionality(key2)) : jsonObject.containsKey(key2);
    }

    @NotNull
    public static final Map<String, Pattern> getBuiltInPatterns() {
        return builtInPatterns;
    }

    public static final boolean isBuiltInPattern(@NotNull Object pattern2) {
        Intrinsics.checkNotNullParameter(pattern2, "pattern");
        return pattern2 instanceof String ? (builtInPatterns.containsKey(pattern2) ? true : (GrammarKt.isPatternToken(pattern2) ? GrammarKt.isLookupRowPattern((String)pattern2) || StringsKt.contains$default((CharSequence)pattern2, " in ", false, 2, null) || GrammarKt.isDictionaryPattern((String)pattern2) : false)) : false;
    }

    public static final boolean isDictionaryPattern(@NotNull String pattern2) {
        Intrinsics.checkNotNullParameter(pattern2, "pattern");
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)GrammarKt.withoutPatternDelimiters(pattern2))).toString();
        Regex regex = new Regex("\\s+");
        int n = 0;
        List<String> pieces = regex.split(charSequence, n);
        return Intrinsics.areEqual(pieces.get(0), "dictionary") ? pieces.size() == 3 : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStringPatternWithRestrictions(@NotNull String patternValue) {
        String it;
        Intrinsics.checkNotNullParameter(patternValue, "patternValue");
        String[] stringArray = new String[]{" "};
        List tokens = StringsKt.split$default((CharSequence)patternValue, stringArray, false, 0, 6, null);
        if (!Intrinsics.areEqual(tokens.get(0), "(string)")) return false;
        stringArray = new String[]{"minLength", "maxLength"};
        Iterable $this$any$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!tokens.contains(it));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNumberPatternWithRestrictions(@NotNull String patternValue) {
        String it;
        Intrinsics.checkNotNullParameter(patternValue, "patternValue");
        String[] stringArray = new String[]{" "};
        List tokens = StringsKt.split$default((CharSequence)patternValue, stringArray, false, 0, 6, null);
        if (!Intrinsics.areEqual(tokens.get(0), "(number)")) return false;
        stringArray = new String[]{"minLength", "maxLength"};
        Iterable $this$any$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!tokens.contains(it));
        return true;
    }

    public static final boolean isPatternToken(@Nullable Object patternValue) {
        Object object = patternValue;
        return object instanceof String ? StringsKt.startsWith$default((String)patternValue, "(", false, 2, null) && StringsKt.endsWith$default((String)patternValue, ")", false, 2, null) : (object instanceof StringValue ? StringsKt.startsWith$default(((StringValue)patternValue).getString(), "(", false, 2, null) && StringsKt.endsWith$default(((StringValue)patternValue).getString(), ")", false, 2, null) : false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Pattern getBuiltInPattern(@NotNull String patternString) {
        Intrinsics.checkNotNullParameter(patternString, "patternString");
        if (!GrammarKt.isPatternToken(patternString)) throw new ContractException("Type " + patternString + " is not a type specifier.", null, null, null, false, 30, null);
        Pattern pattern2 = builtInPatterns.get(patternString);
        if (pattern2 != null) return pattern2;
        boolean bl = false;
        if (GrammarKt.isDictionaryPattern(patternString)) {
            void $this$mapTo$iv$iv;
            List<String> pieces = GrammarKt.breakIntoParts(GrammarKt.withoutPatternDelimiters(patternString), new Regex("\\s+"), 3, "Dictionary type must have 3 parts: type name, key and value");
            Iterable $this$map$iv = CollectionsKt.slice(pieces, new IntRange(1, 2));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(GrammarKt.parsedPattern$default(GrammarKt.withPatternDelimiters(((Object)StringsKt.trim((CharSequence)it)).toString()), null, null, 6, null));
            }
            List patterns2 = (List)destination$iv$iv;
            pattern2 = new DictionaryPattern((Pattern)patterns2.get(0), (Pattern)patterns2.get(1), null, 4, null);
            return pattern2;
        } else if (GrammarKt.isLookupRowPattern(patternString)) {
            List<String> patternParts = GrammarKt.breakIntoParts(GrammarKt.withoutPatternDelimiters(patternString), ":", 2, "Type with key must have the key before the colon and the type specification after it. Got " + patternString);
            String key2 = patternParts.get(0);
            String patternSpec = patternParts.get(1);
            Pattern pattern3 = GrammarKt.parsedPattern$default(GrammarKt.withPatternDelimiters(patternSpec), null, null, 6, null);
            pattern2 = new LookupRowPattern(pattern3, key2);
            return pattern2;
        } else {
            if (!StringsKt.contains$default((CharSequence)patternString, " in ", false, 2, null)) throw new ContractException("Type " + patternString + " does not exist.", null, null, null, false, 30, null);
            List<String> patternParts = GrammarKt.breakIntoParts(GrammarKt.withoutPatternDelimiters(patternString), " in ", 2, patternString + " seems incomplete");
            if (!Intrinsics.areEqual(patternParts.get(1), "string")) {
                throw new ContractException("Types can only be declared to be \"in string\", you probably meant (" + patternParts.get(1) + " in string)", null, null, null, false, 30, null);
            }
            pattern2 = new PatternInStringPattern(GrammarKt.parsedPattern$default(GrammarKt.withPatternDelimiters(patternParts.get(0)), null, null, 6, null), null, 2, null);
        }
        return pattern2;
    }

    @NotNull
    public static final List<String> breakIntoParts(@NotNull String text, @NotNull Regex delimiter, int count2, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(delimiter, "delimiter");
        Intrinsics.checkNotNullParameter(errorMessage, "errorMessage");
        CharSequence charSequence = text;
        int n = 0;
        List<String> pieces = delimiter.split(charSequence, n);
        if (pieces.size() != count2) {
            throw new ContractException(errorMessage, null, null, null, false, 30, null);
        }
        return pieces;
    }

    @NotNull
    public static final List<String> breakIntoParts(@NotNull String text, @NotNull String delimiter, int count2, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(delimiter, "delimiter");
        Intrinsics.checkNotNullParameter(errorMessage, "errorMessage");
        String[] stringArray = new String[]{delimiter};
        List pieces = StringsKt.split$default((CharSequence)text, stringArray, false, 0, 6, null);
        if (pieces.size() != count2) {
            throw new ContractException(errorMessage, null, null, null, false, 30, null);
        }
        return pieces;
    }

    @NotNull
    public static final String withoutPatternDelimiters(@NotNull String patternValue) {
        Intrinsics.checkNotNullParameter(patternValue, "patternValue");
        return StringsKt.removeSurrounding(patternValue, (CharSequence)"(", (CharSequence)")");
    }

    @NotNull
    public static final String withPatternDelimiters(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return "(" + name + ")";
    }

    @NotNull
    public static final String withoutListToken(@NotNull Object patternValue) {
        Intrinsics.checkNotNullParameter(patternValue, "patternValue");
        String patternString = ((Object)StringsKt.trim((CharSequence)((String)patternValue))).toString();
        return "(" + StringsKt.removeSuffix(GrammarKt.withoutPatternDelimiters(patternString), (CharSequence)"*") + ")";
    }

    public static final boolean isRepeatingPattern(@Nullable Object patternValue) {
        return patternValue != null && GrammarKt.isPatternToken(patternValue) && StringsKt.endsWith$default((String)patternValue, "*)", false, 2, null);
    }

    @NotNull
    public static final Pattern stringToPattern(@NotNull String patternValue, @Nullable String key2) {
        Intrinsics.checkNotNullParameter(patternValue, "patternValue");
        return GrammarKt.isPatternToken(patternValue) ? (Pattern)new DeferredPattern(patternValue, key2, null, 4, null) : (Pattern)new ExactValuePattern(new StringValue(patternValue), null, false, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pattern parsedPattern(@NotNull String rawContent, @Nullable String key2, @Nullable String typeAlias) {
        Pattern pattern2;
        Intrinsics.checkNotNullParameter(rawContent, "rawContent");
        String it = StringsKt.removePrefix(((Object)StringsKt.trim((CharSequence)rawContent)).toString(), (CharSequence)UTF_BYTE_ORDER_MARK);
        boolean bl = false;
        if (GrammarKt.isPatternToken(it) && StringsKt.contains$default((CharSequence)it, "/", false, 2, null)) {
            String[] stringArray = new String[]{"/"};
            List list = StringsKt.split$default((CharSequence)GrammarKt.withoutPatternDelimiters(it), stringArray, false, 0, 6, null);
            String container = (String)list.get(0);
            String type2 = (String)list.get(1);
            if (!Intrinsics.areEqual(container, "csv")) {
                throw new ContractException(container + " is not supported", null, null, null, false, 30, null);
            }
            String typeString = "(" + type2 + ")";
            Pattern pattern3 = builtInPatterns.get(typeString);
            if (pattern3 == null) {
                pattern3 = new DeferredPattern(typeString, null, null, 6, null);
            }
            Pattern innerPattern = pattern3;
            pattern2 = new CsvPattern(innerPattern);
        } else if (((CharSequence)it).length() == 0) {
            pattern2 = EmptyStringPattern.INSTANCE;
        } else if (StringsKt.startsWith$default(it, "{", false, 2, null)) {
            pattern2 = JSONObjectPatternKt.toJSONObjectPattern(it, typeAlias);
        } else if (StringsKt.startsWith$default(it, "[", false, 2, null)) {
            pattern2 = new JSONArrayPattern(it, typeAlias);
        } else if (StringsKt.startsWith$default(it, "<", false, 2, null)) {
            pattern2 = new XMLPattern(it, typeAlias);
        } else if (GrammarKt.isStringPatternWithRestrictions(it)) {
            void $this$associateTo$iv$iv;
            String[] container = new String[]{" "};
            List tokens = StringsKt.split$default((CharSequence)it, container, false, 0, 6, null);
            Object $this$associate$iv = CollectionsKt.chunked(CollectionsKt.drop(tokens, 1), 2);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Object restriction = (List)element$iv$iv;
                boolean bl2 = false;
                restriction = TuplesKt.to(restriction.get(0), restriction.get(1));
                map2.put(((Pair)restriction).getFirst(), ((Pair)restriction).getSecond());
            }
            Map restrictions = destination$iv$iv;
            try {
                String string = (String)restrictions.get("minLength");
                String string2 = (String)restrictions.get("maxLength");
                $this$associate$iv = new StringPattern(typeAlias, string != null ? StringsKt.toIntOrNull(string) : null, string2 != null ? StringsKt.toIntOrNull(string2) : null, null, null, false, false, 120, null);
            }
            catch (IllegalArgumentException e2) {
                String string = e2.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ContractException(string, null, e2, null, false, 26, null);
            }
            pattern2 = (Pattern)$this$associate$iv;
        } else if (GrammarKt.isNumberPatternWithRestrictions(it)) {
            Object restrictions = new String[]{" "};
            List tokens = StringsKt.split$default((CharSequence)it, (String[])restrictions, false, 0, 6, null);
            Object $this$associate$iv = CollectionsKt.chunked(CollectionsKt.drop(tokens, 1), 2);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                List restriction = (List)element$iv$iv;
                boolean bl3 = false;
                Pair pair = TuplesKt.to(restriction.get(0), restriction.get(1));
                map3.put(pair.getFirst(), pair.getSecond());
            }
            restrictions = destination$iv$iv;
            try {
                String string = (String)restrictions.get("minLength");
                String string3 = (String)restrictions.get("maxLength");
                $this$associate$iv = new NumberPattern(typeAlias, string != null ? Integer.parseInt(string) : 1, string3 != null ? Integer.parseInt(string3) : Integer.MAX_VALUE, null, false, null, false, null, false, false, 1016, null);
            }
            catch (IllegalArgumentException e3) {
                String string = e3.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ContractException(string, null, e3, null, false, 26, null);
            }
            pattern2 = (Pattern)$this$associate$iv;
        } else if (GrammarKt.isPatternToken(it)) {
            if (GrammarKt.isDictionaryPattern(it)) {
                pattern2 = GrammarKt.getBuiltInPattern(it);
            } else if (GrammarKt.isLookupRowPattern(it)) {
                Pair<String, String> tokens = GrammarKt.parseLookupRowPattern(it);
                String pattern4 = tokens.component1();
                String lookupKey = tokens.component2();
                pattern2 = new LookupRowPattern(GrammarKt.parsedPattern$default(pattern4, null, typeAlias, 2, null), lookupKey);
            } else if (NullPatternKt.isOptionalValuePattern(it)) {
                Pattern[] patternArray = new Pattern[]{new DeferredPattern("(empty)", key2, null, 4, null), GrammarKt.parsedPattern$default(NullPatternKt.withoutNullToken(it), null, typeAlias, 2, null)};
                List<Pattern> patterns2 = CollectionsKt.listOf(patternArray);
                pattern2 = new AnyPattern(patterns2, null, null, null, null, AnyPatternKt.extractCombinedExtensions(patterns2), 30, null);
            } else {
                pattern2 = RestPatternKt.isRestPattern(it) ? (Pattern)new RestPattern(GrammarKt.parsedPattern$default(RestPatternKt.withoutRestToken(it), null, typeAlias, 2, null), null, 2, null) : (GrammarKt.isRepeatingPattern(it) ? (Pattern)new ListPattern(GrammarKt.parsedPattern$default(GrammarKt.withoutListToken(it), null, typeAlias, 2, null), null, null, null, 14, null) : (Intrinsics.areEqual(it, "(number)") || Intrinsics.areEqual(it, "(integer)") ? (Pattern)new DeferredPattern(it, null, null, 4, null) : (GrammarKt.isBuiltInPattern(it) ? GrammarKt.getBuiltInPattern(it) : (Pattern)new DeferredPattern(it, key2, null, 4, null))));
            }
        } else {
            pattern2 = new ExactValuePattern(new StringValue(it), null, false, 6, null);
        }
        return pattern2;
    }

    public static /* synthetic */ Pattern parsedPattern$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return GrammarKt.parsedPattern(string, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<String, String> parseLookupRowPattern(@NotNull String token2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(token2, "token");
        CharSequence charSequence = GrammarKt.withoutPatternDelimiters(token2);
        Regex regex = new Regex(":");
        int n = 2;
        Iterable $this$map$iv = regex.split(charSequence, n);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        List parts = (List)destination$iv$iv;
        String key2 = (String)CollectionsKt.first(parts);
        String patternToken = (String)parts.get(1);
        return new Pair<String, String>(GrammarKt.withPatternDelimiters(patternToken), key2);
    }

    public static final boolean isLookupRowPattern(@NotNull String token2) {
        Intrinsics.checkNotNullParameter(token2, "token");
        CharSequence charSequence = GrammarKt.withoutPatternDelimiters(token2);
        Regex regex = new Regex(":");
        int n = 0;
        List<String> parts = regex.split(charSequence, n);
        return parts.size() == 2;
    }

    @NotNull
    public static final Value parsedJSON(@NotNull String content2, @NotNull MismatchMessages mismatchMessages) {
        JSONComposite jSONComposite;
        Intrinsics.checkNotNullParameter(content2, "content");
        Intrinsics.checkNotNullParameter(mismatchMessages, "mismatchMessages");
        String it = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix(content2, (CharSequence)UTF_BYTE_ORDER_MARK))).toString();
        boolean bl = false;
        if (StringsKt.startsWith$default(it, "{", false, 2, null)) {
            JSONObjectValue jSONObjectValue;
            try {
                jSONObjectValue = new JSONObjectValue(JSONSerialisationKt.jsonStringToValueMap(it));
            }
            catch (Throwable e2) {
                String string = e2.getLocalizedMessage();
                if (string == null) {
                    string = e2.getMessage();
                }
                throw new ContractException("Could not parse json object, got error: " + string, null, e2, null, false, 26, null);
            }
            jSONComposite = jSONObjectValue;
        } else if (StringsKt.startsWith$default(it, "[", false, 2, null)) {
            JSONArrayValue jSONArrayValue;
            try {
                jSONArrayValue = new JSONArrayValue(JSONSerialisationKt.jsonStringToValueArray(it));
            }
            catch (Throwable e3) {
                String string = e3.getLocalizedMessage();
                if (string == null) {
                    string = e3.getMessage();
                }
                throw new ContractException("Could not parse json array, got error: " + string, null, e3, null, false, 26, null);
            }
            jSONComposite = jSONArrayValue;
        } else {
            throw new ContractException(mismatchMessages.mismatchMessage("json value", GrammarKt.stringInErrorMessage(content2)), null, null, null, false, 30, null);
        }
        return jSONComposite;
    }

    public static /* synthetic */ Value parsedJSON$default(String string, MismatchMessages mismatchMessages, int n, Object object) {
        if ((n & 2) != 0) {
            mismatchMessages = DefaultMismatchMessages.INSTANCE;
        }
        return GrammarKt.parsedJSON(string, mismatchMessages);
    }

    @NotNull
    public static final String stringInErrorMessage(@NotNull String value2) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(value2, "value");
        CharSequence charSequence2 = value2;
        if (StringsKt.isBlank(charSequence2)) {
            boolean bl = false;
            charSequence = "an empty string or no body value";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    public static final JSONObjectValue parsedJSONObject(@NotNull String content2, @NotNull MismatchMessages mismatchMessages) {
        JSONObjectValue jSONObjectValue;
        Intrinsics.checkNotNullParameter(content2, "content");
        Intrinsics.checkNotNullParameter(mismatchMessages, "mismatchMessages");
        String it = StringsKt.removePrefix(((Object)StringsKt.trim((CharSequence)content2)).toString(), (CharSequence)UTF_BYTE_ORDER_MARK);
        boolean bl = false;
        if (StringsKt.startsWith$default(it, "{", false, 2, null)) {
            try {
                jSONObjectValue = new JSONObjectValue(JSONSerialisationKt.jsonStringToValueMap(it));
            }
            catch (Throwable e2) {
                String string = e2.getLocalizedMessage();
                if (string == null) {
                    string = e2.getMessage();
                }
                throw new ContractException("Could not parse json object, got error: " + string, null, e2, null, false, 26, null);
            }
        } else {
            throw new ContractException(mismatchMessages.mismatchMessage("json object", GrammarKt.stringInErrorMessage(content2)), null, null, null, false, 30, null);
        }
        return jSONObjectValue;
    }

    public static /* synthetic */ JSONObjectValue parsedJSONObject$default(String string, MismatchMessages mismatchMessages, int n, Object object) {
        if ((n & 2) != 0) {
            mismatchMessages = DefaultMismatchMessages.INSTANCE;
        }
        return GrammarKt.parsedJSONObject(string, mismatchMessages);
    }

    @NotNull
    public static final JSONArrayValue parsedJSONArray(@NotNull String content2, @NotNull MismatchMessages mismatchMessages) {
        JSONArrayValue jSONArrayValue;
        Intrinsics.checkNotNullParameter(content2, "content");
        Intrinsics.checkNotNullParameter(mismatchMessages, "mismatchMessages");
        String it = StringsKt.removePrefix(((Object)StringsKt.trim((CharSequence)content2)).toString(), (CharSequence)UTF_BYTE_ORDER_MARK);
        boolean bl = false;
        if (StringsKt.startsWith$default(it, "[", false, 2, null)) {
            try {
                jSONArrayValue = new JSONArrayValue(JSONSerialisationKt.jsonStringToValueArray(it));
            }
            catch (Throwable e2) {
                String string = e2.getLocalizedMessage();
                if (string == null) {
                    string = e2.getMessage();
                }
                throw new ContractException("Could not parse json array, got error: " + string, null, e2, null, false, 26, null);
            }
        } else {
            throw new ContractException(mismatchMessages.mismatchMessage("json array", GrammarKt.stringInErrorMessage(content2)), null, null, null, false, 30, null);
        }
        return jSONArrayValue;
    }

    public static /* synthetic */ JSONArrayValue parsedJSONArray$default(String string, MismatchMessages mismatchMessages, int n, Object object) {
        if ((n & 2) != 0) {
            mismatchMessages = DefaultMismatchMessages.INSTANCE;
        }
        return GrammarKt.parsedJSONArray(string, mismatchMessages);
    }

    @NotNull
    public static final Value parsedValue(@Nullable String content2) {
        Object object;
        block5: {
            block4: {
                Value value2;
                object = content2;
                if (object == null || (object = ((Object)StringsKt.trim((CharSequence)object)).toString()) == null || (object = StringsKt.removePrefix((String)object, (CharSequence)UTF_BYTE_ORDER_MARK)) == null) break block4;
                Object it = object;
                boolean bl = false;
                try {
                    value2 = StringsKt.startsWith$default((String)it, "{", false, 2, null) ? (Value)new JSONObjectValue(JSONSerialisationKt.jsonStringToValueMap((String)it)) : (StringsKt.startsWith$default((String)it, "[", false, 2, null) ? (Value)new JSONArrayValue(JSONSerialisationKt.jsonStringToValueArray((String)it)) : (StringsKt.startsWith$default((String)it, "<", false, 2, null) ? (Value)XMLNodeKt.toXMLNode$default((String)it, null, 2, null) : (Value)new StringValue((String)it)));
                }
                catch (Throwable e2) {
                    value2 = new StringValue((String)it);
                }
                Value value3 = value2;
                object = value3;
                if (value3 != null) break block5;
            }
            object = EmptyStringKt.getEmptyString();
        }
        return object;
    }

    @NotNull
    public static final Value parsedScalarValue(@Nullable String content2) {
        Value value2;
        String string = content2;
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null || (string = StringsKt.removePrefix(string, (CharSequence)UTF_BYTE_ORDER_MARK)) == null) {
            return NullValue.INSTANCE;
        }
        String trimmed = string;
        if (StringsKt.toIntOrNull(trimmed) != null) {
            value2 = new NumberValue(Integer.parseInt(trimmed));
        } else if (StringsKt.toLongOrNull(trimmed) != null) {
            value2 = new NumberValue(Long.parseLong(trimmed));
        } else if (StringsKt.toDoubleOrNull(trimmed) != null) {
            value2 = new NumberValue(Double.parseDouble(trimmed));
        } else {
            String[] stringArray = new String[]{"true", "false"};
            Set<String> set2 = SetsKt.setOf(stringArray);
            String string2 = trimmed.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            value2 = set2.contains(string2) ? (Value)new BooleanValue(Boolean.parseBoolean(trimmed)) : (Value)new StringValue(trimmed);
        }
        return value2;
    }

    @NotNull
    public static final Value readValue(@NotNull File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return GrammarKt.processContent(FilesKt.readText$default(file2, null, 1, null), FilesKt.getExtension(file2));
    }

    public static final /* synthetic */ <T extends Value> T readValueAs(File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        boolean $i$f$readValueAs = false;
        Value parsedValue = GrammarKt.readValue(file2);
        Intrinsics.reifiedOperationMarker(3, "T");
        if (!(parsedValue instanceof Value)) {
            Intrinsics.reifiedOperationMarker(4, "T");
            throw new ClassCastException("Expected " + Reflection.getOrCreateKotlinClass(Value.class).getSimpleName() + " but got " + Reflection.getOrCreateKotlinClass(parsedValue.getClass()).getSimpleName());
        }
        return (T)parsedValue;
    }

    private static final Value processContent(String content2, String extension) {
        Object object;
        Object object2;
        String string = content2;
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null || (string = StringsKt.removePrefix(string, (CharSequence)UTF_BYTE_ORDER_MARK)) == null) {
            return EmptyStringKt.getEmptyString();
        }
        String trimmedContent = string;
        try {
            Value value2;
            boolean bl = false;
            String string2 = extension.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            switch (string2) {
                case "json": {
                    value2 = GrammarKt.parsedJSON$default(trimmedContent, null, 2, null);
                    break;
                }
                case "yml": 
                case "yaml": {
                    value2 = YAMLSerialisationKt.yamlStringToValue(trimmedContent);
                    break;
                }
                case "xml": {
                    value2 = XMLNodeKt.toXMLNode$default(trimmedContent, null, 2, null);
                    break;
                }
                default: {
                    value2 = GrammarKt.parsedScalarValue(trimmedContent);
                }
            }
            object2 = Result.constructor-impl(value2);
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e2 = throwable;
            boolean bl = false;
            LogStrategy.debug$default(LoggingKt.getLogger(), e2, null, 2, null);
            object = new StringValue(trimmedContent);
        }
        return (Value)object;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("(number)", new NumberPattern(null, 0, 0, null, false, null, false, null, false, false, 1023, null)), TuplesKt.to("(integer)", new NumberPattern(null, 0, 0, null, false, null, false, null, false, false, 1023, null)), TuplesKt.to("(string)", new StringPattern(null, null, null, null, null, false, false, 127, null)), TuplesKt.to("(email)", new EmailPattern(null, null, null, null, 15, null)), TuplesKt.to("(boolean)", new BooleanPattern(null, 1, null)), TuplesKt.to("(null)", NullPattern.INSTANCE), TuplesKt.to("(empty)", EmptyStringPattern.INSTANCE), TuplesKt.to("(date)", DatePattern.INSTANCE), TuplesKt.to("(datetime)", DateTimePattern.INSTANCE), TuplesKt.to("(time)", TimePattern.INSTANCE), TuplesKt.to("(uuid)", UUIDPattern.INSTANCE), TuplesKt.to("(url)", new URLPattern(URLScheme.EITHER, null, 2, null)), TuplesKt.to("(url-http)", new URLPattern(URLScheme.HTTP, null, 2, null)), TuplesKt.to("(url-https)", new URLPattern(URLScheme.HTTPS, null, 2, null)), TuplesKt.to("(url-path)", new URLPattern(URLScheme.PATH, null, 2, null)), TuplesKt.to("(anything)", AnythingPattern.INSTANCE), TuplesKt.to("(anyvalue)", AnyValuePattern.INSTANCE)};
        builtInPatterns = MapsKt.mapOf(pairArray);
    }
}

