/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.pattern;

import io.specmatic.core.Resolver;
import io.specmatic.core.Result;
import io.specmatic.core.ResultKt;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.DeferredPatternKt;
import io.specmatic.core.pattern.ExactValuePattern;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.pattern.JSONArrayPattern;
import io.specmatic.core.pattern.JSONArrayPatternKt;
import io.specmatic.core.pattern.JSONObjectPattern;
import io.specmatic.core.pattern.ListPattern;
import io.specmatic.core.pattern.MemberList;
import io.specmatic.core.pattern.NullPattern;
import io.specmatic.core.pattern.PairOfTypes;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.RestPattern;
import io.specmatic.core.pattern.ResultWithIndex;
import io.specmatic.core.pattern.ReturnValue;
import io.specmatic.core.pattern.Row;
import io.specmatic.core.pattern.SequenceType;
import io.specmatic.core.pattern.SubSchemaCompositePattern;
import io.specmatic.core.pattern.TypeStackKt;
import io.specmatic.core.pattern.config.NegativePatternConfiguration;
import io.specmatic.core.utilities.JSONSerialisationKt;
import io.specmatic.core.utilities.Utilities;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006B!\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J%\u0010 \u001a\u00020\u00002\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J2\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001d2\u0010\u0010&\u001a\f\u0012\u0004\u0012\u00020'0\u0019j\u0002`(H\u0016J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010.\u001a\u00020\u0016H\u00d6\u0001J\u001e\u0010/\u001a\u00020\u001b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001b0\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001a\u00101\u001a\u00020\"2\b\u00102\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J,\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000105042\u0006\u00106\u001a\u0002072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00108\u001a\u000209H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0000042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J$\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000105042\u0006\u00106\u001a\u0002072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010;\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010<\u001a\u00020\u0004H\u00d6\u0001J\u0018\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u000bH\u0002R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006@"}, d2={"Lio/specmatic/core/pattern/JSONArrayPattern;", "Lio/specmatic/core/pattern/Pattern;", "Lio/specmatic/core/pattern/SequenceType;", "jsonString", "", "typeAlias", "(Ljava/lang/String;Ljava/lang/String;)V", "pattern", "", "(Ljava/util/List;Ljava/lang/String;)V", "memberList", "Lio/specmatic/core/pattern/MemberList;", "getMemberList", "()Lio/specmatic/core/pattern/MemberList;", "getPattern", "()Ljava/util/List;", "getTypeAlias", "()Ljava/lang/String;", "typeName", "getTypeName", "arrayLengthMismatchMessage", "expectedLength", "", "actualLength", "calculatePath", "", "value", "Lio/specmatic/core/value/Value;", "resolver", "Lio/specmatic/core/Resolver;", "component1", "component2", "copy", "encompasses", "Lio/specmatic/core/Result;", "otherPattern", "thisResolver", "otherResolver", "typeStack", "Lio/specmatic/core/pattern/PairOfTypes;", "Lio/specmatic/core/pattern/TypeStack;", "equals", "", "other", "", "generate", "hashCode", "listOf", "valueList", "matches", "sampleData", "negativeBasedOn", "Lkotlin/sequences/Sequence;", "Lio/specmatic/core/pattern/ReturnValue;", "row", "Lio/specmatic/core/pattern/Row;", "config", "Lio/specmatic/core/pattern/config/NegativePatternConfiguration;", "newBasedOn", "parse", "toString", "validateInfiniteLength", "otherMembers", "theseMembers", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nJSONArrayPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONArrayPattern.kt\nio/specmatic/core/pattern/JSONArrayPattern\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n350#2,7:319\n1549#2:327\n1620#2,3:328\n1549#2:331\n1620#2,3:332\n1549#2:335\n1620#2,3:336\n1549#2:339\n1620#2,3:340\n1549#2:343\n1620#2,3:344\n1#3:326\n*S KotlinDebug\n*F\n+ 1 JSONArrayPattern.kt\nio/specmatic/core/pattern/JSONArrayPattern\n*L\n21#1:319,7\n40#1:327\n40#1:328,3\n143#1:331\n143#1:332,3\n154#1:335\n154#1:336,3\n171#1:339\n171#1:340,3\n181#1:343\n181#1:344,3\n*E\n"})
public final class JSONArrayPattern
implements Pattern,
SequenceType {
    @NotNull
    private final List<Pattern> pattern;
    @Nullable
    private final String typeAlias;
    @NotNull
    private final String typeName;

    public JSONArrayPattern(@NotNull List<? extends Pattern> pattern2, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter(pattern2, "pattern");
        this.pattern = pattern2;
        this.typeAlias = typeAlias;
        this.typeName = "json array";
    }

    public /* synthetic */ JSONArrayPattern(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(list, string);
    }

    @Override
    @NotNull
    public List<Pattern> getPattern() {
        return this.pattern;
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return this.typeAlias;
    }

    @Override
    @NotNull
    public MemberList getMemberList() {
        int n;
        block4: {
            if (this.getPattern().isEmpty()) {
                return new MemberList(CollectionsKt.emptyList(), null);
            }
            Object $this$indexOfFirst$iv = this.getPattern();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv = iterator2.next();
                Pattern it = (Pattern)item$iv;
                boolean bl = false;
                if (it instanceof RestPattern) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        boolean bl2 = it >= 0 && it < CollectionsKt.getLastIndex(this.getPattern());
        if (bl2) {
            throw new ContractException("A rest operator ... can only be used in the last entry of an array.", null, null, null, false, 30, null);
        }
        Pattern last2 = (Pattern)CollectionsKt.last(this.getPattern());
        boolean bl3 = false;
        return last2 instanceof RestPattern ? new MemberList(CollectionsKt.dropLast(this.getPattern(), 1), ((RestPattern)last2).getPattern()) : new MemberList((List<? extends Pattern>)this.getPattern(), null);
    }

    public JSONArrayPattern(@NotNull String jsonString, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter(jsonString, "jsonString");
        this(JSONSerialisationKt.stringTooPatternArray(jsonString), typeAlias);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) throws Exception {
        Result result2;
        Iterator<Object> iterator2;
        block6: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(resolver, "resolver");
            if (!(sampleData instanceof JSONArrayValue)) {
                return ResultKt.mismatchResult((Pattern)this, sampleData, resolver.getMismatchMessages());
            }
            Resolver resolverWithNumberType = Utilities.withNumberType(Utilities.withNullPattern(resolver));
            Iterable $this$map$iv = (Iterable)this.getPattern();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pattern pattern2 = (Pattern)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DeferredPatternKt.resolvedHop((Pattern)it, resolverWithNumberType));
            }
            List resolvedPatterns = (List)destination$iv$iv;
            Pattern theOnlyPatternInTheArray = (Pattern)CollectionsKt.singleOrNull(resolvedPatterns);
            if (theOnlyPatternInTheArray instanceof ListPattern || theOnlyPatternInTheArray instanceof RestPattern) {
                return theOnlyPatternInTheArray.matches(sampleData, resolverWithNumberType);
            }
            if (resolvedPatterns.size() != ((JSONArrayValue)sampleData).getList().size()) {
                return new Result.Failure(this.arrayLengthMismatchMessage(resolvedPatterns.size(), ((JSONArrayValue)sampleData).getList().size()), null, null, null, null, 30, null);
            }
            Sequence sequence2 = SequencesKt.mapIndexed(CollectionsKt.asSequence(resolvedPatterns), (Function2)new Function2<Integer, Pattern, Result>(sampleData, resolverWithNumberType){
                final /* synthetic */ Value $sampleData;
                final /* synthetic */ Resolver $resolverWithNumberType;
                {
                    this.$sampleData = $sampleData;
                    this.$resolverWithNumberType = $resolverWithNumberType;
                    super(2);
                }

                public final Result invoke(int index, Pattern patternValue) {
                    Intrinsics.checkNotNullParameter(patternValue, "patternValue");
                    Value sampleValue = ((JSONArrayValue)this.$sampleData).getList().get(index);
                    return this.$resolverWithNumberType.matchesPattern(null, patternValue, sampleValue).breadCrumb("[" + index + "]");
                }
            });
            Iterator iterator3 = sequence2.iterator();
            while (iterator3.hasNext()) {
                Iterator<Object> iterator4 = iterator3.next();
                Result it = (Result)((Object)iterator4);
                boolean bl = false;
                if (!(it instanceof Result.Failure)) continue;
                iterator2 = iterator4;
                break block6;
            }
            iterator2 = null;
        }
        if ((result2 = (Result)((Object)iterator2)) == null) {
            result2 = new Result.Success(null, null, 3, null);
        }
        return result2;
    }

    private final String arrayLengthMismatchMessage(int expectedLength, int actualLength) {
        return "Expected an array of length " + expectedLength + ", actual length " + actualLength;
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, "valueList");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        return new JSONArrayValue(JSONArrayPatternKt.access$generate(this, resolverWithNullType));
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(row, "row");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        Sequence<ReturnValue<List<Pattern>>> returnValues2 = JSONArrayPatternKt.newListBasedOn((List<? extends Pattern>)this.getPattern(), row, resolverWithNullType);
        return SequencesKt.map(returnValues2, newBasedOn.1.INSTANCE);
    }

    @NotNull
    public Sequence<JSONArrayPattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        return SequencesKt.map(JSONArrayPatternKt.newBasedOn((List<? extends Pattern>)this.getPattern(), resolverWithNullType), newBasedOn.2.INSTANCE);
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver, @NotNull NegativePatternConfiguration config2) {
        Intrinsics.checkNotNullParameter(row, "row");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Intrinsics.checkNotNullParameter(config2, "config");
        NullPattern[] nullPatternArray = new NullPattern[]{NullPattern.INSTANCE};
        Sequence<NullPattern> it = SequencesKt.sequenceOf(nullPatternArray);
        boolean bl = false;
        return SequencesKt.map(this.getPattern().size() == 1 ? SequencesKt.plus(it, this.getPattern().get(0)) : it, negativeBasedOn.2.INSTANCE);
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return GrammarKt.parsedJSONArray(value2, resolver.getMismatchMessages());
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Result result2;
        Intrinsics.checkNotNullParameter(otherPattern, "otherPattern");
        Intrinsics.checkNotNullParameter(thisResolver, "thisResolver");
        Intrinsics.checkNotNullParameter(otherResolver, "otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, "typeStack");
        Resolver thisResolverWithNullType = Utilities.withNullPattern(thisResolver);
        Resolver otherResolverWithNullType = Utilities.withNullPattern(otherResolver);
        Pattern pattern2 = otherPattern;
        if (pattern2 instanceof ExactValuePattern) {
            result2 = otherPattern.fitsWithin(CollectionsKt.listOf(this), otherResolverWithNullType, thisResolverWithNullType, typeStack);
        } else if (pattern2 instanceof SequenceType) {
            Result result3;
            try {
                MemberList otherMembers = ((SequenceType)((Object)otherPattern)).getMemberList();
                MemberList theseMembers = this.getMemberList();
                result3 = this.validateInfiniteLength(otherMembers, theseMembers).ifSuccess((Function0<? extends Result>)new Function0<Result>(otherMembers, this, otherResolverWithNullType, theseMembers, thisResolverWithNullType, typeStack){
                    final /* synthetic */ MemberList $otherMembers;
                    final /* synthetic */ JSONArrayPattern this$0;
                    final /* synthetic */ Resolver $otherResolverWithNullType;
                    final /* synthetic */ MemberList $theseMembers;
                    final /* synthetic */ Resolver $thisResolverWithNullType;
                    final /* synthetic */ Set<PairOfTypes> $typeStack;
                    {
                        this.$otherMembers = $otherMembers;
                        this.this$0 = $receiver;
                        this.$otherResolverWithNullType = $otherResolverWithNullType;
                        this.$theseMembers = $theseMembers;
                        this.$thisResolverWithNullType = $thisResolverWithNullType;
                        this.$typeStack = $typeStack;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    public final Result invoke() {
                        Object object;
                        Object v0;
                        Object object2;
                        Object object3;
                        block5: {
                            void $this$mapIndexedTo$iv$iv;
                            void $this$mapIndexed$iv;
                            List<Pattern> otherEncompassables = this.$otherMembers.getEncompassableList(this.this$0.getPattern().size(), this.$otherResolverWithNullType);
                            List<Pattern> encompassables = otherEncompassables.size() > this.this$0.getPattern().size() ? this.$theseMembers.getEncompassableList(otherEncompassables.size(), this.$thisResolverWithNullType) : this.this$0.getMemberList().getEncompassables(this.$thisResolverWithNullType);
                            object3 = CollectionsKt.zip((Iterable)encompassables, (Iterable)otherEncompassables);
                            object2 = this.$thisResolverWithNullType;
                            Object object4 = this.$otherResolverWithNullType;
                            Object object5 = this.$typeStack;
                            boolean $i$f$mapIndexed2 = false;
                            void var9_10 = $this$mapIndexed$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                            boolean $i$f$mapIndexedTo = false;
                            int index$iv$iv = 0;
                            for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                                void index;
                                int n;
                                if ((n = index$iv$iv++) < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                Pair pair = (Pair)item$iv$iv;
                                int n2 = n;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                Pattern bigger = (Pattern)pair.component1();
                                Pattern smaller = (Pattern)pair.component2();
                                collection.add(new ResultWithIndex((int)index, TypeStackKt.biggerEncompassesSmaller(bigger, smaller, (Resolver)object2, (Resolver)object4, (Set<PairOfTypes>)object5)));
                            }
                            List results2 = (List)destination$iv$iv;
                            object4 = results2;
                            object5 = object4.iterator();
                            while (object5.hasNext()) {
                                E $i$f$mapIndexed2 = object5.next();
                                ResultWithIndex it = (ResultWithIndex)$i$f$mapIndexed2;
                                boolean bl = false;
                                if (!(it.getResult() instanceof Result.Failure)) continue;
                                v0 = $i$f$mapIndexed2;
                                break block5;
                            }
                            v0 = null;
                        }
                        object3 = v0;
                        if (object3 != null) {
                            Object result2 = object3;
                            boolean bl = false;
                            object2 = ((ResultWithIndex)result2).getResult().breadCrumb("[" + ((ResultWithIndex)result2).getIndex() + "]");
                            if (object2 != null) {
                                object = object2;
                                return object;
                            }
                        }
                        object = new Result.Success(null, null, 3, null);
                        return object;
                    }
                });
            }
            catch (ContractException e2) {
                result3 = new Result.Failure(e2.report(), null, null, null, null, 30, null);
            }
            result2 = result3;
        } else {
            result2 = new Result.Failure("Expected array or list, got " + otherPattern.getTypeName(), null, null, null, null, 30, null);
        }
        return result2;
    }

    private final Result validateInfiniteLength(MemberList otherMembers, MemberList theseMembers) {
        return otherMembers.isEndless() && !theseMembers.isEndless() ? (Result)new Result.Failure("Finite list is not a superset of an infinite list.", null, null, null, null, 30, null) : (Result)new Result.Success(null, null, 3, null);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final Set<String> calculatePath(@NotNull Value value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        if (!(value2 instanceof JSONArrayValue)) {
            return SetsKt.emptySet();
        }
        Iterable iterable = ((JSONArrayValue)value2).getList();
        Collection collection = new ArrayList();
        int n = 0;
        for (Object t2 : iterable) {
            List list;
            int n2;
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Value value3 = (Value)t2;
            int index = n2;
            boolean bl = false;
            if (this.getPattern().size() == 1) {
                resolvedPattern = DeferredPatternKt.resolvedHop((Pattern)this.getPattern().get(0), resolver);
                var13_13 = resolvedPattern;
                if (var13_13 instanceof SubSchemaCompositePattern) {
                    anyPatternPaths = ((SubSchemaCompositePattern)((Object)resolvedPattern)).calculatePath((Value)arrayItem, resolver);
                    $this$map$iv = anyPatternPaths;
                    $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        String string = (String)item$iv$iv;
                        var23_23 = destination$iv$iv;
                        boolean bl2 = false;
                        var25_25 = new String[]{"string", "number", "boolean"};
                        var23_23.add(SetsKt.setOf(var25_25).contains(path) ? "{[" + index + "]}{" + path + "}" : "{[" + index + "]}" + path);
                    }
                    list = (List)destination$iv$iv;
                } else if (var13_13 instanceof JSONObjectPattern) {
                    nestedPaths = ((JSONObjectPattern)resolvedPattern).calculatePath((Value)arrayItem, resolver);
                    $this$map$iv = nestedPaths;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        path = (String)item$iv$iv;
                        var23_23 = destination$iv$iv;
                        boolean bl3 = false;
                        var23_23.add(StringsKt.startsWith$default(nestedPath, "{", false, 2, null) ? "{[" + index + "]}" + nestedPath : "{[" + index + "]}." + nestedPath);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
            } else if (index < this.getPattern().size()) {
                resolvedPattern = DeferredPatternKt.resolvedHop((Pattern)this.getPattern().get(index), resolver);
                var13_13 = resolvedPattern;
                if (var13_13 instanceof SubSchemaCompositePattern) {
                    anyPatternPaths = ((SubSchemaCompositePattern)((Object)resolvedPattern)).calculatePath((Value)arrayItem, resolver);
                    $this$map$iv = anyPatternPaths;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        nestedPath = (String)item$iv$iv;
                        var23_23 = destination$iv$iv;
                        boolean bl4 = false;
                        var25_25 = new String[]{"string", "number", "boolean"};
                        var23_23.add(SetsKt.setOf(var25_25).contains(path) ? "{[" + index + "]}{" + path + "}" : "{[" + index + "]}" + path);
                    }
                    list = (List)destination$iv$iv;
                } else if (var13_13 instanceof JSONObjectPattern) {
                    nestedPaths = ((JSONObjectPattern)resolvedPattern).calculatePath((Value)arrayItem, resolver);
                    $this$map$iv = nestedPaths;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        path = (String)item$iv$iv;
                        var23_23 = destination$iv$iv;
                        boolean bl5 = false;
                        var23_23.add(StringsKt.startsWith$default(nestedPath, "{", false, 2, null) ? "{[" + index + "]}" + nestedPath : "{[" + index + "]}." + nestedPath);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            CollectionsKt.addAll(collection, list);
        }
        return CollectionsKt.toSet((List)collection);
    }

    @NotNull
    public final List<Pattern> component1() {
        return this.pattern;
    }

    @Nullable
    public final String component2() {
        return this.typeAlias;
    }

    @NotNull
    public final JSONArrayPattern copy(@NotNull List<? extends Pattern> pattern2, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter(pattern2, "pattern");
        return new JSONArrayPattern(pattern2, typeAlias);
    }

    public static /* synthetic */ JSONArrayPattern copy$default(JSONArrayPattern jSONArrayPattern, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            list = jSONArrayPattern.pattern;
        }
        if ((n & 2) != 0) {
            string = jSONArrayPattern.typeAlias;
        }
        return jSONArrayPattern.copy(list, string);
    }

    @NotNull
    public String toString() {
        return "JSONArrayPattern(pattern=" + this.pattern + ", typeAlias=" + this.typeAlias + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.pattern).hashCode();
        result2 = result2 * 31 + (this.typeAlias == null ? 0 : this.typeAlias.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONArrayPattern)) {
            return false;
        }
        JSONArrayPattern jSONArrayPattern = (JSONArrayPattern)other;
        if (!Intrinsics.areEqual(this.pattern, jSONArrayPattern.pattern)) {
            return false;
        }
        return Intrinsics.areEqual(this.typeAlias, jSONArrayPattern.typeAlias);
    }

    public JSONArrayPattern() {
        this(null, null, 3, null);
    }
}

