/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.pattern;

import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.Row;
import io.specmatic.core.value.JSONComposite;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.ScalarValue;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0012J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0012J\t\u0010\u0019\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lio/specmatic/core/pattern/JSONExample;", "", "jsonObject", "Lio/specmatic/core/value/JSONComposite;", "originalRow", "Lio/specmatic/core/pattern/Row;", "(Lio/specmatic/core/value/JSONComposite;Lio/specmatic/core/pattern/Row;)V", "getJsonObject", "()Lio/specmatic/core/value/JSONComposite;", "getOriginalRow", "()Lio/specmatic/core/pattern/Row;", "component1", "component2", "copy", "equals", "", "other", "getValueFromTopLevelKeys", "", "columnName", "hasScalarValueForKey", "key", "hashCode", "", "removeKey", "toString", "specmatic-core"})
public final class JSONExample {
    @NotNull
    private final JSONComposite jsonObject;
    @NotNull
    private final Row originalRow;

    public JSONExample(@NotNull JSONComposite jsonObject, @NotNull Row originalRow) {
        Intrinsics.checkNotNullParameter(jsonObject, "jsonObject");
        Intrinsics.checkNotNullParameter(originalRow, "originalRow");
        this.jsonObject = jsonObject;
        this.originalRow = originalRow;
    }

    @NotNull
    public final JSONComposite getJsonObject() {
        return this.jsonObject;
    }

    @NotNull
    public final Row getOriginalRow() {
        return this.originalRow;
    }

    @NotNull
    public final JSONExample removeKey(@NotNull String key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        if (this.jsonObject instanceof JSONObjectValue) {
            return new JSONExample(((JSONObjectValue)this.jsonObject).copy(MapsKt.minus(((JSONObjectValue)this.jsonObject).getJsonObject(), key2)), this.originalRow);
        }
        return this;
    }

    public final boolean hasScalarValueForKey(@NotNull String key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        JSONComposite it = this.jsonObject;
        boolean bl = false;
        return it instanceof JSONObjectValue && ((JSONObjectValue)it).getJsonObject().get(key2) instanceof ScalarValue;
    }

    @NotNull
    public final String getValueFromTopLevelKeys(@NotNull String columnName) {
        Intrinsics.checkNotNullParameter(columnName, "columnName");
        if (!(this.jsonObject instanceof JSONObjectValue)) {
            throw new ContractException("The example provided is a JSON array, while the specification expects a JSON object with key " + columnName, null, null, null, false, 30, null);
        }
        return MapsKt.getValue(((JSONObjectValue)this.jsonObject).getJsonObject(), columnName).toStringLiteral();
    }

    @NotNull
    public final JSONComposite component1() {
        return this.jsonObject;
    }

    @NotNull
    public final Row component2() {
        return this.originalRow;
    }

    @NotNull
    public final JSONExample copy(@NotNull JSONComposite jsonObject, @NotNull Row originalRow) {
        Intrinsics.checkNotNullParameter(jsonObject, "jsonObject");
        Intrinsics.checkNotNullParameter(originalRow, "originalRow");
        return new JSONExample(jsonObject, originalRow);
    }

    public static /* synthetic */ JSONExample copy$default(JSONExample jSONExample, JSONComposite jSONComposite, Row row, int n, Object object) {
        if ((n & 1) != 0) {
            jSONComposite = jSONExample.jsonObject;
        }
        if ((n & 2) != 0) {
            row = jSONExample.originalRow;
        }
        return jSONExample.copy(jSONComposite, row);
    }

    @NotNull
    public String toString() {
        return "JSONExample(jsonObject=" + this.jsonObject + ", originalRow=" + this.originalRow + ")";
    }

    public int hashCode() {
        int result2 = this.jsonObject.hashCode();
        result2 = result2 * 31 + this.originalRow.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONExample)) {
            return false;
        }
        JSONExample jSONExample = (JSONExample)other;
        if (!Intrinsics.areEqual(this.jsonObject, jSONExample.jsonObject)) {
            return false;
        }
        return Intrinsics.areEqual(this.originalRow, jSONExample.originalRow);
    }
}

