/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.pattern;

import com.mifmif.common.regex.Generex;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.pattern.RegExSpec;
import io.specmatic.core.pattern.StringPatternKt;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J)\u0010\t\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000bJ\u001f\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0003H\u0002J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000bJ<\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2 \u0010\u001a\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000b0\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001bH\u0002J\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fJ\u001f\u0010 \u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0003H\u0016J\u0015\u0010#\u001a\u00020$2\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020$2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010%J\f\u0010'\u001a\u00020\u0003*\u00020\u0003H\u0002J\f\u0010(\u001a\u00020\u0003*\u00020\u0003H\u0002J\f\u0010)\u001a\u00020\u0003*\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/specmatic/core/pattern/RegExSpec;", "", "regex", "", "(Ljava/lang/String;)V", "isFinite", "", "originalRegex", "doesNotStartWithRegexDelimiters", "generateFromRegex", "minLength", "", "maxLength", "(Ljava/lang/String;ILjava/lang/Integer;)Ljava/lang/String;", "generateLongestStringOrRandom", "maxLen", "generateRandomString", "Lio/specmatic/core/value/Value;", "(ILjava/lang/Integer;)Lio/specmatic/core/value/Value;", "generateShortestString", "generateShortestStringOrRandom", "minLen", "longestFrom", "state", "Ldk/brics/automaton/State;", "remaining", "memo", "", "Lkotlin/Pair;", "match", "sampleData", "Lio/specmatic/core/value/StringValue;", "patternBaseLength", "(ILjava/lang/Integer;)I", "toString", "validateMaxLength", "", "(Ljava/lang/Integer;)V", "validateMinLength", "replaceRegexLowerBounds", "replaceShorthandEscapeSeq", "validateRegex", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nRegExSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegExSpec.kt\nio/specmatic/core/pattern/RegExSpec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1#2:192\n1855#3,2:193\n*S KotlinDebug\n*F\n+ 1 RegExSpec.kt\nio/specmatic/core/pattern/RegExSpec\n*L\n143#1:193,2\n*E\n"})
public final class RegExSpec {
    @Nullable
    private final String originalRegex;
    @Nullable
    private final String regex;
    private final boolean isFinite;

    /*
     * WARNING - void declaration
     */
    public RegExSpec(@Nullable String regex) {
        String string;
        this.originalRegex = regex;
        RegExSpec regExSpec = this;
        String string2 = regex;
        if (string2 != null) {
            void it;
            String string3 = string2;
            RegExSpec regExSpec2 = regExSpec;
            boolean bl = false;
            string = this.validateRegex(this.replaceShorthandEscapeSeq(StringsKt.removeSuffix(StringsKt.removePrefix(StringsKt.removeSuffix(StringsKt.removePrefix(this.replaceRegexLowerBounds(this.doesNotStartWithRegexDelimiters((String)it)), (CharSequence)"^"), (CharSequence)"$"), (CharSequence)"\\b"), (CharSequence)"\\b")));
            regExSpec = regExSpec2;
        } else {
            string = null;
        }
        regExSpec.regex = string;
        this.isFinite = this.regex != null && !new Generex(this.regex).isInfinite();
    }

    private final String doesNotStartWithRegexDelimiters(String regex) {
        if (StringsKt.startsWith$default(regex, "/", false, 2, null) && StringsKt.endsWith$default(regex, "/", false, 2, null)) {
            throw new IllegalArgumentException("Invalid regex " + this.originalRegex + ". OpenAPI follows ECMA-262 regular expressions, which do not support / / delimiters like those used in many programming languages");
        }
        return regex;
    }

    public final void validateMinLength(@Nullable Integer minLength) {
        if (this.regex == null) {
            return;
        }
        Integer n = minLength;
        if (n != null) {
            String longestString;
            int it = ((Number)n).intValue();
            boolean bl = false;
            String shortestString = this.generateShortestString();
            if (it > shortestString.length() && this.isFinite && (longestString = this.generateLongestStringOrRandom(it)).length() < it) {
                throw new IllegalArgumentException("minLength " + it + " cannot be greater than the length of longest possible string that matches regex " + this.originalRegex);
            }
        }
    }

    public final void validateMaxLength(@Nullable Integer maxLength) {
        if (this.regex == null) {
            return;
        }
        Integer n = maxLength;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            String shortestPossibleString = this.generateShortestString();
            if (shortestPossibleString.length() > it) {
                throw new IllegalArgumentException("maxLength " + it + " cannot be less than the length of shortest possible string that matches regex " + this.originalRegex);
            }
        }
    }

    @NotNull
    public final String generateShortestStringOrRandom(int minLen) {
        if (this.regex == null) {
            return StringPatternKt.randomString(minLen);
        }
        String shortestExample = this.generateShortestString();
        if (minLen <= shortestExample.length()) {
            return shortestExample;
        }
        String string = new Generex(this.regex).random(minLen, minLen);
        Intrinsics.checkNotNullExpressionValue(string, "random(...)");
        return string;
    }

    private final String generateShortestString() {
        String string;
        String string2;
        String string3 = this.regex;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string2 = new RegExp(it).toAutomaton().getShortestExample(true);
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String generateLongestStringOrRandom(int maxLen) {
        if (this.regex == null) {
            return StringPatternKt.randomString(maxLen);
        }
        Generex generex = new Generex(this.regex);
        if (generex.isInfinite()) {
            String string = generex.random(maxLen, maxLen);
            Intrinsics.checkNotNullExpressionValue(string, "random(...)");
            return string;
        }
        Automaton automaton = new RegExp(this.regex).toAutomaton();
        State state = automaton.getInitialState();
        Intrinsics.checkNotNullExpressionValue(state, "getInitialState(...)");
        String string = this.longestFrom(state, maxLen, new LinkedHashMap());
        if (string == null) {
            throw new IllegalStateException("No valid string found");
        }
        return string;
    }

    public final boolean match(@NotNull StringValue sampleData) {
        boolean bl;
        Intrinsics.checkNotNullParameter(sampleData, "sampleData");
        String string = this.regex;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = new Regex(it).matches(sampleData.toStringLiteral());
        } else {
            bl = true;
        }
        return bl;
    }

    private final String replaceRegexLowerBounds(String $this$replaceRegexLowerBounds) {
        Regex pattern2 = new Regex("\\{,(\\d+)}");
        CharSequence charSequence = $this$replaceRegexLowerBounds;
        Function1 function1 = replaceRegexLowerBounds.1.INSTANCE;
        return pattern2.replace(charSequence, function1);
    }

    private final String validateRegex(String $this$validateRegex) {
        Object $this$validateRegex_u24lambda_u245;
        Object object = $this$validateRegex;
        try {
            $this$validateRegex_u24lambda_u245 = object;
            boolean bl = false;
            String random2 = new Generex((String)$this$validateRegex_u24lambda_u245).random();
            Regex regex = new Regex((String)$this$validateRegex_u24lambda_u245);
            Intrinsics.checkNotNull(random2);
            if (!regex.matches(random2)) {
                LoggingKt.getLogger().log("WARNING: Please check the regex " + this.originalRegex + ". We generated a random string " + random2 + " and the regex does not match the string.");
            }
            $this$validateRegex_u24lambda_u245 = Result.constructor-impl($this$validateRegex_u24lambda_u245);
        }
        catch (Throwable bl) {
            $this$validateRegex_u24lambda_u245 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object = $this$validateRegex_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable e2 = throwable;
            boolean bl = false;
            throw new IllegalArgumentException("Failed to parse regex " + this.originalRegex + "\nReason: " + e2.getMessage());
        }
        return (String)object;
    }

    private final String replaceShorthandEscapeSeq(String $this$replaceShorthandEscapeSeq) {
        Regex charClassRegex = new Regex("\\[(?:\\\\.|[^\\]])*]");
        return charClassRegex.replace((CharSequence)$this$replaceShorthandEscapeSeq, replaceShorthandEscapeSeq.1.INSTANCE);
    }

    private final String longestFrom(State state, int remaining, Map<Pair<State, Integer>, String> memo) {
        Pair<State, Integer> key2 = TuplesKt.to(state, remaining);
        String string = memo.get(key2);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        Object best = null;
        Object object = best = state.isAccept() ? "" : null;
        if (remaining > 0) {
            Set<Transition> set2 = state.getTransitions();
            Intrinsics.checkNotNullExpressionValue(set2, "getTransitions(...)");
            Iterable $this$forEach$iv = set2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Transition t2 = (Transition)element$iv;
                boolean bl = false;
                State state2 = t2.getDest();
                Intrinsics.checkNotNullExpressionValue(state2, "getDest(...)");
                String sub2 = this.longestFrom(state2, remaining - 1, memo);
                if (sub2 != null) {
                    String it;
                    boolean bl2 = false;
                    String candidate = t2.getMax() + it;
                    best = best == null ? candidate : (candidate.length() > ((String)best).length() ? candidate : (candidate.length() == ((String)best).length() && candidate.compareTo((String)best) > 0 ? candidate : best));
                }
            }
        }
        memo.put(key2, (String)best);
        return best;
    }

    @NotNull
    public final Value generateRandomString(int minLength, @Nullable Integer maxLength) {
        Value value2;
        String string = this.regex;
        if (string != null) {
            String it = string;
            boolean bl = false;
            value2 = new StringValue(this.generateFromRegex(it, minLength, maxLength));
        } else {
            value2 = new StringValue(StringPatternKt.randomString(this.patternBaseLength(minLength, maxLength)));
        }
        return value2;
    }

    public static /* synthetic */ Value generateRandomString$default(RegExSpec regExSpec, int n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        return regExSpec.generateRandomString(n, n2);
    }

    private final int patternBaseLength(int minLength, Integer maxLength) {
        return 5 < minLength ? minLength : (maxLength != null && 5 > maxLength ? maxLength : 5);
    }

    private final String generateFromRegex(String regex, int minLength, Integer maxLength) {
        String string;
        try {
            string = maxLength == null ? new Generex(regex).random(minLength) : new Generex(regex).random(minLength, maxLength);
            Intrinsics.checkNotNull(string);
        }
        catch (StackOverflowError e2) {
            string = this.generateFromRegex(regex, minLength, maxLength);
        }
        return string;
    }

    static /* synthetic */ String generateFromRegex$default(RegExSpec regExSpec, String string, int n, Integer n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return regExSpec.generateFromRegex(string, n, n2);
    }

    @NotNull
    public String toString() {
        String string = this.regex;
        if (string == null) {
            string = "regex not set";
        }
        return string;
    }
}

