/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.pattern;

import io.specmatic.core.Resolver;
import io.specmatic.core.Result;
import io.specmatic.core.pattern.HasValue;
import io.specmatic.core.pattern.PairOfTypes;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.ReturnValue;
import io.specmatic.core.pattern.Row;
import io.specmatic.core.pattern.ScalarType;
import io.specmatic.core.pattern.StringPatternKt;
import io.specmatic.core.pattern.URLScheme;
import io.specmatic.core.pattern.config.NegativePatternConfiguration;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u001f\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J2\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001cH\u0016J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0017H\u0016J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u001e\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0)2\u0006\u0010#\u001a\u00020\u0017H\u0016J\u001a\u0010*\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010'2\u0006\u0010#\u001a\u00020\u0017H\u0016J,\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010.0-2\u0006\u0010/\u001a\u0002002\u0006\u0010#\u001a\u00020\u00172\u0006\u00101\u001a\u000202H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u00010-2\u0006\u0010#\u001a\u00020\u0017H\u0016J$\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010.0-2\u0006\u0010/\u001a\u0002002\u0006\u0010#\u001a\u00020\u0017H\u0016J\u0018\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0017H\u0016J\t\u00106\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\b\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u00067"}, d2={"Lio/specmatic/core/pattern/URLPattern;", "Lio/specmatic/core/pattern/Pattern;", "Lio/specmatic/core/pattern/ScalarType;", "scheme", "Lio/specmatic/core/pattern/URLScheme;", "typeAlias", "", "(Lio/specmatic/core/pattern/URLScheme;Ljava/lang/String;)V", "pattern", "getPattern", "()Ljava/lang/String;", "getScheme", "()Lio/specmatic/core/pattern/URLScheme;", "getTypeAlias", "typeName", "getTypeName", "component1", "component2", "copy", "encompasses", "Lio/specmatic/core/Result;", "otherPattern", "thisResolver", "Lio/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lio/specmatic/core/pattern/PairOfTypes;", "Lio/specmatic/core/pattern/TypeStack;", "equals", "", "other", "", "generate", "Lio/specmatic/core/value/StringValue;", "resolver", "hashCode", "", "listOf", "Lio/specmatic/core/value/Value;", "valueList", "", "matches", "sampleData", "negativeBasedOn", "Lkotlin/sequences/Sequence;", "Lio/specmatic/core/pattern/ReturnValue;", "row", "Lio/specmatic/core/pattern/Row;", "config", "Lio/specmatic/core/pattern/config/NegativePatternConfiguration;", "newBasedOn", "parse", "value", "toString", "specmatic-core"})
public final class URLPattern
implements Pattern,
ScalarType {
    @NotNull
    private final URLScheme scheme;
    @Nullable
    private final String typeAlias;
    @NotNull
    private final String pattern;
    @NotNull
    private final String typeName;

    public URLPattern(@NotNull URLScheme scheme2, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)scheme2, "scheme");
        this.scheme = scheme2;
        this.typeAlias = typeAlias;
        this.pattern = "(url)";
        this.typeName = "url";
    }

    public /* synthetic */ URLPattern(URLScheme uRLScheme, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uRLScheme = URLScheme.HTTPS;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(uRLScheme, string);
    }

    @NotNull
    public final URLScheme getScheme() {
        return this.scheme;
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return this.typeAlias;
    }

    @Override
    @NotNull
    public String getPattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return sampleData instanceof StringValue ? (this.scheme.matches(this.parse(((StringValue)sampleData).getString(), resolver)) ? (Result)new Result.Success(null, null, 3, null) : (Result)new Result.Failure("Expected " + ((StringValue)sampleData).getString() + " to be " + this.scheme.getType(), null, null, null, null, 30, null)) : (Result)new Result.Failure("URLs can only be held in strings.", null, null, null, null, 30, null);
    }

    @Override
    @NotNull
    public StringValue generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        StringValue providedString = resolver.provideString(this);
        StringValue stringValue = providedString;
        if (stringValue == null) {
            String string = this.scheme.getPrefix();
            String string2 = StringPatternKt.randomString$default(0, 1, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            String string3 = StringPatternKt.randomString$default(0, 1, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            stringValue = new StringValue(string + string2 + ".com/" + string3);
        }
        return stringValue;
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(row, "row");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        HasValue[] hasValueArray = new HasValue[]{new HasValue(this, null, 2, null)};
        return SequencesKt.sequenceOf(hasValueArray);
    }

    @Override
    @NotNull
    public Sequence<Pattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        URLPattern[] uRLPatternArray = new URLPattern[]{this};
        return SequencesKt.sequenceOf(uRLPatternArray);
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver, @NotNull NegativePatternConfiguration config2) {
        Intrinsics.checkNotNullParameter(row, "row");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Intrinsics.checkNotNullParameter(config2, "config");
        return this.newBasedOn(row, resolver);
    }

    @Override
    @NotNull
    public StringValue parse(@NotNull String value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        String string = URI.create(value2).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return new StringValue(string);
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter(otherPattern, "otherPattern");
        Intrinsics.checkNotNullParameter(thisResolver, "thisResolver");
        Intrinsics.checkNotNullParameter(otherResolver, "otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, "typeStack");
        Pattern pattern2 = otherPattern;
        return Intrinsics.areEqual(pattern2, this) ? (Result)new Result.Success(null, null, 3, null) : (pattern2 instanceof URLPattern ? (Result)new Result.Failure("Expected " + this.scheme.getType() + ", got " + ((URLPattern)otherPattern).scheme.getType(), null, null, null, null, 30, null) : (Result)new Result.Failure("Expected " + this.getTypeName() + ", got " + otherPattern.getTypeName(), null, null, null, null, 30, null));
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, "valueList");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final URLScheme component1() {
        return this.scheme;
    }

    @Nullable
    public final String component2() {
        return this.typeAlias;
    }

    @NotNull
    public final URLPattern copy(@NotNull URLScheme scheme2, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)scheme2, "scheme");
        return new URLPattern(scheme2, typeAlias);
    }

    public static /* synthetic */ URLPattern copy$default(URLPattern uRLPattern, URLScheme uRLScheme, String string, int n, Object object) {
        if ((n & 1) != 0) {
            uRLScheme = uRLPattern.scheme;
        }
        if ((n & 2) != 0) {
            string = uRLPattern.typeAlias;
        }
        return uRLPattern.copy(uRLScheme, string);
    }

    @NotNull
    public String toString() {
        return "URLPattern(scheme=" + this.scheme + ", typeAlias=" + this.typeAlias + ")";
    }

    public int hashCode() {
        int result2 = this.scheme.hashCode();
        result2 = result2 * 31 + (this.typeAlias == null ? 0 : this.typeAlias.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof URLPattern)) {
            return false;
        }
        URLPattern uRLPattern = (URLPattern)other;
        if (this.scheme != uRLPattern.scheme) {
            return false;
        }
        return Intrinsics.areEqual(this.typeAlias, uRLPattern.typeAlias);
    }

    public URLPattern() {
        this(null, null, 3, null);
    }
}

