/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.utilities;

import io.specmatic.core.git.NonZeroExitError;
import io.specmatic.core.git.SystemGit;
import io.specmatic.core.git.SystemGitKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"commitAndPush", "", "sourceGit", "Lio/specmatic/core/git/SystemGit;", "specmatic-core"})
public final class ContractSourceKt {
    public static final void commitAndPush(@NotNull SystemGit sourceGit) {
        boolean bl;
        Intrinsics.checkNotNullParameter(sourceGit, "sourceGit");
        try {
            sourceGit.commit();
            bl = true;
        }
        catch (NonZeroExitError e2) {
            if (!SystemGitKt.exitErrorMessageContains(e2, CollectionsKt.listOf("nothing to commit"))) {
                throw e2;
            }
            bl = SystemGitKt.exitErrorMessageContains(e2, CollectionsKt.listOf("branch is ahead of"));
        }
        boolean pushRequired = bl;
        if (pushRequired) {
            System.out.println((Object)"Pushing changes");
            sourceGit.push();
        } else {
            System.out.println((Object)"No changes were made to the repo, so nothing was pushed.");
        }
    }
}

