/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.utilities;

import io.specmatic.core.git.NonZeroExitError;
import io.specmatic.core.pattern.ContractException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\f\u001a\u00020\u0003R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/specmatic/core/utilities/ExternalCommand;", "", "command", "", "workingDirect", "environmentParameters", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "", "([Ljava/lang/String;Ljava/lang/String;)V", "([Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "[Ljava/lang/String;", "executeAsSeparateProcess", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nExternalCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalCommand.kt\nio/specmatic/core/utilities/ExternalCommand\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,43:1\n37#2,2:44\n*S KotlinDebug\n*F\n+ 1 ExternalCommand.kt\nio/specmatic/core/utilities/ExternalCommand\n*L\n16#1:44,2\n*E\n"})
public final class ExternalCommand {
    @NotNull
    private final String[] command;
    @NotNull
    private final String workingDirect;
    @NotNull
    private final Map<String, String> environmentParameters;

    public ExternalCommand(@NotNull String[] command2, @NotNull String workingDirect, @NotNull Map<String, String> environmentParameters) {
        Intrinsics.checkNotNullParameter(command2, "command");
        Intrinsics.checkNotNullParameter(workingDirect, "workingDirect");
        Intrinsics.checkNotNullParameter(environmentParameters, "environmentParameters");
        this.command = command2;
        this.workingDirect = workingDirect;
        this.environmentParameters = environmentParameters;
    }

    public ExternalCommand(@NotNull String command2, @NotNull String workingDirect, @NotNull Map<String, String> environmentParameters) {
        Intrinsics.checkNotNullParameter(command2, "command");
        Intrinsics.checkNotNullParameter(workingDirect, "workingDirect");
        Intrinsics.checkNotNullParameter(environmentParameters, "environmentParameters");
        String[] stringArray = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)command2, stringArray, false, 0, 6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this(thisCollection$iv.toArray(new String[0]), workingDirect, environmentParameters);
    }

    public ExternalCommand(@NotNull String[] command2, @NotNull String workingDirect) {
        Intrinsics.checkNotNullParameter(command2, "command");
        Intrinsics.checkNotNullParameter(workingDirect, "workingDirect");
        this(command2, workingDirect, MapsKt.emptyMap());
    }

    @NotNull
    public final String executeAsSeparateProcess() {
        String string;
        String commandWithParameters = ArraysKt.joinToString$default(this.command, (CharSequence)" ", null, null, 0, null, null, 62, null);
        try {
            ProcessBuilder procBuilder = new ProcessBuilder(ArraysKt.asList(this.command)).directory(new File(this.workingDirect));
            Map<String, String> env = procBuilder.environment();
            env.putAll(this.environmentParameters);
            Process proc = procBuilder.start();
            InputStream inputStream2 = proc.getInputStream();
            Intrinsics.checkNotNullExpressionValue(inputStream2, "getInputStream(...)");
            InputStream inputStream3 = inputStream2;
            Object object = Charsets.UTF_8;
            Object object2 = new InputStreamReader(inputStream3, (Charset)object);
            int n = 8192;
            String out2 = TextStreamsKt.readText(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n));
            InputStream inputStream4 = proc.getErrorStream();
            Intrinsics.checkNotNullExpressionValue(inputStream4, "getErrorStream(...)");
            object = inputStream4;
            object2 = Charsets.UTF_8;
            Reader reader2 = new InputStreamReader((InputStream)object, (Charset)object2);
            int n2 = 8192;
            String err = TextStreamsKt.readText(reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, n2));
            int exitCode = proc.waitFor();
            if (exitCode != 0) {
                throw new NonZeroExitError("Error executing " + commandWithParameters + System.lineSeparator() + "ERRORS: " + err + System.lineSeparator() + System.lineSeparator() + out2 + System.lineSeparator() + System.lineSeparator(), exitCode);
            }
            string = out2;
        }
        catch (Exception otherExceptions) {
            throw new ContractException("Error running " + commandWithParameters + ": " + otherExceptions.getMessage(), null, otherExceptions, null, false, 26, null);
        }
        return string;
    }
}

