/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.utilities;

import io.specmatic.core.git.GitCommand;
import io.specmatic.core.git.GitOperations;
import io.specmatic.core.git.SystemGit;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.utilities.ContractPathData;
import io.specmatic.core.utilities.ContractSource;
import io.specmatic.core.utilities.ContractSourceEntry;
import io.specmatic.core.utilities.ContractSourceKt;
import io.specmatic.core.utilities.ContractsSelectorPredicate;
import io.specmatic.core.utilities.GitSource;
import io.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0000H\u0002J\t\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003JU\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0019H\u0016J\u0013\u0010%\u001a\u00020\f2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\t\u0010,\u001a\u00020-H\u00d6\u0001J\u0010\u0010.\u001a\u00020)2\u0006\u0010$\u001a\u00020\u0019H\u0016J\u0010\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\u0019H\u0002J\u0010\u00101\u001a\u00020\f2\u0006\u00100\u001a\u00020\u0019H\u0002J\u0018\u00102\u001a\u00020\f2\u0006\u0010*\u001a\u00020+2\u0006\u00103\u001a\u00020\u0019H\u0002J\u0010\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\u0019H\u0002J&\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00072\u0006\u00108\u001a\u0002092\u0006\u0010$\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u0004H\u0016J\u0010\u0010;\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0010\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004H\u0016J\u0010\u0010>\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J(\u0010?\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040@0\u00072\f\u0010A\u001a\b\u0012\u0004\u0012\u0002070\u0007H\u0016J\t\u0010B\u001a\u00020\u0004H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0016\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006C"}, d2={"Lio/specmatic/core/utilities/GitRepo;", "Lio/specmatic/core/utilities/ContractSource;", "Lio/specmatic/core/utilities/GitSource;", "gitRepositoryURL", "", "branchName", "testContracts", "", "Lio/specmatic/core/utilities/ContractSourceEntry;", "stubContracts", "type", "useCurrentBranchForCentralRepo", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Z)V", "getBranchName", "()Ljava/lang/String;", "getGitRepositoryURL", "repoName", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "getType", "getUseCurrentBranchForCentralRepo", "()Z", "cloneRepoAndCheckoutBranch", "Ljava/io/File;", "reposBaseDir", "gitRepo", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "directoryRelativeTo", "workingDirectory", "equals", "other", "", "getLatest", "", "sourceGit", "Lio/specmatic/core/git/SystemGit;", "hashCode", "", "install", "isBehind", "contractsRepoDir", "isClean", "isEmptyNestedGitDirectory", "sourceDir", "isNotOnBranch", "contractRepoDir", "loadContracts", "Lio/specmatic/core/utilities/ContractPathData;", "selector", "Lio/specmatic/core/utilities/ContractsSelectorPredicate;", "configFilePath", "localRepoDir", "pathDescriptor", "path", "pushUpdates", "stubDirectoryToContractPath", "Lkotlin/Pair;", "contractPathDataList", "toString", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nGitRepo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepo.kt\nio/specmatic/core/utilities/GitRepo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1549#2:171\n1620#2,3:172\n1603#2,9:175\n1855#2:184\n288#2,2:185\n1856#2:188\n1612#2:189\n1#3:187\n*S KotlinDebug\n*F\n+ 1 GitRepo.kt\nio/specmatic/core/utilities/GitRepo\n*L\n88#1:171\n88#1:172,3\n103#1:175,9\n103#1:184\n104#1:185,2\n103#1:188\n103#1:189\n103#1:187\n*E\n"})
public final class GitRepo
implements ContractSource,
GitSource {
    @NotNull
    private final String gitRepositoryURL;
    @Nullable
    private final String branchName;
    @NotNull
    private final List<ContractSourceEntry> testContracts;
    @NotNull
    private final List<ContractSourceEntry> stubContracts;
    @Nullable
    private final String type;
    private final boolean useCurrentBranchForCentralRepo;
    @NotNull
    private final String repoName;

    public GitRepo(@NotNull String gitRepositoryURL, @Nullable String branchName, @NotNull List<ContractSourceEntry> testContracts, @NotNull List<ContractSourceEntry> stubContracts, @Nullable String type2, boolean useCurrentBranchForCentralRepo) {
        Intrinsics.checkNotNullParameter(gitRepositoryURL, "gitRepositoryURL");
        Intrinsics.checkNotNullParameter(testContracts, "testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, "stubContracts");
        this.gitRepositoryURL = gitRepositoryURL;
        this.branchName = branchName;
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
        this.type = type2;
        this.useCurrentBranchForCentralRepo = useCurrentBranchForCentralRepo;
        String[] stringArray = new String[]{"/"};
        this.repoName = StringsKt.removeSuffix((String)CollectionsKt.last(StringsKt.split$default((CharSequence)this.gitRepositoryURL, stringArray, false, 0, 6, null)), (CharSequence)".git");
    }

    public /* synthetic */ GitRepo(String string, String string2, List list, List list2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(string, string2, list, list2, string3, bl);
    }

    @NotNull
    public final String getGitRepositoryURL() {
        return this.gitRepositoryURL;
    }

    @Nullable
    public final String getBranchName() {
        return this.branchName;
    }

    @Override
    @NotNull
    public List<ContractSourceEntry> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<ContractSourceEntry> getStubContracts() {
        return this.stubContracts;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    public final boolean getUseCurrentBranchForCentralRepo() {
        return this.useCurrentBranchForCentralRepo;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        return this.repoName + ":" + path2;
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        return FilesKt.resolve(workingDirectory, this.repoName);
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter(sourceGit, "sourceGit");
        sourceGit.pull();
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter(sourceGit, "sourceGit");
        ContractSourceKt.commitAndPush(sourceGit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContractPathData> loadContracts(@NotNull ContractsSelectorPredicate selector, @NotNull String workingDirectory, @NotNull String configFilePath) {
        void $this$mapTo$iv$iv;
        File file2;
        Intrinsics.checkNotNullParameter(selector, "selector");
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(configFilePath, "configFilePath");
        File userHome = new File(System.getProperty("user.home"));
        File defaultSpecmaticWorkingDir = FilesKt.resolve(userHome, ".specmatic/repos");
        File defaultRepoDir = this.directoryRelativeTo(defaultSpecmaticWorkingDir);
        File bundleDir = FilesKt.resolve(new File(".specmatic_test_bundle"), this.repoName);
        if (bundleDir.exists()) {
            LoggingKt.getLogger().log("Using contracts from " + bundleDir.getPath());
            file2 = bundleDir;
        } else if (defaultRepoDir.exists()) {
            LoggingKt.getLogger().log("Using contracts in home dir");
            file2 = defaultRepoDir;
        } else {
            File reposBaseDir = this.localRepoDir(workingDirectory);
            File contractsRepoDir = this.directoryRelativeTo(reposBaseDir);
            LoggingKt.getLogger().log("Looking for a contract repo checkout at: " + contractsRepoDir.getCanonicalPath());
            if (!contractsRepoDir.exists()) {
                LoggingKt.getLogger().log("Contract repo dir does not exist.");
                file2 = this.cloneRepoAndCheckoutBranch(reposBaseDir, this);
            } else if (this.isNotOnBranch(contractsRepoDir)) {
                LoggingKt.getLogger().log("Contract repo exists but is not on the correct branch.");
                file2 = this.cloneRepoAndCheckoutBranch(reposBaseDir, this);
            } else if (this.isBehind(contractsRepoDir)) {
                LoggingKt.getLogger().log("Contract repo exists but is behind the remote.");
                file2 = this.cloneRepoAndCheckoutBranch(reposBaseDir, this);
            } else if (this.isClean(contractsRepoDir)) {
                LoggingKt.getLogger().log("Contract repo exists, is clean, and is up to date with remote.");
                file2 = contractsRepoDir;
            } else {
                LoggingKt.getLogger().log("Contract repo exists, but it is not clean.");
                file2 = this.cloneRepoAndCheckoutBranch(reposBaseDir, this);
            }
        }
        File repoDir = file2;
        Iterable $this$map$iv = selector.select(this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ContractSourceEntry contractSourceEntry = (ContractSourceEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = repoDir.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
            String string2 = FilesKt.resolve(repoDir, it.getPath()).getPath();
            Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
            collection.add(new ContractPathData(string, string2, this.getType(), this.gitRepositoryURL, this.branchName, it.getPath(), it.getBaseUrl(), it.getGenerative(), null, 256, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<String, String>> stubDirectoryToContractPath(@NotNull List<ContractPathData> contractPathDataList) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(contractPathDataList, "contractPathDataList");
        Iterable $this$mapNotNull$iv = this.getStubContracts();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<String, String> pair;
            String string;
            Object v1;
            ContractSourceEntry contractSourceEntry;
            block5: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                contractSourceEntry = (ContractSourceEntry)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$firstOrNull$iv = contractPathDataList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ContractPathData it = (ContractPathData)element$iv;
                    boolean bl3 = false;
                    String string2 = it.getSpecificationPath();
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (!Intrinsics.areEqual(string2, contractSourceEntry.getPath())) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            ContractPathData contractPathData = v1;
            if (contractPathData == null || (string = contractPathData.getBaseDir()) == null) {
                pair = null;
            } else {
                String directory = string;
                pair = TuplesKt.to(directory, contractSourceEntry.getPath());
            }
            if (pair == null) continue;
            Pair<String, String> it$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isNotOnBranch(File contractRepoDir) {
        String currentBranch;
        String expectedBranch;
        String string = contractRepoDir.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        GitCommand sourceGit = Utilities.getSystemGit(string);
        String string2 = this.branchName;
        if (string2 == null) {
            string2 = sourceGit.getOriginDefaultBranchName();
        }
        return !Intrinsics.areEqual(expectedBranch = string2, currentBranch = sourceGit.currentBranch());
    }

    private final boolean isClean(File contractsRepoDir) {
        String string = contractsRepoDir.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        GitCommand sourceGit = Utilities.getSystemGit(string);
        return ((CharSequence)sourceGit.statusPorcelain()).length() == 0;
    }

    private final boolean isBehind(File contractsRepoDir) {
        String string = contractsRepoDir.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        GitCommand sourceGit = Utilities.getSystemGitWithAuth(string);
        sourceGit.fetch();
        return sourceGit.revisionsBehindCount() > 0;
    }

    private final File cloneRepoAndCheckoutBranch(File reposBaseDir, GitRepo gitRepo) {
        LoggingKt.getLogger().log("Cloning " + this.gitRepositoryURL + " into " + reposBaseDir.getPath());
        reposBaseDir.mkdirs();
        File repositoryDirectory = GitOperations.clone(reposBaseDir, gitRepo);
        if (this.branchName == null) {
            LoggingKt.getLogger().log("No branch specified, using default branch");
        } else {
            GitOperations.checkout(repositoryDirectory, this.branchName, this.useCurrentBranchForCentralRepo);
        }
        return repositoryDirectory;
    }

    private final File localRepoDir(String workingDirectory) {
        return FilesKt.resolve(new File(workingDirectory), "repos");
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        File baseReposDirectory = FilesKt.resolve(workingDirectory, "repos");
        File sourceDir = FilesKt.resolve(baseReposDirectory, this.repoName);
        String string = sourceDir.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        SystemGit sourceGit = new SystemGit(string, null, null, 6, null);
        try {
            System.out.println((Object)("Checking " + sourceDir.getPath()));
            if (!sourceDir.exists()) {
                sourceDir.mkdirs();
            }
            if (!sourceGit.workingDirectoryIsGitRepo() || this.isEmptyNestedGitDirectory(sourceGit, sourceDir)) {
                System.out.println((Object)"Found it, not a git dir, recreating...");
                FilesKt.deleteRecursively(sourceDir);
                sourceDir.mkdirs();
                System.out.println((Object)("Cloning " + this.gitRepositoryURL + " into " + sourceDir.getCanonicalPath()));
                File file2 = sourceDir.getCanonicalFile().getParentFile();
                Intrinsics.checkNotNullExpressionValue(file2, "getParentFile(...)");
                this.cloneRepoAndCheckoutBranch(file2, this);
            } else {
                System.out.println((Object)("Git repo already exists at " + sourceDir.getPath() + ", so ignoring it and moving on"));
            }
        }
        catch (Throwable e2) {
            System.out.println((Object)("Could not clone " + this.gitRepositoryURL + "\n" + e2.getClass().getName() + ": " + Utilities.exceptionCauseMessage(e2)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEmptyNestedGitDirectory(SystemGit sourceGit, File sourceDir) {
        if (!sourceGit.workingDirectoryIsGitRepo()) return false;
        if (Intrinsics.areEqual(GitCommand.getRemoteUrl$default(sourceGit, null, 1, null), this.gitRepositoryURL)) return false;
        File[] fileArray = sourceDir.listFiles();
        if (fileArray == null) return false;
        if (fileArray.length != 0) return false;
        return true;
    }

    @NotNull
    public final String component1() {
        return this.gitRepositoryURL;
    }

    @Nullable
    public final String component2() {
        return this.branchName;
    }

    @NotNull
    public final List<ContractSourceEntry> component3() {
        return this.testContracts;
    }

    @NotNull
    public final List<ContractSourceEntry> component4() {
        return this.stubContracts;
    }

    @Nullable
    public final String component5() {
        return this.type;
    }

    public final boolean component6() {
        return this.useCurrentBranchForCentralRepo;
    }

    @NotNull
    public final GitRepo copy(@NotNull String gitRepositoryURL, @Nullable String branchName, @NotNull List<ContractSourceEntry> testContracts, @NotNull List<ContractSourceEntry> stubContracts, @Nullable String type2, boolean useCurrentBranchForCentralRepo) {
        Intrinsics.checkNotNullParameter(gitRepositoryURL, "gitRepositoryURL");
        Intrinsics.checkNotNullParameter(testContracts, "testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, "stubContracts");
        return new GitRepo(gitRepositoryURL, branchName, testContracts, stubContracts, type2, useCurrentBranchForCentralRepo);
    }

    public static /* synthetic */ GitRepo copy$default(GitRepo gitRepo, String string, String string2, List list, List list2, String string3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = gitRepo.gitRepositoryURL;
        }
        if ((n & 2) != 0) {
            string2 = gitRepo.branchName;
        }
        if ((n & 4) != 0) {
            list = gitRepo.testContracts;
        }
        if ((n & 8) != 0) {
            list2 = gitRepo.stubContracts;
        }
        if ((n & 0x10) != 0) {
            string3 = gitRepo.type;
        }
        if ((n & 0x20) != 0) {
            bl = gitRepo.useCurrentBranchForCentralRepo;
        }
        return gitRepo.copy(string, string2, list, list2, string3, bl);
    }

    @NotNull
    public String toString() {
        return "GitRepo(gitRepositoryURL=" + this.gitRepositoryURL + ", branchName=" + this.branchName + ", testContracts=" + this.testContracts + ", stubContracts=" + this.stubContracts + ", type=" + this.type + ", useCurrentBranchForCentralRepo=" + this.useCurrentBranchForCentralRepo + ")";
    }

    public int hashCode() {
        int result2 = this.gitRepositoryURL.hashCode();
        result2 = result2 * 31 + (this.branchName == null ? 0 : this.branchName.hashCode());
        result2 = result2 * 31 + ((Object)this.testContracts).hashCode();
        result2 = result2 * 31 + ((Object)this.stubContracts).hashCode();
        result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.useCurrentBranchForCentralRepo);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitRepo)) {
            return false;
        }
        GitRepo gitRepo = (GitRepo)other;
        if (!Intrinsics.areEqual(this.gitRepositoryURL, gitRepo.gitRepositoryURL)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.branchName, gitRepo.branchName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.testContracts, gitRepo.testContracts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stubContracts, gitRepo.stubContracts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.type, gitRepo.type)) {
            return false;
        }
        return this.useCurrentBranchForCentralRepo == gitRepo.useCurrentBranchForCentralRepo;
    }
}

