/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.utilities;

import io.specmatic.core.Configuration;
import io.specmatic.core.HttpRequest;
import io.specmatic.core.HttpRequestKt;
import io.specmatic.core.KeyData;
import io.specmatic.core.Resolver;
import io.specmatic.core.Result;
import io.specmatic.core.SpecmaticConfigKt;
import io.specmatic.core.azure.AzureAuthCredentials;
import io.specmatic.core.git.GitCommand;
import io.specmatic.core.git.SystemGit;
import io.specmatic.core.log.LogStrategy;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.pattern.NullPattern;
import io.specmatic.core.pattern.NumberPattern;
import io.specmatic.core.utilities.ContractPathData;
import io.specmatic.core.utilities.ContractSource;
import io.specmatic.core.utilities.ContractSourceEntry;
import io.specmatic.core.utilities.ContractsSelectorPredicate;
import io.specmatic.core.utilities.GitMonoRepo;
import io.specmatic.core.utilities.GitRepo;
import io.specmatic.core.utilities.LocalFileSystemSource;
import io.specmatic.core.utilities.SystemExit;
import io.specmatic.core.utilities.URIValidationResult;
import io.specmatic.core.utilities.Utilities;
import io.specmatic.core.utilities.WebSource;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00c4\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\b\u001a&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\b\u001a\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u000e\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u001a\u001c\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00012\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u001a\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0001\u001a\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0001H\u0002\u001a\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0001\u001a\u000e\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0001\u001a\u0012\u0010.\u001a\u00020/2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u0001\u001a\u0006\u00101\u001a\u00020\u0001\u001a\u0018\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001e\u00104\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0001H\u0000\u001a\u000e\u00108\u001a\u0002062\u0006\u00109\u001a\u00020\u001a\u001a\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\f2\u0006\u0010<\u001a\u000206\u001a\u001e\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\f2\u0006\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\b\u001a\u000e\u0010=\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0006\u0010>\u001a\u00020?\u001a\u0016\u0010@\u001a\u0004\u0018\u00010\u00012\f\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B\u001a\u000e\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u0001\u001a\u0018\u0010G\u001a\u0004\u0018\u00010\u00012\u0006\u0010H\u001a\u00020\u00012\u0006\u0010I\u001a\u00020\u0001\u001a\u000e\u0010J\u001a\u00020\u00012\u0006\u0010K\u001a\u00020\u0001\u001a\u000e\u0010L\u001a\u00020E2\u0006\u0010M\u001a\u00020E\u001a\u000e\u0010L\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n\u001a'\u0010N\u001a\u0002HO\"\u0004\b\u0000\u0010O2\u0006\u0010P\u001a\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u0002HO0S\u00a2\u0006\u0002\u0010T\u001a\u0010\u0010U\u001a\u00020\u00012\u0006\u0010V\u001a\u00020\u0001H\u0002\u001a\u001e\u0010W\u001a\u00020\u00172\u0006\u0010X\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u00012\u0006\u0010Y\u001a\u00020\u0001\u001a\u001a\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0\f\u001a\u001c\u0010]\u001a\u00020\u00172\f\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010_\u001a\u00020\u0001\u001a\u001e\u0010`\u001a\u00020\u00012\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\u00012\u0006\u0010d\u001a\u00020\u0004\u001a\u000e\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\u0001\u001a\u0010\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020iH\u0000\u001a\u0010\u0010k\u001a\u00020i2\u0006\u0010j\u001a\u00020iH\u0000\u001a\u000e\u0010l\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010m\u001a\u00020\u0001*\u00020\u0001\u001a\u0018\u0010n\u001a\b\u0012\u0004\u0012\u00020o0\f*\b\u0012\u0004\u0012\u00020\u00010\fH\u0002\u00a8\u0006p"}, d2={"consolePrintableURL", "", "host", "port", "", "keyStoreData", "Lio/specmatic/core/KeyData;", "containsTextContent", "", "node", "Lorg/w3c/dom/Node;", "contractFilePathsFrom", "", "Lio/specmatic/core/utilities/ContractPathData;", "configFilePath", "workingDirectory", "useCurrentBranchForCentralRepo", "selector", "Lio/specmatic/core/utilities/ContractsSelectorPredicate;", "contractStubPaths", "configFileName", "contractTestPathsFrom", "createIfDoesNotExist", "", "workingDirectoryPath", "examplesDirFor", "Ljava/io/File;", "openApiFilePath", "alternateSuffix", "exceptionCauseMessage", "e", "", "exceptionMessageStack", "messages", "exitIfAnyDoNotExist", "label", "filePaths", "exitWithMessage", "", "message", "getExamplesDir", "suffix", "getSystemGit", "Lio/specmatic/core/git/GitCommand;", "path", "getSystemGitWithAuth", "getTransportCallingCallback", "Lorg/eclipse/jgit/api/TransportConfigCallback;", "bearerToken", "gitRootDir", "isEmptyText", "it", "jsonArray", "source", "Lio/specmatic/core/value/JSONObjectValue;", "key", "loadConfigJSON", "configFile", "loadSources", "Lio/specmatic/core/utilities/ContractSource;", "configJson", "messageStringFrom", "newXMLBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "nullOrExceptionString", "fn", "Lkotlin/Function0;", "Lio/specmatic/core/Result;", "parseXML", "Lorg/w3c/dom/Document;", "xmlData", "readEnvVarOrProperty", "envVarName", "propertyName", "readFile", "filePath", "removeIrrelevantNodes", "document", "runWithTimeout", "T", "timeout", "", "task", "Ljava/util/concurrent/Callable;", "(JLjava/util/concurrent/Callable;)Ljava/lang/Object;", "sanitizeFilename", "input", "saveJsonFile", "jsonString", "fileName", "strings", "list", "Lio/specmatic/core/value/Value;", "throwExceptionIfDirectoriesAreInvalid", "directoryPathsToVerify", "natureOfDirectoryPaths", "uniqueNameForApiOperation", "httpRequest", "Lio/specmatic/core/HttpRequest;", "baseURL", "responseStatus", "validateTestOrStubUri", "Lio/specmatic/core/utilities/URIValidationResult;", "uri", "withNullPattern", "Lio/specmatic/core/Resolver;", "resolver", "withNumberType", "xmlToString", "capitalizeFirstChar", "toContractSourceEntries", "Lio/specmatic/core/utilities/ContractSourceEntry;", "specmatic-core"})
@JvmName(name="Utilities")
@SourceDebugExtension(value={"SMAP\nUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utilities.kt\nio/specmatic/core/utilities/Utilities\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,477:1\n1549#2:478\n1620#2,3:479\n1855#2,2:482\n1549#2:484\n1620#2,3:485\n1549#2:488\n1620#2,3:489\n1549#2:492\n1620#2,3:493\n1549#2:496\n1620#2,3:497\n766#2:500\n857#2,2:501\n819#2:503\n847#2,2:504\n1360#2:506\n1446#2,5:507\n1549#2:512\n1620#2,3:513\n1#3:516\n*S KotlinDebug\n*F\n+ 1 Utilities.kt\nio/specmatic/core/utilities/Utilities\n*L\n127#1:478\n127#1:479,3\n131#1:482,2\n169#1:484\n169#1:485,3\n200#1:488\n200#1:489,3\n237#1:492\n237#1:493,3\n242#1:496\n242#1:497,3\n261#1:500\n261#1:501,2\n268#1:503\n268#1:504,2\n321#1:506\n321#1:507,5\n329#1:512\n329#1:513,3\n*E\n"})
public final class Utilities {
    @NotNull
    public static final Void exitWithMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        SystemExit.INSTANCE.exitWith(1, "\n" + message + "\n");
        throw new KotlinNothingValueException();
    }

    @NotNull
    public static final String messageStringFrom(@NotNull Throwable e2) {
        Intrinsics.checkNotNullParameter(e2, "e");
        List<String> messageStack = Utilities.exceptionMessageStack(e2, CollectionsKt.emptyList());
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default(messageStack, "; ", null, null, 0, null, messageStringFrom.1.INSTANCE, 30, null))).toString();
    }

    @NotNull
    public static final String exceptionCauseMessage(@NotNull Throwable e2) {
        String string;
        Intrinsics.checkNotNullParameter(e2, "e");
        if (e2 instanceof ContractException) {
            string = ((ContractException)e2).report();
        } else {
            Object object;
            CharSequence charSequence = Utilities.messageStringFrom(e2);
            if (charSequence.length() == 0) {
                boolean bl = false;
                object = "Exception class=" + e2.getClass().getName();
            } else {
                object = charSequence;
            }
            string = (String)object;
        }
        return string;
    }

    @NotNull
    public static final List<String> exceptionMessageStack(@NotNull Throwable e2, @NotNull List<String> messages) {
        String message;
        Intrinsics.checkNotNullParameter(e2, "e");
        Intrinsics.checkNotNullParameter(messages, "messages");
        String string = e2.getLocalizedMessage();
        if (string == null) {
            string = e2.getMessage();
        }
        List<String> newMessages = (message = string) != null ? CollectionsKt.plus((Collection)messages, message) : messages;
        Throwable cause = e2.getCause();
        return cause == null ? newMessages : Utilities.exceptionMessageStack(cause, newMessages);
    }

    @NotNull
    public static final String readFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        return ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default(new File(filePath), null, 1, null))).toString();
    }

    @NotNull
    public static final Document parseXML(@NotNull String xmlData) {
        Intrinsics.checkNotNullParameter(xmlData, "xmlData");
        DocumentBuilder builder = Utilities.newXMLBuilder();
        Document document = builder.parse(new InputSource(new StringReader(StringsKt.removePrefix(xmlData, (CharSequence)"\ufeff"))));
        Intrinsics.checkNotNullExpressionValue(document, "parse(...)");
        return Utilities.removeIrrelevantNodes(document);
    }

    @NotNull
    public static final DocumentBuilder newXMLBuilder() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        builder.setErrorHandler(null);
        Intrinsics.checkNotNull(builder);
        return builder;
    }

    @NotNull
    public static final Document removeIrrelevantNodes(@NotNull Document document) {
        Intrinsics.checkNotNullParameter(document, "document");
        Element element = document.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue(element, "getDocumentElement(...)");
        Utilities.removeIrrelevantNodes(element);
        return document;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Node removeIrrelevantNodes(@NotNull Node node) {
        Intrinsics.checkNotNullParameter(node, "node");
        if (node.hasChildNodes() && !Utilities.containsTextContent(node)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = RangesKt.until(0, node.getChildNodes().getLength());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void i2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(node.getChildNodes().item((int)i2));
            }
            List childNodes = (List)destination$iv$iv;
            Iterable $this$forEach$iv = childNodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (Utilities.isEmptyText(it, node) || it.getNodeType() == 8) {
                    node.removeChild(it);
                    continue;
                }
                if (!it.hasChildNodes()) continue;
                Utilities.removeIrrelevantNodes(it);
            }
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isEmptyText(Node it, Node node) {
        if (it.getNodeType() != 3) return false;
        if (node.getNodeType() != 1) return false;
        String string = it.getTextContent();
        Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
        if (!StringsKt.isBlank(((Object)StringsKt.trim((CharSequence)string)).toString())) return false;
        return true;
    }

    private static final boolean containsTextContent(Node node) {
        return node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 3 && node.getNodeType() == 1;
    }

    @NotNull
    public static final String xmlToString(@NotNull Node node) {
        Intrinsics.checkNotNullParameter(node, "node");
        StringWriter writer = new StringWriter();
        StreamResult result2 = new StreamResult(writer);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), result2);
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public static final TransportConfigCallback getTransportCallingCallback(@Nullable String bearerToken) {
        return arg_0 -> Utilities.getTransportCallingCallback$lambda$3(bearerToken, arg_0);
    }

    public static /* synthetic */ TransportConfigCallback getTransportCallingCallback$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return Utilities.getTransportCallingCallback(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> strings(@NotNull List<? extends Value> list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Value value2 = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(it instanceof StringValue)) {
                Utilities.exitWithMessage("All members of the paths array must be strings, but found one (" + it.toStringLiteral() + ") which was not");
                throw new KotlinNothingValueException();
            }
            collection.add(((StringValue)it).getString());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<ContractSource> loadSources(@NotNull String configFilePath, boolean useCurrentBranchForCentralRepo) {
        Intrinsics.checkNotNullParameter(configFilePath, "configFilePath");
        return SpecmaticConfigKt.loadSpecmaticConfig(configFilePath).loadSources(useCurrentBranchForCentralRepo);
    }

    public static /* synthetic */ List loadSources$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Utilities.loadSources(string, bl);
    }

    @NotNull
    public static final JSONObjectValue loadConfigJSON(@NotNull File configFile) {
        Value value2;
        Intrinsics.checkNotNullParameter(configFile, "configFile");
        try {
            value2 = GrammarKt.parsedJSON$default(FilesKt.readText$default(configFile, null, 1, null), null, 2, null);
        }
        catch (Throwable e2) {
            throw new ContractException("Error reading the " + Configuration.Companion.getConfigFilePath() + ": " + Utilities.exceptionCauseMessage(e2), null, e2, null, false, 26, null);
        }
        Value configJson = value2;
        if (!(configJson instanceof JSONObjectValue)) {
            throw new ContractException("The contents of " + Configuration.Companion.getConfigFilePath() + " must be a json object", null, null, null, false, 30, null);
        }
        return (JSONObjectValue)configJson;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final List<ContractSource> loadSources(@NotNull JSONObjectValue configJson) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(configJson, "configJson");
        Value sources = configJson.getJsonObject().getOrDefault("sources", null);
        if (!(sources instanceof JSONArrayValue)) {
            throw new ContractException("The \"sources\" key must hold a list of sources.", null, null, null, false, 30, null);
        }
        Iterable $this$map$iv = ((JSONArrayValue)sources).getList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void source2;
            Value value2 = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(source2 instanceof JSONObjectValue)) {
                throw new ContractException("Every element of the sources json array must be a json object, but got this: " + source2.toStringLiteral(), null, null, null, false, 30, null);
            }
            String type2 = HttpRequestKt.nativeString(((JSONObjectValue)source2).getJsonObject(), "provider");
            String string = HttpRequestKt.nativeString(((JSONObjectValue)source2).getJsonObject(), "provider");
            if (string == null) throw new ContractException("Provider " + HttpRequestKt.nativeString(((JSONObjectValue)source2).getJsonObject(), "provider") + " not recognised in " + Configuration.Companion.getConfigFilePath(), null, null, null, false, 30, null);
            int n = -1;
            switch (string.hashCode()) {
                case 102354: {
                    if (string.equals("git")) {
                        n = 1;
                    }
                    break;
                }
                case 117588: {
                    if (string.equals("web")) {
                        n = 2;
                    }
                    break;
                }
                case -1572513109: {
                    if (string.equals("filesystem")) {
                        n = 3;
                    }
                    break;
                }
            }
            collection.add(switch (n) {
                case 1 -> {
                    String repositoryURL = HttpRequestKt.nativeString(((JSONObjectValue)source2).getJsonObject(), "repository");
                    String branch = HttpRequestKt.nativeString(((JSONObjectValue)source2).getJsonObject(), "branch");
                    List<String> stubPaths = Utilities.jsonArray((JSONObjectValue)source2, "stub");
                    List<String> testPaths = Utilities.jsonArray((JSONObjectValue)source2, "test");
                    yield (ContractSource)((Object)(repositoryURL == null ? new GitMonoRepo(Utilities.toContractSourceEntries(testPaths), Utilities.toContractSourceEntries(stubPaths), type2) : new GitRepo(repositoryURL, branch, Utilities.toContractSourceEntries(testPaths), Utilities.toContractSourceEntries(stubPaths), type2, false, 32, null)));
                }
                case 3 -> {
                    String directory;
                    if (HttpRequestKt.nativeString(((JSONObjectValue)source2).getJsonObject(), "directory") == null) {
                        throw new ContractException("The \"directory\" key is required for the local source provider", null, null, null, false, 30, null);
                    }
                    List<String> stubPaths = Utilities.jsonArray((JSONObjectValue)source2, "stub");
                    List<String> testPaths = Utilities.jsonArray((JSONObjectValue)source2, "test");
                    yield new LocalFileSystemSource(directory, Utilities.toContractSourceEntries(testPaths), Utilities.toContractSourceEntries(stubPaths));
                }
                case 2 -> {
                    List<String> stubPaths = Utilities.jsonArray((JSONObjectValue)source2, "stub");
                    List<String> testPaths = Utilities.jsonArray((JSONObjectValue)source2, "test");
                    yield new WebSource(Utilities.toContractSourceEntries(testPaths), Utilities.toContractSourceEntries(stubPaths));
                }
                default -> throw new ContractException("Provider " + HttpRequestKt.nativeString(((JSONObjectValue)source2).getJsonObject(), "provider") + " not recognised in " + Configuration.Companion.getConfigFilePath(), null, null, null, false, 30, null);
            });
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ContractSourceEntry> toContractSourceEntries(List<String> $this$toContractSourceEntries) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toContractSourceEntries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ContractSourceEntry((String)it, null, null, 6, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> jsonArray(@NotNull JSONObjectValue source2, @NotNull String key2) {
        List list;
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(key2, "key");
        Value value2 = source2.getJsonObject().get(key2);
        if (value2 instanceof JSONArrayValue) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((JSONArrayValue)value2).getList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Value value3 = (Value)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toStringLiteral());
            }
            list = (List)destination$iv$iv;
        } else if (value2 == null) {
            list = CollectionsKt.emptyList();
        } else {
            throw new ContractException("Expected " + key2 + " to be an array", null, null, null, false, 30, null);
        }
        return list;
    }

    public static final void createIfDoesNotExist(@NotNull String workingDirectoryPath) {
        Intrinsics.checkNotNullParameter(workingDirectoryPath, "workingDirectoryPath");
        File workingDirectory = new File(workingDirectoryPath);
        if (!workingDirectory.exists()) {
            try {
                workingDirectory.mkdirs();
            }
            catch (Throwable e2) {
                Utilities.exitWithMessage(Utilities.exceptionCauseMessage(e2));
                throw new KotlinNothingValueException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void throwExceptionIfDirectoriesAreInvalid(@NotNull List<String> directoryPathsToVerify, @NotNull String natureOfDirectoryPaths) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(directoryPathsToVerify, "directoryPathsToVerify");
        Intrinsics.checkNotNullParameter(natureOfDirectoryPaths, "natureOfDirectoryPaths");
        Iterable $this$filter$iv = directoryPathsToVerify;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!new File(it).exists() || !new File(it).isDirectory())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List invalidDataDirs = (List)destination$iv$iv;
        if (!((Collection)invalidDataDirs).isEmpty()) {
            throw new Exception("The following " + natureOfDirectoryPaths + " are invalid: " + CollectionsKt.joinToString$default(invalidDataDirs, ", ", null, null, 0, null, null, 62, null) + ". Please provide the valid " + natureOfDirectoryPaths + ".");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void exitIfAnyDoNotExist(@NotNull String label, @NotNull List<String> filePaths) {
        List list;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(filePaths, "filePaths");
        Iterable $this$filterNot$iv = filePaths;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String contractPath = (String)element$iv$iv;
            boolean bl = false;
            if (new File(contractPath).exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            throw new ContractException(label + ": " + CollectionsKt.joinToString$default(it, ", ", null, null, 0, null, null, 62, null), null, null, null, false, 30, null);
        }
    }

    @NotNull
    public static final List<ContractPathData> contractStubPaths(@NotNull String configFileName, boolean useCurrentBranchForCentralRepo) {
        Intrinsics.checkNotNullParameter(configFileName, "configFileName");
        return Utilities.contractFilePathsFrom(configFileName, ".specmatic", useCurrentBranchForCentralRepo, Utilities::contractStubPaths$lambda$11);
    }

    public static /* synthetic */ List contractStubPaths$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Utilities.contractStubPaths(string, bl);
    }

    @NotNull
    public static final List<ContractPathData> contractTestPathsFrom(@NotNull String configFilePath, @NotNull String workingDirectory, boolean useCurrentBranchForCentralRepo) {
        Intrinsics.checkNotNullParameter(configFilePath, "configFilePath");
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        return Utilities.contractFilePathsFrom(configFilePath, workingDirectory, useCurrentBranchForCentralRepo, Utilities::contractTestPathsFrom$lambda$12);
    }

    public static /* synthetic */ List contractTestPathsFrom$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return Utilities.contractTestPathsFrom(string, string2, bl);
    }

    @NotNull
    public static final String gitRootDir() {
        String gitRoot = new SystemGit(null, null, null, 7, null).gitRoot();
        String string = gitRoot.substring(StringsKt.lastIndexOf$default((CharSequence)gitRoot, '/', 0, false, 6, null) + 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContractPathData> contractFilePathsFrom(@NotNull String configFilePath, @NotNull String workingDirectory, boolean useCurrentBranchForCentralRepo, @NotNull ContractsSelectorPredicate selector) {
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(configFilePath, "configFilePath");
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(selector, "selector");
        LoggingKt.getLogger().log("Loading config file " + configFilePath);
        List<ContractSource> sources = Utilities.loadSources(configFilePath, useCurrentBranchForCentralRepo);
        Iterable $this$flatMap$iv = sources;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ContractSource it = (ContractSource)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.loadContracts(selector, workingDirectory, configFilePath);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List contractPathData = (List)destination$iv$iv;
        LoggingKt.getLogger().debug("Spec file paths in " + configFilePath + ":");
        LogStrategy logStrategy = LoggingKt.getLogger();
        Iterable iterable2 = contractPathData;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue(string, "lineSeparator(...)");
        logStrategy.debug(CollectionsKt.joinToString$default(iterable2, string, null, null, 0, null, contractFilePathsFrom.1.INSTANCE, 30, null));
        Iterable $this$map$iv = contractPathData;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Integer n;
            void data2;
            ContractPathData bl = (ContractPathData)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            try {
                Integer n2;
                if (data2.getBaseUrl() != null) {
                    String url2;
                    boolean bl3 = false;
                    URI uri2 = new URI(url2);
                    n2 = uri2.getPort() != -1 ? Integer.valueOf(uri2.getPort()) : null;
                } else {
                    n2 = null;
                }
                n = n2;
            }
            catch (Throwable throwable) {
                n = null;
            }
            Integer parsedPort = n;
            collection.add(parsedPort != null && !Intrinsics.areEqual(data2.getPort(), parsedPort) ? ContractPathData.copy$default((ContractPathData)data2, null, null, null, null, null, null, null, null, parsedPort, 255, null) : data2);
        }
        List contractPathDataWithPorts = (List)destination$iv$iv2;
        return contractPathDataWithPorts;
    }

    public static /* synthetic */ List contractFilePathsFrom$default(String string, String string2, boolean bl, ContractsSelectorPredicate contractsSelectorPredicate, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return Utilities.contractFilePathsFrom(string, string2, bl, contractsSelectorPredicate);
    }

    @NotNull
    public static final GitCommand getSystemGit(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        return new SystemGit(path2, null, null, 6, null);
    }

    @NotNull
    public static final GitCommand getSystemGitWithAuth(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        return new SystemGit(path2, null, AzureAuthCredentials.INSTANCE, 2, null);
    }

    @NotNull
    public static final Resolver withNullPattern(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return Resolver.copy$default(resolver, null, false, MapsKt.plus(resolver.getNewPatterns(), TuplesKt.to("(empty)", NullPattern.INSTANCE)), null, null, null, false, null, null, null, null, null, null, null, null, false, null, null, null, 524283, null);
    }

    @NotNull
    public static final Resolver withNumberType(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return Resolver.copy$default(resolver, null, false, MapsKt.plus(resolver.getNewPatterns(), TuplesKt.to("(number)", new NumberPattern(null, 0, 0, null, false, null, false, null, false, false, 1023, null))), null, null, null, false, null, null, null, null, null, null, null, null, false, null, null, null, 524283, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String capitalizeFirstChar(@NotNull String $this$capitalizeFirstChar) {
        String string;
        Intrinsics.checkNotNullParameter($this$capitalizeFirstChar, "<this>");
        String string2 = $this$capitalizeFirstChar;
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c2 = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string3 = String.valueOf((char)it);
            Intrinsics.checkNotNull(string3, "null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String string5 = string2;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
            string = stringBuilder2.append(string6).toString();
        } else {
            string = string2;
        }
        return string;
    }

    public static final void saveJsonFile(@NotNull String jsonString, @NotNull String path2, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(jsonString, "jsonString");
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        File directory = new File(path2);
        directory.mkdirs();
        FilesKt.writeText$default(new File(directory, fileName), jsonString, null, 2, null);
    }

    @Nullable
    public static final String readEnvVarOrProperty(@NotNull String envVarName, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter(envVarName, "envVarName");
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        String string = System.getenv(envVarName);
        if (string == null) {
            string = System.getProperty(propertyName);
        }
        return string;
    }

    @NotNull
    public static final File examplesDirFor(@NotNull String openApiFilePath, @NotNull String alternateSuffix) {
        Intrinsics.checkNotNullParameter(openApiFilePath, "openApiFilePath");
        Intrinsics.checkNotNullParameter(alternateSuffix, "alternateSuffix");
        File examplesDir = Utilities.getExamplesDir(openApiFilePath, "_examples");
        return examplesDir.isDirectory() ? examplesDir : Utilities.getExamplesDir(openApiFilePath, alternateSuffix);
    }

    private static final File getExamplesDir(String openApiFilePath, String suffix) {
        File it = new File(openApiFilePath).getCanonicalFile();
        boolean bl = false;
        File file2 = it.getParentFile();
        Intrinsics.checkNotNullExpressionValue(file2, "getParentFile(...)");
        String string = it.getParent();
        Intrinsics.checkNotNull(it);
        return FilesKt.resolve(file2, string + "/" + FilesKt.getNameWithoutExtension(it) + suffix);
    }

    @Nullable
    public static final String nullOrExceptionString(@NotNull Function0<? extends Result> fn) {
        Intrinsics.checkNotNullParameter(fn, "fn");
        try {
            Result result2 = fn.invoke();
            if (result2 instanceof Result.Failure) {
                return result2.reportString();
            }
            return null;
        }
        catch (Throwable t2) {
            return LogStrategy.exceptionString$default(LoggingKt.getLogger(), t2, null, 2, null);
        }
    }

    private static final String sanitizeFilename(String input) {
        CharSequence charSequence = input;
        Regex regex = new Regex("[\\\\/:*?\"'<>| ]");
        String string = "_";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final String uniqueNameForApiOperation(@NotNull HttpRequest httpRequest, @NotNull String baseURL, int responseStatus2) {
        String formattedPath;
        String string;
        String string2;
        String contentType2;
        Intrinsics.checkNotNullParameter(httpRequest, "httpRequest");
        Intrinsics.checkNotNullParameter(baseURL, "baseURL");
        String method2 = httpRequest.component1();
        String path2 = httpRequest.component2();
        Map<String, String> headers2 = httpRequest.component3();
        if (Intrinsics.areEqual(method2, "PATCH")) {
            String string3 = headers2.get("Content-Type");
            if (string3 == null) {
                string3 = "";
            }
            v1 = "_" + StringsKt.replace$default(string3, "/", "_", false, 4, null);
        } else {
            v1 = contentType2 = "";
        }
        if (((string2 = path2) != null && (string2 = StringsKt.replace$default(string2, baseURL, "", false, 4, null)) != null ? StringsKt.drop(string2, 1) : (string = null)) == null) {
            string = "";
        }
        if (((CharSequence)(formattedPath = string)).length() == 0) {
            return method2 + "_" + responseStatus2;
        }
        String rawName = formattedPath + "_" + method2 + "_" + responseStatus2 + contentType2;
        return Utilities.sanitizeFilename(rawName);
    }

    @NotNull
    public static final String consolePrintableURL(@NotNull String host2, int port2, @Nullable KeyData keyStoreData) {
        String string;
        Intrinsics.checkNotNullParameter(host2, "host");
        KeyData keyData = keyStoreData;
        if (keyData != null) {
            KeyData it = keyData;
            boolean bl = false;
            string = "https";
        } else {
            string = "http";
        }
        String protocol = string;
        String displayableHost = Intrinsics.areEqual(host2, "0.0.0.0") ? "localhost" : host2;
        return protocol + "://" + displayableHost + ":" + port2;
    }

    public static /* synthetic */ String consolePrintableURL$default(String string, int n, KeyData keyData, int n2, Object object) {
        if ((n2 & 4) != 0) {
            keyData = null;
        }
        return Utilities.consolePrintableURL(string, n, keyData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T runWithTimeout(long timeout2, @NotNull Callable<T> task) {
        Intrinsics.checkNotNullParameter(task, "task");
        TimeUnit unit = TimeUnit.MILLISECONDS;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<T> future = executor.submit(task);
        try {
            T t2 = future.get(timeout2, unit);
            return t2;
        }
        catch (TimeoutException e2) {
            future.cancel(true);
            throw e2;
        }
        catch (ExecutionException e3) {
            Throwable throwable = e3.getCause();
            if (throwable == null) {
                throwable = e3;
            }
            throw throwable;
        }
        finally {
            executor.shutdown();
        }
    }

    @NotNull
    public static final URIValidationResult validateTestOrStubUri(@NotNull String uri2) {
        CharSequence charSequence;
        URI uRI;
        Intrinsics.checkNotNullParameter(uri2, "uri");
        try {
            uRI = new URL(uri2).toURI();
        }
        catch (URISyntaxException e2) {
            LoggingKt.consoleDebug(e2);
            return URIValidationResult.URIParsingError;
        }
        catch (MalformedURLException e3) {
            LoggingKt.consoleDebug(e3);
            return URIValidationResult.URIParsingError;
        }
        URI parsedURI = uRI;
        String[] e3 = new String[]{"http", "https"};
        List<String> validProtocols = CollectionsKt.listOf(e3);
        IntRange validPorts = new IntRange(1, 65535);
        return !validProtocols.contains(parsedURI.getScheme()) ? URIValidationResult.InvalidURLSchemeError : ((charSequence = (CharSequence)parsedURI.getHost()) == null || StringsKt.isBlank(charSequence) ? URIValidationResult.MissingHostError : (parsedURI.getPort() != -1 && !validPorts.contains(parsedURI.getPort()) ? URIValidationResult.InvalidPortError : URIValidationResult.Success));
    }

    private static final void getTransportCallingCallback$lambda$3(String $bearerToken, Transport transport) {
        if (transport instanceof SshTransport) {
            ((SshTransport)transport).setSshSessionFactory(new SshdSessionFactory());
        } else if ($bearerToken != null && transport instanceof TransportHttp) {
            LoggingKt.getLogger().debug("Setting Authorization header");
            ((TransportHttp)transport).setAdditionalHeaders(MapsKt.mapOf(TuplesKt.to("Authorization", "Bearer " + $bearerToken)));
        }
    }

    private static final List contractStubPaths$lambda$11(ContractSource source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        return source2.getStubContracts();
    }

    private static final List contractTestPathsFrom$lambda$12(ContractSource source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        return source2.getTestContracts();
    }
}

