/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.value;

import io.specmatic.core.ExampleDeclarations;
import io.specmatic.core.pattern.ExactValuePattern;
import io.specmatic.core.pattern.NumberPattern;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.ScalarValue;
import io.specmatic.core.value.TypeDeclaration;
import io.specmatic.core.value.TypeDeclarationKt;
import io.specmatic.core.value.Value;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0016\u0010\u001a\u001a\u00020\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\u0017H\u0016J8\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0006\u0010%\u001a\u00020\u00072\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170'2\u0006\u0010(\u001a\u00020$H\u0016J8\u0010)\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0006\u0010*\u001a\u00020\u00072\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170'2\u0006\u0010(\u001a\u00020$H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006+"}, d2={"Lio/specmatic/core/value/NumberValue;", "Lio/specmatic/core/value/Value;", "Lio/specmatic/core/value/ScalarValue;", "number", "", "(Ljava/lang/Number;)V", "httpContentType", "", "getHttpContentType", "()Ljava/lang/String;", "nativeValue", "getNativeValue", "()Ljava/lang/Number;", "getNumber", "component1", "copy", "displayableType", "displayableValue", "equals", "", "other", "", "exactMatchElseType", "Lio/specmatic/core/pattern/Pattern;", "hashCode", "", "listOf", "valueList", "", "specificity", "toString", "toStringLiteral", "type", "typeDeclarationWithKey", "Lkotlin/Pair;", "Lio/specmatic/core/value/TypeDeclaration;", "Lio/specmatic/core/ExampleDeclarations;", "key", "types", "", "exampleDeclarations", "typeDeclarationWithoutKey", "exampleKey", "specmatic-core"})
public final class NumberValue
implements Value,
ScalarValue {
    @NotNull
    private final Number number;
    @NotNull
    private final String httpContentType;

    public NumberValue(@NotNull Number number) {
        Intrinsics.checkNotNullParameter(number, "number");
        this.number = number;
        this.httpContentType = "text/plain";
    }

    @NotNull
    public final Number getNumber() {
        return this.number;
    }

    @Override
    @NotNull
    public String getHttpContentType() {
        return this.httpContentType;
    }

    @Override
    @NotNull
    public String displayableValue() {
        return this.toStringLiteral();
    }

    @Override
    @NotNull
    public String toStringLiteral() {
        return this.number.toString();
    }

    @Override
    @NotNull
    public String displayableType() {
        return "number";
    }

    @Override
    @NotNull
    public Pattern exactMatchElseType() {
        return new ExactValuePattern(this, null, false, 6, null);
    }

    @Override
    @NotNull
    public Pattern type() {
        return new NumberPattern(null, 0, 0, null, false, null, false, null, false, false, 1023, null);
    }

    @Override
    @NotNull
    public Pair<TypeDeclaration, ExampleDeclarations> typeDeclarationWithKey(@NotNull String key2, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(types, "types");
        Intrinsics.checkNotNullParameter(exampleDeclarations, "exampleDeclarations");
        String displayableType = this.number instanceof Integer || this.number instanceof Long ? "integer" : this.displayableType();
        return TypeDeclarationKt.primitiveTypeDeclarationWithKey(key2, types, exampleDeclarations, displayableType, this.number.toString());
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList) {
        Intrinsics.checkNotNullParameter(valueList, "valueList");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public Pair<TypeDeclaration, ExampleDeclarations> typeDeclarationWithoutKey(@NotNull String exampleKey, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        Intrinsics.checkNotNullParameter(exampleKey, "exampleKey");
        Intrinsics.checkNotNullParameter(types, "types");
        Intrinsics.checkNotNullParameter(exampleDeclarations, "exampleDeclarations");
        String displayableType = this.number instanceof Integer || this.number instanceof Long ? "integer" : this.displayableType();
        return TypeDeclarationKt.primitiveTypeDeclarationWithoutKey(exampleKey, types, exampleDeclarations, displayableType, this.number.toString());
    }

    @Override
    @NotNull
    public Number getNativeValue() {
        return this.number;
    }

    @Override
    public int specificity() {
        return 1;
    }

    @NotNull
    public String toString() {
        return this.number.toString();
    }

    @NotNull
    public final Number component1() {
        return this.number;
    }

    @NotNull
    public final NumberValue copy(@NotNull Number number) {
        Intrinsics.checkNotNullParameter(number, "number");
        return new NumberValue(number);
    }

    public static /* synthetic */ NumberValue copy$default(NumberValue numberValue, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = numberValue.number;
        }
        return numberValue.copy(number);
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NumberValue)) {
            return false;
        }
        NumberValue numberValue = (NumberValue)other;
        return Intrinsics.areEqual(this.number, numberValue.number);
    }
}

