/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.value;

import io.ktor.http.HeaderValueWithParametersKt;
import io.specmatic.core.ExampleDeclarations;
import io.specmatic.core.Result;
import io.specmatic.core.pattern.DeferredPattern;
import io.specmatic.core.pattern.ExactValuePattern;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.StringPattern;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.ScalarValue;
import io.specmatic.core.value.TypeDeclaration;
import io.specmatic.core.value.TypeDeclarationKt;
import io.specmatic.core.value.Value;
import io.specmatic.core.value.XMLNode;
import io.specmatic.core.value.XMLValue;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020\u001fH\u00d6\u0001J\u0006\u0010!\u001a\u00020\u0019J\u0016\u0010\"\u001a\u00020\u00012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001fH\u0016J\b\u0010(\u001a\u00020\u0005H\u0016J\b\u0010)\u001a\u00020\u0005H\u0016J\u0006\u0010*\u001a\u00020\u0000J\b\u0010+\u001a\u00020\u001dH\u0016J8\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-2\u0006\u00100\u001a\u00020\u00052\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001d022\u0006\u00103\u001a\u00020/H\u0016J8\u00104\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-2\u0006\u00105\u001a\u00020\u00052\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001d022\u0006\u00103\u001a\u00020/H\u0016J\b\u00106\u001a\u00020\u0005H\u0016R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u00067"}, d2={"Lio/specmatic/core/value/StringValue;", "Lio/specmatic/core/value/Value;", "Lio/specmatic/core/value/ScalarValue;", "Lio/specmatic/core/value/XMLValue;", "string", "", "(Ljava/lang/String;)V", "httpContentType", "getHttpContentType", "()Ljava/lang/String;", "nativeValue", "getNativeValue", "getString", "addSchema", "schema", "Lio/specmatic/core/value/XMLNode;", "build", "Lorg/w3c/dom/Node;", "document", "Lorg/w3c/dom/Document;", "component1", "copy", "displayableType", "displayableValue", "equals", "", "other", "", "exactMatchElseType", "Lio/specmatic/core/pattern/Pattern;", "generality", "", "hashCode", "isPatternToken", "listOf", "valueList", "", "matchFailure", "Lio/specmatic/core/Result$Failure;", "specificity", "toString", "toStringLiteral", "trimmed", "type", "typeDeclarationWithKey", "Lkotlin/Pair;", "Lio/specmatic/core/value/TypeDeclaration;", "Lio/specmatic/core/ExampleDeclarations;", "key", "types", "", "exampleDeclarations", "typeDeclarationWithoutKey", "exampleKey", "valueErrorSnippet", "specmatic-core"})
public final class StringValue
implements Value,
ScalarValue,
XMLValue {
    @NotNull
    private final String string;
    @NotNull
    private final String httpContentType;

    public StringValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        this.string = string;
        this.httpContentType = "text/plain";
    }

    public /* synthetic */ StringValue(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    @NotNull
    public final String getString() {
        return this.string;
    }

    @Override
    @NotNull
    public String getHttpContentType() {
        return this.httpContentType;
    }

    @Override
    @NotNull
    public String valueErrorSnippet() {
        return this.displayableValue();
    }

    @Override
    @NotNull
    public String displayableValue() {
        return HeaderValueWithParametersKt.quote(this.toStringLiteral());
    }

    @Override
    @NotNull
    public String toStringLiteral() {
        return this.string;
    }

    @Override
    @NotNull
    public String displayableType() {
        return "string";
    }

    @Override
    @NotNull
    public Pattern exactMatchElseType() {
        return this.isPatternToken() ? (Pattern)new DeferredPattern(this.string, null, null, 6, null) : (Pattern)new ExactValuePattern(this, null, false, 6, null);
    }

    @Override
    @NotNull
    public Node build(@NotNull Document document) {
        Intrinsics.checkNotNullParameter(document, "document");
        Text text = document.createTextNode(this.string);
        Intrinsics.checkNotNullExpressionValue(text, "createTextNode(...)");
        return text;
    }

    @Override
    @NotNull
    public Result.Failure matchFailure() {
        return new Result.Failure("Unexpected child value found: " + this.string, null, null, null, null, 30, null);
    }

    @Override
    @NotNull
    public XMLValue addSchema(@NotNull XMLNode schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return this;
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList) {
        Intrinsics.checkNotNullParameter(valueList, "valueList");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public Pattern type() {
        return new StringPattern(null, null, null, null, null, false, false, 127, null);
    }

    @Override
    @NotNull
    public Pair<TypeDeclaration, ExampleDeclarations> typeDeclarationWithKey(@NotNull String key2, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(types, "types");
        Intrinsics.checkNotNullParameter(exampleDeclarations, "exampleDeclarations");
        return TypeDeclarationKt.primitiveTypeDeclarationWithKey(key2, types, exampleDeclarations, this.displayableType(), this.string);
    }

    @Override
    @NotNull
    public Pair<TypeDeclaration, ExampleDeclarations> typeDeclarationWithoutKey(@NotNull String exampleKey, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        Intrinsics.checkNotNullParameter(exampleKey, "exampleKey");
        Intrinsics.checkNotNullParameter(types, "types");
        Intrinsics.checkNotNullParameter(exampleDeclarations, "exampleDeclarations");
        return TypeDeclarationKt.primitiveTypeDeclarationWithoutKey(exampleKey, types, exampleDeclarations, this.displayableType(), this.string);
    }

    @Override
    @NotNull
    public String getNativeValue() {
        return this.string;
    }

    @NotNull
    public String toString() {
        return this.string;
    }

    public final boolean isPatternToken() {
        return GrammarKt.isPatternToken(((Object)StringsKt.trim((CharSequence)this.string)).toString());
    }

    @NotNull
    public final StringValue trimmed() {
        return new StringValue(((Object)StringsKt.trim((CharSequence)this.string)).toString());
    }

    @Override
    public int generality() {
        return GrammarKt.isPatternToken(this.string) ? 1 : 0;
    }

    @Override
    public int specificity() {
        return !GrammarKt.isPatternToken(this.string) ? 1 : 0;
    }

    @NotNull
    public final String component1() {
        return this.string;
    }

    @NotNull
    public final StringValue copy(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        return new StringValue(string);
    }

    public static /* synthetic */ StringValue copy$default(StringValue stringValue, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = stringValue.string;
        }
        return stringValue.copy(string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringValue)) {
            return false;
        }
        StringValue stringValue = (StringValue)other;
        return Intrinsics.areEqual(this.string, stringValue.string);
    }

    public StringValue() {
        this(null, 1, null);
    }
}

