/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.value;

import io.specmatic.core.utilities.Utilities;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.XMLNode;
import io.specmatic.core.value.XMLNodeBuilder;
import io.specmatic.core.value.XMLNodeKt;
import io.specmatic.core.value.XMLValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u001a&\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a$\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00022\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u001a$\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u001a$\u0010\r\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u001a?\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00022\u0014\b\u0002\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0019\b\u0002\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u0017\u001a\n\u0010\u0018\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\f*\u00020\u0002\u00a8\u0006\u001b"}, d2={"attributes", "", "", "Lio/specmatic/core/value/StringValue;", "node", "Lorg/w3c/dom/Node;", "childNodes", "", "Lio/specmatic/core/value/XMLValue;", "parentNamespaces", "getNamespaces", "nonTextXMLNode", "Lio/specmatic/core/value/XMLNode;", "toXMLNode", "xmlData", "document", "Lorg/w3c/dom/Document;", "xmlNode", "name", "childrenFn", "Lkotlin/Function1;", "Lio/specmatic/core/value/XMLNodeBuilder;", "", "Lkotlin/ExtensionFunctionType;", "localName", "namespacePrefix", "toXML", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nXMLNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMLNode.kt\nio/specmatic/core/value/XMLNodeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,364:1\n1549#2:365\n1620#2,3:366\n1789#2,3:369\n1549#2:372\n1620#2,3:373\n1789#2,3:376\n1238#2,4:388\n1238#2,4:396\n478#3,7:379\n468#3:386\n414#3:387\n453#3:392\n403#3:393\n453#3:394\n403#3:395\n*S KotlinDebug\n*F\n+ 1 XMLNode.kt\nio/specmatic/core/value/XMLNodeKt\n*L\n31#1:365\n31#1:366,3\n33#1:369,3\n39#1:372\n39#1:373,3\n41#1:376,3\n62#1:388,4\n333#1:396,4\n62#1:379,7\n62#1:386\n62#1:387\n62#1:392\n62#1:393\n333#1:394\n333#1:395\n*E\n"})
public final class XMLNodeKt {
    @NotNull
    public static final XMLNode toXMLNode(@NotNull Document document, @NotNull Map<String, String> parentNamespaces) {
        Intrinsics.checkNotNullParameter(document, "document");
        Intrinsics.checkNotNullParameter(parentNamespaces, "parentNamespaces");
        Element element = document.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue(element, "getDocumentElement(...)");
        return XMLNodeKt.nonTextXMLNode(element, parentNamespaces);
    }

    public static /* synthetic */ XMLNode toXMLNode$default(Document document, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return XMLNodeKt.toXMLNode(document, map2);
    }

    @NotNull
    public static final XMLValue toXMLNode(@NotNull Node node, @NotNull Map<String, String> parentNamespaces) {
        XMLValue xMLValue;
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(parentNamespaces, "parentNamespaces");
        if (node.getNodeType() == 3) {
            String string = node.getTextContent();
            Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
            xMLValue = new StringValue(string);
        } else {
            xMLValue = XMLNodeKt.nonTextXMLNode(node, parentNamespaces);
        }
        return xMLValue;
    }

    public static /* synthetic */ XMLValue toXMLNode$default(Node node, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return XMLNodeKt.toXMLNode(node, map2);
    }

    private static final XMLNode nonTextXMLNode(Node node, Map<String, String> parentNamespaces) {
        Map<String, StringValue> attributes2 = XMLNodeKt.attributes(node);
        Map<String, String> namespacesForChildrenToInherit = XMLNodeKt.getNamespaces(attributes2);
        String string = node.getNodeName();
        Intrinsics.checkNotNullExpressionValue(string, "getNodeName(...)");
        return new XMLNode(string, XMLNodeKt.attributes(node), XMLNodeKt.childNodes(node, MapsKt.plus(parentNamespaces, namespacesForChildrenToInherit)), parentNamespaces);
    }

    static /* synthetic */ XMLNode nonTextXMLNode$default(Node node, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return XMLNodeKt.nonTextXMLNode(node, map2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<XMLValue> childNodes(Node node, Map<String, String> parentNamespaces) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = RangesKt.until(0, node.getChildNodes().getLength());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(node.getChildNodes().item((int)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        List<XMLValue> initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List<XMLValue> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void item;
            Node item$iv$iv = (Node)element$iv;
            List<XMLValue> acc = accumulator$iv;
            boolean bl = false;
            Collection collection = acc;
            Intrinsics.checkNotNull(item);
            accumulator$iv = CollectionsKt.plus(collection, XMLNodeKt.toXMLNode((Node)item, parentNamespaces));
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, StringValue> attributes(Node node) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = RangesKt.until(0, node.getAttributes().getLength());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Node node2 = node.getAttributes().item((int)it);
            Intrinsics.checkNotNull(node2, "null cannot be cast to non-null type org.w3c.dom.Attr");
            collection.add((Attr)node2);
        }
        $this$map$iv = (List)destination$iv$iv;
        Map<String, StringValue> initial$iv = MapsKt.emptyMap();
        boolean $i$f$fold = false;
        Map<String, StringValue> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void item;
            Attr item$iv$iv = (Attr)element$iv;
            Map<String, StringValue> acc = accumulator$iv;
            boolean bl = false;
            String string = item.getName();
            String string2 = item.getValue();
            Intrinsics.checkNotNullExpressionValue(string2, "getValue(...)");
            accumulator$iv = MapsKt.plus(acc, TuplesKt.to(string, new StringValue(string2)));
        }
        return accumulator$iv;
    }

    @NotNull
    public static final XMLNode toXMLNode(@NotNull String xmlData, @NotNull Map<String, String> parentNamespaces) {
        Intrinsics.checkNotNullParameter(xmlData, "xmlData");
        Intrinsics.checkNotNullParameter(parentNamespaces, "parentNamespaces");
        Document document = Utilities.parseXML(xmlData);
        return XMLNodeKt.toXMLNode(document, parentNamespaces);
    }

    public static /* synthetic */ XMLNode toXMLNode$default(String string, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return XMLNodeKt.toXMLNode(string, map2);
    }

    @NotNull
    public static final String localName(@NotNull String $this$localName) {
        Intrinsics.checkNotNullParameter($this$localName, "<this>");
        return StringsKt.substringAfter$default($this$localName, ':', null, 2, null);
    }

    @NotNull
    public static final String namespacePrefix(@NotNull String $this$namespacePrefix) {
        Intrinsics.checkNotNullParameter($this$namespacePrefix, "<this>");
        String[] stringArray = new String[]{":"};
        List parts = StringsKt.split$default((CharSequence)$this$namespacePrefix, stringArray, false, 0, 6, null);
        return parts.size() == 1 ? "" : (String)CollectionsKt.first(parts);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> getNamespaces(@NotNull Map<String, StringValue> attributes2) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Object it;
        Map map2;
        Map $this$mapKeysTo$iv$iv;
        Intrinsics.checkNotNullParameter(attributes2, "attributes");
        Map<String, StringValue> $this$filterKeys$iv = attributes2;
        boolean $i$f$filterKeys = false;
        Map<String, StringValue> result$iv = new LinkedHashMap();
        for (Map.Entry<String, StringValue> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it2 = entry$iv.getKey();
            boolean bl = false;
            if (!StringsKt.startsWith$default(it2, "xmlns:", false, 2, null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$mapKeys$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object = StringsKt.removePrefix((String)it.getKey(), (CharSequence)"xmlns:");
            Map map3 = map2;
            boolean bl2 = false;
            it = it$iv$iv.getValue();
            map3.put(object, it);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it3;
            void it$iv$iv;
            it = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            map2 = map4;
            boolean bl3 = false;
            String string = ((StringValue)it3.getValue()).toString();
            map2.put(k2, string);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final XMLNode xmlNode(@NotNull String name, @NotNull Map<String, String> attributes2, @NotNull Function1<? super XMLNodeBuilder, Unit> childrenFn) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(attributes2, "attributes");
        Intrinsics.checkNotNullParameter(childrenFn, "childrenFn");
        XMLNodeBuilder nodeBuilder = new XMLNodeBuilder(MapsKt.emptyMap());
        childrenFn.invoke(nodeBuilder);
        List<XMLValue> children2 = nodeBuilder.getNodes();
        Map<String, String> parentNamespaces = nodeBuilder.getParentNamespaces();
        Map<String, String> map2 = attributes2;
        String string = name;
        boolean $i$f$mapValues = false;
        void var8_9 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            StringValue stringValue = new StringValue((String)it.getValue());
            map4.put(k2, stringValue);
        }
        Map<String, String> map5 = parentNamespaces;
        List<XMLValue> list = children2;
        Map map6 = destination$iv$iv;
        String string2 = string;
        return new XMLNode(string2, map6, list, map5);
    }

    public static /* synthetic */ XMLNode xmlNode$default(String string, Map map2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            function1 = xmlNode.1.INSTANCE;
        }
        return XMLNodeKt.xmlNode(string, map2, function1);
    }

    @NotNull
    public static final XMLNode toXML(@NotNull String $this$toXML) {
        Intrinsics.checkNotNullParameter($this$toXML, "<this>");
        return XMLNodeKt.toXMLNode$default($this$toXML, null, 2, null);
    }
}

