/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.wsdl.parser.message;

import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.value.Value;
import io.specmatic.core.value.XMLNode;
import io.specmatic.core.wsdl.parser.message.AttributeElementKt;
import io.specmatic.core.wsdl.parser.message.SimpleElementKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/specmatic/core/wsdl/parser/message/AttributeElement;", "", "xmlNode", "Lio/specmatic/core/value/XMLNode;", "(Lio/specmatic/core/value/XMLNode;)V", "mandatory", "", "name", "", "getName", "()Ljava/lang/String;", "nameWithOptionality", "getNameWithOptionality", "type", "Lio/specmatic/core/value/Value;", "getType", "()Lio/specmatic/core/value/Value;", "specmatic-core"})
public final class AttributeElement {
    @NotNull
    private final String name;
    @NotNull
    private final Value type;
    private final boolean mandatory;
    @NotNull
    private final String nameWithOptionality;

    public AttributeElement(@NotNull XMLNode xmlNode2) {
        Intrinsics.checkNotNullParameter(xmlNode2, "xmlNode");
        String string = AttributeElementKt.fromNameAttribute(xmlNode2);
        if (string == null) {
            throw new ContractException("'name' not defined for attribute: " + xmlNode2.getOneLineDescription(), null, null, null, false, 30, null);
        }
        this.name = string;
        this.type = SimpleElementKt.elementTypeValue(xmlNode2);
        Boolean bl = AttributeElementKt.isMandatory(xmlNode2);
        this.mandatory = bl != null ? bl : false;
        this.nameWithOptionality = this.mandatory ? this.name : this.name + ".opt";
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Value getType() {
        return this.type;
    }

    @NotNull
    public final String getNameWithOptionality() {
        return this.nameWithOptionality;
    }
}

