/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.wsdl.parser.message;

import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.XMLPattern;
import io.specmatic.core.value.FullyQualifiedName;
import io.specmatic.core.value.XMLNode;
import io.specmatic.core.wsdl.parser.SOAPMessageType;
import io.specmatic.core.wsdl.parser.WSDL;
import io.specmatic.core.wsdl.parser.message.MessageTypeInfoParser;
import io.specmatic.core.wsdl.parser.message.MessageTypeProcessingComplete;
import io.specmatic.core.wsdl.parser.message.ParseMessageWithElementRef;
import io.specmatic.core.wsdl.parser.message.ParseMessageWithoutElementRef;
import io.specmatic.core.wsdl.payload.EmptySOAPPayload;
import io.specmatic.core.wsdl.payload.SoapPayloadType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\u0001H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/specmatic/core/wsdl/parser/message/GetMessageTypeReference;", "Lio/specmatic/core/wsdl/parser/message/MessageTypeInfoParser;", "wsdl", "Lio/specmatic/core/wsdl/parser/WSDL;", "messageTypeNode", "Lio/specmatic/core/value/XMLNode;", "soapMessageType", "Lio/specmatic/core/wsdl/parser/SOAPMessageType;", "existingTypes", "", "", "Lio/specmatic/core/pattern/XMLPattern;", "operationName", "(Lio/specmatic/core/wsdl/parser/WSDL;Lio/specmatic/core/value/XMLNode;Lio/specmatic/core/wsdl/parser/SOAPMessageType;Ljava/util/Map;Ljava/lang/String;)V", "getMessageTypeNode", "()Lio/specmatic/core/value/XMLNode;", "execute", "specmatic-core"})
public final class GetMessageTypeReference
implements MessageTypeInfoParser {
    @NotNull
    private final WSDL wsdl;
    @NotNull
    private final XMLNode messageTypeNode;
    @NotNull
    private final SOAPMessageType soapMessageType;
    @NotNull
    private final Map<String, XMLPattern> existingTypes;
    @NotNull
    private final String operationName;

    public GetMessageTypeReference(@NotNull WSDL wsdl, @NotNull XMLNode messageTypeNode, @NotNull SOAPMessageType soapMessageType, @NotNull Map<String, XMLPattern> existingTypes, @NotNull String operationName) {
        Intrinsics.checkNotNullParameter(wsdl, "wsdl");
        Intrinsics.checkNotNullParameter(messageTypeNode, "messageTypeNode");
        Intrinsics.checkNotNullParameter((Object)soapMessageType, "soapMessageType");
        Intrinsics.checkNotNullParameter(existingTypes, "existingTypes");
        Intrinsics.checkNotNullParameter(operationName, "operationName");
        this.wsdl = wsdl;
        this.messageTypeNode = messageTypeNode;
        this.soapMessageType = soapMessageType;
        this.existingTypes = existingTypes;
        this.operationName = operationName;
    }

    @NotNull
    public final XMLNode getMessageTypeNode() {
        return this.messageTypeNode;
    }

    @Override
    @NotNull
    public MessageTypeInfoParser execute() {
        MessageTypeInfoParser messageTypeInfoParser;
        FullyQualifiedName fullyQualifiedMessageName = this.messageTypeNode.fullyQualifiedNameFromAttribute("message");
        XMLNode messageNode = this.wsdl.findMessageNode(fullyQualifiedMessageName);
        XMLNode xMLNode = messageNode.firstNode();
        if (xMLNode == null) {
            return new MessageTypeProcessingComplete(new SoapPayloadType(this.existingTypes, new EmptySOAPPayload(this.soapMessageType)));
        }
        XMLNode partNode = xMLNode;
        if (partNode.getAttributes().containsKey("element")) {
            FullyQualifiedName fullyQualifiedTypeName = partNode.fullyQualifiedNameFromAttribute("element");
            messageTypeInfoParser = new ParseMessageWithElementRef(this.wsdl, fullyQualifiedTypeName, this.soapMessageType, this.existingTypes, this.operationName);
        } else if (partNode.getAttributes().containsKey("type")) {
            FullyQualifiedName fullyQualifiedTypeName = partNode.fullyQualifiedNameFromAttribute("type");
            String partName = partNode.getAttributeValue("name", "Part node of message named " + fullyQualifiedMessageName.getLocalName() + " does not have a name.");
            messageTypeInfoParser = new ParseMessageWithoutElementRef(fullyQualifiedMessageName, partName, fullyQualifiedTypeName, this.soapMessageType, this.existingTypes, this.operationName, this.wsdl);
        } else {
            throw new ContractException("Part node of message named " + fullyQualifiedMessageName.getLocalName() + " should contain either an element attribute or a type attribute.", null, null, null, false, 30, null);
        }
        return messageTypeInfoParser;
    }
}

