/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.wsdl.parser.message;

import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.XMLNode;
import io.specmatic.core.wsdl.parser.SOAP11ParserKt;
import io.specmatic.core.wsdl.parser.WSDL;
import io.specmatic.core.wsdl.parser.message.ChildElementType;
import io.specmatic.core.wsdl.parser.message.ComplexElement;
import io.specmatic.core.wsdl.parser.message.SimpleElement;
import io.specmatic.core.wsdl.parser.message.WSDLElement;
import java.lang.invoke.CallSite;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lio/specmatic/core/wsdl/parser/message/InlineType;", "Lio/specmatic/core/wsdl/parser/message/ChildElementType;", "parentTypeName", "", "child", "Lio/specmatic/core/value/XMLNode;", "wsdl", "Lio/specmatic/core/wsdl/parser/WSDL;", "(Ljava/lang/String;Lio/specmatic/core/value/XMLNode;Lio/specmatic/core/wsdl/parser/WSDL;)V", "getChild", "()Lio/specmatic/core/value/XMLNode;", "getParentTypeName", "()Ljava/lang/String;", "getWsdl", "()Lio/specmatic/core/wsdl/parser/WSDL;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "getWSDLElement", "Lkotlin/Pair;", "Lio/specmatic/core/wsdl/parser/message/WSDLElement;", "hashCode", "", "toString", "specmatic-core"})
public final class InlineType
implements ChildElementType {
    @NotNull
    private final String parentTypeName;
    @NotNull
    private final XMLNode child;
    @NotNull
    private final WSDL wsdl;

    public InlineType(@NotNull String parentTypeName, @NotNull XMLNode child, @NotNull WSDL wsdl) {
        Intrinsics.checkNotNullParameter(parentTypeName, "parentTypeName");
        Intrinsics.checkNotNullParameter(child, "child");
        Intrinsics.checkNotNullParameter(wsdl, "wsdl");
        this.parentTypeName = parentTypeName;
        this.child = child;
        this.wsdl = wsdl;
    }

    @NotNull
    public final String getParentTypeName() {
        return this.parentTypeName;
    }

    @NotNull
    public final XMLNode getChild() {
        return this.child;
    }

    @NotNull
    public final WSDL getWsdl() {
        return this.wsdl;
    }

    @Override
    @NotNull
    public Pair<String, WSDLElement> getWSDLElement() {
        String wsdlTypeReference = "";
        StringValue stringValue = this.child.getAttributes().get("name");
        if (stringValue == null) {
            throw new ContractException("Element does not have a name: " + this.child, null, null, null, false, 30, null);
        }
        StringValue elementName = stringValue;
        String specmaticTypeName = this.parentTypeName + "_" + elementName;
        WSDLElement element = SOAP11ParserKt.hasSimpleTypeAttribute(this.child) ? (WSDLElement)new SimpleElement(wsdlTypeReference, this.child, this.wsdl) : (WSDLElement)new ComplexElement(wsdlTypeReference, this.child, this.wsdl, null, 8, null);
        return new Pair<CallSite, WSDLElement>((CallSite)((Object)specmaticTypeName), element);
    }

    @NotNull
    public final String component1() {
        return this.parentTypeName;
    }

    @NotNull
    public final XMLNode component2() {
        return this.child;
    }

    @NotNull
    public final WSDL component3() {
        return this.wsdl;
    }

    @NotNull
    public final InlineType copy(@NotNull String parentTypeName, @NotNull XMLNode child, @NotNull WSDL wsdl) {
        Intrinsics.checkNotNullParameter(parentTypeName, "parentTypeName");
        Intrinsics.checkNotNullParameter(child, "child");
        Intrinsics.checkNotNullParameter(wsdl, "wsdl");
        return new InlineType(parentTypeName, child, wsdl);
    }

    public static /* synthetic */ InlineType copy$default(InlineType inlineType, String string, XMLNode xMLNode, WSDL wSDL, int n, Object object) {
        if ((n & 1) != 0) {
            string = inlineType.parentTypeName;
        }
        if ((n & 2) != 0) {
            xMLNode = inlineType.child;
        }
        if ((n & 4) != 0) {
            wSDL = inlineType.wsdl;
        }
        return inlineType.copy(string, xMLNode, wSDL);
    }

    @NotNull
    public String toString() {
        return "InlineType(parentTypeName=" + this.parentTypeName + ", child=" + this.child + ", wsdl=" + this.wsdl + ")";
    }

    public int hashCode() {
        int result2 = this.parentTypeName.hashCode();
        result2 = result2 * 31 + this.child.hashCode();
        result2 = result2 * 31 + this.wsdl.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InlineType)) {
            return false;
        }
        InlineType inlineType = (InlineType)other;
        if (!Intrinsics.areEqual(this.parentTypeName, inlineType.parentTypeName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.child, inlineType.child)) {
            return false;
        }
        return Intrinsics.areEqual(this.wsdl, inlineType.wsdl);
    }
}

