/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.license.core;

import io.specmatic.license.core.LicenseV1;
import io.specmatic.license.core.LicenseV3;
import io.specmatic.license.core.LicensedProduct;
import io.specmatic.license.core.SpecmaticPublicKey;
import io.specmatic.license.core.UtilizationTracker;
import io.specmatic.license.core.providers.LicenseLoaderContext;
import io.specmatic.license.core.providers.LicenseProvider;
import java.net.URL;
import java.security.PublicKey;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u000212B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0004\b\t\u0010\fJ!\u0010\u000f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010JG\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019JG\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015\u00a2\u0006\u0004\b\u0018\u0010\u001aR\u0018\u0010\u000f\u001a\u0006*\u00020\u001b0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00020#8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R$\u0010*\u001a\f\u0012\b\u0012\u0006*\u00020)0)0(8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0014\u0010!\u001a\u00020.8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100"}, d2={"Lio/specmatic/license/core/LicenseResolver;", "", "<init>", "()V", "Ljava/security/PublicKey;", "publicKey", "Ljava/net/URL;", "licenseServerUrl", "Lio/specmatic/license/core/LicenseV1;", "license", "(Ljava/security/PublicKey;Ljava/net/URL;)Lio/specmatic/license/core/LicenseV1;", "", "(Ljava/security/PublicKey;Ljava/lang/String;)Lio/specmatic/license/core/LicenseV1;", "p0", "p1", "a", "(Ljava/net/URL;Ljava/security/PublicKey;)Lio/specmatic/license/core/LicenseV1;", "Lio/specmatic/license/core/LicensedProduct;", "product", "", "feature", "", "labels", "", "utilize", "(Ljava/security/PublicKey;Ljava/net/URL;Lio/specmatic/license/core/LicensedProduct;Ljava/lang/Enum;Ljava/util/Set;)V", "(Ljava/security/PublicKey;Ljava/lang/String;Lio/specmatic/license/core/LicensedProduct;Ljava/lang/Enum;Ljava/util/Set;)V", "Lorg/joda/time/Duration;", "b", "Lorg/joda/time/Duration;", "", "Lio/specmatic/license/core/LicenseResolver$CacheKey;", "Lio/specmatic/license/core/LicenseResolver$CacheValue;", "c", "Ljava/util/Map;", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "", "Lio/specmatic/license/core/providers/LicenseProvider;", "providersInPriority", "Ljava/util/List;", "getProvidersInPriority", "()Ljava/util/List;", "Lio/specmatic/license/core/UtilizationTracker;", "d", "Lio/specmatic/license/core/UtilizationTracker;", "CacheKey", "CacheValue"})
@SourceDebugExtension(value={"SMAP\nLicenseResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseResolver.kt\nio/specmatic/license/core/LicenseResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n288#2,2:100\n1054#2:102\n1855#2,2:103\n*S KotlinDebug\n*F\n+ 1 LicenseResolver.kt\nio/specmatic/license/core/LicenseResolver\n*L\n85#1:100,2\n16#1:102\n33#1:103,2\n*E\n"})
public final class LicenseResolver {
    @NotNull
    public static final LicenseResolver INSTANCE = new LicenseResolver();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final List<LicenseProvider> providersInPriority;
    private static final Duration b;
    @NotNull
    private static final Map<CacheKey, CacheValue> c;
    @NotNull
    private static final UtilizationTracker d;

    private LicenseResolver() {
    }

    @NotNull
    @JvmName(name="getLogger")
    public final Logger getLogger() {
        return logger;
    }

    @NotNull
    @JvmName(name="getProvidersInPriority")
    public final List<LicenseProvider> getProvidersInPriority() {
        return providersInPriority;
    }

    public final void utilize(@NotNull PublicKey publicKey, @Nullable String licenseServerUrl, @NotNull LicensedProduct product, @NotNull Enum<?> feature, @NotNull Set<String> labels) {
        Intrinsics.checkNotNullParameter(publicKey, "");
        Intrinsics.checkNotNullParameter((Object)product, "");
        Intrinsics.checkNotNullParameter(feature, "");
        Intrinsics.checkNotNullParameter(labels, "");
        this.utilize(publicKey, licenseServerUrl != null ? new URL(licenseServerUrl) : null, product, feature, labels);
    }

    public static /* synthetic */ void utilize$default(LicenseResolver licenseResolver, PublicKey publicKey, String string, LicensedProduct licensedProduct, Enum enum_, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            publicKey = SpecmaticPublicKey.INSTANCE.getValue();
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            set2 = SetsKt.emptySet();
        }
        licenseResolver.utilize(publicKey, string, licensedProduct, enum_, set2);
    }

    public final void utilize(@NotNull PublicKey publicKey, @Nullable URL licenseServerUrl, @NotNull LicensedProduct product, @NotNull Enum<?> feature, @NotNull Set<String> labels) {
        Intrinsics.checkNotNullParameter(publicKey, "");
        Intrinsics.checkNotNullParameter((Object)product, "");
        Intrinsics.checkNotNullParameter(feature, "");
        Intrinsics.checkNotNullParameter(labels, "");
        LicenseV1 licenseV1 = this.license(publicKey, licenseServerUrl);
        licenseV1.utilize$core(product);
        if (licenseV1 instanceof LicenseV3) {
            d.recordUtilization((LicenseV3)licenseV1, feature, labels);
        }
    }

    public static /* synthetic */ void utilize$default(LicenseResolver licenseResolver, PublicKey publicKey, URL uRL, LicensedProduct licensedProduct, Enum enum_, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            publicKey = SpecmaticPublicKey.INSTANCE.getValue();
        }
        if ((n & 2) != 0) {
            uRL = null;
        }
        if ((n & 0x10) != 0) {
            set2 = SetsKt.emptySet();
        }
        licenseResolver.utilize(publicKey, uRL, licensedProduct, enum_, set2);
    }

    @NotNull
    public final LicenseV1 license(@NotNull PublicKey publicKey, @Nullable String licenseServerUrl) {
        Intrinsics.checkNotNullParameter(publicKey, "");
        return this.license(publicKey, licenseServerUrl != null ? new URL(licenseServerUrl) : null);
    }

    public static /* synthetic */ LicenseV1 license$default(LicenseResolver licenseResolver, PublicKey publicKey, String string, int n, Object object) {
        if ((n & 1) != 0) {
            publicKey = SpecmaticPublicKey.INSTANCE.getValue();
        }
        return licenseResolver.license(publicKey, string);
    }

    @NotNull
    public final LicenseV1 license(@NotNull PublicKey publicKey, @Nullable URL licenseServerUrl) {
        Intrinsics.checkNotNullParameter(publicKey, "");
        DateTime dateTime = DateTime.now();
        CacheKey cacheKey = new CacheKey(publicKey, licenseServerUrl);
        CacheValue cacheValue2 = c.compute(cacheKey, (arg_0, arg_1) -> LicenseResolver.a(new Function2<CacheKey, CacheValue, CacheValue>(dateTime, licenseServerUrl, publicKey){
            final /* synthetic */ DateTime $e;
            final /* synthetic */ URL $f;
            final /* synthetic */ PublicKey $g;
            {
                this.$e = $now;
                this.$f = $licenseServerUrl;
                this.$g = $publicKey;
                super(2);
            }

            public final CacheValue invoke(CacheKey cacheKey, CacheValue oldValue) {
                CacheValue cacheValue2;
                Intrinsics.checkNotNullParameter(cacheKey, "");
                if (oldValue != null && oldValue.getTimestamp().plus(LicenseResolver.access$getCACHE_TTL$p()).isAfter(this.$e)) {
                    cacheValue2 = oldValue;
                } else {
                    LicenseV1 licenseV1 = LicenseResolver.access$loadOrFetchLicense(LicenseResolver.INSTANCE, this.$f, this.$g);
                    DateTime dateTime = this.$e;
                    Intrinsics.checkNotNull(dateTime);
                    CacheValue cacheValue3 = new CacheValue(licenseV1, dateTime);
                    cacheValue2 = cacheValue3;
                }
                return cacheValue2;
            }
        }, arg_0, arg_1));
        logger.trace("Returning cached license for key: {}", (Object)cacheKey);
        CacheValue cacheValue3 = cacheValue2;
        Intrinsics.checkNotNull(cacheValue3);
        return cacheValue3.getLicense();
    }

    public static /* synthetic */ LicenseV1 license$default(LicenseResolver licenseResolver, PublicKey publicKey, URL uRL, int n, Object object) {
        if ((n & 1) != 0) {
            publicKey = SpecmaticPublicKey.INSTANCE.getValue();
        }
        if ((n & 2) != 0) {
            uRL = new URL("https://insights.specmatic.io");
        }
        return licenseResolver.license(publicKey, uRL);
    }

    private final LicenseV1 a(URL uRL, PublicKey publicKey) {
        Object object;
        Object v1;
        Object object2;
        LicenseLoaderContext licenseLoaderContext;
        block4: {
            DateTime dateTime = DateTime.now();
            Intrinsics.checkNotNullExpressionValue(dateTime, "");
            licenseLoaderContext = new LicenseLoaderContext(uRL, dateTime, 0, 0L, 12, null);
            object2 = providersInPriority;
            boolean bl = false;
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Object t2 = iterator2.next();
                LicenseProvider licenseProvider = (LicenseProvider)t2;
                boolean bl2 = false;
                if (!(licenseProvider.license(publicKey, licenseLoaderContext) != null)) continue;
                v1 = t2;
                break block4;
            }
            v1 = null;
        }
        LicenseProvider licenseProvider = v1;
        if (licenseProvider != null) {
            logger.info("Using license provider: " + licenseProvider.getClass() + " - " + licenseProvider.getDescribe());
        } else {
            logger.warn("No license provider found. Using Specmatic without a license is not recommended. Please visit the https://specmatic.io/pricing/ page to see the available plans and upgrade..");
        }
        if ((object = licenseProvider) == null || (object = ((LicenseProvider)object).license(publicKey, licenseLoaderContext)) == null) {
            throw new IllegalStateException("No license provider found");
        }
        object2 = object;
        return object2;
    }

    private static final CacheValue a(Function2 function2, Object object, Object object2) {
        return (CacheValue)function2.invoke(object, object2);
    }

    public static final /* synthetic */ Duration access$getCACHE_TTL$p() {
        return b;
    }

    public static final /* synthetic */ LicenseV1 access$loadOrFetchLicense(LicenseResolver $this, URL licenseServerUrl, PublicKey publicKey) {
        return $this.a(licenseServerUrl, publicKey);
    }

    static {
        Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue(logger, "");
        LicenseResolver.logger = logger;
        ServiceLoader<LicenseProvider> serviceLoader = ServiceLoader.load(LicenseProvider.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, "");
        Iterable iterable = serviceLoader;
        boolean bl = false;
        providersInPriority = CollectionsKt.sortedWith(iterable, new Comparator(){

            public final int compare(T a2, T b2) {
                LicenseProvider licenseProvider = (LicenseProvider)b2;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(licenseProvider.getPriority());
                licenseProvider = (LicenseProvider)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, licenseProvider.getPriority());
            }
        });
        b = Duration.standardMinutes(5L);
        c = new ConcurrentHashMap();
        d = new UtilizationTracker();
        if (providersInPriority.isEmpty()) {
            throw new IllegalStateException("No license providers found. Please ensure that at least one implementation of LicenseProvider is available.");
        }
        iterable = providersInPriority;
        bl = false;
        for (Object t2 : iterable) {
            LicenseProvider licenseProvider = (LicenseProvider)t2;
            boolean bl2 = false;
            LicenseResolver.logger.info("Found license provider " + licenseProvider.getClass() + " (priority " + licenseProvider.getPriority() + "): " + licenseProvider.getDescribe());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u0004H\u00c7\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c7\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d7\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000bR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\t"}, d2={"Lio/specmatic/license/core/LicenseResolver$CacheKey;", "", "Ljava/security/PublicKey;", "publicKey", "Ljava/net/URL;", "licenseServerUrl", "<init>", "(Ljava/security/PublicKey;Ljava/net/URL;)V", "component1", "()Ljava/security/PublicKey;", "component2", "()Ljava/net/URL;", "copy", "(Ljava/security/PublicKey;Ljava/net/URL;)Lio/specmatic/license/core/LicenseResolver$CacheKey;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/net/URL;", "getLicenseServerUrl", "Ljava/security/PublicKey;", "getPublicKey"})
    private static final class CacheKey {
        @NotNull
        private final PublicKey publicKey;
        @Nullable
        private final URL licenseServerUrl;

        public CacheKey(@NotNull PublicKey publicKey, @Nullable URL licenseServerUrl) {
            Intrinsics.checkNotNullParameter(publicKey, "");
            this.publicKey = publicKey;
            this.licenseServerUrl = licenseServerUrl;
        }

        @NotNull
        @JvmName(name="getPublicKey")
        public final PublicKey getPublicKey() {
            return this.publicKey;
        }

        @Nullable
        @JvmName(name="getLicenseServerUrl")
        public final URL getLicenseServerUrl() {
            return this.licenseServerUrl;
        }

        @NotNull
        public final PublicKey component1() {
            return this.publicKey;
        }

        @Nullable
        public final URL component2() {
            return this.licenseServerUrl;
        }

        @NotNull
        public final CacheKey copy(@NotNull PublicKey publicKey, @Nullable URL licenseServerUrl) {
            Intrinsics.checkNotNullParameter(publicKey, "");
            return new CacheKey(publicKey, licenseServerUrl);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, PublicKey publicKey, URL uRL, int n, Object object) {
            if ((n & 1) != 0) {
                publicKey = cacheKey.publicKey;
            }
            if ((n & 2) != 0) {
                uRL = cacheKey.licenseServerUrl;
            }
            return cacheKey.copy(publicKey, uRL);
        }

        @NotNull
        public String toString() {
            return "CacheKey(publicKey=" + this.publicKey + ", licenseServerUrl=" + this.licenseServerUrl + ")";
        }

        public int hashCode() {
            int n = this.publicKey.hashCode();
            n = n * 31 + (this.licenseServerUrl == null ? 0 : this.licenseServerUrl.hashCode());
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual(this.publicKey, cacheKey.publicKey)) {
                return false;
            }
            return Intrinsics.areEqual(this.licenseServerUrl, cacheKey.licenseServerUrl);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c7\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c7\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d7\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\tR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u000b"}, d2={"Lio/specmatic/license/core/LicenseResolver$CacheValue;", "", "Lio/specmatic/license/core/LicenseV1;", "license", "Lorg/joda/time/DateTime;", "timestamp", "<init>", "(Lio/specmatic/license/core/LicenseV1;Lorg/joda/time/DateTime;)V", "component1", "()Lio/specmatic/license/core/LicenseV1;", "component2", "()Lorg/joda/time/DateTime;", "copy", "(Lio/specmatic/license/core/LicenseV1;Lorg/joda/time/DateTime;)Lio/specmatic/license/core/LicenseResolver$CacheValue;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lio/specmatic/license/core/LicenseV1;", "getLicense", "Lorg/joda/time/DateTime;", "getTimestamp"})
    private static final class CacheValue {
        @NotNull
        private final LicenseV1 license;
        @NotNull
        private final DateTime timestamp;

        public CacheValue(@NotNull LicenseV1 license2, @NotNull DateTime timestamp) {
            Intrinsics.checkNotNullParameter(license2, "");
            Intrinsics.checkNotNullParameter(timestamp, "");
            this.license = license2;
            this.timestamp = timestamp;
        }

        @NotNull
        @JvmName(name="getLicense")
        public final LicenseV1 getLicense() {
            return this.license;
        }

        @NotNull
        @JvmName(name="getTimestamp")
        public final DateTime getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final LicenseV1 component1() {
            return this.license;
        }

        @NotNull
        public final DateTime component2() {
            return this.timestamp;
        }

        @NotNull
        public final CacheValue copy(@NotNull LicenseV1 license2, @NotNull DateTime timestamp) {
            Intrinsics.checkNotNullParameter(license2, "");
            Intrinsics.checkNotNullParameter(timestamp, "");
            return new CacheValue(license2, timestamp);
        }

        public static /* synthetic */ CacheValue copy$default(CacheValue cacheValue2, LicenseV1 licenseV1, DateTime dateTime, int n, Object object) {
            if ((n & 1) != 0) {
                licenseV1 = cacheValue2.license;
            }
            if ((n & 2) != 0) {
                dateTime = cacheValue2.timestamp;
            }
            return cacheValue2.copy(licenseV1, dateTime);
        }

        @NotNull
        public String toString() {
            return "CacheValue(license=" + this.license + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int n = this.license.hashCode();
            n = n * 31 + this.timestamp.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheValue)) {
                return false;
            }
            CacheValue cacheValue2 = (CacheValue)other;
            if (!Intrinsics.areEqual(this.license, cacheValue2.license)) {
                return false;
            }
            return Intrinsics.areEqual(this.timestamp, cacheValue2.timestamp);
        }
    }
}

