/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.license.core;

import io.specmatic.license.core.LicenseType;
import io.specmatic.license.core.LicenseV1;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u000e\u001a\u00020\r8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\f\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\u001d\u001a\u0004\b\u001e\u0010\u0019"}, d2={"Lio/specmatic/license/core/LicenseV2;", "Lio/specmatic/license/core/LicenseV1;", "", "licensee", "Lorg/joda/time/DateTime;", "startDate", "Lorg/joda/time/Duration;", "duration", "Lio/specmatic/license/core/LicenseType;", "licenseType", "", "rateLimit", "organisationId", "Ljava/net/URL;", "insightsServerURL", "<init>", "(Ljava/lang/String;Lorg/joda/time/DateTime;Lorg/joda/time/Duration;Lio/specmatic/license/core/LicenseType;ILjava/lang/String;Ljava/net/URL;)V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/net/URL;", "getInsightsServerURL", "()Ljava/net/URL;", "Ljava/lang/String;", "getOrganisationId"})
public class LicenseV2
extends LicenseV1 {
    @NotNull
    private final String organisationId;
    @NotNull
    private final URL insightsServerURL;

    public LicenseV2(@NotNull String licensee, @NotNull DateTime startDate, @NotNull Duration duration, @NotNull LicenseType licenseType, int rateLimit, @NotNull String organisationId, @NotNull URL insightsServerURL) {
        Intrinsics.checkNotNullParameter(licensee, "");
        Intrinsics.checkNotNullParameter(startDate, "");
        Intrinsics.checkNotNullParameter(duration, "");
        Intrinsics.checkNotNullParameter((Object)licenseType, "");
        Intrinsics.checkNotNullParameter(organisationId, "");
        Intrinsics.checkNotNullParameter(insightsServerURL, "");
        super(licensee, startDate, duration, licenseType, rateLimit);
        this.organisationId = organisationId;
        this.insightsServerURL = insightsServerURL;
    }

    @NotNull
    @JvmName(name="getOrganisationId")
    public final String getOrganisationId() {
        return this.organisationId;
    }

    @NotNull
    @JvmName(name="getInsightsServerURL")
    public final URL getInsightsServerURL() {
        return this.insightsServerURL;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append(super.toString());
        stringBuilder2.append("Organisation ID: " + this.organisationId + "\n");
        stringBuilder2.append("Insights server: " + this.insightsServerURL + "\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LicenseV2)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.organisationId, ((LicenseV2)other).organisationId)) {
            return false;
        }
        return Intrinsics.areEqual(this.insightsServerURL, ((LicenseV2)other).insightsServerURL);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.organisationId.hashCode();
        n = 31 * n + this.insightsServerURL.hashCode();
        return n;
    }
}

