/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.license.core;

import io.specmatic.license.core.Labels;
import io.specmatic.license.core.LicenseV3;
import io.specmatic.license.core.UtilizationTracker;
import io.specmatic.license.core.a.a;
import io.specmatic.license.core.a.a.d;
import io.specmatic.license.core.dto.Usage;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u0003J7\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00042\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u00100\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0016\u0010\u0003R\u0016\u0010\u0014\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001b\u001a\u0006*\u00020\u001a0\u001a8\u0007\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\"\u001a\u00020\u001f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R8\u0010(\u001a&\u0012\u0004\u0012\u00020\u0004\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%0$0$0#8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'"}, d2={"Lio/specmatic/license/core/UtilizationTracker;", "", "<init>", "()V", "Lio/specmatic/license/core/LicenseV3;", "license", "", "feature", "", "", "labels", "", "recordUtilization", "(Lio/specmatic/license/core/LicenseV3;Ljava/lang/Enum;Ljava/util/Set;)V", "shipAll", "p0", "", "Lio/specmatic/license/core/Labels;", "", "p1", "a", "(Lio/specmatic/license/core/LicenseV3;Ljava/util/Map;)V", "shutdownAndFlush", "", "p", "Z", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "Ljava/util/concurrent/ScheduledExecutorService;", "o", "Ljava/util/concurrent/ScheduledExecutorService;", "b", "", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/atomic/AtomicInteger;", "n", "Ljava/util/Map;", "c"})
@SourceDebugExtension(value={"SMAP\nUtilizationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UtilizationTracker.kt\nio/specmatic/license/core/UtilizationTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class UtilizationTracker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final Map<LicenseV3, ConcurrentHashMap<Labels, ConcurrentHashMap<String, AtomicInteger>>> n = new ConcurrentHashMap();
    @NotNull
    private final ScheduledExecutorService o;
    private volatile boolean p;

    public UtilizationTracker() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(UtilizationTracker::a);
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "");
        this.o = scheduledExecutorService;
        this.o.scheduleAtFixedRate(() -> UtilizationTracker.a(this), 15L, 15L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> UtilizationTracker.b(this)));
    }

    @JvmName(name="getLogger")
    public final Logger getLogger() {
        return this.logger;
    }

    public final void recordUtilization(@NotNull LicenseV3 license2, @NotNull Enum<?> feature, @NotNull Set<String> labels) {
        Intrinsics.checkNotNullParameter(license2, "");
        Intrinsics.checkNotNullParameter(feature, "");
        Intrinsics.checkNotNullParameter(labels, "");
        ConcurrentHashMap concurrentHashMap = this.n.computeIfAbsent(license2, arg_0 -> UtilizationTracker.a(recordUtilization.labelMap.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentHashMap, "");
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap;
        ConcurrentHashMap concurrentHashMap3 = concurrentHashMap2.computeIfAbsent(new Labels(labels), arg_0 -> UtilizationTracker.b(recordUtilization.featureMap.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentHashMap3, "");
        ConcurrentHashMap concurrentHashMap4 = concurrentHashMap3;
        String string = feature.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "");
        AtomicInteger atomicInteger = concurrentHashMap4.computeIfAbsent(string, arg_0 -> UtilizationTracker.c(recordUtilization.counter.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(atomicInteger, "");
        AtomicInteger atomicInteger2 = atomicInteger;
        atomicInteger2.incrementAndGet();
    }

    public final void shipAll() {
        for (Map.Entry<LicenseV3, ConcurrentHashMap<Labels, ConcurrentHashMap<String, AtomicInteger>>> entry : this.n.entrySet()) {
            int n;
            Object object;
            Iterator iterator2;
            Map map2;
            Object object2;
            LicenseV3 licenseV3 = entry.getKey();
            ConcurrentHashMap<Labels, ConcurrentHashMap<String, AtomicInteger>> concurrentHashMap = entry.getValue();
            Map map3 = new LinkedHashMap();
            for (Map.Entry entry2 : ((Map)concurrentHashMap).entrySet()) {
                Object object3 = (Labels)entry2.getKey();
                object2 = (ConcurrentHashMap)entry2.getValue();
                map2 = new LinkedHashMap();
                iterator2 = ((Map)object2).entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry3 = iterator2.next();
                    String string = (String)entry3.getKey();
                    object = (AtomicInteger)entry3.getValue();
                    n = ((AtomicInteger)object).get();
                    if (n <= 0) continue;
                    map2.put(string, n);
                }
                if (!(!map2.isEmpty())) continue;
                map3.put(object3, map2);
            }
            if (!(!map3.isEmpty())) continue;
            try {
                this.a(licenseV3, map3);
                ConcurrentHashMap<Labels, ConcurrentHashMap<String, AtomicInteger>> concurrentHashMap2 = this.n.get(licenseV3);
                if (concurrentHashMap2 == null) continue;
                ConcurrentHashMap<Labels, ConcurrentHashMap<String, AtomicInteger>> concurrentHashMap3 = concurrentHashMap2;
                for (Object object3 : map3.entrySet()) {
                    object2 = (Labels)object3.getKey();
                    map2 = (Map)object3.getValue();
                    if ((ConcurrentHashMap)concurrentHashMap3.get(object2) == null) continue;
                    for (Map.Entry entry4 : map2.entrySet()) {
                        object = (String)entry4.getKey();
                        n = ((Number)entry4.getValue()).intValue();
                        AtomicInteger atomicInteger = (AtomicInteger)((ConcurrentHashMap)((Object)iterator2)).get(object);
                        if (atomicInteger == null) continue;
                        atomicInteger.addAndGet(-n);
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private final void a(LicenseV3 licenseV3, Map<Labels, ? extends Map<String, Integer>> map2) {
        List<Usage> list = Usage.Companion.fromUtilizationData(licenseV3.getLicensee(), map2);
        String string = d.D().writeValueAsString(list);
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(licenseV3.getInsightsServerURL() + "/api/orgs/" + licenseV3.getOrganisationId() + "/consume/bulk")).header("Content-Type", "application/json").timeout(Duration.ofSeconds(5L)).POST(HttpRequest.BodyPublishers.ofString(string)).build();
        HttpResponse<String> httpResponse = a.e().send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (httpResponse.statusCode() != 202) {
            this.logger.error("Failed to ship utilization data: " + httpResponse.statusCode() + " - " + httpResponse.body());
            throw new RuntimeException("Failed to ship utilization data: " + httpResponse.statusCode() + " - " + httpResponse.body());
        }
        this.logger.info("Successfully shipped utilization data for " + licenseV3.getLicensee());
    }

    public final void shutdownAndFlush() {
        if (!this.p) {
            this.p = true;
            this.o.shutdown();
            try {
                if (!this.o.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.o.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                this.o.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.shipAll();
        }
    }

    private static final Thread a(Runnable runnable2) {
        Thread thread2;
        Thread thread3 = thread2 = new Thread(runnable2);
        boolean bl = false;
        thread3.setDaemon(true);
        return thread2;
    }

    private static final void a(UtilizationTracker utilizationTracker) {
        try {
            utilizationTracker.shipAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void b(UtilizationTracker utilizationTracker) {
        utilizationTracker.shutdownAndFlush();
    }

    private static final ConcurrentHashMap a(Function1 function1, Object object) {
        return (ConcurrentHashMap)function1.invoke(object);
    }

    private static final ConcurrentHashMap b(Function1 function1, Object object) {
        return (ConcurrentHashMap)function1.invoke(object);
    }

    private static final AtomicInteger c(Function1 function1, Object object) {
        return (AtomicInteger)function1.invoke(object);
    }
}

