/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.license.core.a;

import io.specmatic.license.core.LicenseExpiredException;
import io.specmatic.license.core.LicenseNotYetValidException;
import io.specmatic.license.core.LicenseRateLimitExceededException;
import io.specmatic.license.core.LicenseType;
import io.specmatic.license.core.LicensedProduct;
import io.specmatic.license.core.a.g;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\r\u0010\u001d\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020!2\b\b\u0002\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b$\u0010%R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010&\u001a\u0004\b'\u0010(R\u0011\u0010+\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001a\u0010\t\u001a\u00020\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010,\u001a\u0004\b-\u0010.R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010/\u001a\u0004\b0\u0010 R\u001e\u00102\u001a\u0006*\u000201018\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u0017\u0010\u000b\u001a\u00020\n8\u0007\u00a2\u0006\f\n\u0004\b\u000b\u00106\u001a\u0004\b7\u0010\u0018R\u0014\u0010;\u001a\u0002088\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0011\u0010=\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0018R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010>\u001a\u0004\b?\u0010*"}, d2={"Lio/specmatic/license/core/a/e;", "", "", "licensee", "Lorg/joda/time/DateTime;", "startDate", "Lorg/joda/time/Duration;", "duration", "Lio/specmatic/license/core/LicenseType;", "licenseType", "", "rateLimit", "<init>", "(Ljava/lang/String;Lorg/joda/time/DateTime;Lorg/joda/time/Duration;Lio/specmatic/license/core/LicenseType;I)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "cumulativeUsage", "Lio/specmatic/license/core/LicensedProduct;", "product", "exceedsLimit", "(ILio/specmatic/license/core/LicensedProduct;)Z", "hashCode", "()I", "now", "isExpired", "(Lorg/joda/time/DateTime;)Z", "isNotExpired", "isUnlimitedLicense", "()Z", "toString", "()Ljava/lang/String;", "", "utilize$core", "(Lio/specmatic/license/core/LicensedProduct;)V", "validateDates", "(Lorg/joda/time/DateTime;)V", "Lorg/joda/time/Duration;", "getDuration", "()Lorg/joda/time/Duration;", "getEndDate", "()Lorg/joda/time/DateTime;", "endDate", "Lio/specmatic/license/core/LicenseType;", "getLicenseType", "()Lio/specmatic/license/core/LicenseType;", "Ljava/lang/String;", "getLicensee", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "I", "getRateLimit", "Ljava/util/concurrent/atomic/AtomicInteger;", "x", "Ljava/util/concurrent/atomic/AtomicInteger;", "a", "getRemainingLimitValue", "remainingLimitValue", "Lorg/joda/time/DateTime;", "getStartDate"})
public class e {
    @NotNull
    private final String licensee;
    @NotNull
    private final DateTime startDate;
    @NotNull
    private final Duration duration;
    @NotNull
    private final LicenseType licenseType;
    private final int rateLimit;
    private final Logger logger;
    @NotNull
    private final AtomicInteger x;

    public e(@NotNull String string, @NotNull DateTime dateTime, @NotNull Duration duration, @NotNull LicenseType licenseType, int n) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(dateTime, "");
        Intrinsics.checkNotNullParameter(duration, "");
        Intrinsics.checkNotNullParameter((Object)licenseType, "");
        this.licensee = string;
        this.startDate = dateTime;
        this.duration = duration;
        this.licenseType = licenseType;
        this.rateLimit = n;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.x = new AtomicInteger(this.rateLimit);
    }

    @NotNull
    @JvmName(name="getLicensee")
    public final String getLicensee() {
        return this.licensee;
    }

    @NotNull
    @JvmName(name="getStartDate")
    public final DateTime getStartDate() {
        return this.startDate;
    }

    @NotNull
    @JvmName(name="getDuration")
    public final Duration getDuration() {
        return this.duration;
    }

    @NotNull
    @JvmName(name="getLicenseType")
    public final LicenseType getLicenseType() {
        return this.licenseType;
    }

    @JvmName(name="getRateLimit")
    public final int getRateLimit() {
        return this.rateLimit;
    }

    @JvmName(name="getLogger")
    public final Logger getLogger() {
        return this.logger;
    }

    @JvmName(name="getRemainingLimitValue")
    public final int getRemainingLimitValue() {
        return this.x.get();
    }

    @NotNull
    @JvmName(name="getEndDate")
    public final DateTime getEndDate() {
        DateTime dateTime = this.startDate.plus(this.duration);
        Intrinsics.checkNotNullExpressionValue(dateTime, "");
        return dateTime;
    }

    public final void utilize$core(@NotNull LicensedProduct product) {
        Intrinsics.checkNotNullParameter((Object)product, "");
        e.validateDates$default(this, null, 1, null);
        if (this.isUnlimitedLicense()) {
            return;
        }
        int n = this.x.getAndDecrement();
        if (n <= 0) {
            throw new LicenseRateLimitExceededException(this.rateLimit, this.licenseType, product);
        }
    }

    public final boolean exceedsLimit(int cumulativeUsage, @NotNull LicensedProduct product) {
        Intrinsics.checkNotNullParameter((Object)product, "");
        e.validateDates$default(this, null, 1, null);
        if (this.isUnlimitedLicense()) {
            return false;
        }
        if (cumulativeUsage > this.rateLimit) {
            throw new LicenseRateLimitExceededException(this.rateLimit, this.licenseType, product);
        }
        return false;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        String string = g.k().print(this.startDate);
        String string2 = g.k().print(this.getEndDate());
        String string3 = this.isUnlimitedLicense() ? "Unlimited" : String.valueOf(this.rateLimit);
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append("Licensed to: " + this.licensee + "\n");
        stringBuilder2.append("Start date: " + string + "\n");
        stringBuilder2.append("Expiry date: " + string2 + "\n");
        stringBuilder2.append("License type: " + this.licenseType + "\n");
        stringBuilder2.append("Rate limit: " + string3 + "\n");
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "");
        return string4;
    }

    public final boolean isUnlimitedLicense() {
        return this.rateLimit == -1;
    }

    public final void validateDates(@NotNull DateTime now) {
        Intrinsics.checkNotNullParameter(now, "");
        if (now.isBefore(this.startDate)) {
            throw new LicenseNotYetValidException(this.startDate);
        }
        if (this.isExpired(now)) {
            throw new LicenseExpiredException(this.getEndDate());
        }
    }

    public static /* synthetic */ void validateDates$default(e e2, DateTime dateTime, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException();
        }
        if ((n & 1) != 0) {
            DateTime dateTime2 = DateTime.now();
            Intrinsics.checkNotNullExpressionValue(dateTime2, "");
            dateTime = dateTime2;
        }
        e2.validateDates(dateTime);
    }

    public final boolean isExpired(@NotNull DateTime now) {
        Intrinsics.checkNotNullParameter(now, "");
        return now.isAfter(this.getEndDate());
    }

    public static /* synthetic */ boolean isExpired$default(e e2, DateTime dateTime, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException();
        }
        if ((n & 1) != 0) {
            DateTime dateTime2 = DateTime.now();
            Intrinsics.checkNotNullExpressionValue(dateTime2, "");
            dateTime = dateTime2;
        }
        return e2.isExpired(dateTime);
    }

    public final boolean isNotExpired(@NotNull DateTime now) {
        Intrinsics.checkNotNullParameter(now, "");
        return !this.isExpired(now);
    }

    public static /* synthetic */ boolean isNotExpired$default(e e2, DateTime dateTime, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException();
        }
        if ((n & 1) != 0) {
            DateTime dateTime2 = DateTime.now();
            Intrinsics.checkNotNullExpressionValue(dateTime2, "");
            dateTime = dateTime2;
        }
        return e2.isNotExpired(dateTime);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof e)) {
            return false;
        }
        if (this.rateLimit != ((e)other).rateLimit) {
            return false;
        }
        if (!Intrinsics.areEqual(this.licensee, ((e)other).licensee)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.startDate, ((e)other).startDate)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.duration, ((e)other).duration)) {
            return false;
        }
        if (this.licenseType != ((e)other).licenseType) {
            return false;
        }
        return this.x.get() == ((e)other).x.get();
    }

    public int hashCode() {
        int n = this.rateLimit;
        n = 31 * n + this.licensee.hashCode();
        n = 31 * n + this.startDate.hashCode();
        n = 31 * n + this.duration.hashCode();
        n = 31 * n + this.licenseType.hashCode();
        n = 31 * n + this.x.hashCode();
        return n;
    }
}

