/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.license.core.cli;

import io.specmatic.license.core.LicenseResolver;
import io.specmatic.license.core.LicenseV1;
import io.specmatic.license.core.LicenseV3;
import io.specmatic.license.core.SpecmaticPublicKey;
import io.specmatic.license.core.providers.LicenseLoaderContext;
import io.specmatic.license.core.providers.a.e;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import picocli.CommandLine;

@CommandLine.Command(name="get-license", mixinStandardHelpOptions=true, description={"Fetch a license from a Specmatic License Server"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003R\"\u0010\u0007\u001a\u00020\u00068\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f"}, d2={"Lio/specmatic/license/core/cli/FetchLicenseCommand;", "Ljava/lang/Runnable;", "<init>", "()V", "", "run", "Ljava/net/URL;", "licenseServerUrl", "Ljava/net/URL;", "getLicenseServerUrl", "()Ljava/net/URL;", "setLicenseServerUrl", "(Ljava/net/URL;)V"})
public final class FetchLicenseCommand
implements Runnable {
    @CommandLine.Option(names={"--insights-server-url"}, description={"URL of the Specmatic Insights Server"}, paramLabel="URL", hidden=true, defaultValue="https://insights.specmatic.io")
    @NotNull
    private URL licenseServerUrl = new URL("https://insights.specmatic.io");

    @NotNull
    @JvmName(name="getLicenseServerUrl")
    public final URL getLicenseServerUrl() {
        return this.licenseServerUrl;
    }

    @JvmName(name="setLicenseServerUrl")
    public final void setLicenseServerUrl(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter(uRL, "");
        this.licenseServerUrl = uRL;
    }

    @Override
    public void run() {
        DateTime dateTime = DateTime.now();
        new e(null, null, 3, null).b(SpecmaticPublicKey.INSTANCE.getValue(), new LicenseLoaderContext(this.licenseServerUrl, null, 0, 0L, 14, null));
        LicenseV1 licenseV1 = LicenseResolver.INSTANCE.license(SpecmaticPublicKey.INSTANCE.getValue(), this.licenseServerUrl);
        if (licenseV1 instanceof LicenseV3) {
            System.out.println((Object)("Got license:\n" + licenseV1));
            return;
        }
        DateTime dateTime2 = DateTime.now();
        int n = new Duration(dateTime, dateTime2).toStandardSeconds().getSeconds();
        throw new RuntimeException("Failed to fetch license from " + this.licenseServerUrl + " after " + n + " seconds. Falling back to available license:\n" + licenseV1);
    }
}

