/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.license.core.providers;

import io.specmatic.license.core.providers.LicenseProvider;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0014\u0010\u0012\u001a\u00020\u000f8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011"}, d2={"Lio/specmatic/license/core/providers/AbstractClasspathLicenseProvider;", "Lio/specmatic/license/core/providers/LicenseProvider;", "", "classpathFile", "", "priority", "<init>", "(Ljava/lang/String;I)V", "Ljava/lang/String;", "getClasspathFile", "()Ljava/lang/String;", "getDescribe", "describe", "getLicenseText", "licenseText", "Ljava/net/URL;", "E", "()Ljava/net/URL;", "a"})
@SourceDebugExtension(value={"SMAP\nAbstractClasspathLicenseProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractClasspathLicenseProvider.kt\nio/specmatic/license/core/providers/AbstractClasspathLicenseProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public abstract class AbstractClasspathLicenseProvider
extends LicenseProvider {
    @NotNull
    private final String classpathFile;

    public AbstractClasspathLicenseProvider(@NotNull String classpathFile, int priority) {
        Intrinsics.checkNotNullParameter(classpathFile, "");
        super(priority);
        this.classpathFile = classpathFile;
        if (!(priority < 1000)) {
            boolean bl = false;
            String string = "priority must be less than 1000, but was " + priority;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    @JvmName(name="getClasspathFile")
    public final String getClasspathFile() {
        return this.classpathFile;
    }

    @Override
    @NotNull
    @JvmName(name="getDescribe")
    public String getDescribe() {
        String string = this.E().toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    @JvmName(name="E")
    private final URL E() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource(this.classpathFile);
        if (uRL == null) {
            throw new IllegalStateException("License file " + this.classpathFile + " not found in classpath");
        }
        URL uRL2 = uRL;
        return uRL2;
    }

    @Override
    @Nullable
    @JvmName(name="getLicenseText")
    public String getLicenseText() {
        URL uRL = this.E();
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes(uRL);
        return new String(byArray, charset);
    }
}

