/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.license.core.providers;

import io.specmatic.license.core.LicenseLoader;
import io.specmatic.license.core.LicenseV1;
import io.specmatic.license.core.providers.LicenseLoaderContext;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0004\b\r\u0010\fR\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000e8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u000e8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016"}, d2={"Lio/specmatic/license/core/providers/LicenseProvider;", "", "", "priority", "<init>", "(I)V", "Ljava/security/PublicKey;", "publicKey", "Lio/specmatic/license/core/providers/LicenseLoaderContext;", "context", "Lio/specmatic/license/core/LicenseV1;", "doLoadLicense", "(Ljava/security/PublicKey;Lio/specmatic/license/core/providers/LicenseLoaderContext;)Lio/specmatic/license/core/LicenseV1;", "license", "", "getDescribe", "()Ljava/lang/String;", "describe", "getLicenseText", "licenseText", "I", "getPriority", "()I"})
public abstract class LicenseProvider {
    private final int priority;

    public LicenseProvider(int priority) {
        this.priority = priority;
    }

    @JvmName(name="getPriority")
    public final int getPriority() {
        return this.priority;
    }

    @Nullable
    @JvmName(name="getDescribe")
    public abstract String getDescribe();

    @Nullable
    @JvmName(name="getLicenseText")
    public abstract String getLicenseText();

    @Nullable
    public final LicenseV1 license(@NotNull PublicKey publicKey, @Nullable LicenseLoaderContext context) {
        Object object;
        Intrinsics.checkNotNullParameter(publicKey, "");
        LicenseV1 licenseV1 = this.doLoadLicense(publicKey, context);
        Object object2 = context;
        if (object2 == null || (object2 = ((LicenseLoaderContext)object2).getNow()) == null || (object2 = ((DateTime)object2).toDateTime()) == null) {
            object2 = object = DateTime.now();
        }
        if (licenseV1 != null) {
            Intrinsics.checkNotNull(object);
            if (licenseV1.isNotExpired((DateTime)object)) {
                return licenseV1;
            }
        }
        return null;
    }

    public static /* synthetic */ LicenseV1 license$default(LicenseProvider licenseProvider, PublicKey publicKey, LicenseLoaderContext licenseLoaderContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException();
        }
        if ((n & 2) != 0) {
            licenseLoaderContext = null;
        }
        return licenseProvider.license(publicKey, licenseLoaderContext);
    }

    @Nullable
    public LicenseV1 doLoadLicense(@NotNull PublicKey publicKey, @Nullable LicenseLoaderContext context) {
        Intrinsics.checkNotNullParameter(publicKey, "");
        String string = this.getLicenseText();
        if (string == null) {
            return null;
        }
        String string2 = string;
        return LicenseLoader.INSTANCE.load(string2, publicKey);
    }

    public static /* synthetic */ LicenseV1 doLoadLicense$default(LicenseProvider licenseProvider, PublicKey publicKey, LicenseLoaderContext licenseLoaderContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException();
        }
        if ((n & 2) != 0) {
            licenseLoaderContext = null;
        }
        return licenseProvider.doLoadLicense(publicKey, licenseLoaderContext);
    }
}

