/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.license.core.providers.a;

import io.specmatic.license.core.LicenseLoadException;
import io.specmatic.license.core.LicenseLoader;
import io.specmatic.license.core.LicenseV1;
import io.specmatic.license.core.LicenseV3;
import io.specmatic.license.core.a.a.a;
import io.specmatic.license.core.a.d;
import io.specmatic.license.core.a.h;
import io.specmatic.license.core.a.i;
import io.specmatic.license.core.a.j;
import io.specmatic.license.core.a.k;
import io.specmatic.license.core.providers.LicenseLoaderContext;
import io.specmatic.license.core.providers.LicenseProvider;
import io.specmatic.license.core.providers.a.f;
import java.io.File;
import java.net.URL;
import java.security.PublicKey;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\rH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0015J\u0011\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u001cJ)\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u001dJ!\u0010\u000b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\rH\u0001\u00a2\u0006\u0004\b\u000b\u0010\u0010J'\u0010\u000b\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u001fJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u000b\u0010 R\u0014\u0010\u000f\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010(\u001a\u00020%8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u001a\u0010-\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u0016\u0010/\u001a\u0004\u0018\u00010\b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010$R\u0018\u00103\u001a\u0006*\u000200008\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102"}, d2={"Lio/specmatic/license/core/providers/a/e;", "Lio/specmatic/license/core/providers/LicenseProvider;", "Ljava/io/File;", "p0", "Lorg/joda/time/Duration;", "p1", "<init>", "(Ljava/io/File;Lorg/joda/time/Duration;)V", "", "Ljava/security/PublicKey;", "Lio/specmatic/license/core/a/i;", "b", "(Ljava/lang/String;Ljava/security/PublicKey;)Lio/specmatic/license/core/a/i;", "Lio/specmatic/license/core/providers/LicenseLoaderContext;", "Lio/specmatic/license/core/LicenseV3;", "a", "(Ljava/security/PublicKey;Lio/specmatic/license/core/providers/LicenseLoaderContext;)Lio/specmatic/license/core/LicenseV3;", "Lorg/joda/time/DateTime;", "I", "()Lorg/joda/time/DateTime;", "", "(Lorg/joda/time/DateTime;)Z", "Lio/specmatic/license/core/a/h;", "H", "()Lio/specmatic/license/core/a/h;", "Lio/specmatic/license/core/a/j;", "p2", "p3", "(Ljava/lang/String;Ljava/security/PublicKey;Lio/specmatic/license/core/a/j;Lorg/joda/time/DateTime;)Lio/specmatic/license/core/LicenseV3;", "(Lio/specmatic/license/core/a/h;Ljava/security/PublicKey;Lorg/joda/time/DateTime;)Lio/specmatic/license/core/LicenseV3;", "", "(Lio/specmatic/license/core/a/h;Ljava/security/PublicKey;Lorg/joda/time/DateTime;)V", "(Lorg/joda/time/DateTime;)Lorg/joda/time/Duration;", "U", "Ljava/io/File;", "getDescribe", "()Ljava/lang/String;", "Lio/specmatic/license/core/a/d;", "X", "Lio/specmatic/license/core/a/d;", "c", "V", "Lorg/joda/time/Duration;", "G", "()Lorg/joda/time/Duration;", "d", "getLicenseText", "e", "Lorg/slf4j/Logger;", "W", "Lorg/slf4j/Logger;", "f"})
@SourceDebugExtension(value={"SMAP\nHomeDirLicenseV3Provider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HomeDirLicenseV3Provider.kt\nio/specmatic/license/core/providers/internal/HomeDirLicenseV3Provider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public final class e
extends LicenseProvider {
    @NotNull
    private final File U;
    @NotNull
    private final Duration V;
    private final Logger W;
    @NotNull
    private final d X;

    public e(@NotNull File file2, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(file2, "");
        Intrinsics.checkNotNullParameter(duration, "");
        super(4000);
        this.U = file2;
        this.V = duration;
        this.W = LoggerFactory.getLogger(this.getClass());
        this.X = new d(this.U);
    }

    public /* synthetic */ e(File file2, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file2 = f.J();
        }
        if ((n & 2) != 0) {
            Duration duration2 = Duration.standardHours(24L);
            Intrinsics.checkNotNullExpressionValue(duration2, "");
            duration = duration2;
        }
        this(file2, duration);
    }

    @NotNull
    @JvmName(name="G")
    public final Duration G() {
        return this.V;
    }

    @Override
    @Nullable
    @JvmName(name="getDescribe")
    public String getDescribe() {
        h h2 = this.H();
        h h3 = h2;
        return h3 != null ? "File exists with license status " + h3.n() + ": " + this.U.toURI() : (this.U.exists() ? "File exists but no license record found: " + this.U.toURI() : "File does not exist: " + this.U.toURI());
    }

    private final h H() {
        return this.X.i();
    }

    @Override
    @Nullable
    @JvmName(name="getLicenseText")
    public String getLicenseText() {
        h h2;
        h h3 = h2 = this.H();
        return h3 != null ? h3.m() : null;
    }

    @Nullable
    public synchronized LicenseV3 a(@NotNull PublicKey publicKey, @Nullable LicenseLoaderContext licenseLoaderContext) {
        Intrinsics.checkNotNullParameter(publicKey, "");
        String string = System.getProperty("specmatic.license.v3.disabled");
        boolean bl = string != null ? Boolean.parseBoolean(string) : false;
        if (bl) {
            this.W.info("Specmatic V3 license checking is disabled via system property 'specmatic.license.v3.disabled'.");
            return null;
        }
        if (!this.U.exists()) {
            return null;
        }
        Object object = licenseLoaderContext;
        if (object == null || (object = ((LicenseLoaderContext)object).getLicenseServerURL()) == null) {
            return null;
        }
        Object object2 = object;
        DateTime dateTime = licenseLoaderContext.getNow();
        h h2 = this.H();
        if (h2 == null) {
            this.W.info("No license file found, requesting new license from server: {}", object2);
            return this.b(publicKey, licenseLoaderContext);
        }
        LicenseV1 licenseV1 = LicenseLoader.INSTANCE.load(h2.m(), publicKey);
        DateTime dateTime2 = dateTime.toDateTime();
        Intrinsics.checkNotNullExpressionValue(dateTime2, "");
        if (licenseV1.isExpired(dateTime2)) {
            this.W.info("License is expired, forcing synchronous refresh");
            return this.a(h2, publicKey, dateTime);
        }
        if (this.a(dateTime)) {
            this.W.info("License is fresh (validated {} ago), returning cached license.", (Object)this.b(dateTime).toPeriod());
            LicenseV1 licenseV12 = LicenseLoader.INSTANCE.load(h2.m(), publicKey);
            return licenseV12 instanceof LicenseV3 ? (LicenseV3)licenseV12 : null;
        }
        this.W.info("License needs refresh (validated {} ago), returning license while refreshing in background.", (Object)this.b(dateTime).toPeriod());
        this.b(h2, publicKey, dateTime);
        LicenseV1 licenseV13 = LicenseLoader.INSTANCE.load(h2.m(), publicKey);
        return licenseV13 instanceof LicenseV3 ? (LicenseV3)licenseV13 : null;
    }

    private final boolean a(DateTime dateTime) {
        return this.b(dateTime).compareTo(this.V) <= 0;
    }

    private final Duration b(DateTime dateTime) {
        return new Duration(this.I().toDateTime(), dateTime.toDateTime());
    }

    private final DateTime I() {
        h h2 = this.H();
        Intrinsics.checkNotNull(h2);
        return h2.o();
    }

    @Nullable
    public final LicenseV3 b(@NotNull PublicKey publicKey, @NotNull LicenseLoaderContext licenseLoaderContext) {
        Intrinsics.checkNotNullParameter(publicKey, "");
        Intrinsics.checkNotNullParameter(licenseLoaderContext, "");
        URL uRL = licenseLoaderContext.getLicenseServerURL();
        Intrinsics.checkNotNull(uRL);
        a a2 = new a(uRL);
        String string = a2.a(licenseLoaderContext.getMaxAttempts(), licenseLoaderContext.getIntervalMilliSeconds());
        if (string == null) {
            this.W.error("Failed to obtain license from server. Falling back to default classpath license.");
            return null;
        }
        this.W.info("Successfully obtained new license from server, saving to DB - " + string);
        return this.a(string, publicKey, new i.a(), licenseLoaderContext.getNow());
    }

    private final LicenseV3 a(String string, PublicKey publicKey, j j2, DateTime dateTime) {
        LicenseV1 licenseV1 = LicenseLoader.INSTANCE.load(string, publicKey);
        if (!(licenseV1 instanceof LicenseV3)) {
            throw new LicenseLoadException("Expected a LicenseV3 but got " + licenseV1.getClass().getName());
        }
        LicenseV1 licenseV12 = licenseV1;
        LicenseV3 licenseV3 = (LicenseV3)licenseV12;
        boolean bl = false;
        this.X.a(string, j2, dateTime);
        return (LicenseV3)licenseV12;
    }

    private final LicenseV3 a(h h2, PublicKey publicKey, DateTime dateTime) {
        i i2 = this.b(h2.m(), publicKey);
        if (i2 instanceof i.a ? true : i2 instanceof i.b) {
            this.W.info("License status OK. Updating DB with current license text.");
            String string = h2.m();
            Intrinsics.checkNotNull(i2);
            return this.a(string, publicKey, (j)((Object)i2), dateTime);
        }
        if (i2 instanceof i.c) {
            LicenseV1 licenseV1 = LicenseLoader.INSTANCE.load(((i.c)i2).v(), publicKey);
            DateTime dateTime2 = dateTime.toDateTime();
            Intrinsics.checkNotNullExpressionValue(dateTime2, "");
            if (licenseV1.isExpired(dateTime2)) {
                this.W.error("Refreshed license is still expired, saving the license and moving on.");
                return this.a(((i.c)i2).v(), publicKey, (j)((Object)i2), dateTime);
            }
            this.W.info("Synchronous license check returned valid refreshed license. Updating DB with new license and returning it.");
            return this.a(((i.c)i2).v(), publicKey, (j)((Object)i2), dateTime);
        }
        if (i2 instanceof i.d) {
            this.W.warn("License revoked by server. Deleting license file.");
            this.X.j();
            return null;
        }
        if (i2 instanceof i.e) {
            this.W.warn("License status unknown from server. Will retry until grace period expires.");
        }
        return null;
    }

    private final void b(h h2, PublicKey publicKey, DateTime dateTime) {
        this.W.info("Checking license status with server in background thread.");
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(e::b);
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "");
        ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService;
        scheduledExecutorService2.submit(() -> e.a(this, h2, publicKey, dateTime, scheduledExecutorService2));
    }

    private final i b(String string, PublicKey publicKey) {
        Object object;
        try {
            i i2;
            object = LicenseLoader.INSTANCE.load(string, publicKey);
            if (object instanceof LicenseV3) {
                this.W.info("Validating license with server using LicenseV3.");
                i2 = k.a((LicenseV3)object);
            } else {
                this.W.error("Loaded license is not a LicenseV3 instance.");
                i2 = new i.e("License is not a LicenseV3 instance.");
            }
            object = i2;
        }
        catch (Exception exception) {
            this.W.error("Error parsing license or checking status: {}", (Object)exception.getMessage());
            object = new i.e("Error parsing license or checking status: " + exception.getMessage());
        }
        return object;
    }

    private static final Thread b(Runnable runnable2) {
        Thread thread2;
        Thread thread3 = thread2 = new Thread(runnable2);
        boolean bl = false;
        thread3.setDaemon(true);
        return thread2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void a(e e2, h h2, PublicKey publicKey, DateTime dateTime, ScheduledExecutorService scheduledExecutorService) {
        try {
            e2.a(h2, publicKey, dateTime);
        }
        catch (Exception exception) {
            e2.W.error("Error during async license refresh: ", exception);
        }
        finally {
            scheduledExecutorService.shutdown();
        }
    }

    public e() {
        this(null, null, 3, null);
    }

    @Override
    public /* synthetic */ LicenseV1 doLoadLicense(PublicKey publicKey, LicenseLoaderContext context) {
        return this.a(publicKey, context);
    }
}

