/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.proxy;

import io.specmatic.proxy.FileWriter;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/specmatic/proxy/RealFileWriter;", "Lio/specmatic/proxy/FileWriter;", "dataDir", "", "(Ljava/lang/String;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "createDirectory", "", "fileName", "path", "subDirectory", "writeText", "content", "specmatic-core"})
public final class RealFileWriter
implements FileWriter {
    @NotNull
    private final File dataDir;

    public RealFileWriter(@NotNull File dataDir) {
        Intrinsics.checkNotNullParameter(dataDir, "dataDir");
        this.dataDir = dataDir;
    }

    public RealFileWriter(@NotNull String dataDir) {
        Intrinsics.checkNotNullParameter(dataDir, "dataDir");
        this(new File(dataDir));
    }

    @Override
    public void createDirectory() {
        if (!this.dataDir.exists()) {
            this.dataDir.mkdirs();
        }
    }

    @Override
    public void writeText(@NotNull String path2, @NotNull String content2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(content2, "content");
        FilesKt.writeText$default(FilesKt.resolve(this.dataDir, path2), content2, null, 2, null);
    }

    @Override
    @NotNull
    public FileWriter subDirectory(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        return new RealFileWriter(FilesKt.resolve(this.dataDir, path2));
    }

    @Override
    @NotNull
    public String fileName(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        String string = FilesKt.resolve(this.dataDir, path2).getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        return string;
    }
}

