/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.deserializer;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.deserializer.SwaggerDeserializer;
import io.swagger.report.Message;
import io.swagger.report.MessageBuilder;
import io.swagger.report.Severity;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;

public abstract class AbstractSwaggerDeserializer<T>
implements SwaggerDeserializer<T> {
    protected final Class<T> clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    protected final ObjectMapper objectMapper = new ObjectMapper();

    protected AbstractSwaggerDeserializer() {
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    @Override
    public T deserialize(JsonNode jsonNode, MessageBuilder messageBuilder) {
        T deserializedObject = null;
        try {
            deserializedObject = this.objectMapper.readValue(jsonNode.traverse(), this.clazz);
        }
        catch (JsonMappingException e2) {
            messageBuilder.append(new Message(e2.getPathReference(), e2.getMessage(), Severity.ERROR));
        }
        catch (IOException e3) {
            messageBuilder.append(new Message("", e3.getMessage(), Severity.ERROR));
        }
        return deserializedObject;
    }
}

