/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import io.swagger.models.Xml;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.commons.lang3.StringUtils;

class JAXBAnnotationsHelper {
    private static final String JAXB_DEFAULT = "##default";

    private JAXBAnnotationsHelper() {
    }

    public static void apply(AnnotatedMember member, Property property2) {
        if (member.hasAnnotation(XmlElementWrapper.class) || member.hasAnnotation(XmlElement.class)) {
            JAXBAnnotationsHelper.applyElement(member, property2);
        } else if (member.hasAnnotation(XmlAttribute.class) && JAXBAnnotationsHelper.isAttributeAllowed(property2)) {
            JAXBAnnotationsHelper.applyAttribute(member, property2);
        }
    }

    private static void applyElement(AnnotatedMember member, Property property2) {
        XmlElementWrapper wrapper2 = member.getAnnotation(XmlElementWrapper.class);
        if (wrapper2 != null) {
            Xml xml = JAXBAnnotationsHelper.getXml(property2);
            xml.setWrapped(true);
            if (!(JAXB_DEFAULT.equals(wrapper2.name()) || wrapper2.name().isEmpty() || wrapper2.name().equals(property2.getName()))) {
                xml.setName(wrapper2.name());
            }
        } else {
            XmlElement element = member.getAnnotation(XmlElement.class);
            if (element != null) {
                JAXBAnnotationsHelper.setName(element.namespace(), element.name(), property2);
            }
        }
    }

    private static void applyAttribute(AnnotatedMember member, Property property2) {
        XmlAttribute attribute = member.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            Xml xml = JAXBAnnotationsHelper.getXml(property2);
            xml.setAttribute(true);
            JAXBAnnotationsHelper.setName(attribute.namespace(), attribute.name(), property2);
        }
    }

    private static Xml getXml(Property property2) {
        Xml existing = property2.getXml();
        if (existing != null) {
            return existing;
        }
        Xml created = new Xml();
        property2.setXml(created);
        return created;
    }

    private static boolean setName(String ns, String name, Property property2) {
        String useNS;
        String useName;
        boolean apply = false;
        String cleanName = StringUtils.trimToNull(name);
        if (!JAXBAnnotationsHelper.isEmpty(cleanName) && !cleanName.equals(property2.getName())) {
            useName = cleanName;
            apply = true;
        } else {
            useName = null;
        }
        String cleanNS = StringUtils.trimToNull(ns);
        if (!JAXBAnnotationsHelper.isEmpty(cleanNS)) {
            useNS = cleanNS;
            apply = true;
        } else {
            useNS = null;
        }
        if (apply) {
            JAXBAnnotationsHelper.getXml(property2).name(useName).namespace(useNS);
        }
        return apply;
    }

    private static boolean isAttributeAllowed(Property property2) {
        for (Class item : new Class[]{ArrayProperty.class, MapProperty.class, ObjectProperty.class, RefProperty.class}) {
            if (!item.isInstance(property2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(String name) {
        return StringUtils.isEmpty(name) || JAXB_DEFAULT.equals(name);
    }
}

