/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.jackson.PackageVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;

public class SwaggerAnnotationIntrospector
extends AnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private boolean isThereAHiddenField = false;

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember m4) {
        ApiModelProperty ann = m4.getAnnotation(ApiModelProperty.class);
        if (ann != null && ann.hidden()) {
            this.isThereAHiddenField = true;
            return true;
        }
        JsonCreator constructor = m4.getAnnotation(JsonCreator.class);
        return constructor != null && this.isThereAHiddenField;
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember m4) {
        ApiModelProperty ann = m4.getAnnotation(ApiModelProperty.class);
        if (ann != null) {
            return ann.required();
        }
        XmlElement elem = m4.getAnnotation(XmlElement.class);
        if (elem != null && elem.required()) {
            return true;
        }
        return null;
    }

    @Override
    public String findPropertyDescription(Annotated a2) {
        ApiModel model = a2.getAnnotation(ApiModel.class);
        if (model != null && !"".equals(model.description())) {
            return model.description();
        }
        ApiModelProperty prop = a2.getAnnotation(ApiModelProperty.class);
        if (prop != null) {
            return prop.value();
        }
        return null;
    }

    @Override
    public Integer findPropertyIndex(Annotated a2) {
        ApiModelProperty prop = a2.getAnnotation(ApiModelProperty.class);
        if (prop != null && prop.position() != 0) {
            return prop.position();
        }
        return null;
    }

    @Override
    public List<NamedType> findSubtypes(Annotated a2) {
        ApiModel api = a2.getAnnotation(ApiModel.class);
        if (api != null) {
            Class<?>[] classes = api.subTypes();
            ArrayList<NamedType> names2 = new ArrayList<NamedType>(classes.length);
            for (Class<?> subType : classes) {
                names2.add(new NamedType(subType));
            }
            if (!names2.isEmpty()) {
                return names2;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String findTypeName(AnnotatedClass ac) {
        return null;
    }
}

