/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.models.refs.GenericRef;
import io.swagger.models.refs.RefFormat;
import io.swagger.models.refs.RefType;
import java.util.Map;

public class RefModel
implements Model {
    private GenericRef genericRef;
    private String description;
    private ExternalDocs externalDocs;
    private Map<String, Property> properties;
    private Object example;
    private String title;

    public RefModel() {
    }

    public RefModel(String ref) {
        this.set$ref(ref);
    }

    public RefModel(String ref, RefFormat refFormat) {
        this.genericRef = new GenericRef(RefType.DEFINITION, ref, refFormat);
    }

    public RefModel asDefault(String ref) {
        this.set$ref(RefType.DEFINITION.getInternalPrefix() + ref);
        return this;
    }

    @Override
    @JsonIgnore
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @JsonIgnore
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Property> properties) {
        this.properties = properties;
    }

    @JsonIgnore
    public String getSimpleRef() {
        return this.genericRef.getSimpleRef();
    }

    public String getOriginalRef() {
        if (this.genericRef != null) {
            return this.genericRef.getOriginalRef();
        }
        return null;
    }

    public String get$ref() {
        return this.genericRef.getRef();
    }

    public void set$ref(String ref) {
        this.genericRef = new GenericRef(RefType.DEFINITION, ref);
    }

    @JsonIgnore
    public RefFormat getRefFormat() {
        return this.genericRef.getFormat();
    }

    @Override
    @JsonIgnore
    public Object getExample() {
        return this.example;
    }

    @Override
    public void setExample(Object example) {
        this.example = example;
    }

    @Override
    @JsonIgnore
    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs value2) {
        this.externalDocs = value2;
    }

    @Override
    public Object clone() {
        RefModel cloned = new RefModel();
        cloned.genericRef = this.genericRef;
        cloned.description = this.description;
        cloned.properties = this.properties;
        cloned.example = this.example;
        return cloned;
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getVendorExtensions() {
        return null;
    }

    @Override
    @JsonIgnore
    public Boolean getBooleanValue() {
        return null;
    }

    @Override
    public void setBooleanValue(Boolean booleanValue) {
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.description == null ? 0 : this.description.hashCode());
        result2 = 31 * result2 + (this.example == null ? 0 : this.example.hashCode());
        result2 = 31 * result2 + (this.externalDocs == null ? 0 : this.externalDocs.hashCode());
        result2 = 31 * result2 + (this.properties == null ? 0 : this.properties.hashCode());
        result2 = 31 * result2 + (this.genericRef == null ? 0 : this.genericRef.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefModel other = (RefModel)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.example == null ? other.example != null : !this.example.equals(other.example)) {
            return false;
        }
        if (this.externalDocs == null ? other.externalDocs != null : !this.externalDocs.equals(other.externalDocs)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.genericRef == null ? other.genericRef != null : !this.genericRef.equals(other.genericRef));
    }

    @Override
    @JsonIgnore
    public String getReference() {
        return this.genericRef.getRef();
    }

    @Override
    public void setReference(String reference) {
        this.genericRef = new GenericRef(RefType.DEFINITION, reference);
    }
}

