/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.properties;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.AbstractProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.models.properties.UntypedProperty;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBuilder {
    static final Logger LOGGER = LoggerFactory.getLogger(PropertyBuilder.class);

    public static Property build(String type2, String format2, Map<PropertyId, Object> args2) {
        Map<PropertyId, Object> fixedArgs;
        Map<PropertyId, Object> safeArgs;
        Processor processor = Processor.fromType(type2, format2);
        if (processor == null) {
            return null;
        }
        Map<Object, Object> map2 = safeArgs = args2 == null ? Collections.emptyMap() : args2;
        if (format2 != null) {
            fixedArgs = new EnumMap(PropertyId.class);
            fixedArgs.putAll(safeArgs);
            fixedArgs.put(PropertyId.FORMAT, format2);
        } else {
            fixedArgs = safeArgs;
        }
        return processor.build(fixedArgs);
    }

    public static Property merge(Property property2, Map<PropertyId, Object> args2) {
        Processor processor;
        if (args2 != null && !args2.isEmpty() && (processor = Processor.fromProperty(property2)) != null) {
            processor.merge(property2, args2);
        }
        return property2;
    }

    public static Model toModel(Property property2) {
        Processor processor = Processor.fromProperty(property2);
        if (processor != null) {
            return processor.toModel(property2);
        }
        return null;
    }

    private static enum Processor {
        BOOLEAN(BooleanProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return BooleanProperty.isType(type2, format2);
            }

            @Override
            protected BooleanProperty create() {
                return new BooleanProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof BooleanProperty) {
                    BooleanProperty resolved2 = (BooleanProperty)property2;
                    if (args2.containsKey((Object)PropertyId.DEFAULT)) {
                        String value2 = (String)PropertyId.DEFAULT.findValue(args2);
                        if (value2 != null) {
                            resolved2.setDefault(value2);
                        } else {
                            resolved2.setDefault((Boolean)null);
                        }
                    }
                }
                return property2;
            }
        }
        ,
        BYTE_ARRAY(ByteArrayProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return ByteArrayProperty.isType(type2, format2);
            }

            @Override
            protected ByteArrayProperty create() {
                return new ByteArrayProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof ByteArrayProperty) {
                    ByteArrayProperty resolved2 = (ByteArrayProperty)property2;
                    this.mergeString(resolved2, args2);
                    resolved2.setEnum(null);
                    resolved2.setPattern("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
                }
                return property2;
            }

            @Override
            public Model toModel(Property property2) {
                if (this.isType(property2)) {
                    return this.createStringModel((StringProperty)property2);
                }
                return null;
            }
        }
        ,
        BINARY(BinaryProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return BinaryProperty.isType(type2, format2);
            }

            @Override
            protected BinaryProperty create() {
                return new BinaryProperty();
            }
        }
        ,
        DATE(DateProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return DateProperty.isType(type2, format2);
            }

            @Override
            protected DateProperty create() {
                return new DateProperty();
            }
        }
        ,
        DATE_TIME(DateTimeProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return DateTimeProperty.isType(type2, format2);
            }

            @Override
            protected DateTimeProperty create() {
                return new DateTimeProperty();
            }
        }
        ,
        INT(IntegerProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return IntegerProperty.isType(type2, format2);
            }

            @Override
            protected IntegerProperty create() {
                return new IntegerProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof IntegerProperty) {
                    IntegerProperty resolved2 = (IntegerProperty)property2;
                    this.mergeNumeric(resolved2, args2);
                    if (args2.containsKey((Object)PropertyId.DEFAULT)) {
                        String value2 = (String)PropertyId.DEFAULT.findValue(args2);
                        if (value2 != null) {
                            resolved2.setDefault(value2);
                        } else {
                            resolved2.setDefault((Integer)null);
                        }
                    }
                }
                return property2;
            }

            @Override
            public Model toModel(Property property2) {
                if (this.isType(property2)) {
                    IntegerProperty resolved2 = (IntegerProperty)property2;
                    ModelImpl model = this.createModel(resolved2);
                    Integer defaultValue = resolved2.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        LONG(LongProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return LongProperty.isType(type2, format2);
            }

            @Override
            protected LongProperty create() {
                return new LongProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof LongProperty) {
                    LongProperty resolved2 = (LongProperty)property2;
                    this.mergeNumeric(resolved2, args2);
                    if (args2.containsKey((Object)PropertyId.DEFAULT)) {
                        String value2 = (String)PropertyId.DEFAULT.findValue(args2);
                        if (value2 != null) {
                            resolved2.setDefault(value2);
                        } else {
                            resolved2.setDefault((Long)null);
                        }
                    }
                }
                return property2;
            }

            @Override
            public Model toModel(Property property2) {
                if (this.isType(property2)) {
                    LongProperty resolved2 = (LongProperty)property2;
                    ModelImpl model = this.createModel(resolved2);
                    Long defaultValue = resolved2.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        FLOAT(FloatProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return FloatProperty.isType(type2, format2);
            }

            @Override
            protected FloatProperty create() {
                return new FloatProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof FloatProperty) {
                    FloatProperty resolved2 = (FloatProperty)property2;
                    this.mergeNumeric(resolved2, args2);
                    if (args2.containsKey((Object)PropertyId.DEFAULT)) {
                        String value2 = (String)PropertyId.DEFAULT.findValue(args2);
                        if (value2 != null) {
                            resolved2.setDefault(value2);
                        } else {
                            resolved2.setDefault((Float)null);
                        }
                    }
                }
                return property2;
            }

            @Override
            public Model toModel(Property property2) {
                if (this.isType(property2)) {
                    FloatProperty resolved2 = (FloatProperty)property2;
                    ModelImpl model = this.createModel(resolved2);
                    Float defaultValue = resolved2.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        DOUBLE(DoubleProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return DoubleProperty.isType(type2, format2);
            }

            @Override
            protected DoubleProperty create() {
                return new DoubleProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof DoubleProperty) {
                    DoubleProperty resolved2 = (DoubleProperty)property2;
                    this.mergeNumeric(resolved2, args2);
                    if (args2.containsKey((Object)PropertyId.DEFAULT)) {
                        String value2 = (String)PropertyId.DEFAULT.findValue(args2);
                        if (value2 != null) {
                            resolved2.setDefault(value2);
                        } else {
                            resolved2.setDefault((Double)null);
                        }
                    }
                }
                return property2;
            }

            @Override
            public Model toModel(Property property2) {
                if (this.isType(property2)) {
                    DoubleProperty resolved2 = (DoubleProperty)property2;
                    ModelImpl model = this.createModel(resolved2);
                    Double defaultValue = resolved2.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        INTEGER(BaseIntegerProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return BaseIntegerProperty.isType(type2, format2);
            }

            @Override
            protected BaseIntegerProperty create() {
                return new BaseIntegerProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof BaseIntegerProperty) {
                    BaseIntegerProperty resolved2 = (BaseIntegerProperty)property2;
                    this.mergeNumeric(resolved2, args2);
                }
                return property2;
            }
        }
        ,
        DECIMAL(DecimalProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return DecimalProperty.isType(type2, format2);
            }

            @Override
            protected DecimalProperty create() {
                return new DecimalProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof DecimalProperty) {
                    DecimalProperty resolved2 = (DecimalProperty)property2;
                    this.mergeNumeric(resolved2, args2);
                }
                return property2;
            }
        }
        ,
        FILE(FileProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return FileProperty.isType(type2, format2);
            }

            @Override
            protected FileProperty create() {
                return new FileProperty();
            }
        }
        ,
        REFERENCE(RefProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return RefProperty.isType(type2, format2);
            }

            @Override
            protected RefProperty create() {
                return new RefProperty();
            }

            @Override
            public Model toModel(Property property2) {
                if (property2 instanceof RefProperty) {
                    RefProperty resolved2 = (RefProperty)property2;
                    RefModel model = new RefModel(resolved2.getOriginalRef(), resolved2.getRefFormat());
                    model.setDescription(resolved2.getDescription());
                    return model;
                }
                return null;
            }
        }
        ,
        E_MAIL(EmailProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return EmailProperty.isType(type2, format2);
            }

            @Override
            protected EmailProperty create() {
                return new EmailProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof EmailProperty) {
                    this.mergeString((EmailProperty)property2, args2);
                }
                return property2;
            }

            @Override
            public Model toModel(Property property2) {
                if (this.isType(property2)) {
                    return this.createStringModel((StringProperty)property2);
                }
                return null;
            }
        }
        ,
        UUID(UUIDProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return UUIDProperty.isType(type2, format2);
            }

            @Override
            protected UUIDProperty create() {
                return new UUIDProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof UUIDProperty) {
                    Object value2;
                    UUIDProperty resolved2 = (UUIDProperty)property2;
                    if (args2.containsKey((Object)PropertyId.DEFAULT)) {
                        value2 = (String)PropertyId.DEFAULT.findValue(args2);
                        property2.setDefault((String)value2);
                    }
                    if (args2.containsKey((Object)PropertyId.MIN_LENGTH)) {
                        value2 = (Integer)PropertyId.MIN_LENGTH.findValue(args2);
                        resolved2.setMinLength((Integer)value2);
                    }
                    if (args2.containsKey((Object)PropertyId.MAX_LENGTH)) {
                        value2 = (Integer)PropertyId.MAX_LENGTH.findValue(args2);
                        resolved2.setMaxLength((Integer)value2);
                    }
                    if (args2.containsKey((Object)PropertyId.PATTERN)) {
                        value2 = (String)PropertyId.PATTERN.findValue(args2);
                        resolved2.setPattern((String)value2);
                    }
                }
                return property2;
            }

            @Override
            public Model toModel(Property property2) {
                if (this.isType(property2)) {
                    UUIDProperty resolved2 = (UUIDProperty)property2;
                    ModelImpl model = this.createModel(resolved2);
                    model.setDefaultValue(resolved2.getDefault());
                    return model;
                }
                return null;
            }
        }
        ,
        OBJECT(ObjectProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return ObjectProperty.isType(type2, format2);
            }

            @Override
            protected ObjectProperty create() {
                return new ObjectProperty();
            }
        }
        ,
        UNTYPED(UntypedProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return UntypedProperty.isType(type2, format2);
            }

            @Override
            protected UntypedProperty create() {
                return new UntypedProperty();
            }
        }
        ,
        ARRAY(ArrayProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return ArrayProperty.isType(type2);
            }

            @Override
            protected ArrayProperty create() {
                return new ArrayProperty();
            }

            @Override
            public Model toModel(Property property2) {
                if (property2 instanceof ArrayProperty) {
                    ArrayProperty resolved2 = (ArrayProperty)property2;
                    ArrayModel model = new ArrayModel().items(resolved2.getItems()).description(resolved2.getDescription());
                    return model;
                }
                return null;
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof ArrayProperty) {
                    Constable value2;
                    ArrayProperty resolved2 = (ArrayProperty)property2;
                    if (args2.containsKey((Object)PropertyId.MIN_ITEMS)) {
                        value2 = (Integer)PropertyId.MIN_ITEMS.findValue(args2);
                        resolved2.setMinItems((Integer)value2);
                    }
                    if (args2.containsKey((Object)PropertyId.MAX_ITEMS)) {
                        value2 = (Integer)PropertyId.MAX_ITEMS.findValue(args2);
                        resolved2.setMaxItems((Integer)value2);
                    }
                    if (args2.containsKey((Object)PropertyId.UNIQUE_ITEMS)) {
                        value2 = (Boolean)PropertyId.UNIQUE_ITEMS.findValue(args2);
                        resolved2.setUniqueItems((Boolean)value2);
                    }
                }
                return property2;
            }
        }
        ,
        MAP(MapProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return MapProperty.isType(type2, format2);
            }

            @Override
            protected MapProperty create() {
                return new MapProperty();
            }

            @Override
            public Model toModel(Property property2) {
                if (property2 instanceof MapProperty) {
                    MapProperty resolved2 = (MapProperty)property2;
                    return this.createModel(property2).additionalProperties(resolved2.getAdditionalProperties());
                }
                return null;
            }
        }
        ,
        STRING(StringProperty.class){

            @Override
            protected boolean isType(String type2, String format2) {
                return StringProperty.isType(type2, format2);
            }

            @Override
            protected StringProperty create() {
                return new StringProperty();
            }

            @Override
            public Property merge(Property property2, Map<PropertyId, Object> args2) {
                super.merge(property2, args2);
                if (property2 instanceof StringProperty) {
                    this.mergeString((StringProperty)property2, args2);
                }
                return property2;
            }

            @Override
            public Model toModel(Property property2) {
                if (this.isType(property2)) {
                    return this.createStringModel((StringProperty)property2);
                }
                return null;
            }
        };

        private final Class<? extends Property> type;

        private Processor(Class<? extends Property> type2) {
            this.type = type2;
        }

        public static Processor fromType(String type2, String format2) {
            for (Processor item : Processor.values()) {
                if (!item.isType(type2, format2)) continue;
                return item;
            }
            LOGGER.debug("no property for " + type2 + ", " + format2);
            return null;
        }

        public static Processor fromProperty(Property property2) {
            for (Processor item : Processor.values()) {
                if (!item.isType(property2)) continue;
                return item;
            }
            LOGGER.error("no property for " + (property2 == null ? "null" : property2.getClass().getName()));
            return null;
        }

        protected abstract boolean isType(String var1, String var2);

        protected boolean isType(Property property2) {
            return this.type.isInstance(property2);
        }

        protected abstract Property create();

        protected <N extends AbstractNumericProperty> N mergeNumeric(N property2, Map<PropertyId, Object> args2) {
            Comparable<BigDecimal> value2;
            if (args2.containsKey((Object)PropertyId.MINIMUM) && (value2 = (BigDecimal)PropertyId.MINIMUM.findValue(args2)) != null) {
                property2.setMinimum((BigDecimal)value2);
            }
            if (args2.containsKey((Object)PropertyId.MAXIMUM) && (value2 = (BigDecimal)PropertyId.MAXIMUM.findValue(args2)) != null) {
                property2.setMaximum((BigDecimal)value2);
            }
            if (args2.containsKey((Object)PropertyId.EXCLUSIVE_MINIMUM)) {
                value2 = (Boolean)PropertyId.EXCLUSIVE_MINIMUM.findValue(args2);
                property2.setExclusiveMinimum((Boolean)value2);
            }
            if (args2.containsKey((Object)PropertyId.EXCLUSIVE_MAXIMUM)) {
                value2 = (Boolean)PropertyId.EXCLUSIVE_MAXIMUM.findValue(args2);
                property2.setExclusiveMaximum((Boolean)value2);
            }
            if (args2.containsKey((Object)PropertyId.MULTIPLE_OF) && (value2 = (BigDecimal)PropertyId.MULTIPLE_OF.findValue(args2)) != null) {
                property2.setMultipleOf((BigDecimal)value2);
            }
            return property2;
        }

        protected <N extends StringProperty> N mergeString(N property2, Map<PropertyId, Object> args2) {
            Object value2;
            if (args2.containsKey((Object)PropertyId.DEFAULT)) {
                value2 = (String)PropertyId.DEFAULT.findValue(args2);
                property2.setDefault((String)value2);
            }
            if (args2.containsKey((Object)PropertyId.MIN_LENGTH)) {
                value2 = (Integer)PropertyId.MIN_LENGTH.findValue(args2);
                property2.setMinLength((Integer)value2);
            }
            if (args2.containsKey((Object)PropertyId.MAX_LENGTH)) {
                value2 = (Integer)PropertyId.MAX_LENGTH.findValue(args2);
                property2.setMaxLength((Integer)value2);
            }
            if (args2.containsKey((Object)PropertyId.PATTERN)) {
                value2 = (String)PropertyId.PATTERN.findValue(args2);
                property2.setPattern((String)value2);
            }
            if (args2.containsKey((Object)PropertyId.ENUM)) {
                value2 = (List)PropertyId.ENUM.findValue(args2);
                property2.setEnum((List<String>)value2);
            }
            return property2;
        }

        protected ModelImpl createModel(Property property2) {
            return new ModelImpl().type(property2.getType()).format(property2.getFormat()).description(property2.getDescription());
        }

        protected ModelImpl createStringModel(StringProperty property2) {
            ModelImpl model = this.createModel(property2);
            model.setDefaultValue(property2.getDefault());
            return model;
        }

        public Property build(Map<PropertyId, Object> args2) {
            return this.merge(this.create(), args2);
        }

        public Property merge(Property property2, Map<PropertyId, Object> args2) {
            if (args2.containsKey((Object)PropertyId.READ_ONLY)) {
                property2.setReadOnly((Boolean)PropertyId.READ_ONLY.findValue(args2));
            }
            if (property2 instanceof AbstractProperty) {
                List values2;
                Object value2;
                AbstractProperty resolved2 = (AbstractProperty)property2;
                if (resolved2.getFormat() == null) {
                    resolved2.setFormat((String)PropertyId.FORMAT.findValue(args2));
                }
                if (args2.containsKey((Object)PropertyId.ALLOW_EMPTY_VALUE)) {
                    value2 = (Boolean)PropertyId.ALLOW_EMPTY_VALUE.findValue(args2);
                    resolved2.setAllowEmptyValue((Boolean)value2);
                }
                if (args2.containsKey((Object)PropertyId.TITLE)) {
                    value2 = (String)PropertyId.TITLE.findValue(args2);
                    resolved2.setTitle((String)value2);
                }
                if (args2.containsKey((Object)PropertyId.DESCRIPTION)) {
                    value2 = (String)PropertyId.DESCRIPTION.findValue(args2);
                    resolved2.setDescription((String)value2);
                }
                if (args2.containsKey((Object)PropertyId.EXAMPLE)) {
                    value2 = PropertyId.EXAMPLE.findValue(args2);
                    resolved2.setExample(value2);
                }
                if (args2.containsKey((Object)PropertyId.VENDOR_EXTENSIONS)) {
                    value2 = (Map)PropertyId.VENDOR_EXTENSIONS.findValue(args2);
                    resolved2.setVendorExtensionMap((Map<String, Object>)value2);
                }
                if (args2.containsKey((Object)PropertyId.ENUM) && (values2 = (List)PropertyId.ENUM.findValue(args2)) != null) {
                    AbstractProperty p;
                    if (property2 instanceof BooleanProperty) {
                        p = (BooleanProperty)property2;
                        for (String value3 : values2) {
                            try {
                                ((BooleanProperty)p)._enum(Boolean.parseBoolean(value3));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property2 instanceof IntegerProperty) {
                        p = (IntegerProperty)property2;
                        for (String value3 : values2) {
                            try {
                                ((IntegerProperty)p)._enum(Integer.parseInt(value3));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property2 instanceof LongProperty) {
                        p = (LongProperty)property2;
                        for (String value3 : values2) {
                            try {
                                ((LongProperty)p)._enum(Long.parseLong(value3));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property2 instanceof DoubleProperty) {
                        p = (DoubleProperty)property2;
                        for (String value3 : values2) {
                            try {
                                ((DoubleProperty)p)._enum(Double.parseDouble(value3));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property2 instanceof FloatProperty) {
                        p = (FloatProperty)property2;
                        for (String value3 : values2) {
                            try {
                                ((FloatProperty)p)._enum(Float.valueOf(Float.parseFloat(value3)));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property2 instanceof DateProperty) {
                        p = (DateProperty)property2;
                        for (String value3 : values2) {
                            try {
                                ((DateProperty)p)._enum(value3);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property2 instanceof DateTimeProperty) {
                        p = (DateTimeProperty)property2;
                        for (String value3 : values2) {
                            try {
                                ((DateTimeProperty)p)._enum(value3);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property2 instanceof UUIDProperty) {
                        p = (UUIDProperty)property2;
                        for (String value3 : values2) {
                            try {
                                ((UUIDProperty)p)._enum(value3);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            return property2;
        }

        public Model toModel(Property property2) {
            return this.createModel(property2);
        }
    }

    public static enum PropertyId {
        ENUM("enum"),
        TITLE("title"),
        DESCRIPTION("description"),
        DEFAULT("default"),
        PATTERN("pattern"),
        DESCRIMINATOR("discriminator"),
        MIN_ITEMS("minItems"),
        MAX_ITEMS("maxItems"),
        MIN_PROPERTIES("minProperties"),
        MAX_PROPERTIES("maxProperties"),
        MIN_LENGTH("minLength"),
        MAX_LENGTH("maxLength"),
        MINIMUM("minimum"),
        MAXIMUM("maximum"),
        EXCLUSIVE_MINIMUM("exclusiveMinimum"),
        EXCLUSIVE_MAXIMUM("exclusiveMaximum"),
        UNIQUE_ITEMS("uniqueItems"),
        EXAMPLE("example"),
        TYPE("type"),
        FORMAT("format"),
        READ_ONLY("readOnly"),
        REQUIRED("required"),
        VENDOR_EXTENSIONS("vendorExtensions"),
        ALLOW_EMPTY_VALUE("allowEmptyValue"),
        MULTIPLE_OF("multipleOf"),
        ADDITIONAL_PROPERTIES("additionalProperties");

        private String propertyName;

        private PropertyId(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public <T> T findValue(Map<PropertyId, Object> args2) {
            Object value2 = args2.get((Object)this);
            return (T)value2;
        }
    }
}

