/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.reader;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.models.apideclaration.Api;
import io.swagger.models.apideclaration.ApiDeclaration;
import io.swagger.models.apideclaration.Model;
import io.swagger.models.apideclaration.ModelProperty;
import io.swagger.models.apideclaration.Operation;
import io.swagger.models.apideclaration.Parameter;
import io.swagger.models.reader.SwaggerParser;
import io.swagger.report.Message;
import io.swagger.report.MessageBuilder;
import io.swagger.report.Severity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiDeclarationParser
extends SwaggerParser {
    public ApiDeclaration read(String json2, MessageBuilder messages) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            Object models;
            List<Api> o;
            Map m4 = mapper.readValue(json2, Map.class);
            ApiDeclaration api = new ApiDeclaration();
            String apiVersion = this.readString(m4.get("apiVersion"));
            if (apiVersion != null) {
                api.setApiVersion(apiVersion);
            } else {
                messages.append(new Message("ApiDeclaration.apiVersion", "apiVersion is missing", Severity.RECOMMENDED));
            }
            String swaggerVersion = this.readString(m4.get("swaggerVersion"));
            if (swaggerVersion != null) {
                api.setSwaggerVersion(swaggerVersion);
            } else {
                messages.append(new Message("ApiDeclaration.swaggerVersion", "swaggerVersion is missing", Severity.ERROR));
            }
            String basePath = this.readString(m4.get("basePath"));
            if (basePath != null) {
                api.setBasePath(basePath);
            } else {
                messages.append(new Message("ApiDeclaration.basePath", "basePath is missing", Severity.ERROR));
            }
            String resourcePath = this.readString(m4.get("resourcePath"));
            if (resourcePath != null) {
                api.setResourcePath(resourcePath);
            } else {
                messages.append(new Message("ApiDeclaration.resourcePath", "resourcePath is missing", Severity.ERROR));
            }
            String produces = this.readString(m4.get("produces"));
            Object apis = m4.get("apis");
            if (apis != null && (o = this.readApis((List)apis, messages)).size() > 0) {
                api.setApis(o);
            }
            if ((models = m4.get("models")) != null) {
                Map<String, Model> modelMap = this.readModels((Map)models, messages);
                api.setModels(modelMap);
            }
            return api;
        }
        catch (Exception e2) {
            messages.append(new Message("ApiDeclaration", "invalid json", Severity.ERROR));
            return null;
        }
    }

    Map<String, Model> readModels(Map<String, Object> o, MessageBuilder messages) {
        HashMap<String, Model> output = new HashMap<String, Model>();
        for (String modelName : o.keySet()) {
            Model model = new Model();
            Map value2 = (Map)o.get(modelName);
            String id = this.readString(value2.get("id"));
            model.setId(id);
            String description = this.readString(value2.get("description"));
            model.setDescription(description);
            String discriminator = this.readString(value2.get("discriminator"));
            model.setDiscriminator(discriminator);
            Object properties = value2.get("properties");
            if (properties != null) {
                // empty if block
            }
            output.put(modelName, model);
        }
        return output;
    }

    List<ModelProperty> readProperties(Map<String, Object> properties, MessageBuilder messages) {
        ArrayList<ModelProperty> output = new ArrayList<ModelProperty>();
        for (String key2 : properties.keySet()) {
            Map value2 = (Map)properties.get(key2);
            ModelProperty prop = new ModelProperty();
            String type2 = this.readString(value2.get("type"));
            prop.setType(type2);
            String qualifiedType = this.readString(value2.get("qualifiedType"));
            output.add(prop);
        }
        return output;
    }

    List<Api> readApis(List<Map<String, Object>> om, MessageBuilder messages) {
        ArrayList<Api> output = new ArrayList<Api>();
        for (Map<String, Object> o : om) {
            Api op = new Api();
            String path2 = this.readString(o.get("path"));
            if (path2 != null) {
                op.setPath(path2);
            } else {
                messages.append(new Message("ApiDeclaration.apis", "path is missing", Severity.ERROR));
            }
            Object operations = o.get("operations");
            if (operations instanceof List) {
                List<Operation> ops = this.readOperations((List)operations, messages);
                op.setOperations(ops);
            }
            output.add(op);
        }
        return output;
    }

    List<Operation> readOperations(List<Map<String, Object>> ops, MessageBuilder messages) {
        return new ArrayList<Operation>();
    }

    List<Parameter> readParameters(List<Map<String, Object>> o, MessageBuilder messages) {
        ArrayList<Parameter> output = new ArrayList<Parameter>();
        for (Map<String, Object> p : o) {
            Parameter param = this.readParameter(p, messages);
            if (param == null) continue;
            output.add(param);
        }
        return output;
    }

    Parameter readParameter(Map<String, Object> o, MessageBuilder messages) {
        Parameter param = new Parameter();
        String name = this.readString(o.get("name"));
        if (name != null) {
            param.setName(name);
        } else {
            messages.append(new Message("ApiDeclaration.apis.operations.parameters.name", "missing name", Severity.ERROR));
        }
        String description = this.readString(o.get("description"));
        param.setDescription(description);
        Boolean required = this.readBoolean(o.get("required"));
        param.setRequired(required);
        String type2 = this.readString(o.get("type"));
        param.setType(type2);
        Boolean allowMultiple = this.readBoolean(o.get("allowMultiple"));
        param.setAllowMultiple(allowMultiple);
        return param;
    }
}

