/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.reader;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.apideclaration.ApiDeclaration;
import io.swagger.models.resourcelisting.ApiListingReference;
import io.swagger.models.resourcelisting.ResourceListing;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceListingReader {
    public static void main(String[] args2) throws IOException, URISyntaxException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        String baseUrl = "http://petstore.swagger.io/api/api-docs";
        ResourceListing resourceListing = objectMapper.readValue(new URL(baseUrl), ResourceListing.class);
        HashMap<String, ApiDeclaration> apiDeclarations = new HashMap<String, ApiDeclaration>();
        List<ApiListingReference> apis = resourceListing.getApis();
        if (apis != null) {
            for (ApiListingReference apiListingReference : apis) {
                URI uri2 = new URI(apiListingReference.getPath());
                URL apiUrl = uri2.isAbsolute() ? uri2.toURL() : new URL(baseUrl + apiListingReference.getPath());
                apiDeclarations.put(apiListingReference.getPath(), objectMapper.readValue(apiUrl, ApiDeclaration.class));
            }
        }
        System.out.println("---=== Resource Listing (" + baseUrl + ") ==--");
        System.out.println(resourceListing);
        for (Map.Entry entry : apiDeclarations.entrySet()) {
            System.out.println("---=== API Declaration (" + (String)entry.getKey() + ") ==--");
            System.out.println(entry.getValue());
        }
    }
}

