/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.utils;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Xml;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PropertyModelConverter {
    public Property modelToProperty(Model model) {
        if (model instanceof ModelImpl) {
            ModelImpl m4 = (ModelImpl)model;
            if (m4.getAdditionalProperties() != null) {
                MapProperty mapProperty = new MapProperty();
                mapProperty.setType(m4.getType());
                mapProperty.setAllowEmptyValue(m4.getAllowEmptyValue());
                mapProperty.setDefault((String)m4.getDefaultValue());
                mapProperty.setDescription(m4.getDescription());
                mapProperty.setExample(m4.getExample());
                mapProperty.setFormat(m4.getFormat());
                mapProperty.setName(m4.getName());
                mapProperty.setTitle(m4.getTitle());
                List<String> required = m4.getRequired();
                if (required != null) {
                    for (String name : required) {
                        if (!name.equals(m4.getName())) continue;
                        mapProperty.setRequired(true);
                    }
                }
                mapProperty.setXml(m4.getXml());
                mapProperty.setVendorExtensions(m4.getVendorExtensions());
                mapProperty.setAdditionalProperties(m4.getAdditionalProperties());
                return mapProperty;
            }
            Property property2 = this.propertyByType(m4);
            if (property2 instanceof ObjectProperty) {
                ObjectProperty objectProperty = (ObjectProperty)property2;
                objectProperty.setProperties(model.getProperties());
                objectProperty.setExample(model.getExample());
                return objectProperty;
            }
            if (property2 instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)property2;
                ModelImpl modelImpl = (ModelImpl)model;
                stringProperty.setPattern(modelImpl.getPattern());
                stringProperty.setMaxLength(modelImpl.getMaxLength());
                stringProperty.setMinLength(modelImpl.getMinLength());
                return stringProperty;
            }
            if (property2 instanceof AbstractNumericProperty) {
                AbstractNumericProperty numericProperty = (AbstractNumericProperty)property2;
                ModelImpl modelImpl = (ModelImpl)model;
                numericProperty.setMaximum(modelImpl.getMaximum());
                numericProperty.setMinimum(modelImpl.getMinimum());
                numericProperty.setMultipleOf(modelImpl.getMultipleOf());
                numericProperty.setExclusiveMinimum(modelImpl.getExclusiveMinimum());
                numericProperty.setExclusiveMaximum(modelImpl.getExclusiveMaximum());
                return numericProperty;
            }
            return property2;
        }
        if (model instanceof ArrayModel) {
            ArrayModel m5 = (ArrayModel)model;
            ArrayProperty property3 = new ArrayProperty();
            Property inner = m5.getItems();
            property3.setItems(inner);
            property3.setExample(m5.getExample());
            property3.setMaxItems(m5.getMaxItems());
            property3.setMinItems(m5.getMinItems());
            property3.setDescription(m5.getDescription());
            property3.setTitle(m5.getTitle());
            property3.setUniqueItems(m5.getUniqueItems());
            property3.setXml(m5.getXml());
            return property3;
        }
        if (model instanceof RefModel) {
            RefModel ref = (RefModel)model;
            RefProperty refProperty = new RefProperty(ref.get$ref(), ref.getRefFormat());
            return refProperty;
        }
        if (model instanceof ComposedModel) {
            ObjectProperty objectProperty = new ObjectProperty();
            objectProperty.setDescription(model.getDescription());
            objectProperty.setTitle(model.getTitle());
            objectProperty.setExample(model.getExample());
            ComposedModel cm = (ComposedModel)model;
            HashSet<String> requiredProperties = new HashSet<String>();
            for (Model item : cm.getAllOf()) {
                Property itemProperty = this.modelToProperty(item);
                if (itemProperty instanceof RefProperty) {
                    RefProperty refProperty = (RefProperty)itemProperty;
                    objectProperty.property(refProperty.getSimpleRef(), itemProperty);
                    continue;
                }
                if (!(itemProperty instanceof ObjectProperty)) continue;
                ObjectProperty itemPropertyObject = (ObjectProperty)itemProperty;
                if (itemPropertyObject.getProperties() != null) {
                    for (String key2 : itemPropertyObject.getProperties().keySet()) {
                        objectProperty.property(key2, itemPropertyObject.getProperties().get(key2));
                    }
                }
                if (itemPropertyObject.getRequiredProperties() == null) continue;
                for (String req : itemPropertyObject.getRequiredProperties()) {
                    requiredProperties.add(req);
                }
            }
            if (requiredProperties.size() > 0) {
                objectProperty.setRequiredProperties(new ArrayList<String>(requiredProperties));
            }
            if (cm.getVendorExtensions() != null) {
                for (String key3 : cm.getVendorExtensions().keySet()) {
                    objectProperty.vendorExtension(key3, cm.getVendorExtensions().get(key3));
                }
            }
            return objectProperty;
        }
        return null;
    }

    private Property propertyByType(ModelImpl model) {
        return PropertyBuilder.build(model.getType(), model.getFormat(), this.argsFromModel(model));
    }

    private Map<PropertyBuilder.PropertyId, Object> argsFromModel(ModelImpl model) {
        if (model == null) {
            return Collections.emptyMap();
        }
        EnumMap<PropertyBuilder.PropertyId, Object> args2 = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
        args2.put(PropertyBuilder.PropertyId.DESCRIPTION, model.getDescription());
        args2.put(PropertyBuilder.PropertyId.EXAMPLE, model.getExample());
        args2.put(PropertyBuilder.PropertyId.ENUM, model.getEnum());
        args2.put(PropertyBuilder.PropertyId.TITLE, model.getTitle());
        args2.put(PropertyBuilder.PropertyId.DEFAULT, model.getDefaultValue());
        args2.put(PropertyBuilder.PropertyId.DESCRIMINATOR, model.getDiscriminator());
        args2.put(PropertyBuilder.PropertyId.UNIQUE_ITEMS, model.getUniqueItems());
        args2.put(PropertyBuilder.PropertyId.VENDOR_EXTENSIONS, model.getVendorExtensions());
        args2.put(PropertyBuilder.PropertyId.PATTERN, model.getPattern());
        args2.put(PropertyBuilder.PropertyId.MAXIMUM, model.getMaximum());
        args2.put(PropertyBuilder.PropertyId.MINIMUM, model.getMinimum());
        args2.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, model.getExclusiveMaximum());
        args2.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, model.getExclusiveMinimum());
        args2.put(PropertyBuilder.PropertyId.MULTIPLE_OF, model.getMultipleOf());
        args2.put(PropertyBuilder.PropertyId.MIN_LENGTH, model.getMinLength());
        args2.put(PropertyBuilder.PropertyId.MAX_LENGTH, model.getMaxLength());
        return args2;
    }

    public Model propertyToModel(Property property2) {
        String description = property2.getDescription();
        String type2 = property2.getType();
        String format2 = property2.getFormat();
        Object example = null;
        Boolean allowEmptyValue = property2.getAllowEmptyValue();
        if (property2 instanceof RefProperty) {
            RefProperty ref = (RefProperty)property2;
            RefModel refModel = new RefModel(ref.getOriginalRef(), ref.getRefFormat());
            return refModel;
        }
        Map<String, Object> extensions = property2.getVendorExtensions();
        Property additionalProperties = null;
        if (property2 instanceof MapProperty) {
            additionalProperties = ((MapProperty)property2).getAdditionalProperties();
        }
        String name = property2.getName();
        Xml xml = property2.getXml();
        Map<String, Property> properties = null;
        if (property2 instanceof ObjectProperty) {
            ObjectProperty objectProperty = (ObjectProperty)property2;
            properties = objectProperty.getProperties();
        }
        if (property2 instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property2;
            ArrayModel arrayModel = new ArrayModel();
            arrayModel.setItems(arrayProperty.getItems());
            arrayModel.setDescription(description);
            arrayModel.setExample(example);
            arrayModel.setUniqueItems(arrayProperty.getUniqueItems());
            if (extensions != null) {
                arrayModel.setVendorExtensions(extensions);
            }
            if (properties != null) {
                arrayModel.setProperties(properties);
            }
            return arrayModel;
        }
        ModelImpl model = new ModelImpl();
        model.setDescription(description);
        model.setExample(property2.getExample());
        model.setName(name);
        model.setXml(xml);
        model.setType(type2);
        model.setFormat(format2);
        model.setAllowEmptyValue(allowEmptyValue);
        if (property2 instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property2;
            model.setPattern(stringProperty.getPattern());
            model.setMinLength(stringProperty.getMinLength());
            model.setMaxLength(stringProperty.getMaxLength());
            model.setEnum(stringProperty.getEnum());
        }
        if (property2 instanceof AbstractNumericProperty) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)property2;
            model.setMaximum(numericProperty.getMaximum());
            model.setMinimum(numericProperty.getMinimum());
            model.setExclusiveMaximum(numericProperty.getExclusiveMaximum());
            model.setExclusiveMinimum(numericProperty.getExclusiveMinimum());
            model.setMultipleOf(numericProperty.getMultipleOf());
        }
        if (extensions != null) {
            model.setVendorExtensions(extensions);
        }
        if (additionalProperties != null) {
            model.setAdditionalProperties(additionalProperties);
        }
        if (properties != null) {
            model.setProperties(properties);
        }
        return model;
    }
}

