/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.SwaggerParserExtension;
import io.swagger.parser.util.ClasspathHelper;
import io.swagger.parser.util.DeserializationUtils;
import io.swagger.parser.util.RemoteUrl;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.parser.util.SwaggerDeserializer;
import io.swagger.util.Json;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Swagger20Parser
implements SwaggerParserExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(Swagger20Parser.class);

    @Override
    public SwaggerDeserializationResult readWithInfo(JsonNode node) {
        SwaggerDeserializer ser = new SwaggerDeserializer();
        return ser.deserialize(node);
    }

    @Override
    public SwaggerDeserializationResult readWithInfo(String location, List<AuthorizationValue> auths) {
        SwaggerDeserializationResult errorOutput = new SwaggerDeserializationResult();
        try {
            JsonNode rootNode;
            String data2;
            location = location.replaceAll("\\\\", "/");
            if (location.toLowerCase().startsWith("http")) {
                data2 = RemoteUrl.urlToString(location, auths);
            } else {
                String fileScheme = "file:";
                Path path2 = location.toLowerCase().startsWith("file:") ? Paths.get(URI.create(location)) : Paths.get(location, new String[0]);
                data2 = Files.exists(path2, new LinkOption[0]) ? FileUtils.readFileToString(path2.toFile(), "UTF-8") : ClasspathHelper.loadFileFromClasspath(location);
            }
            if (data2.trim().startsWith("{")) {
                ObjectMapper mapper = Json.mapper();
                rootNode = mapper.readTree(data2);
            } else {
                rootNode = this.deserializeYaml(data2, errorOutput);
            }
            return this.readWithInfo(rootNode);
        }
        catch (SSLHandshakeException e2) {
            errorOutput.message("unable to read location `" + location + "` due to a SSL configuration error.  It is possible that the server SSL certificate is invalid, self-signed, or has an untrusted Certificate Authority.");
            return errorOutput;
        }
        catch (Exception e3) {
            errorOutput.message("unable to read location `" + location + "`");
            return errorOutput;
        }
    }

    protected JsonNode deserializeYaml(String data2) throws IOException {
        return this.deserializeYaml(data2, null);
    }

    protected JsonNode deserializeYaml(String data2, SwaggerDeserializationResult errorOutput) throws IOException {
        return DeserializationUtils.readYamlTree(data2, errorOutput);
    }

    @Override
    public Swagger read(String location, List<AuthorizationValue> auths) throws IOException {
        LOGGER.info("reading from " + location);
        try {
            String data2;
            location = location.replaceAll("\\\\", "/");
            if (location.toLowerCase().startsWith("http")) {
                data2 = RemoteUrl.urlToString(location, auths);
            } else {
                String fileScheme = "file:";
                Path path2 = location.toLowerCase().startsWith("file:") ? Paths.get(URI.create(location)) : Paths.get(location, new String[0]);
                data2 = Files.exists(path2, new LinkOption[0]) ? FileUtils.readFileToString(path2.toFile(), "UTF-8") : ClasspathHelper.loadFileFromClasspath(location);
            }
            return this.convertToSwagger(data2);
        }
        catch (Exception e2) {
            if (System.getProperty("debugParser") != null) {
                e2.printStackTrace();
            }
            return null;
        }
    }

    private Swagger convertToSwagger(String data2) throws IOException {
        if (data2 != null) {
            JsonNode rootNode;
            if (data2.trim().startsWith("{")) {
                ObjectMapper mapper = Json.mapper();
                rootNode = mapper.readTree(data2);
            } else {
                rootNode = this.deserializeYaml(data2);
            }
            if (System.getProperty("debugParser") != null) {
                LOGGER.info("\n\nSwagger Tree: \n" + ReflectionToStringBuilder.toString(rootNode, ToStringStyle.MULTI_LINE_STYLE) + "\n\n");
            }
            if (rootNode == null) {
                return null;
            }
            JsonNode swaggerNode = rootNode.get("swagger");
            if (swaggerNode == null) {
                return null;
            }
            SwaggerDeserializationResult result2 = new SwaggerDeserializer().deserialize(rootNode);
            Swagger convertValue = result2.getSwagger();
            if (System.getProperty("debugParser") != null) {
                LOGGER.info("\n\nSwagger Tree convertValue : \n" + ReflectionToStringBuilder.toString(convertValue, ToStringStyle.MULTI_LINE_STYLE) + "\n\n");
            }
            return convertValue;
        }
        return null;
    }

    public Swagger parse(String data2) throws IOException {
        Validate.notEmpty(data2, "data must not be null!", new Object[0]);
        return this.convertToSwagger(data2);
    }

    @Override
    public Swagger read(JsonNode node) throws IOException {
        if (node == null) {
            return null;
        }
        try {
            return Json.mapper().convertValue((Object)node, Swagger.class);
        }
        catch (Exception e2) {
            LOGGER.error("Exception deserializing via core Json.mapper(), trying parser deserialization");
            SwaggerDeserializationResult result2 = new SwaggerDeserializer().deserialize(node);
            Swagger convertValue = result2.getSwagger();
            if (System.getProperty("debugParser") != null) {
                LOGGER.info("\n\nSwagger Tree convertValue : \n" + ReflectionToStringBuilder.toString(convertValue, ToStringStyle.MULTI_LINE_STYLE) + "\n\n");
            }
            return convertValue;
        }
    }
}

